/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDocument.h"

#include <wtf/GetPtr.h>

#include "Attr.h"
#include "CDATASection.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Comment.h"
#include "DOMImplementation.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "DocumentType.h"
#include "Element.h"
#include "EntityReference.h"
#include "Event.h"
#include "ExceptionCode.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSComment.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMImplementation.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSText.h"
#include "JSTreeWalker.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeIterator.h"
#include "NodeList.h"
#include "PlatformString.h"
#include "ProcessingInstruction.h"
#include "Range.h"
#include "StyleSheetList.h"
#include "Text.h"
#include "TreeWalker.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"
#include "kjs_css.h"
#include "kjs_window.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSDocumentTableEntries[] =
{
    { "documentElement", JSDocument::DocumentElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "doctype", JSDocument::DoctypeAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "selectedStylesheetSet", JSDocument::SelectedStylesheetSetAttrNum, DontDelete, 0, 0 },
    { "preferredStylesheetSet", JSDocument::PreferredStylesheetSetAttrNum, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[20] },
    { "xmlVersion", JSDocument::XMLVersionAttrNum, DontDelete, 0, 0 },
    { "defaultView", JSDocument::DefaultViewAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "readyState", JSDocument::ReadyStateAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlStandalone", JSDocument::XMLStandaloneAttrNum, DontDelete, 0, 0 },
    { "inputEncoding", JSDocument::InputEncodingAttrNum, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[18] },
    { 0, 0, 0, 0, 0 },
    { "documentURI", JSDocument::DocumentURIAttrNum, DontDelete, 0, 0 },
    { "implementation", JSDocument::ImplementationAttrNum, DontDelete|ReadOnly, 0, &JSDocumentTableEntries[19] },
    { 0, 0, 0, 0, 0 },
    { "URL", JSDocument::URLAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "xmlEncoding", JSDocument::XMLEncodingAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "charset", JSDocument::CharsetAttrNum, DontDelete, 0, 0 },
    { "defaultCharset", JSDocument::DefaultCharsetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "styleSheets", JSDocument::StyleSheetsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "characterSet", JSDocument::CharacterSetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSDocument::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSDocumentTable = 
{
    2, 21, JSDocumentTableEntries, 18
};

/* Hash table for constructor */

static const HashEntry JSDocumentConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSDocumentConstructorTable = 
{
    2, 1, JSDocumentConstructorTableEntries, 1
};

class JSDocumentConstructor : public DOMObject {
public:
    JSDocumentConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSDocumentPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSDocumentConstructor::info = { "DocumentConstructor", 0, &JSDocumentConstructorTable, 0 };

bool JSDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentConstructor, DOMObject>(exec, &JSDocumentConstructorTable, this, propertyName, slot);
}

JSValue* JSDocumentConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSDocumentPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "queryCommandState", JSDocument::QueryCommandStateFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "importNode", JSDocument::ImportNodeFuncNum, DontDelete|Function, 2, 0 },
    { "createEntityReference", JSDocument::CreateEntityReferenceFuncNum, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[36] },
    { "createNodeIterator", JSDocument::CreateNodeIteratorFuncNum, DontDelete|Function, 4, 0 },
    { "queryCommandIndeterm", JSDocument::QueryCommandIndetermFuncNum, DontDelete|Function, 1, 0 },
    { "createElement", JSDocument::CreateElementFuncNum, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[35] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "createComment", JSDocument::CreateCommentFuncNum, DontDelete|Function, 1, 0 },
    { "queryCommandEnabled", JSDocument::QueryCommandEnabledFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { "queryCommandValue", JSDocument::QueryCommandValueFuncNum, DontDelete|Function, 1, 0 },
    { "createElementNS", JSDocument::CreateElementNSFuncNum, DontDelete|Function, 2, 0 },
    { "createCDATASection", JSDocument::CreateCDATASectionFuncNum, DontDelete|Function, 1, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "getElementsByTagNameNS", JSDocument::GetElementsByTagNameNSFuncNum, DontDelete|Function, 2, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "createDocumentFragment", JSDocument::CreateDocumentFragmentFuncNum, DontDelete|Function, 0, &JSDocumentPrototypeTableEntries[30] },
    { "createAttribute", JSDocument::CreateAttributeFuncNum, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[32] },
    { "getElementsByTagName", JSDocument::GetElementsByTagNameFuncNum, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[41] },
    { "createAttributeNS", JSDocument::CreateAttributeNSFuncNum, DontDelete|Function, 2, &JSDocumentPrototypeTableEntries[37] },
    { "createTreeWalker", JSDocument::CreateTreeWalkerFuncNum, DontDelete|Function, 4, &JSDocumentPrototypeTableEntries[38] },
    { 0, 0, 0, 0, 0 },
    { "getElementById", JSDocument::GetElementByIdFuncNum, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[33] },
    { "createTextNode", JSDocument::CreateTextNodeFuncNum, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[31] },
    { "createProcessingInstruction", JSDocument::CreateProcessingInstructionFuncNum, DontDelete|Function, 2, &JSDocumentPrototypeTableEntries[34] },
    { "adoptNode", JSDocument::AdoptNodeFuncNum, DontDelete|Function, 1, 0 },
    { "createEvent", JSDocument::CreateEventFuncNum, DontDelete|Function, 1, 0 },
    { "createRange", JSDocument::CreateRangeFuncNum, DontDelete|Function, 0, 0 },
    { "getOverrideStyle", JSDocument::GetOverrideStyleFuncNum, DontDelete|Function, 2, 0 },
    { "createExpression", JSDocument::CreateExpressionFuncNum, DontDelete|Function, 2, 0 },
    { "createNSResolver", JSDocument::CreateNSResolverFuncNum, DontDelete|Function, 1, &JSDocumentPrototypeTableEntries[40] },
    { "evaluate", JSDocument::EvaluateFuncNum, DontDelete|Function, 5, &JSDocumentPrototypeTableEntries[39] },
    { "execCommand", JSDocument::ExecCommandFuncNum, DontDelete|Function, 3, 0 },
    { "queryCommandSupported", JSDocument::QueryCommandSupportedFuncNum, DontDelete|Function, 1, 0 },
    { "elementFromPoint", JSDocument::ElementFromPointFuncNum, DontDelete|Function, 2, 0 }
};

static const HashTable JSDocumentPrototypeTable = 
{
    2, 42, JSDocumentPrototypeTableEntries, 30
};

const ClassInfo JSDocumentPrototype::info = { "DocumentPrototype", 0, &JSDocumentPrototypeTable, 0 };

JSObject* JSDocumentPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentPrototype>(exec, "[[JSDocument.prototype]]");
}

bool JSDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSDocumentPrototypeFunction, JSObject>(exec, &JSDocumentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDocument::info = { "Document", &JSEventTargetNode::info, &JSDocumentTable, 0 };

JSDocument::JSDocument(ExecState* exec, Document* impl)
    : JSEventTargetNode(exec, impl)
{
    setPrototype(JSDocumentPrototype::self(exec));
}

JSDocument::~JSDocument()
{
    ScriptInterpreter::forgetDOMObject(static_cast<Document*>(impl()));
}

bool JSDocument::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocument, JSEventTargetNode>(exec, &JSDocumentTable, this, propertyName, slot);
}

JSValue* JSDocument::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DoctypeAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return toJS(exec, WTF::getPtr(imp->doctype()));
    }
    case ImplementationAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return toJS(exec, WTF::getPtr(imp->implementation()));
    }
    case DocumentElementAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return toJS(exec, WTF::getPtr(imp->documentElement()));
    }
    case InputEncodingAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrNull(imp->inputEncoding());
    }
    case XMLEncodingAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrNull(imp->xmlEncoding());
    }
    case XMLVersionAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrNull(imp->xmlVersion());
    }
    case XMLStandaloneAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsBoolean(imp->xmlStandalone());
    }
    case DocumentURIAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrNull(imp->documentURI());
    }
    case DefaultViewAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return toJS(exec, WTF::getPtr(imp->defaultView()));
    }
    case StyleSheetsAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return toJS(exec, WTF::getPtr(imp->styleSheets()), imp);
    }
    case URLAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsString(imp->URL());
    }
    case CharsetAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrUndefined(imp->charset());
    }
    case DefaultCharsetAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrUndefined(imp->defaultCharset());
    }
    case ReadyStateAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrUndefined(imp->readyState());
    }
    case CharacterSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrNull(imp->characterSet());
    }
    case PreferredStylesheetSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrNull(imp->preferredStylesheetSet());
    }
    case SelectedStylesheetSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        return jsStringOrNull(imp->selectedStylesheetSet());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSDocument::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSDocument, JSEventTargetNode>(exec, propertyName, value, attr, &JSDocumentTable, this);
}

void JSDocument::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XMLVersionAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        ExceptionCode ec = 0;
        imp->setXMLVersion(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    case XMLStandaloneAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        ExceptionCode ec = 0;
        imp->setXMLStandalone(value->toBoolean(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case DocumentURIAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        imp->setDocumentURI(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CharsetAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        imp->setCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SelectedStylesheetSetAttrNum: {
        Document* imp = static_cast<Document*>(impl());

        imp->setSelectedStylesheetSet(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSDocument::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSDocumentConstructor>(exec, "[[Document.constructor]]");
}
JSValue* JSDocumentPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSDocument::info))
      return throwError(exec, TypeError);

    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObj)->impl());

    switch (id) {
    case JSDocument::CreateElementFuncNum: {
        ExceptionCode ec = 0;
        String tagName = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createElement(tagName, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateDocumentFragmentFuncNum: {


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createDocumentFragment()));
        return result;
    }
    case JSDocument::CreateTextNodeFuncNum: {
        String data = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createTextNode(data)));
        return result;
    }
    case JSDocument::CreateCommentFuncNum: {
        String data = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createComment(data)));
        return result;
    }
    case JSDocument::CreateCDATASectionFuncNum: {
        ExceptionCode ec = 0;
        String data = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createCDATASection(data, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateProcessingInstructionFuncNum: {
        ExceptionCode ec = 0;
        String target = args[0]->toString(exec);
        String data = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createProcessingInstruction(target, data, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateAttributeFuncNum: {
        ExceptionCode ec = 0;
        String name = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createAttribute(name, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateEntityReferenceFuncNum: {
        ExceptionCode ec = 0;
        String name = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createEntityReference(name, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::GetElementsByTagNameFuncNum: {
        String tagname = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagName(tagname)));
        return result;
    }
    case JSDocument::ImportNodeFuncNum: {
        ExceptionCode ec = 0;
        Node* importedNode = toNode(args[0]);
        bool deep = args[1]->toBoolean(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->importNode(importedNode, deep, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateElementNSFuncNum: {
        ExceptionCode ec = 0;
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String qualifiedName = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createElementNS(namespaceURI, qualifiedName, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateAttributeNSFuncNum: {
        ExceptionCode ec = 0;
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String qualifiedName = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createAttributeNS(namespaceURI, qualifiedName, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::GetElementsByTagNameNSFuncNum: {
        String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
        String localName = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
        return result;
    }
    case JSDocument::GetElementByIdFuncNum: {
        String elementId = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getElementById(elementId)));
        return result;
    }
    case JSDocument::AdoptNodeFuncNum: {
        ExceptionCode ec = 0;
        Node* source = toNode(args[0]);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->adoptNode(source, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateEventFuncNum: {
        ExceptionCode ec = 0;
        String eventType = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createEvent(eventType, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateRangeFuncNum: {


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createRange()));
        return result;
    }
    case JSDocument::CreateNodeIteratorFuncNum: {
        ExceptionCode ec = 0;
        Node* root = toNode(args[0]);
        bool whatToShowOk;
        unsigned whatToShow = args[1]->toInt32(exec, whatToShowOk);
        if (!whatToShowOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        NodeFilter* filter = toNodeFilter(args[2]);
        bool entityReferenceExpansion = args[3]->toBoolean(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createNodeIterator(root, whatToShow, filter, entityReferenceExpansion, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateTreeWalkerFuncNum: {
        ExceptionCode ec = 0;
        Node* root = toNode(args[0]);
        bool whatToShowOk;
        unsigned whatToShow = args[1]->toInt32(exec, whatToShowOk);
        if (!whatToShowOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        NodeFilter* filter = toNodeFilter(args[2]);
        bool entityReferenceExpansion = args[3]->toBoolean(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createTreeWalker(root, whatToShow, filter, entityReferenceExpansion, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::GetOverrideStyleFuncNum: {
        Element* element = toElement(args[0]);
        String pseudoElement = args[1]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getOverrideStyle(element, pseudoElement)));
        return result;
    }
    case JSDocument::CreateExpressionFuncNum: {
        ExceptionCode ec = 0;
        String expression = args[0]->toString(exec);
        RefPtr<XPathNSResolver> customResolver;
        XPathNSResolver* resolver = toXPathNSResolver(args[1]);
        if (!resolver) {
            customResolver = JSCustomXPathNSResolver::create(exec, args[1]);
            if (exec->hadException())
                return jsUndefined();
            resolver = customResolver.get();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createExpression(expression, resolver, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::CreateNSResolverFuncNum: {
        Node* nodeResolver = toNode(args[0]);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createNSResolver(nodeResolver)));
        return result;
    }
    case JSDocument::EvaluateFuncNum: {
        ExceptionCode ec = 0;
        String expression = args[0]->toString(exec);
        Node* contextNode = toNode(args[1]);
        RefPtr<XPathNSResolver> customResolver;
        XPathNSResolver* resolver = toXPathNSResolver(args[2]);
        if (!resolver) {
            customResolver = JSCustomXPathNSResolver::create(exec, args[2]);
            if (exec->hadException())
                return jsUndefined();
            resolver = customResolver.get();
        }
        unsigned short type = args[3]->toInt32(exec);
        XPathResult* inResult = toXPathResult(args[4]);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->evaluate(expression, contextNode, resolver, type, inResult, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSDocument::ExecCommandFuncNum: {
        String command = args[0]->toString(exec);
        bool userInterface = args[1]->toBoolean(exec);
        String value = valueToStringWithUndefinedOrNullCheck(exec, args[2]);


        KJS::JSValue* result = jsBoolean(imp->execCommand(command, userInterface, value));
        return result;
    }
    case JSDocument::QueryCommandEnabledFuncNum: {
        String command = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->queryCommandEnabled(command));
        return result;
    }
    case JSDocument::QueryCommandIndetermFuncNum: {
        String command = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->queryCommandIndeterm(command));
        return result;
    }
    case JSDocument::QueryCommandStateFuncNum: {
        String command = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->queryCommandState(command));
        return result;
    }
    case JSDocument::QueryCommandSupportedFuncNum: {
        String command = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->queryCommandSupported(command));
        return result;
    }
    case JSDocument::QueryCommandValueFuncNum: {
        String command = args[0]->toString(exec);


        KJS::JSValue* result = jsStringOrFalse(imp->queryCommandValue(command));
        return result;
    }
    case JSDocument::ElementFromPointFuncNum: {
        bool xOk;
        int x = args[0]->toInt32(exec, xOk);
        if (!xOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }
        bool yOk;
        int y = args[1]->toInt32(exec, yOk);
        if (!yOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->elementFromPoint(x, y)));
        return result;
    }
    }
    return 0;
}

}
