<?php
# report all errors
if(defined(E_ALL)==false) { define('E_ALL',2048); } # PHP 3 compat.
error_reporting(E_ALL); # report all errors.

function microtime_float(){ list($usec,$sec)=explode(' ',microtime()); return ((float)$usec+(float)$sec); }
# lets time this thing.
$start_time=microtime_float();

# Legal Stuff:
# RAM-CMS - Really Amazing Modest Content Management System.
# Copyright (C) 2007,2008 Robert Alex Marder.
# E-Mail: ralexwebs@inbox.com
# WWW: http://www.nongnu.org/ram-cms/
# Version: 0.1.0
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# or see <http://www.gnu.org/licenses/>.

# use the safer superglobals if we can / must.
if(isset($_SERVER['PHP_SELF'])==true)
{
	$PHP_SELF=$_SERVER['PHP_SELF'];
}
if(isset($_GET['page'])==true)
{
	$page=$_GET['page'];
}
if(isset($page)==false)
{
	$page='';
}

# as of post 0.7 config.php is required.
require('config.php');

# the RAM-CMS function library is required to run.
require('functions.php');

# check config.php settings. If some things are not set, set the defaults
# TODO: this may not be required in current versions - investigate further.
if(isset($index_file)==false)
{
	$index_file=basename($PHP_SELF);
}

# include the $theme_file so we have a template to work with.
# if $theme_file isn't defined in config.php, or if the $theme_file 
# doesn't exist, then return HTTP 500 Error.
if(isset($theme_file)==true && $theme_file!='' && file_exists('themes/'.$theme_file)==true)
{
	#include('themes/'.$theme_file);
	$page_template=file_get_contents('themes/'.$theme_file);
	unset($theme_file);
}
else
{
	header('HTTP/1.0 500 Internal Server Error');
	header('Cache-Control: no-store, no-cache, must-revalidate');
	header('Pragma: no-cache');
	echo 'Fatal Error: Unable To Find / Open / Read Theme File.';
	die;
}

### START MAIN PROGRAM ###

# page file extension.
$ext='.txt';

# if $page ends with a / character then append $def_page to it and set it to $page
# this allows home pages to work in subdirectories off of pages/ directory.
if(substr($page,-1)=='/')
{
	$page=$page.$def_page;
}

# if $page is not set or empty string, we should assume the $def_page is what 
# we want to show.
if($page=='')
{
	$page=$def_page;
}
unset($def_page);

# quick compression (gzip, deflate, none) if supported by PHP and client.
if($compress==true && function_exists('ob_gzhandler')==true && function_exists('ob_start')==true)
{
	ob_start('ob_gzhandler');
}
unset($compress);

# determine whether we should return 404 page.
# if $page include .. or if $page starts with a / then we will return 404 as a security measure.
if(file_exists($pages_dir.$page.$ext)==false || strstr($page,'..')!=false || substr($page,0,1)=='/')
{
	$page='404';
}

# if the page wasn't found return HTTP 404 Not Found and don't cache.
if($page=='404')
{
	header('HTTP/1.0 404 Not Found');
	$nocache=true;
}

# determine last time page was updated.
$updated_show=ramcms_last_update_time($pages_dir.$page.$ext);

# page requested is not a program, but a standard static page.
# format it as required.
$fp=fopen($pages_dir.$page.$ext,'r');
unset($page); unset($ext);
# grab the title, always the first line.
$title=trim(fgets($fp,1024));
# grab the header, always second line.
$header=trim(fgets($fp,1024));
# if header is nothing, set header to title.
if(trim($header)=='')
{
	$header=$title;
}
# grab body, line three till EOF
$body='';
while(!feof($fp))
{
	$body=$body.fread($fp,1024);
}
fclose($fp);

# send HTTP headers
ramcms_send_http_headers($nocache);
unset($nocache);

# start parsing the template and filling in as needed.
if($strip_whitespace==true)
{
	$body=ramcms_remove_body_whitespace($body);
}
unset($strip_whitespace);

if($bbcode==true)
{
	$body=ramcms_bbcode_parser($body);
}

$page_template=ramcms_page_template_parser($page_template,$keywords,$description,$title,$site_name,$header,$updated_show,$body,$copyright);

unset($keywords);
unset($description);
unset($title);
unset($site_name);
unset($header);
unset($updated_show);
unset($body);
unset($copyright);
unset($bbcode);

# finish off the page timer.
$end_time=microtime_float();
$timed=number_format($end_time-$start_time,5);
$page_template=str_replace('[[gen_time]]',$timed,$page_template);
unset($timed); unset($end_time); unset($start_time);

# dump the entire page to the server, for sending to client.
# this should be the only HTTP body content echo'd from this 
# program to the client, the rest should be buffered into 
# PHP variables.
echo $page_template;
unset($page_template);

#print_r($GLOBALS);

?>