.TH groff_opmode @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
groff_opmode \- control GNU roff \(lqpen state\(rq
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.\"
.\" ====================================================================
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_opmode_7_man_C
.cp 0
.
.\" ====================================================================
.\" Local macro definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
Primarily intended to support the operation of
.MR pdfroff @MAN1EXT@ ,
but also potentially useful in other, similar contexts,
the
.B \%groff_opmode
supplementary macro package offers a mechanism
for synchronization of the typesetter's \%\(lqpen-up\(rq
and \%\(lqpen-down\(rq states,
as appropriate to particular phases of document production.
.
In the case of
.MR pdfroff @MAN1EXT@ ,
it is used to suppress the output of the document body content,
when processing the phase for production of a table of contents,
(when this is output
.I following
processing of the body content),
and vice-versa.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
Typically loaded from within
.MR groff @MAN7EXT@
document source,
or by another dependent macro package,
using the
.MR groff @MAN7EXT@
request:
.RS 3n
.SY .\^mso\ opmode
.YS
.RE
.
.P
the
.B \%groff_opmode
macro package provides the
.B \%.\^OP
macro,
which exhibits the invocation syntax:
.
.RS 3n
.SY .\^OP
.RI \%[< output-phase >\ .\|.\|.\&]
.YS
.RE
.
.P
A call of the
.B \%.\^OP
macro should be placed at the beginning of any section of the
.MR groff @MAN7EXT@
input file,
for which the content is designated for processing
in a different phase from that which has gone before;
for example,
when using the emulated
classical table of contents relocation feature of
.MR pdfroff @MAN7EXT@ ,
the call:
.P
.RS 3n
.EX
\%.OP 2
.EE
.RE
.P
would be placed at the beginning of the document body content,
(normally the beginning of the input file),
indicating that the following content should be output during
.MR pdfroff @MAN7EXT@ 's
document body processing phase,
whereas the complementary call:
.P
.RS 3n
.EX
\%.OP 1
.EE
.RE
.P
would be placed after the document body content,
to prepare for output of the collected table of contents, in
.MR pdfroff @MAN7EXT@ 's
table of contents processing phase.
.
.P
The behaviour of the
.B \%.\^OP
macro is determined according to the setting of the
.B \%PHASE
register,
which is expected to have been set,
usually as a command line assignment for an individual invocation of
.MR groff @MAN1EXT@ ,
depending on the particular phase of output file processing
to which the invocation \%relates\|\(em\|\c
.MR pdfroff @MAN1EXT@
sets it to
.I \%one
when initiating its table of contents output phase, and to
.I \%two
for its document body output phase.
.
This behaviour may be described as follows:
.RS 3n
.ll -3n
.IP \(bu 2n
If the
.B \%PHASE
register is
.I \%not
defined,
(as is the case during
.MR pdfroff @MAN1EXT@ 's
initial document analysis phase\|\(em\|which
produces no physical output),
.B \%.\^OP
sets the
.B \%OPMODE
register to
.IR one ,
but has no effect on
.MR groff @MAN7EXT@ 's
.RI \(lq "pen state" \(rq;
this effectively indicates that
.MR groff @MAN7EXT@
is expected to be operating in its default
.RI \(lq "pen-down" \(rq
state,
.I without
actually enforcing this.
.
.IP \(bu 2n
When the
.B \%PHASE
register
.I is
defined,
then each specified
.RI \%\(lq< output-phase >\(rq
argument is compared, in turn, with
.BR \%PHASE ,
until one compares as equal,
or no more remain;
if an equal match is found,
then the
.B \%OPMODE
register is set to
.IR one ,
and
.MR groff @MAN7EXT@ 's
.RI \%\(lq pen-down \(rq
state is activated;
otherwise,
when no equal match is found, the
.B \%OPMODE
register is set to
.IR \%zero ,
and
.MR groff @MAN7EXT@ 's
.RI \%\(lq pen-up \(rq
state is activated.
.
.IP \(bu 2n
If the
.B \%PHASE
register
.I is
defined,
but no
.RI \%\(lq< output-phase >\(rq
arguments have been specified,
then the
.B \%OPMODE
register is
.I immediately
set to
.IR one ,
and
.MR groff @MAN7EXT@ 's
.RI \%\(lq pen-down \(rq
state is activated.
.ll +3n
.RE
.P
This provides a mechanism for tracking the anticipated
.MR groff @MAN7EXT@
\(lqpen state\(rq,
when performing multiple phase
.MR groff @MAN1EXT@
document formatting,
supporting modification of the formatter's behaviour
on the basis of the indicated \(lqpen state\(rq;
for example, the
.MR groff_pdfmark @MAN7EXT@
macros,
and associated macro packages such as
.MR groff_mspdf @MAN7EXT@ ,
may use the information conveyed by
.B \%OPMODE
to suppress generation of
.I \%pdfmark
code,
while processing document sections in which the
.RI \%\(lq pen-up \(rq
state has been activated.
.br
.
.
.ne 5v
.\" ====================================================================
.SH Control Registers
.\" ====================================================================
.
The following two numeric registers
are associated with the operation of the
.B \%.\^OP
macro:
.TP
.B \%PHASE
Defined by
.MR pdfroff @MAN1EXT@ ,
this numeric register is assigned a value of
.IR one ,
when the processing objective is to produce
a table of contents,
and a value of
.IR two ,
for production of the document body content.
.
.TP
.B \%OPMODE
Assigned on execution of the
.B \%.\^OP
macro,
this numeric register assumes a value of
.IR \%zero ,
when the typesetter is switched to its
.RI \%\(lq pen-up \(rq
state,
and a value of
.IR one ,
following a switch to the
.RI \%\(lq pen-down \(rq
state.
.
.IP
When used in conjunction with the
.MR groff_pdfmark @MAN7EXT@
macros,
the
.B \%OPMODE
register is aliased to that package's
.B \%PDFOPMODE
register.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@SITE_TMACDIR@/opmode.tmac
Provides the implementation of the
.B \%.\^OP
macro.
.
.
.\" ====================================================================
.SH Caveats\" and Bugs
.\" ====================================================================
.
Assignment of the
.B \%PHASE
register lies firmly within the purview
of whatever process is responsible for driving multiple phase
.MR groff @MAN1EXT@
document formatting.
It should neither be defined,
nor reassigned within any document source file;
doing so may result in undefined behaviour.
.
.
.\" ====================================================================
.\" SH Examples
.\" ====================================================================
.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.B \%groff_opmode
supplementary macro implementation is provided by the
.I \%groff-pdfmark
package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ;
originally developed as a complement to the GNU Troff Project,
it is now independently maintained at
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the most recently published version may
.I always
be obtained.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation on the use of
.MR pdfroff @MAN1EXT@ ,
(support of which is the primary function of
.BR \%groff_opmode ),
and of the
.I \%groff-pdfmark
macro suite in general, may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_opmode_7_man_C]
.do rr *groff_opmode_7_man_C
.
.\" ====================================================================
.\"
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
