.TH groff_omit @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
groff_omit \- demarcate non-printing meta-data in groff input
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.
.\" ====================================================================
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_omit_7_man_C
.cp 0
.
.\" ====================================================================
.\" Local macro definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.B \%groff_omit
is an auxiliary
.MR groff @MAN7EXT@
macro package,
which is intended for use when a mechanism is required
for identification of embedded \%meta-data,
within
.MR groff @MAN7EXT@
input,
while excluding it from
.MR groff @MAN1EXT@
output,
yet facilitating its extraction for use in other contexts.
.
It defines the
.B \%OMIT
macro,
which may be used by any client macro package,
or document,
to generate pairs of macro definitions,
such as the
.BR \%CS ,
and
.B \%CE
macro pair generated by
.MR groff_mspdf @MAN7EXT@ ,
and used by
.MR pdfroff @MAN1EXT@ ,
to identify \%meta-data,
within any
.MR groff @MAN7EXT@
input data stream,
whence it will be ignored during normal
.MR groff @MAN1EXT@
processing,
but will be available for extraction,
and inclusion,
by
.MR pdfroff @MAN1EXT@ ,
while processing a nominated \%style-sheet for the purpose of
formatting document \%front-matter.
.
.P
The
.B \%OMIT
macro may be used to generate arbitrarily named macro pairs,
each of which will exhibit the same behaviour as
.MR groff_mspdf @MAN7EXT@ 's
.B \%CS
and
.B \%CE
pair.
.
Within each such generated macro pair,
the macro which corresponds to
.BR \%CS \|\^\(em\|and
.B \%CS
itself,
of course\|\(em\|records its own name,
as a \%meta-data block initiator,
after which it performs the equivalent of the
.MR groff @MAN7EXT@
.P
.RS 3n
.EX
\&.ig CE
.EE
.RE
.P
request,
(substituting the corresponding macro of the pair for
.BR \%CE ),
thus causing
.MR groff @MAN1EXT@
to ignore the demarcated input data block.
.
.P
When the \%meta-data block termination macro,
which corresponds to
.MR groff_mspdf @MAN7EXT@ 's
.B \%CE
macro,
is encountered,
it checks that there is a record of an active \%meta-data block,
initiated by its corresponding initiator macro,
and then deletes the initiation record.
If no such initiation record exists,
a diagnostic message is displayed,
reporting this as an error.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
The
.B \%groff_omit
macros are normally loaded by another,
dependent client macro package,
using a
.MR groff @MAN7EXT@
request of the form:
.RS 3n
.SY .\^mso\ \^omit.tmac
.YS
.RE
.P
To designate the client macro package as
the origin for any associated diagnostic messages,
the loading request may be qualified,
for example,
as when loaded by the
.MR groff_mspdf @MAN7EXT@
package,
to designate
.RI \%\(lq spdf.tmac \(rq
as the message origin,
and then generate the
.B CS
and
.B CE
macro pair:
.RS 3n
.SY .\^ds\ \^OMIT\h'0.01n'.\h'0.25n'SETUP\ \|\-client
.I \^spdf.tmac
.SY .\^mso\ \^omit.tmac
.SY .\^OMIT\ \^CS\ \^CE
.YS
.RE
.P
More generally,
specification of the
.B \%OMIT\h'0.01n'.\h'0.25n'SETUP
string is optional;
if it
.I is
specified,
its definition
.I \%must
be placed
.I \%before
the
.I \%omit.tmac
file is loaded,
and it must conform to the syntax:
.RS 3n
.SY .\^ds\ \^OMIT\h'0.01n'.\h'0.25n'SETUP
.RB \|[ \-client
.RI < message-source >]
.RB \|[[ \-replace
.RI < diagnostic-macro-name >]\ .\|.\|.\&]
.YS
.RE
.P
specifying the optional initialization arguments:
.RS 3n
.SY \-client
.RI \|< message-source >
.YS
.RE
.IP
.ll -3n
Designates
.RI \%< message-source >
as the effective origin of
.I all
messages which are displayed by the
.B \%OMIT
API's diagnostic macro;
if this option is not specified,
.RI \%< message-source >
is assigned a default value of
.RI \%\^\(lq omit.tmac \(rq.
.ll +3n
.RS 3n
.SY \-replace
.RI \|< diagnostic-macro-name >
.YS
.RE
.IP
.ll -3n
Specifies that the
.B \%OMIT
API's diagnostic macro should be used,
in place of the original diagnostic macro named by
.RI \%< diagnostic-macro-name >;
this option may be repeated,
as many times as may be necessary,
to replace any number of other diagnostic macros.
.ll +3n
.P
Following initialization of the
.B \%OMIT
API,
as described above,
the
.B \%OMIT
macro may be called,
at any appropriate time,
to generate arbitrarily named \%meta-data demarcating macro pairs,
in accordance with the generalized syntactic form:
.RS 3n
.SY .\^OMIT
.RI < start-macro-name >
.RI < end-macro-name >
.YS
.RE
.P
Given that neither of the macros designated by
.RI \%< start-macro-name >,
nor
.RI \%< end-macro-name >,
has any capability for interpretation of arguments,
the general format for the use of any macro pair,
generated by such use of the
.B \%OMIT
macro,
is:
.RS 3n
.ll -3n
.SY .\^\c
.RI < start-macro-name >
.SY \&\c
.I any block of document
.IR \%meta-data ,
.I or other arbitrary
.IR content ,
.SY \&\c
.I which is not to be interpreted during normal
.MR groff @MAN1EXT@
.IR processing ,
.SY \&\c
.I but which should otherwise be explicitly
.IR identifiable ;
.SY \&\c
.I this data block ends on invocation of
\&.\|.\|.
.SY .\^\c
.RI < end-macro-name >
.ll +3n
.YS
.RE
.P
Any such block of data may then extracted,
for use in a context
.I other than
normal
.MR groff @MAN1EXT@
processing,
for example,
by directing a copy of the
.MR groff @MAN1EXT@
input data stream through a filter such as:
.RS 3n
.SY sed\ \-n
.BI \(aq/\^\(ha\^\(rs\^.
.BR * <\c
.IR start-macro-name >\c
.B \^/\^,\|/\^\(ha\^\(rs\^.
.BR * <\c
.IR end-macro-name >\c
.BI \^/ p \(aq
.YS
.RE
.P
and processing the resultant output,
in whatever manner may be appropriate.
.
.
.\" ====================================================================
.SH Control Variables
.\" ====================================================================
.
The
.B \%groff_omit
package interprets
.I one
.MR groff @MAN7EXT@
string variable,
namely
.BR \%OMIT\h'0.01n'.\h'0.25n'SETUP ;
when this is defined
.I before
the
.I \%omit.tmac
file is loaded,
its value is interpreted as a specification of
the arguments to be passed to the
.B \%OMIT
API initialization logic;
if undefined,
this initialization logic behaves as if passed a default value of
.RB \%\^\(lq \-client \ \c
.IR omit.tmac \(rq.
.
The
.MR groff_mspdf @MAN7EXT@
macro package uses this facility,
to insinuate its own name,
.RI \%\(lq spdf.tmac \(rq,
as the effective source of messages originating from within itself,
.BR \%groff_omit ,
.I and
.MR groff_ms @MAN7EXT@ .
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @SITE_TMACDIR@/omit.tmac
Implements the
.B \%OMIT
macro,
its associated API initialization logic,
and diagnostic macro.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.B \%groff_omit
macros are provided as a constituent of the
.I \%groff-pdfmark
package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ;
it is maintained,
independently of
.IR \%GNU\ roff ,
at
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the latest version may
.I always
be obtained.
.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation,
on the use of the
.I \%groff-pdfmark
macro suite may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_omit_7_man_C]
.do rr *groff_omit_7_man_C
.
.\" ====================================================================
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
