% FUNCTION [...] = gf_mesh_levelset_set(mesh_levelset MLS, [operation [, args]])
%
%   General function for modification of mesh_levelset objects.
%   
%
%   * gf_mesh_levelset_set(mesh_levelset MLS, 'add', levelset ls)
%   Add a link to the levelset `ls`.
%   
%   Only a reference is kept, no copy is done. In order to indicate
%   that the linked mesh is cut by a levelset one has to call this
%   method, where `ls` is an levelset object. An arbitrary number of
%   levelset can be added.
%   
%   **WARNING**
%   
%   The mesh of `ls` and the linked mesh must be the same.
%
%   * gf_mesh_levelset_set(mesh_levelset MLS, 'sup', levelset ls)
%   Remove a link to the levelset `ls`.
%
%   * gf_mesh_levelset_set(mesh_levelset MLS, 'adapt')
%   Do all the work (cut the convexes with the levelsets).
%   
%   To initialice the mesh_levelset object or to actualize it when the
%   value of any levelset function is modified, one has to call
%   this method.
%
%
function [varargout]=gf_mesh_levelset_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_levelset_set', varargin{:});
  else
    gf_matlab('mesh_levelset_set', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
