% FUNCTION F=gf_fem(string FEM_NAME)
%     Returns a handle F to one of the various Finite Elements Method defined
%     in Getfem.
% 
%     example of FEM names are:
% * FEM_PK(N,K)
%    classical Lagrange element PK on a simplex of dimension N
%  * FEM_PK_DISCONTINUOUS(N,K[,alpha])}
%     discontinuous Lagrange element PK on a simplex of dim N
%  * FEM_QK(N,K)}
%    classical Lagrange element QK on quadrangles, hexahedrons etc
%  * FEM_QK_DISCONTINUOUS(N,K[,alpha])}
%    discontinuous Lagrange element QK on quadrangles, hexahedrons etc
%  * FEM_Q2_INCOMPLETE
%    incomplete 2D Q2 element with 8 dof (serendipity Quad 8 element)  *
% FEM_PK_PRISM(N,K)
%    classical Lagrange element PK on a prism
%  * FEM_PK_PRISM_DISCONTINUOUS(N,K[,alpha])   classical discontinuous Lagrange
% element PK on a prism.  * FEM_PK_WITH_CUBIC_BUBBLE(N,K)
%    classical Lagrange element PK on a simplex with an additional volumic
% bubble function.
%  * FEM_P1_NONCONFORMING
%    non-conforming P1 method on a triangle.
%  * FEM_P1_BUBBLE_FACE(N)
%    P1 method on a simplex with an additional bubble function on face 0.
%  * FEM_P1_BUBBLE_FACE_LAG
%    P1 method on a simplex with an additional lagrange dof on face 0.
%   * FEM_PK_HIERARCHICAL(N,K)
%    PK element with a hierarchical basis
%  * FEM_QK_HIERARCHICAL(N,K)
%    QK element with a hierarchical basis
%  * FEM_PK_PRISM_HIERARCHICAL(N,K)
%    PK element on a prism with a hierarchical basis
%  * FEM_STRUCTURED_COMPOSITE(FEM, K)
%    Composite fem on a grid with K divisions
%  * FEM_PK_HIERARCHICAL_COMPOSITE(N,K,S)
%    PK composite element on a grid with S subdivisions and with a hierarchical
% basis
%  * FEM_PK_FULL_HIERARCHICAL_COMPOSITE(N,K,S)
%    PK composite element with S subdivisions and a hierarchical basis on both
% degree and subdivision
%  * FEM_PRODUCT(FEM1,FEM2)
%    tensorial product of two polynomial elements
%  * FEM_HERMITE(N)
%    Hermite element P3 on a simplex of dimension N=1,2,3
%  * FEM_ARGYRIS
%    Argyris element P5 on the triangle. * FEM_HCT_TRIANGLE
%     Hsieh-Clough-Tocher element on the triangle (composite P3   element which
% is C^1), should be used with IM_HCT_COMPOSITE()   integration method.
%  * FEM(:_(BRT0(N)
%    Raviart-Thomas element of order 0 on a simplex of dimension N.
%  * FEM(:_(BNEDELEC(N)
%    Nedelec edge element of order 0 on a simplex of dimension N.
function [varargout]=gf_fem(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('fem',varargin{:});
  else
    gf_matlab('fem',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
