function display(f)
% gfFem/display displays a short summary for a gfFem object
% see gfFem/char for an exhaustive description of the object.

  for i=1:numel(f)
    s_eq='non equiv'; if (gf_fem_get(f(i), 'is_equivalent')), s_eq='EQUIV'; end;
    s_pol='non poly'; if (gf_fem_get(f(i), 'is_polynomial')), s_pol='POLY'; end;
    s_lag='non lagr'; if (gf_fem_get(f(i), 'is_lagrange')), s_lag='LAGR'; end;
    est_deg = gf_fem_get(f(i),'estimated_degree');
    disp(sprintf(['gfFem object ID=%u dim=%d, target_dim=%d, nbdof=%d,'...
		  '[%s, %s, %s], est.degree=%d\n -> %s'],...
		 double(f(i).id),...
		 gf_fem_get(f(i),'dim'),...
		 gf_fem_get(f(i),'target_dim'),...
		 gf_fem_get(f(i),'nbdof'),...
		 s_eq,s_pol,s_lag,est_deg,...
		 gf_fem_get(f(i),'char')));
  end;
