/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;

public class LocationFinder {
    private final Map<Long, Location> locations = new HashMap<Long, Location>();

    public LocationFinder(NeuronSquareMesh2D map2) {
        int nR = map2.getNumberOfRows();
        int nC = map2.getNumberOfColumns();
        for (int r2 = 0; r2 < nR; ++r2) {
            for (int c2 = 0; c2 < nC; ++c2) {
                Long id = map2.getNeuron(r2, c2).getIdentifier();
                if (this.locations.get(id) != null) {
                    throw new MathIllegalStateException();
                }
                this.locations.put(id, new Location(r2, c2));
            }
        }
    }

    public Location getLocation(Neuron n2) {
        return this.locations.get(n2.getIdentifier());
    }

    public static class Location {
        private final int row;
        private final int column;

        public Location(int row2, int column2) {
            this.row = row2;
            this.column = column2;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

