/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import freemarker.template._TemplateAPI;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Deprecated
public class DOMNodeModel
implements TemplateHashModel {
    private static HashMap equivalenceTable = new HashMap();
    private Node node;
    private HashMap cache = new HashMap();

    public DOMNodeModel(Node node) {
        this.node = node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TemplateModel get(String key2) throws TemplateModelException {
        TemplateModel result2 = null;
        if (equivalenceTable.containsKey(key2)) {
            key2 = (String)equivalenceTable.get(key2);
        }
        if (this.cache.containsKey(key2)) {
            result2 = (TemplateModel)this.cache.get(key2);
        }
        if (result2 != null) return result2;
        if ("attributes".equals(key2)) {
            NamedNodeMap attributes = this.node.getAttributes();
            if (attributes != null) {
                SimpleHash hash = new SimpleHash(_TemplateAPI.SAFE_OBJECT_WRAPPER);
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    Attr att = (Attr)attributes.item(i2);
                    hash.put(att.getName(), att.getValue());
                }
                result2 = hash;
            }
        } else if (key2.charAt(0) == '@') {
            if (!(this.node instanceof Element)) throw new TemplateModelException("Trying to get an attribute value for a non-element node");
            String attValue = ((Element)this.node).getAttribute(key2.substring(1));
            result2 = new SimpleScalar(attValue);
        } else if ("is_element".equals(key2)) {
            result2 = this.node instanceof Element ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        } else if ("is_text".equals(key2)) {
            result2 = this.node instanceof Text ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        } else if ("name".equals(key2)) {
            result2 = new SimpleScalar(this.node.getNodeName());
        } else if ("children".equals(key2)) {
            result2 = new NodeListTM(this.node.getChildNodes());
        } else if ("parent".equals(key2)) {
            Node parent = this.node.getParentNode();
            result2 = parent == null ? null : new DOMNodeModel(parent);
        } else if ("ancestorByName".equals(key2)) {
            result2 = new AncestorByName();
        } else if ("nextSibling".equals(key2)) {
            Node next = this.node.getNextSibling();
            result2 = next == null ? null : new DOMNodeModel(next);
        } else if ("previousSibling".equals(key2)) {
            Node previous = this.node.getPreviousSibling();
            result2 = previous == null ? null : new DOMNodeModel(previous);
        } else if ("nextSiblingElement".equals(key2)) {
            Element next = DOMNodeModel.nextSiblingElement(this.node);
            result2 = next == null ? null : new DOMNodeModel(next);
        } else if ("previousSiblingElement".equals(key2)) {
            Element previous = DOMNodeModel.previousSiblingElement(this.node);
            result2 = previous == null ? null : new DOMNodeModel(previous);
        } else if ("nextElement".equals(key2)) {
            Element next = DOMNodeModel.nextElement(this.node);
            result2 = next == null ? null : new DOMNodeModel(next);
        } else if ("previousElement".equals(key2)) {
            Element previous = DOMNodeModel.previousElement(this.node);
            result2 = previous == null ? null : new DOMNodeModel(previous);
        } else if ("text".equals(key2)) {
            result2 = new SimpleScalar(DOMNodeModel.getText(this.node));
        }
        this.cache.put(key2, result2);
        return result2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private static String getText(Node node) {
        String result2 = "";
        if (node instanceof Text) {
            result2 = ((Text)node).getData();
        } else if (node instanceof Element) {
            NodeList children = node.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                result2 = result2 + DOMNodeModel.getText(children.item(i2));
            }
        }
        return result2;
    }

    private static Element nextSiblingElement(Node node) {
        Node next = node;
        while (next != null) {
            if (!((next = next.getNextSibling()) instanceof Element)) continue;
            return (Element)next;
        }
        return null;
    }

    private static Element previousSiblingElement(Node node) {
        Node previous = node;
        while (previous != null) {
            if (!((previous = previous.getPreviousSibling()) instanceof Element)) continue;
            return (Element)previous;
        }
        return null;
    }

    private static Element nextElement(Node node) {
        Element nextSiblingElement;
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                if (!(child instanceof Element)) continue;
                return (Element)child;
            }
        }
        if ((nextSiblingElement = DOMNodeModel.nextSiblingElement(node)) != null) {
            return nextSiblingElement;
        }
        Node parent = node.getParentNode();
        while (parent instanceof Element) {
            Element next = DOMNodeModel.nextSiblingElement(parent);
            if (next != null) {
                return next;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    private static Element previousElement(Node node) {
        Element result2 = DOMNodeModel.previousSiblingElement(node);
        if (result2 != null) {
            return result2;
        }
        Node parent = node.getParentNode();
        if (parent instanceof Element) {
            return (Element)parent;
        }
        return null;
    }

    void setParent(DOMNodeModel parent) {
        if (parent != null) {
            this.cache.put("parent", parent);
        }
    }

    String getNodeName() {
        return this.node.getNodeName();
    }

    static {
        equivalenceTable.put("*", "children");
        equivalenceTable.put("@*", "attributes");
    }

    class NodeListTM
    implements TemplateSequenceModel,
    TemplateMethodModel {
        private NodeList nodeList;
        private TemplateModel[] nodes;

        NodeListTM(NodeList nodeList) {
            this.nodeList = nodeList;
            this.nodes = new TemplateModel[nodeList.getLength()];
        }

        @Override
        public TemplateModel get(int index) {
            DOMNodeModel result2 = (DOMNodeModel)this.nodes[index];
            if (result2 == null) {
                result2 = new DOMNodeModel(this.nodeList.item(index));
                this.nodes[index] = result2;
                result2.setParent(DOMNodeModel.this);
            }
            return result2;
        }

        @Override
        public int size() {
            return this.nodes.length;
        }

        @Override
        public Object exec(List arguments2) throws TemplateModelException {
            if (arguments2.size() != 1) {
                throw new TemplateModelException("Expecting exactly one string argument here");
            }
            if (!(DOMNodeModel.this.node instanceof Element)) {
                throw new TemplateModelException("Expecting element here.");
            }
            Element elem = (Element)DOMNodeModel.this.node;
            return new NodeListTM(elem.getElementsByTagName((String)arguments2.get(0)));
        }
    }

    class AncestorByName
    implements TemplateMethodModel {
        AncestorByName() {
        }

        @Override
        public Object exec(List arguments2) throws TemplateModelException {
            if (arguments2.size() != 1) {
                throw new TemplateModelException("Expecting exactly one string argument here");
            }
            String nodeName = (String)arguments2.get(0);
            for (DOMNodeModel ancestor = (DOMNodeModel)DOMNodeModel.this.get("parent"); ancestor != null; ancestor = (DOMNodeModel)ancestor.get("parent")) {
                if (!nodeName.equals(ancestor.getNodeName())) continue;
                return ancestor;
            }
            return null;
        }
    }
}

