/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.GDE;
import gde.data.AbstractRecordSet;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.NotSupportedFileFormatException;
import gde.io.NMEAParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;

public class NMEAReaderWriter {
    static Logger log = Logger.getLogger(NMEAReaderWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static String tmpSetupString;
    static final DataExplorer application;
    static final Channels channels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordSet read(String filePath, IDevice device, String recordNameExtend, Integer channelConfigNumber) throws NotSupportedFileFormatException, IOException, DataInconsitsentException, DataTypeException {
        AbstractRecordSet recordSet;
        long startTime;
        block52: {
            startTime = System.nanoTime() / 1000000L;
            String line = "*";
            recordSet = null;
            Object recordSetName = "";
            Channel activeChannel = null;
            int lineNumber = 1;
            int activeChannelConfigNumber = 1;
            Object recordSetNameExtend = device.getRecordSetStemNameReplacement();
            long timeStamp = -1L;
            int lastProgress = 0;
            File inputFile = new File(filePath);
            GDE.getUiNotification().setProgress(0);
            try {
                activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get(channelConfigNumber);
                if (activeChannel == null) break block52;
                GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGT0594") + filePath);
                activeChannelConfigNumber = activeChannel.getNumber();
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannelConfigNumber, "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                int measurementSize = device.getNumberOfMeasurements(activeChannelConfigNumber);
                int dataBlockSize = Math.abs(device.getDataBlockSize(InputTypes.FILE_IO));
                log.log(java.util.logging.Level.FINE, "measurementSize = " + measurementSize + "; dataBlockSize = " + dataBlockSize);
                if (measurementSize < dataBlockSize) {
                    dataBlockSize = measurementSize;
                }
                NMEAParser data = new NMEAParser(device.getDataBlockLeader(), device.getDataBlockSeparator().value(), device.getDataBlockCheckSumType(), dataBlockSize, device, activeChannelConfigNumber, device.getUTCdelta());
                long approximateLines = inputFile.length() / 65L;
                DataInputStream binReader = new DataInputStream(new FileInputStream(inputFile));
                byte[] buffer = new byte[1024];
                byte[] lineEnding = device.getDataBlockEnding();
                boolean lineEndingOcurred = false;
                int chars = binReader.read(buffer);
                for (int i = 0; i < chars; ++i) {
                    if (buffer[i] != lineEnding[0] || i >= chars - lineEnding.length - 1 || buffer[i + lineEnding.length + 1] == 36 || lineEnding.length > 1 && buffer[i + 1] != lineEnding[1]) continue;
                    lineEndingOcurred = true;
                }
                binReader.close();
                if (!lineEndingOcurred) {
                    throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0042", new Object[]{chars, filePath}));
                }
                tmpSetupString = new String(buffer);
                if (tmpSetupString.indexOf(NMEAParser.NMEA.SETUP.toString(), 1) > -1 && tmpSetupString.indexOf(NMEAParser.NMEA.SETUP.toString(), 1) < 3) {
                    try {
                        data.timeOffsetUTC = (short)((buffer[14] << 8) + (buffer[13] & 0xFF));
                        data.timeOffsetUTC = (short)(data.timeOffsetUTC > 12 ? 12 : (data.timeOffsetUTC < -12 ? -12 : (int)data.timeOffsetUTC));
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "failed interpreting binary data, time offset to UTC not set!");
                    }
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                Vector<String> lines = new Vector<String>();
                Object airSpeedFactor = " ";
                while ((line = reader.readLine()) != null && (line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.SETUP.name()) || line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.GPSSETUP.name()) || line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.UL2SETUP.name()) || !line.startsWith(device.getDataBlockLeader()) || !data.isSupportedSentence(line.substring(1, line.indexOf(device.getDataBlockSeparator().value(), 2))))) {
                    if (line != null && (line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.SETUP.name()) || line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.GPSSETUP.name()) || line.startsWith(device.getDataBlockLeader() + NMEAParser.NMEA.UL2SETUP.name()))) {
                        Vector<String> setupLine = new Vector<String>();
                        setupLine.add(line);
                        log.log(Level.INFO, line);
                        if (line.split(",").length > 36) {
                            byte value = (byte)Integer.parseInt(line.split(",")[36], 16);
                            airSpeedFactor = String.format(Messages.getString("GDE_MSGT0988"), 100 + (value > 0 ? value : value)) + "%";
                        }
                        data.parse(setupLine, lineNumber);
                    } else if (line != null && line.startsWith(device.getDataBlockLeader()) && !data.isSupportedSentence(line.substring(1, line.indexOf(device.getDataBlockSeparator().value(), 2)))) {
                        log.log(Level.WARNING, filePath + " line number " + lineNumber + " does not starts with supported NMEA sentence" + line.substring(1, 6) + " !");
                    } else {
                        log.log(Level.WARNING, filePath + " line number " + lineNumber + " does not starts with " + device.getDataBlockLeader() + " !");
                    }
                    ++lineNumber;
                }
                String signature = line.substring(0, 6);
                log.log(Level.FINE, "sync with signature: " + signature);
                --lineNumber;
                do {
                    if ((line = line.trim()).length() > 7) {
                        approximateLines = inputFile.length() / (long)line.length();
                    }
                    ++lineNumber;
                    if (line.length() > 7 && line.startsWith(device.getDataBlockLeader())) {
                        log.log(java.util.logging.Level.FINER, line);
                        lines.add(line);
                    } else {
                        log.log(Level.WARNING, "line number " + lineNumber + " line length to short or missing " + device.getDataBlockLeader() + " !");
                    }
                    log.log(Level.FINER, "signature = " + signature);
                    while (!device.getName().equals("UniLog2") && (line = reader.readLine()) != null) {
                        line = line.trim();
                        ++lineNumber;
                        if (line.startsWith(signature)) break;
                        if (line.length() > 7 && line.startsWith(device.getDataBlockLeader())) {
                            log.log(java.util.logging.Level.FINER, line);
                            lines.add(line);
                            continue;
                        }
                        log.log(Level.WARNING, filePath + " line number " + lineNumber + " line length to short or missing " + device.getDataBlockLeader() + " !");
                    }
                    data.parse(lines, lineNumber);
                    int progress = (int)((long)(lineNumber * 100) / approximateLines);
                    if (progress > lastProgress && progress % 5 == 0) {
                        GDE.getUiNotification().setProgress(progress);
                        lastProgress = progress;
                    }
                    lines.clear();
                    if (line != null && line.length() > 7) {
                        lines.add(line);
                        signature = line.substring(0, 6);
                    }
                    if (device.getStateType() == null) {
                        throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0043", new Object[]{device.getPropertiesFileName()}));
                    }
                    try {
                        recordSetNameExtend = device.getRecordSetStateNameReplacement(1);
                        if (recordNameExtend.length() > 0) {
                            recordSetNameExtend = (String)recordSetNameExtend + " [" + recordNameExtend + "]";
                        }
                    }
                    catch (Exception e) {
                        throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0044", new Object[]{0, filePath, device.getPropertiesFileName()}));
                    }
                    if (recordSet == null || !recordSet.getName().contains((CharSequence)recordSetNameExtend)) {
                        recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                        recordSet = RecordSet.createRecordSet((String)recordSetName, device, activeChannel.getNumber(), true, true, true);
                        recordSetName = recordSet.getName();
                        String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(data.getDate() == null ? new Date() : data.getDate());
                        boolean isOutdated = false;
                        try {
                            isOutdated = Integer.parseInt(dateTime.split("-")[0]) <= 2000;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!isOutdated) {
                            String description = device.getName() + " - " + Messages.getString("GDE_MSGT0129") + dateTime;
                            if (!data.deviceSerialNumber.equals("")) {
                                description = description + GDE.LINE_SEPARATOR + "S/N : " + data.deviceSerialNumber;
                            }
                            if (!data.firmwareVersion.equals("")) {
                                description = description.contains(GDE.LINE_SEPARATOR) ? description + "; Firmware  : " + data.firmwareVersion : GDE.LINE_SEPARATOR + "Firmware  : " + data.firmwareVersion;
                            }
                            ((RecordSet)recordSet).setRecordSetDescription(description);
                            activeChannel.setFileDescription(dateTime.substring(0, 10) + (activeChannel.getFileDescription().length() < 11 ? "" : activeChannel.getFileDescription().substring(10)));
                        } else {
                            ((RecordSet)recordSet).setRecordSetDescription(device.getName() + " - " + Messages.getString("GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date()));
                        }
                        activeChannel.put(recordSetName, recordSet);
                    }
                    if (timeStamp < (long)data.time_ms) {
                        ((RecordSet)recordSet).addNoneCalculationRecordsPoints(data.values, data.time_ms);
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "add " + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss.SSS").format(data.time_ms));
                        }
                    }
                    timeStamp = data.time_ms;
                } while ((line = reader.readLine()) != null);
                activeChannel.setActiveRecordSet((String)recordSetName);
                ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(((RecordSet)activeChannel.get(recordSetName)).getRecordSetDescription() + " " + data.getComment());
                ((RecordSet)activeChannel.get(recordSetName)).setStartTimeStamp(data.getStartTimeStamp());
                activeChannel.applyTemplate((String)recordSetName, true);
                ((RecordSet)activeChannel.get(recordSetName)).checkAllDisplayable();
                device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                ((RecordSet)activeChannel.get(recordSetName)).updateVisibleAndDisplayableRecordsForTable();
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet((String)recordSetName);
                }
                reader.close();
                reader = null;
                ((RecordSet)activeChannel.get(recordSetName)).descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                if (data.airPressures.getMaxEntryCount() > 0) {
                    log.log(Level.INFO, data.airPressures.listValues());
                    String descriptionUpdate = String.format(Messages.getString("GDE_MSGT0989"), filePath.substring(filePath.lastIndexOf(GDE.FILE_SEPARATOR) + 1), airSpeedFactor, (double)data.airPressures.getAvgDiffMaxCount() / 1000.0, data.airPressures.getMaxEntryCount(), data.vcAirSpeed40.getCount(), data.vcAirSpeedDp1.getCount(), data.vcAirSpeed70.getCount(), (double)data.vcAirSpeed40.getAvgValuesA() / 1000.0, (double)data.vcAirSpeedDp1.getAvgValuesA() / 1000.0, (double)data.vcAirSpeed70.getAvgValuesA() / 1000.0, (double)data.vcAirSpeed40.getAvgValuesB() / 1000.0, (double)data.vcAirSpeedDp1.getAvgValuesB() / 1000.0, (double)data.vcAirSpeed70.getAvgValuesB() / 1000.0);
                    log.log(Level.INFO, descriptionUpdate);
                    if (descriptionUpdate.length() > 5 && descriptionUpdate.contains("nmea")) {
                        ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(((RecordSet)activeChannel.get(recordSetName)).getRecordSetDescription() + descriptionUpdate.substring(descriptionUpdate.indexOf("nmea") + 5));
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                if (GDE.isWithUi()) {
                    application.openMessageDialog(e.getMessage());
                }
            }
            catch (IOException e) {
                log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                if (GDE.isWithUi()) {
                    application.openMessageDialog(e.getMessage());
                }
            }
            catch (Exception e) {
                if (activeChannel != null && activeChannel.size() > 0) {
                    recordSetName = activeChannel.getFirstRecordSetName();
                    activeChannel.setActiveRecordSet((String)recordSetName);
                    device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                    ((RecordSet)activeChannel.get(recordSetName)).checkAllDisplayable();
                    if (GDE.isWithUi()) {
                        activeChannel.switchRecordSet((String)recordSetName);
                    }
                }
                String msg = filePath + " - " + Messages.getString("GDE_MSGE0045", new Object[]{e.getMessage(), lineNumber});
                log.log(java.util.logging.Level.WARNING, msg, e);
                if (GDE.isWithUi()) {
                    application.openMessageDialog(msg);
                }
            }
            finally {
                GDE.getUiNotification().setProgress(100);
                GDE.getUiNotification().setStatusMessage("");
            }
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, String.format("read time = %s", StringHelper.getFormatedTime("mm:ss:SSS", System.nanoTime() / 1000000L - startTime)));
        }
        return recordSet;
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
    }
}

