/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.io.IOException;
import java.util.logging.Logger;

public class CSV2SerialPort
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = CSV2SerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    final byte startByte;
    final byte endByte;
    final byte endByte_1;
    final byte[] tmpByte = new byte[1];
    final int timeout;
    final int stableIndex;
    final int tmpDataLength;
    byte[] answer;
    byte[] tmpData;
    byte[] data = new byte[]{0};
    long time = 0L;
    boolean isDataReceived = false;
    int index = 0;
    final boolean isSerialRequest;
    final byte[] serialRequest;

    public CSV2SerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
        this.startByte = (byte)this.device.getDataBlockLeader().charAt(0);
        this.endByte = this.device.getDataBlockEnding()[this.device.getDataBlockEnding().length - 1];
        this.endByte_1 = this.device.getDataBlockEnding().length == 2 ? this.device.getDataBlockEnding()[0] : (byte)0;
        this.tmpDataLength = Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO));
        this.timeout = this.device.getDeviceConfiguration().getReadTimeOut();
        this.stableIndex = this.device.getDeviceConfiguration().getReadStableIndex();
        this.tmpData = new byte[0];
        this.isSerialRequest = this.device.getDeviceConfiguration().isSerialPortRequest();
        this.serialRequest = this.device.getDeviceConfiguration().getSerialPortRequest();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "EOL " + StringHelper.byte2Hex2CharString((byte[])this.device.getDataBlockEnding(), (int)this.device.getDataBlockEnding().length));
        }
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        try {
            if (this.isSerialRequest) {
                this.write(this.serialRequest);
            }
            this.readNewData();
            int startIndex = this.findStartIndex(0);
            this.findDataEnd(startIndex);
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        log.log(Level.INFO, "return received data");
        this.isDataReceived = false;
        return this.data;
    }

    private int findStartIndex(int searchIndex) throws IOException, TimeOutException {
        this.index = searchIndex;
        while (this.index < this.answer.length && this.answer[this.index] != this.startByte) {
            ++this.index;
        }
        if (this.index >= this.answer.length) {
            log.log(Level.WARNING, "startIndex not found, check leading character defined");
            this.isDataReceived = false;
            this.readNewData();
            return this.findStartIndex(0);
        }
        searchIndex = this.index++;
        this.tmpData = new byte[0];
        return searchIndex;
    }

    protected byte[] findDataEnd(int startIndex) throws IOException, TimeOutException {
        String $METHOD_NAME = "findDataEnd";
        if (this.endByte_1 != 0) {
            while (this.index < this.answer.length && (this.endByte_1 == 0 && this.answer[this.index - 1] != this.endByte_1 || this.answer[this.index] != this.endByte)) {
                ++this.index;
            }
        } else {
            while (this.index < this.answer.length && this.answer[this.index] != this.endByte) {
                ++this.index;
            }
        }
        if (this.index < this.answer.length && this.tmpData.length + this.index - startIndex > 8) {
            int endIndex = this.index > 1 && this.endByte_1 != 0 && this.answer[this.index] == this.endByte ? (this.index = this.index - 1) : this.index;
            this.data = new byte[this.tmpData.length + endIndex - startIndex];
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, this.tmpData.length + " + " + endIndex + " - " + startIndex);
            }
            System.arraycopy(this.tmpData, 0, this.data, 0, this.tmpData.length);
            System.arraycopy(this.answer, startIndex, this.data, this.tmpData.length, endIndex - startIndex);
            if (log.isLoggable(Level.FINER)) {
                StringBuilder sb = new StringBuilder();
                for (byte b : this.data) {
                    sb.append((char)b);
                }
                while (sb.length() > 5 && (sb.charAt(sb.length() - 1) == '\n' || sb.charAt(sb.length() - 1) == '\r')) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                log.logp(Level.FINER, $CLASS_NAME, "findDataEnd", sb.toString());
            }
            return this.data;
        }
        log.log(Level.INFO, "endIndex not found, save temporary data, read new data ");
        this.data = new byte[this.tmpData.length];
        System.arraycopy(this.tmpData, 0, this.data, 0, this.data.length);
        this.tmpData = new byte[this.answer.length - startIndex + this.data.length];
        System.arraycopy(this.data, 0, this.tmpData, 0, this.data.length);
        System.arraycopy(this.answer, startIndex, this.tmpData, this.data.length, this.answer.length - startIndex);
        this.isDataReceived = false;
        this.readNewData();
        this.index = 0;
        this.findDataEnd(0);
        return this.data;
    }

    protected void readNewData() throws IOException, TimeOutException {
        if (!this.isDataReceived) {
            this.answer = new byte[this.tmpDataLength];
            this.answer = this.read(this.answer, this.timeout, this.stableIndex);
            this.isDataReceived = true;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])this.answer, (int)this.answer.length));
            }
        }
    }

    protected int getArrayLengthByCheckEnding() {
        int lenght;
        for (lenght = this.tmpData.length; lenght > 0 && (this.endByte_1 == 0 && this.tmpData[lenght - 2] != this.endByte_1 || this.tmpData[lenght - 1] != this.endByte); --lenght) {
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "getArrayLengthByCheckEnding", "array length = " + lenght);
        }
        return lenght;
    }

    protected boolean isChecksumOK(byte[] buffer) {
        String $METHOD_NAME = "isChecksumOK";
        boolean isOK = false;
        int check_sum = Checksum.XOR((byte[])buffer, (int)(buffer.length - 4));
        if (Integer.parseInt(String.format("%c%c", buffer[buffer.length - 4], buffer[buffer.length - 3])) == check_sum) {
            isOK = true;
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "isChecksumOK", "Check_sum = " + isOK);
        }
        return isOK;
    }
}

