/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbPort;
import javax.usb.UsbServices;

public class DumpUsbDevices {
    private static void dumpDevice(UsbDevice device) {
        System.out.println(device);
        UsbPort port = device.getParentUsbPort();
        if (port != null) {
            System.out.println("Connected to port: " + port.getPortNumber());
            System.out.println("Parent: " + String.valueOf(port.getUsbHub()));
        }
        System.out.println(device.getUsbDeviceDescriptor());
        for (UsbConfiguration configuration : device.getUsbConfigurations()) {
            System.out.println(configuration.getUsbConfigurationDescriptor());
            for (UsbInterface iface : configuration.getUsbInterfaces()) {
                System.out.println(iface.getUsbInterfaceDescriptor());
                for (UsbEndpoint endpoint : iface.getUsbEndpoints()) {
                    System.out.println(endpoint.getUsbEndpointDescriptor());
                }
            }
        }
        System.out.println();
        if (device.isUsbHub()) {
            UsbHub hub = (UsbHub)device;
            for (UsbDevice child : hub.getAttachedUsbDevices()) {
                DumpUsbDevices.dumpDevice(child);
            }
        }
    }

    public static void main(String[] args) throws UsbException {
        UsbServices services = UsbHostManager.getUsbServices();
        System.out.println("USB Service Implementation: " + services.getImpDescription());
        System.out.println("Implementation version: " + services.getImpVersion());
        System.out.println("Service API version: " + services.getApiVersion());
        System.out.println();
        DumpUsbDevices.dumpDevice((UsbDevice)services.getRootUsbHub());
    }
}

