/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class JvmAbi {
    @JvmField
    @NotNull
    public static final FqName JVM_FIELD_ANNOTATION_FQ_NAME;
    private static final ClassId REFLECTION_FACTORY_IMPL;
    @NotNull
    public static final JvmAbi INSTANCE;

    @JvmStatic
    public static final boolean isGetterName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return StringsKt.startsWith$default(name, "get", false, 2, null) || StringsKt.startsWith$default(name, "is", false, 2, null);
    }

    @JvmStatic
    public static final boolean isSetterName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return StringsKt.startsWith$default(name, "set", false, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final String getterName(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        return JvmAbi.startsWithIsPrefix(propertyName) ? propertyName : "get" + CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
    }

    @JvmStatic
    @NotNull
    public static final String setterName(@NotNull String propertyName) {
        String string2;
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        StringBuilder stringBuilder = new StringBuilder().append("set");
        if (JvmAbi.startsWithIsPrefix(propertyName)) {
            String string3 = propertyName;
            int n2 = "is".length();
            boolean bl = false;
            String string4 = string3.substring(n2);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = CapitalizeDecapitalizeKt.capitalizeAsciiOnly(propertyName);
        }
        return stringBuilder.append(string2).toString();
    }

    @JvmStatic
    public static final boolean startsWithIsPrefix(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (!StringsKt.startsWith$default(name, "is", false, 2, null)) {
            return false;
        }
        if (name.length() == "is".length()) {
            return false;
        }
        char c2 = name.charAt("is".length());
        return Intrinsics.compare(97, c2) > 0 || Intrinsics.compare(c2, 122) > 0;
    }

    private JvmAbi() {
    }

    static {
        JvmAbi jvmAbi;
        INSTANCE = jvmAbi = new JvmAbi();
        JVM_FIELD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmField");
        ClassId classId = ClassId.topLevel(new FqName("kotlin.reflect.jvm.internal.ReflectionFactoryImpl"));
        Intrinsics.checkNotNullExpressionValue(classId, "ClassId.topLevel(FqName(\u2026.ReflectionFactoryImpl\"))");
        REFLECTION_FACTORY_IMPL = classId;
    }
}

