/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.device.smmodellbau.UniLog2;
import gde.io.DataParser;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class UniLog2SetupReaderWriter {
    static final Logger log = Logger.getLogger(UniLog2SetupReaderWriter.class.getName());
    final DataExplorer application = DataExplorer.getInstance();
    final UniLog2 device;
    final Shell parent;
    static final int TEL_ALARM_CURRENT = 1;
    static final int TEL_ALARM_VOLTAGE_START = 2;
    static final int TEL_ALARM_VOLTAGE = 4;
    static final int TEL_ALARM_CAPACITY = 8;
    static final int TEL_ALARM_HEIGHT = 16;
    static final int TEL_ALARM_VOLTAGE_RX = 32;
    static final int TEL_ALARM_VOLTAGE_CELL = 64;
    static final int TEL_ALARM_ANALOG_1 = 128;
    static final int TEL_ALARM_ANALOG_2 = 256;
    static final int TEL_ALARM_ANALOG_3 = 512;
    static final int TEL_ALARM_CLIMB = 1024;
    static final int TEL_ALARM_SINK = 2048;
    static final int TEL_ALARM_ENERGY = 4096;
    static final int TEL_ALARM_RPM_MIN = 8192;
    static final int TEL_ALARM_RPM_MAX = 16384;
    static final int AUTO_START_CURRENT = 1;
    static final int AUTO_START_RX = 2;
    static final int AUTO_START_TIME = 4;
    static final byte SENSOR_TYPE_GAM = 0;
    static final int SENSOR_TYPE_EAM = 1;
    static final int SENSOR_TYPE_ESC = 2;
    short serialNumber = (short)357;
    short firmwareVersion = (short)109;
    short dataRate = (short)2;
    short startModus = 1;
    short startCurrent = (short)3;
    short startRx = (short)15;
    short startTime = (short)5;
    short currentSensorType = 1;
    short modusA1 = 0;
    short modusA2 = 0;
    short modusA3 = 0;
    short numberProb_MotorPole = (short)2;
    short gearFactor = (short)100;
    short varioThreshold = (short)5;
    short varioTon = 0;
    short limiterModus = 0;
    short energyLimit = (short)1000;
    short minMaxRx = 0;
    short stopModus = 0;
    short varioThresholdSink = (short)5;
    short frskyAddr = 0;
    short telemetrieType = 0;
    short capacityReset = 0;
    short currentOffset = 0;
    short varioOffMotor = 0;
    int jetiValueVisibility = -1;
    short varioFactor = 0;
    byte serialNumberFix = 0;
    byte robbe_T_Box = 0;
    short setTime = 0;
    short varioFilter = 1;
    short telemetryAlarms = 0;
    short currentAlarm = (short)100;
    short voltageStartAlarm = (short)124;
    short voltageAlarm = (short)100;
    short capacityAlarm = (short)2000;
    short heightAlarm = (short)200;
    short voltageRxAlarm = (short)450;
    short cellVoltageAlarm = (short)30;
    short analogAlarm1 = (short)100;
    short analogAlarm2 = (short)100;
    short analogAlarm3 = (short)100;
    short analogAlarm1Direct = 0;
    short analogAlarm2Direct = 0;
    short analogAlarm3Direct = 0;
    short energyAlarm = 0;
    short rpmMinAlarm = 0;
    short rpmMaxAlarm = 0;
    byte mLinkAddressVoltage = 0;
    byte mLinkAddressCurrent = 1;
    byte mLinkAddressRevolution = (byte)2;
    byte mLinkAddressCapacity = (byte)3;
    byte mLinkAddressVario = (byte)4;
    byte mLinkAddressHeight = (byte)5;
    byte mLinkAddressA1 = (byte)7;
    byte mLinkAddressA2 = (byte)8;
    byte mLinkAddressA3 = (byte)9;
    byte mLinkAddressCellMinimum = (byte)10;
    byte mLinkAddressCell1 = (byte)11;
    byte mLinkAddressCell2 = (byte)12;
    byte mLinkAddressCell3 = (byte)13;
    byte mLinkAddressCell4 = (byte)14;
    byte mLinkAddressCell5 = (byte)15;
    byte mLinkAddressCell6 = (byte)15;
    byte mLinkAddressHeightGain = (byte)6;
    byte mLinkAddressEnergy = (byte)15;
    byte[] sbusStartSlot = new byte[16];
    byte spektrumSensors = 0;
    byte spektrumNumber = 0;
    byte mLinkAddressRemainCap = (byte)15;
    byte mLinkAddressFree = (byte)15;
    short betaVersion = 0;
    short hardwareVersion = 0;
    short checkSum;
    byte[] setupData = new byte[192];

    public UniLog2SetupReaderWriter(Shell useParent, UniLog2 useDevice) {
        this.parent = useParent;
        this.device = useDevice;
    }

    void loadSetup() {
        FileDialog fd = this.application.openFileOpenDialog(this.parent, Messages.getString((String)"GDE_MSGT2501"), new String[]{"*.ini", "*"}, this.device.getConfigurationFileDirecotry(), this.device.getDefaultConfigurationFileName(), 4);
        UniLog2.selectedSetupFilePath = fd.getFilterPath() + "/" + fd.getFileName();
        log.log(Level.FINE, "selectedSetupFile = " + UniLog2.selectedSetupFilePath);
        if (fd.getFileName().length() > 4) {
            try {
                FileInputStream file_input = new FileInputStream(new File(UniLog2.selectedSetupFilePath));
                DataInputStream data_in = new DataInputStream(file_input);
                byte[] buffer = new byte[192];
                int size = data_in.read(buffer);
                data_in.close();
                if (size != 192) {
                    log.log(Level.SEVERE, "error reading configuration file, data size != 192 Bytes!");
                }
                this.serialNumber = DataParser.parse2Short((byte[])buffer, (int)0);
                this.firmwareVersion = DataParser.parse2Short((byte[])buffer, (int)2);
                this.dataRate = DataParser.parse2Short((byte[])buffer, (int)4);
                this.startModus = DataParser.parse2Short((byte[])buffer, (int)6);
                this.startCurrent = DataParser.parse2Short((byte[])buffer, (int)8);
                this.startRx = DataParser.parse2Short((byte[])buffer, (int)10);
                this.startTime = DataParser.parse2Short((byte[])buffer, (int)12);
                this.currentSensorType = DataParser.parse2Short((byte[])buffer, (int)14);
                this.modusA1 = DataParser.parse2Short((byte[])buffer, (int)16);
                this.modusA2 = DataParser.parse2Short((byte[])buffer, (int)18);
                this.modusA3 = DataParser.parse2Short((byte[])buffer, (int)20);
                this.numberProb_MotorPole = DataParser.parse2Short((byte[])buffer, (int)22);
                this.gearFactor = DataParser.parse2Short((byte[])buffer, (int)24);
                this.varioThreshold = DataParser.parse2Short((byte[])buffer, (int)26);
                this.varioTon = DataParser.parse2Short((byte[])buffer, (int)28);
                this.limiterModus = DataParser.parse2Short((byte[])buffer, (int)30);
                this.energyLimit = DataParser.parse2Short((byte[])buffer, (int)32);
                this.minMaxRx = DataParser.parse2Short((byte[])buffer, (int)34);
                this.stopModus = DataParser.parse2Short((byte[])buffer, (int)36);
                this.stopModus = DataParser.parse2Short((byte[])buffer, (int)36);
                this.varioThresholdSink = DataParser.parse2Short((byte[])buffer, (int)38);
                this.frskyAddr = DataParser.parse2Short((byte[])buffer, (int)40);
                this.telemetrieType = DataParser.parse2Short((byte[])buffer, (int)42);
                this.capacityReset = DataParser.parse2Short((byte[])buffer, (int)44);
                this.currentOffset = DataParser.parse2Short((byte[])buffer, (int)46);
                this.varioOffMotor = DataParser.parse2Short((byte[])buffer, (int)48);
                this.jetiValueVisibility = DataParser.parse2Int((byte[])buffer, (int)50);
                this.varioFactor = DataParser.parse2Short((byte[])buffer, (int)54);
                this.serialNumberFix = buffer[56];
                this.robbe_T_Box = buffer[57];
                this.setTime = DataParser.parse2Short((byte[])buffer, (int)58);
                this.varioFilter = DataParser.parse2Short((byte[])buffer, (int)60);
                this.telemetryAlarms = DataParser.parse2Short((byte[])buffer, (int)74);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.int2bin_16((int)this.telemetryAlarms));
                }
                this.currentAlarm = DataParser.parse2Short((byte[])buffer, (int)76);
                this.voltageStartAlarm = DataParser.parse2Short((byte[])buffer, (int)78);
                this.voltageAlarm = DataParser.parse2Short((byte[])buffer, (int)80);
                this.capacityAlarm = DataParser.parse2Short((byte[])buffer, (int)82);
                this.heightAlarm = DataParser.parse2Short((byte[])buffer, (int)84);
                this.voltageRxAlarm = DataParser.parse2Short((byte[])buffer, (int)86);
                this.cellVoltageAlarm = DataParser.parse2Short((byte[])buffer, (int)88);
                this.analogAlarm1 = DataParser.parse2Short((byte[])buffer, (int)90);
                this.analogAlarm2 = DataParser.parse2Short((byte[])buffer, (int)92);
                this.analogAlarm3 = DataParser.parse2Short((byte[])buffer, (int)94);
                this.analogAlarm1Direct = DataParser.parse2Short((byte[])buffer, (int)96);
                this.analogAlarm2Direct = DataParser.parse2Short((byte[])buffer, (int)98);
                this.analogAlarm3Direct = DataParser.parse2Short((byte[])buffer, (int)100);
                this.energyAlarm = DataParser.parse2Short((byte[])buffer, (int)102);
                this.rpmMinAlarm = DataParser.parse2Short((byte[])buffer, (int)104);
                this.rpmMaxAlarm = DataParser.parse2Short((byte[])buffer, (int)106);
                this.mLinkAddressVoltage = buffer[128];
                this.mLinkAddressCurrent = buffer[129];
                this.mLinkAddressRevolution = buffer[130];
                this.mLinkAddressCapacity = buffer[131];
                this.mLinkAddressVario = buffer[132];
                this.mLinkAddressHeight = buffer[133];
                this.mLinkAddressA1 = buffer[134];
                this.mLinkAddressA2 = buffer[135];
                this.mLinkAddressA3 = buffer[136];
                this.mLinkAddressCellMinimum = buffer[137];
                this.mLinkAddressCell1 = buffer[138];
                this.mLinkAddressCell2 = buffer[139];
                this.mLinkAddressCell3 = buffer[140];
                this.mLinkAddressCell4 = buffer[141];
                this.mLinkAddressCell5 = buffer[142];
                this.mLinkAddressCell6 = buffer[143];
                this.mLinkAddressHeightGain = buffer[144];
                this.mLinkAddressEnergy = buffer[145];
                System.arraycopy(buffer, 146, this.sbusStartSlot, 0, 16);
                this.spektrumSensors = buffer[162];
                this.spektrumNumber = buffer[163];
                this.mLinkAddressRemainCap = buffer[164];
                this.mLinkAddressFree = buffer[165];
                this.betaVersion = DataParser.parse2Short((byte[])buffer, (int)186);
                this.hardwareVersion = DataParser.parse2Short((byte[])buffer, (int)188);
                this.checkSum = (short)(((buffer[191] & 0xFF) << 8) + (buffer[190] & 0xFF));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "$UL2SETUP," + StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
                }
                byte[] chkBuffer = new byte[190];
                System.arraycopy(buffer, 0, chkBuffer, 0, chkBuffer.length);
                short checkCRC = Checksum.CRC16((byte[])chkBuffer, (int)0);
                if (this.checkSum != checkCRC) {
                    log.log(Level.WARNING, "Checksum missmatch!");
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    void saveSetup() {
        FileDialog fileDialog = this.application.prepareFileSaveDialog(this.parent, Messages.getString((String)"GDE_MSGT2502"), new String[]{"*.ini", "*"}, this.device.getConfigurationFileDirecotry(), this.device.getDefaultConfigurationFileName());
        log.log(Level.FINE, "selectedSetupFile = " + fileDialog.getFileName());
        String setupFilePath = fileDialog.open();
        if (setupFilePath != null && setupFilePath.length() > 4) {
            File setupFile = new File(setupFilePath);
            byte[] buffer = new byte[192];
            short tmpCheckSum = 0;
            try {
                buffer[0] = (byte)(this.serialNumber & 0xFF);
                buffer[1] = (byte)((this.serialNumber & 0xFF00) >> 8);
                buffer[2] = (byte)(this.firmwareVersion & 0xFF);
                buffer[3] = (byte)((this.firmwareVersion & 0xFF00) >> 8);
                buffer[4] = (byte)(this.dataRate & 0xFF);
                buffer[5] = (byte)((this.dataRate & 0xFF00) >> 8);
                buffer[6] = (byte)(this.startModus & 0xFF);
                buffer[7] = (byte)((this.startModus & 0xFF00) >> 8);
                buffer[8] = (byte)(this.startCurrent & 0xFF);
                buffer[9] = (byte)((this.startCurrent & 0xFF00) >> 8);
                buffer[10] = (byte)(this.startRx & 0xFF);
                buffer[11] = (byte)((this.startRx & 0xFF00) >> 8);
                buffer[12] = (byte)(this.startTime & 0xFF);
                buffer[13] = (byte)((this.startTime & 0xFF00) >> 8);
                buffer[14] = (byte)(this.currentSensorType & 0xFF);
                buffer[15] = (byte)((this.currentSensorType & 0xFF00) >> 8);
                buffer[16] = (byte)(this.modusA1 & 0xFF);
                buffer[17] = (byte)((this.modusA1 & 0xFF00) >> 8);
                buffer[18] = (byte)(this.modusA2 & 0xFF);
                buffer[19] = (byte)((this.modusA2 & 0xFF00) >> 8);
                buffer[20] = (byte)(this.modusA3 & 0xFF);
                buffer[21] = (byte)((this.modusA3 & 0xFF00) >> 8);
                buffer[22] = (byte)(this.numberProb_MotorPole & 0xFF);
                buffer[23] = (byte)((this.numberProb_MotorPole & 0xFF00) >> 8);
                buffer[24] = (byte)(this.gearFactor & 0xFF);
                buffer[25] = (byte)((this.gearFactor & 0xFF00) >> 8);
                buffer[26] = (byte)(this.varioThreshold & 0xFF);
                buffer[27] = (byte)((this.varioThreshold & 0xFF00) >> 8);
                buffer[28] = (byte)(this.varioTon & 0xFF);
                buffer[29] = (byte)((this.varioTon & 0xFF00) >> 8);
                buffer[30] = (byte)(this.limiterModus & 0xFF);
                buffer[31] = (byte)((this.limiterModus & 0xFF00) >> 8);
                buffer[32] = (byte)(this.energyLimit & 0xFF);
                buffer[33] = (byte)((this.energyLimit & 0xFF00) >> 8);
                buffer[34] = (byte)(this.minMaxRx & 0xFF);
                buffer[35] = (byte)((this.minMaxRx & 0xFF00) >> 8);
                buffer[36] = (byte)(this.stopModus & 0xFF);
                buffer[37] = (byte)((this.stopModus & 0xFF00) >> 8);
                buffer[38] = (byte)(this.varioThresholdSink & 0xFF);
                buffer[39] = (byte)((this.varioThresholdSink & 0xFF00) >> 8);
                buffer[40] = (byte)(this.frskyAddr & 0xFF);
                buffer[41] = (byte)((this.frskyAddr & 0xFF00) >> 8);
                buffer[42] = (byte)(this.telemetrieType & 0xFF);
                buffer[43] = (byte)((this.telemetrieType & 0xFF00) >> 8);
                buffer[44] = (byte)(this.capacityReset & 0xFF);
                buffer[45] = (byte)((this.capacityReset & 0xFF00) >> 8);
                buffer[46] = (byte)(this.currentOffset & 0xFF);
                buffer[47] = (byte)((this.currentOffset & 0xFF00) >> 8);
                buffer[48] = (byte)(this.varioOffMotor & 0xFF);
                buffer[49] = (byte)((this.varioOffMotor & 0xFF00) >> 8);
                buffer[50] = (byte)(this.jetiValueVisibility & 0xFF);
                buffer[51] = (byte)((this.jetiValueVisibility & 0xFF00) >> 8);
                buffer[52] = (byte)((this.jetiValueVisibility & 0xFF0000) >> 16);
                buffer[53] = (byte)((this.jetiValueVisibility & 0xFF000000) >> 24);
                buffer[54] = (byte)(this.varioFactor & 0xFF);
                buffer[55] = (byte)((this.varioFactor & 0xFF00) >> 8);
                buffer[56] = (byte)(this.serialNumberFix & 0xFF);
                buffer[57] = (byte)(this.robbe_T_Box & 0xFF);
                buffer[58] = (byte)(this.setTime & 0xFF);
                buffer[59] = (byte)((this.setTime & 0xFF00) >> 8);
                buffer[60] = (byte)(this.varioFilter & 0xFF);
                buffer[61] = (byte)((this.varioFilter & 0xFF00) >> 8);
                buffer[74] = (byte)(this.telemetryAlarms & 0xFF);
                buffer[75] = (byte)((this.telemetryAlarms & 0xFF00) >> 8);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.int2bin_16((int)this.telemetryAlarms));
                }
                buffer[76] = (byte)(this.currentAlarm & 0xFF);
                buffer[77] = (byte)((this.currentAlarm & 0xFF00) >> 8);
                buffer[78] = (byte)(this.voltageStartAlarm & 0xFF);
                buffer[79] = (byte)((this.voltageStartAlarm & 0xFF00) >> 8);
                buffer[80] = (byte)(this.voltageAlarm & 0xFF);
                buffer[81] = (byte)((this.voltageAlarm & 0xFF00) >> 8);
                buffer[82] = (byte)(this.capacityAlarm & 0xFF);
                buffer[83] = (byte)((this.capacityAlarm & 0xFF00) >> 8);
                buffer[84] = (byte)(this.heightAlarm & 0xFF);
                buffer[85] = (byte)((this.heightAlarm & 0xFF00) >> 8);
                buffer[86] = (byte)(this.voltageRxAlarm & 0xFF);
                buffer[87] = (byte)((this.voltageRxAlarm & 0xFF00) >> 8);
                buffer[88] = (byte)(this.cellVoltageAlarm & 0xFF);
                buffer[89] = (byte)((this.cellVoltageAlarm & 0xFF00) >> 8);
                buffer[90] = (byte)(this.analogAlarm1 & 0xFF);
                buffer[91] = (byte)((this.analogAlarm1 & 0xFF00) >> 8);
                buffer[92] = (byte)(this.analogAlarm2 & 0xFF);
                buffer[93] = (byte)((this.analogAlarm2 & 0xFF00) >> 8);
                buffer[94] = (byte)(this.analogAlarm3 & 0xFF);
                buffer[95] = (byte)((this.analogAlarm3 & 0xFF00) >> 8);
                buffer[96] = (byte)(this.analogAlarm1Direct & 0xFF);
                buffer[97] = (byte)((this.analogAlarm1Direct & 0xFF00) >> 8);
                buffer[98] = (byte)(this.analogAlarm2Direct & 0xFF);
                buffer[99] = (byte)((this.analogAlarm2Direct & 0xFF00) >> 8);
                buffer[100] = (byte)(this.analogAlarm3Direct & 0xFF);
                buffer[101] = (byte)((this.analogAlarm3Direct & 0xFF00) >> 8);
                buffer[102] = (byte)(this.energyAlarm & 0xFF);
                buffer[103] = (byte)((this.energyAlarm & 0xFF00) >> 8);
                buffer[104] = (byte)(this.rpmMinAlarm & 0xFF);
                buffer[105] = (byte)((this.rpmMinAlarm & 0xFF00) >> 8);
                buffer[106] = (byte)(this.rpmMaxAlarm & 0xFF);
                buffer[107] = (byte)((this.rpmMaxAlarm & 0xFF00) >> 8);
                buffer[128] = this.mLinkAddressVoltage;
                buffer[129] = this.mLinkAddressCurrent;
                buffer[130] = this.mLinkAddressRevolution;
                buffer[131] = this.mLinkAddressCapacity;
                buffer[132] = this.mLinkAddressVario;
                buffer[133] = this.mLinkAddressHeight;
                buffer[134] = this.mLinkAddressA1;
                buffer[135] = this.mLinkAddressA2;
                buffer[136] = this.mLinkAddressA3;
                buffer[137] = this.mLinkAddressCellMinimum;
                buffer[138] = this.mLinkAddressCell1;
                buffer[139] = this.mLinkAddressCell2;
                buffer[140] = this.mLinkAddressCell3;
                buffer[141] = this.mLinkAddressCell4;
                buffer[142] = this.mLinkAddressCell5;
                buffer[143] = this.mLinkAddressCell6;
                buffer[144] = this.mLinkAddressHeightGain;
                buffer[145] = this.mLinkAddressEnergy;
                System.arraycopy(this.sbusStartSlot, 0, buffer, 146, 8);
                buffer[162] = this.spektrumSensors;
                buffer[163] = this.spektrumNumber;
                buffer[164] = this.mLinkAddressRemainCap;
                buffer[165] = this.mLinkAddressFree;
                buffer[186] = (byte)(this.betaVersion & 0xFF);
                buffer[187] = (byte)((this.betaVersion & 0xFF00) >> 8);
                buffer[188] = (byte)(this.hardwareVersion & 0xFF);
                buffer[189] = (byte)((this.hardwareVersion & 0xFF00) >> 8);
                byte[] chkBuffer = new byte[190];
                System.arraycopy(buffer, 0, chkBuffer, 0, chkBuffer.length);
                tmpCheckSum = Checksum.CRC16((byte[])chkBuffer, (int)0);
                buffer[190] = (byte)(tmpCheckSum & 0xFF);
                buffer[191] = (byte)((tmpCheckSum & 0xFF00) >> 8);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "$UL2SETUP," + StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
                }
                FileOutputStream file_out = new FileOutputStream(setupFile);
                DataOutputStream data_out = new DataOutputStream(file_out);
                data_out.write(buffer);
                data_out.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Error writing setupfile = " + fileDialog.getFileName() + " - " + e.getMessage());
            }
        }
    }

    public int getJetiMeasurementCount() {
        int count = 20;
        for (int i = 0; i < 32; ++i) {
            count -= this.jetiValueVisibility >> i & 1;
        }
        return count;
    }

    public static enum Sensor {
        GAM("GAM"),
        EAM("EAM"),
        ESC("ESC");

        private final String value;

        private Sensor(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static List<Sensor> getAsList() {
            ArrayList<Sensor> sensors = new ArrayList<Sensor>();
            for (Sensor sensor : Sensor.values()) {
                sensors.add(sensor);
            }
            return sensors;
        }
    }
}

