/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.ThreeEighthesFieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeEighthesFieldIntegrator<T extends RealFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public ThreeEighthesFieldIntegrator(Field<T> field2, T step) {
        super(field2, "3/8", step);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] c2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), 3);
        c2[0] = this.fraction(1, 3);
        c2[1] = c2[0].add(c2[0]);
        c2[2] = (RealFieldElement)this.getField().getOne();
        return c2;
    }

    @Override
    public T[][] getA() {
        RealFieldElement[][] a2 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 3, -1);
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i2 + 1);
        }
        a2[0][0] = this.fraction(1, 3);
        a2[1][0] = (RealFieldElement)a2[0][0].negate();
        a2[1][1] = (RealFieldElement)this.getField().getOne();
        a2[2][0] = (RealFieldElement)this.getField().getOne();
        a2[2][1] = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
        a2[2][2] = (RealFieldElement)this.getField().getOne();
        return a2;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] b2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), 4);
        b2[0] = this.fraction(1, 8);
        b2[1] = this.fraction(3, 8);
        b2[2] = b2[1];
        b2[3] = b2[0];
        return b2;
    }

    @Override
    protected ThreeEighthesFieldStepInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new ThreeEighthesFieldStepInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

