/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.Stack;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationShrinker
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG = false;
    private static final int UNSUPPORTED = -1;
    private static final int NOP = 0;
    private static final int POP = 87;
    private static final int POP2 = 88;
    private static final int DUP = 89;
    private static final int DUP_X1 = 90;
    private static final int DUP_X2 = 91;
    private static final int DUP2 = 92;
    private static final int DUP2_X1 = 93;
    private static final int DUP2_X2 = 94;
    private static final int SWAP = 95;
    private static final int MOV_X2 = 22363;
    private static final int MOV2_X1 = 22621;
    private static final int MOV2_X2 = 22622;
    private static final int POP_X1 = 22367;
    private static final int POP_X2 = 5724253;
    private static final int POP_X3 = -1;
    private static final int POP2_X1 = 5789531;
    private static final int POP2_X2 = 0x58585E;
    private static final int POP3 = 22360;
    private static final int POP4 = 22616;
    private static final int POP_DUP = 22871;
    private static final int POP_SWAP_POP = 0x575F57;
    private static final int POP2_SWAP_POP = 5726040;
    private static final int SWAP_DUP_X1 = 23135;
    private static final int SWAP_DUP_X1_SWAP = 0x5F5A5F;
    private static final int SWAP_POP_DUP = 5855071;
    private static final int SWAP_POP_DUP_X1 = 5920607;
    private static final int DUP_X2_POP2 = 22619;
    private static final int DUP2_X1_POP3 = 5724253;
    private static final int DUP2_X2_POP3 = 5724254;
    private static final int DUP2_X2_SWAP_POP = 5726046;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator();
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true, true);
    private final MyUnusedParameterSimplifier unusedParameterSimplifier = new MyUnusedParameterSimplifier();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyVariableInitializationMarker variableInitializationMarker = new MyVariableInitializationMarker();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false, false);
    private boolean[][] stacksNecessaryAfter = new boolean[1024][16];
    private boolean[][] stacksSimplifiedBefore = new boolean[1024][16];
    private boolean[] instructionsNecessary = new boolean[1024];
    private int maxMarkedOffset;

    public EvaluationShrinker() {
        this(new PartialEvaluator(), null, null);
    }

    public EvaluationShrinker(PartialEvaluator partialEvaluator, InstructionVisitor instructionVisitor, InstructionVisitor instructionVisitor2) {
        this.partialEvaluator = partialEvaluator;
        this.extraDeletedInstructionVisitor = instructionVisitor;
        this.extraAddedInstructionVisitor = instructionVisitor2;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while shrinking instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        int n;
        int n2;
        this.initializeNecessary(codeAttribute);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int n3 = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.partialEvaluator.isTraced(n2)) continue;
            Instruction instruction2 = InstructionFactory.create(codeAttribute.code, n2);
            instruction2.accept(clazz, method, codeAttribute, n2, this.unusedParameterSimplifier);
        }
        this.maxMarkedOffset = -1;
        n2 = this.partialEvaluator.superInitializationOffset();
        if (n2 != -2) {
            this.markInstruction(n2);
        }
        for (n = 0; n < n3; ++n) {
            if (!this.partialEvaluator.isTraced(n)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, n);
            if (instruction.opcode == -89 && ((BranchInstruction)instruction).branchOffset == 0) {
                this.markInstruction(n);
                continue;
            }
            if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, n, instruction)) continue;
            this.markInstruction(n);
        }
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            if (this.isInstructionNecessary(n)) {
                instruction = InstructionFactory.create(codeAttribute.code, n);
                instruction.accept(clazz, method, codeAttribute, n, this.producerMarker);
            }
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        for (n = 0; n < n3; ++n) {
            if (!this.isInstructionNecessary(n)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, n);
            instruction.accept(clazz, method, codeAttribute, n, this.variableInitializationMarker);
        }
        this.maxMarkedOffset = n3 - 1;
        while (this.maxMarkedOffset >= 0) {
            n = this.maxMarkedOffset;
            this.maxMarkedOffset = n - 1;
            if (!this.partialEvaluator.isTraced(n)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, n);
            instruction.accept(clazz, method, codeAttribute, n, this.stackConsistencyFixer);
            this.markStraddlingBranches(n, this.partialEvaluator.branchTargets(n), true);
            this.markStraddlingBranches(n, this.partialEvaluator.branchOrigins(n), false);
        }
        for (n = 0; n < n3; ++n) {
            if (!this.partialEvaluator.isTraced(n) || this.isInstructionNecessary(n) || !this.isAllSmallerThanOrEqual(this.partialEvaluator.branchTargets(n), n) || this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(n), n)) continue;
            this.replaceByInfiniteLoop(clazz, n);
        }
        for (n = 0; n < n3; ++n) {
            int n4;
            if (!this.isInstructionNecessary(n) || !this.partialEvaluator.isSubroutineInvocation(n) || this.isInstructionNecessary(n4 = n + (instruction = InstructionFactory.create(codeAttribute.code, n)).length(n))) continue;
            this.replaceByInfiniteLoop(clazz, n4);
        }
        n = 0;
        do {
            instruction = InstructionFactory.create(codeAttribute.code, n);
            if (this.isInstructionNecessary(n)) continue;
            this.codeAttributeEditor.clearModifications(n);
            this.codeAttributeEditor.deleteInstruction(n);
            if (this.extraDeletedInstructionVisitor == null) continue;
            instruction.accept(clazz, method, codeAttribute, n, this.extraDeletedInstructionVisitor);
        } while ((n += instruction.length(n)) < n3);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private void markVariableProducers(int n, int n2) {
        InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getVariablesBefore(n).getProducerValue(n2).instructionOffsetValue();
        if (instructionOffsetValue != null) {
            int n3 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n3; ++i) {
                int n4 = instructionOffsetValue.instructionOffset(i);
                this.markInstruction(n4);
            }
        }
    }

    private void markVariableInitializers(int n, int n2) {
        InstructionOffsetValue instructionOffsetValue = this.simplePartialEvaluator.getVariablesBefore(n).getProducerValue(n2).instructionOffsetValue();
        if (instructionOffsetValue != null) {
            int n3 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n3; ++i) {
                int n4 = instructionOffsetValue.instructionOffset(i);
                if (this.isInstructionNecessary(n4) || !this.isVariableInitialization(n4, n2)) continue;
                this.markInstruction(n4);
            }
        }
    }

    private void markStackProducers(Clazz clazz, int n, Instruction instruction) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        int n2 = tracedStack.size();
        int n3 = instruction.stackPopCount(clazz);
        for (int i = n2 - n3; i < n2; ++i) {
            this.markStackEntryProducers(n, i);
        }
    }

    private void conditionallyMarkStackEntryProducers(int n, int n2, int n3) {
        int n4 = this.partialEvaluator.getStackAfter(n).size() - n2 - 1;
        if (this.isStackEntryNecessaryAfter(n, n4)) {
            int n5 = this.partialEvaluator.getStackBefore(n).size() - n3 - 1;
            this.markStackEntryProducers(n, n5);
        }
    }

    private void markStackEntryProducers(int n, int n2) {
        if (!this.isStackSimplifiedBefore(n, n2)) {
            this.markStackEntryProducers(this.partialEvaluator.getStackBefore(n).getBottomProducerValue(n2).instructionOffsetValue(), n2);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue instructionOffsetValue, int n) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                this.markStackEntryAfter(n3, n);
                this.markInstruction(n3);
            }
        }
    }

    private void markInitialization(int n) {
        int n2 = this.partialEvaluator.initializationOffset(n);
        TracedStack tracedStack = this.partialEvaluator.getStackAfter(n);
        this.markStackEntryAfter(n2, tracedStack.size() - 1);
        this.markInstruction(n2);
    }

    private void markStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, boolean bl) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                if (bl) {
                    this.markStraddlingBranch(n, n3, n, n3);
                    continue;
                }
                this.markStraddlingBranch(n, n3, n3, n);
            }
        }
    }

    private void markStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isInstructionNecessary(n3) && this.isAnyInstructionNecessary(n, n2)) {
            this.markInstruction(n3);
        }
    }

    private void insertPushInstructions(int n, boolean bl, int n2) {
        this.markInstruction(n);
        SimpleInstruction simpleInstruction = new SimpleInstruction(this.pushOpcode(n2));
        if (bl) {
            this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
        } else {
            this.codeAttributeEditor.insertBeforeInstruction(n, simpleInstruction);
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
            }
        }
    }

    private byte pushOpcode(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + n + "]");
    }

    private void insertPopInstructions(int n, boolean bl, int n2) {
        this.markInstruction(n);
        switch (n2) {
            case 1: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(87);
                if (bl) {
                    this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
                    break;
                }
                this.codeAttributeEditor.insertAfterInstruction(n, simpleInstruction);
                if (this.extraAddedInstructionVisitor == null) break;
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
                break;
            }
            case 2: {
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                if (bl) {
                    this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
                    break;
                }
                this.codeAttributeEditor.insertAfterInstruction(n, simpleInstruction);
                if (this.extraAddedInstructionVisitor == null) break;
                ((Instruction)simpleInstruction).accept(null, null, null, n, this.extraAddedInstructionVisitor);
                break;
            }
            default: {
                int n3;
                Instruction[] instructionArray = new Instruction[n2 / 2 + n2 % 2];
                SimpleInstruction simpleInstruction = new SimpleInstruction(88);
                for (n3 = 0; n3 < n2 / 2; ++n3) {
                    instructionArray[n3] = simpleInstruction;
                }
                if (n2 % 2 == 1) {
                    simpleInstruction = new SimpleInstruction(87);
                    instructionArray[n2 / 2] = simpleInstruction;
                }
                if (bl) {
                    this.codeAttributeEditor.replaceInstruction(n, instructionArray);
                    for (n3 = 1; n3 < instructionArray.length; ++n3) {
                        if (this.extraAddedInstructionVisitor == null) continue;
                        instructionArray[n3].accept(null, null, null, n, this.extraAddedInstructionVisitor);
                    }
                } else {
                    this.codeAttributeEditor.insertAfterInstruction(n, instructionArray);
                    for (n3 = 0; n3 < instructionArray.length; ++n3) {
                        if (this.extraAddedInstructionVisitor == null) continue;
                        instructionArray[n3].accept(null, null, null, n, this.extraAddedInstructionVisitor);
                    }
                }
                break;
            }
        }
    }

    private void replaceByStaticInvocation(Clazz clazz, int n, ConstantInstruction constantInstruction) {
        ConstantInstruction constantInstruction2 = new ConstantInstruction(-72, constantInstruction.constantIndex);
        this.codeAttributeEditor.replaceInstruction(n, constantInstruction2);
    }

    private void replaceByInfiniteLoop(Clazz clazz, int n) {
        this.markInstruction(n);
        BranchInstruction branchInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(n, branchInstruction);
    }

    private boolean isDupOrSwap(Instruction instruction) {
        return instruction.opcode >= 89 && instruction.opcode <= 95;
    }

    private boolean isPop(Instruction instruction) {
        return instruction.opcode == 87 || instruction.opcode == 88;
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.partialEvaluator.isTraced(i) || this.isInstructionNecessary(i) || !this.isAnyLargerThan(this.partialEvaluator.branchTargets(i), n2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2;
        if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2;
        if (instructionOffsetValue != null && (n2 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                if (instructionOffsetValue.instructionOffset(i) <= n) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int n;
        int n2 = codeAttribute.u4codeLength;
        int n3 = codeAttribute.u2maxLocals;
        int n4 = codeAttribute.u2maxStack;
        if (this.stacksNecessaryAfter.length < n2 || this.stacksNecessaryAfter[0].length < n4) {
            this.stacksNecessaryAfter = new boolean[n2][n4];
        } else {
            for (n = 0; n < n2; ++n) {
                Arrays.fill(this.stacksNecessaryAfter[n], 0, n4, false);
            }
        }
        if (this.stacksSimplifiedBefore.length < n2 || this.stacksSimplifiedBefore[0].length < n4) {
            this.stacksSimplifiedBefore = new boolean[n2][n4];
        } else {
            for (n = 0; n < n2; ++n) {
                Arrays.fill(this.stacksSimplifiedBefore[n], 0, n4, false);
            }
        }
        if (this.instructionsNecessary.length < n2) {
            this.instructionsNecessary = new boolean[n2];
        } else {
            Arrays.fill(this.instructionsNecessary, 0, n2, false);
        }
    }

    private boolean isVariableInitialization(int n, int n2) {
        Value value = this.partialEvaluator.getVariablesBefore(n).getValue(n2);
        if (value == null) {
            return true;
        }
        Value value2 = this.partialEvaluator.getVariablesAfter(n).getValue(n2);
        if (value2.computationalType() != value.computationalType()) {
            return true;
        }
        if (!(value2.computationalType() != 5 || value2.referenceValue().isNull() != 1 && value2.referenceValue().getType().equals(value.referenceValue().getType()))) {
            return true;
        }
        Value value3 = this.partialEvaluator.getVariablesBefore(n).getProducerValue(n2);
        return value3.instructionOffsetValue().instructionOffsetCount() == 1 && value3.instructionOffsetValue().instructionOffset(0) == -1;
    }

    private void markStackEntryAfter(int n, int n2) {
        if (!this.isStackEntryNecessaryAfter(n, n2)) {
            this.stacksNecessaryAfter[n][n2] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isStackEntriesPresentBefore(int n, int n2, int n3) {
        boolean bl = this.isStackEntryPresentBefore(n, n2);
        boolean bl2 = this.isStackEntryPresentBefore(n, n3);
        return bl || bl2;
    }

    private boolean isStackEntryPresentBefore(int n, int n2) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(n);
        InstructionOffsetValue instructionOffsetValue = tracedStack.getBottomProducerValue(n2).instructionOffsetValue();
        return this.isAnyStackEntryNecessaryAfter(instructionOffsetValue, n2);
    }

    private boolean isStackEntriesNecessaryAfter(int n, int n2, int n3) {
        boolean bl = this.isStackEntryNecessaryAfter(n, n2);
        boolean bl2 = this.isStackEntryNecessaryAfter(n, n3);
        return bl || bl2;
    }

    private boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsetValue, int n) {
        int n2 = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.isStackEntryNecessaryAfter(instructionOffsetValue.instructionOffset(i), n)) continue;
            return true;
        }
        return false;
    }

    private boolean isStackEntryNecessaryAfter(int n, int n2) {
        return n == -1 || this.stacksNecessaryAfter[n][n2];
    }

    private void markStackSimplificationBefore(int n, int n2) {
        this.stacksSimplifiedBefore[n][n2] = true;
    }

    private boolean isStackSimplifiedBefore(int n, int n2) {
        return this.stacksSimplifiedBefore[n][n2];
    }

    private void markInstruction(int n) {
        if (!this.isInstructionNecessary(n)) {
            this.instructionsNecessary[n] = true;
            if (this.maxMarkedOffset < n) {
                this.maxMarkedOffset = n;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isInstructionNecessary(i)) continue;
            return true;
        }
        return false;
    }

    private int lastNecessaryInstructionOffset(int n) {
        for (int i = n - 1; i >= 0; --i) {
            if (!this.isInstructionNecessary(n)) continue;
            return i;
        }
        return 0;
    }

    private boolean isInstructionNecessary(int n) {
        return n == -1 || this.instructionsNecessary[n];
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(n)) {
                int n2;
                int n3;
                int n4;
                Object object;
                int n5 = instruction.stackPopCount(clazz);
                if (n5 > 0) {
                    object = EvaluationShrinker.this.partialEvaluator.getStackBefore(n);
                    n4 = ((Stack)object).size();
                    n3 = 0;
                    for (n2 = n4 - n5; n2 < n4; ++n2) {
                        if (EvaluationShrinker.this.isStackSimplifiedBefore(n, n2)) continue;
                        if (EvaluationShrinker.this.isStackEntryPresentBefore(n, n2)) {
                            EvaluationShrinker.this.markStackEntryProducers(n, n2);
                            continue;
                        }
                        ++n3;
                    }
                    if (n3 > 0) {
                        if (n3 > (instruction.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + n3 + "] at [" + n + "]");
                        }
                        EvaluationShrinker.this.insertPushInstructions(n, false, ((Stack)object).getTop(0).computationalType());
                    }
                }
                if ((object = EvaluationShrinker.this.partialEvaluator.branchTargets(n)) != null && ((InstructionOffsetValue)object).instructionOffsetCount() == 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(n);
                    n3 = tracedStack.size() - n5;
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!EvaluationShrinker.this.isStackEntryPresentBefore(n, n2)) continue;
                        EvaluationShrinker.this.markStackEntryProducers(n, n2);
                    }
                }
                if ((n4 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(n);
                    n2 = tracedStack.size();
                    int n6 = 0;
                    for (int i = n2 - n4; i < n2; ++i) {
                        if (EvaluationShrinker.this.isStackEntryNecessaryAfter(n, i)) continue;
                        ++n6;
                    }
                    if (n6 > 0) {
                        EvaluationShrinker.this.insertPopInstructions(n, false, n6);
                    }
                }
            } else {
                int n7;
                int n8;
                int n9;
                int n10 = instruction.stackPopCount(clazz);
                if (n10 > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(n);
                    int n11 = tracedStack.size();
                    n9 = 0;
                    for (n8 = n11 - n10; n8 < n11; ++n8) {
                        if (!EvaluationShrinker.this.isStackEntryPresentBefore(n, n8)) continue;
                        EvaluationShrinker.this.markStackEntryProducers(n, n8);
                        ++n9;
                    }
                    if (n9 > 0) {
                        EvaluationShrinker.this.insertPopInstructions(n, true, n9);
                    }
                }
                if ((n7 = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(n);
                    n9 = tracedStack.size();
                    n8 = 0;
                    for (int i = n9 - n7; i < n9; ++i) {
                        if (!EvaluationShrinker.this.isStackEntryNecessaryAfter(n, i)) continue;
                        ++n8;
                    }
                    if (n8 > 0) {
                        EvaluationShrinker.this.insertPushInstructions(n, true, tracedStack.getTop(0).computationalType());
                    }
                }
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(n) && EvaluationShrinker.this.isDupOrSwap(simpleInstruction)) {
                int n2;
                byte by;
                int n3;
                int n4;
                int n5 = EvaluationShrinker.this.partialEvaluator.getStackBefore(n).size();
                int n6 = simpleInstruction.stackPopCount(clazz);
                if (n6 > 0) {
                    for (n4 = n5 - n6; n4 < n5; ++n4) {
                        if (!EvaluationShrinker.this.isStackEntryPresentBefore(n, n4)) continue;
                        EvaluationShrinker.this.markStackEntryProducers(n, n4);
                    }
                }
                if ((n3 = this.fixDupSwap(n, by = simpleInstruction.opcode, n4 = n5 - 1, n2 = EvaluationShrinker.this.partialEvaluator.getStackAfter(n).size() - 1)) == -1) {
                    throw new UnsupportedOperationException("Can't handle " + simpleInstruction.toString() + " instruction at [" + n + "]");
                }
                if ((n3 & 0xFFFFFF00) == 0) {
                    byte by2 = (byte)n3;
                    if (by2 == 0) {
                        EvaluationShrinker.this.codeAttributeEditor.deleteInstruction(n);
                        if (EvaluationShrinker.this.extraDeletedInstructionVisitor != null) {
                            EvaluationShrinker.this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, n, null);
                        }
                    } else if (by2 == by) {
                        EvaluationShrinker.this.codeAttributeEditor.undeleteInstruction(n);
                    } else {
                        SimpleInstruction simpleInstruction2 = new SimpleInstruction(by2);
                        EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(n, simpleInstruction2);
                    }
                } else {
                    Instruction[] instructionArray;
                    Instruction[] instructionArray2 = new Instruction[4];
                    int n7 = 0;
                    while (n3 != 0) {
                        instructionArray = new SimpleInstruction((byte)n3);
                        instructionArray2[n7++] = instructionArray;
                        n3 >>>= 8;
                    }
                    if (n7 < 4) {
                        instructionArray = new Instruction[n7];
                        System.arraycopy(instructionArray2, 0, instructionArray, 0, n7);
                        instructionArray2 = instructionArray;
                    }
                    EvaluationShrinker.this.codeAttributeEditor.replaceInstruction(n, instructionArray2);
                }
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, n, simpleInstruction);
            }
        }

        private int fixDupSwap(int n, byte by, int n2, int n3) {
            switch (by) {
                case 89: {
                    return this.fixedDup(n, n2, n3);
                }
                case 90: {
                    return this.fixedDup_x1(n, n2, n3);
                }
                case 91: {
                    return this.fixedDup_x2(n, n2, n3);
                }
                case 92: {
                    return this.fixedDup2(n, n2, n3);
                }
                case 93: {
                    return this.fixedDup2_x1(n, n2, n3);
                }
                case 94: {
                    return this.fixedDup2_x2(n, n2, n3);
                }
                case 95: {
                    return this.fixedSwap(n, n2, n3);
                }
            }
            throw new IllegalArgumentException("Not a dup/swap opcode [" + by + "]");
        }

        private int fixedDup(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 0);
            boolean bl2 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 0);
            boolean bl3 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 1);
            return bl2 ? (bl3 ? 89 : 0) : (bl3 ? 0 : (bl ? 87 : 0));
        }

        private int fixedDup_x1(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 0);
            boolean bl2 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 0);
            boolean bl4 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 1);
            boolean bl5 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 2);
            return bl4 ? (bl5 ? (bl3 ? 90 : 95) : (bl3 ? 0 : (bl ? 87 : 0))) : (bl2 ? (bl5 ? (bl3 ? 5855071 : 22367) : (bl3 ? 22367 : (bl ? 88 : 87))) : (bl5 ? (bl3 ? 89 : 0) : (bl3 ? 0 : (bl ? 87 : 0))));
        }

        private int fixedDup_x2(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 0);
            boolean bl2 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 2);
            boolean bl4 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 0);
            boolean bl5 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 1);
            boolean bl6 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl7 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 3);
            return bl5 ? (bl6 ? (bl7 ? (bl4 ? 91 : 22363) : (bl4 ? 0 : (bl ? 87 : 0))) : (bl3 ? (bl7 ? -1 : (bl4 ? 5724253 : (bl ? 0x575F57 : 22367))) : (bl7 ? (bl4 ? 90 : 95) : (bl4 ? 0 : (bl ? 87 : 0))))) : (bl2 ? (bl6 ? (bl7 ? (bl4 ? 5920607 : 22619) : (bl4 ? 22367 : (bl ? 88 : 87))) : (bl3 ? (bl7 ? (bl4 ? -1 : 5789531) : (bl4 ? 5789531 : (bl ? 22360 : 88))) : (bl7 ? (bl4 ? 5855071 : 22367) : (bl4 ? 22367 : (bl ? 88 : 87))))) : (bl6 ? (bl7 ? (bl4 ? 90 : 95) : (bl4 ? 0 : (bl ? 87 : 0))) : (bl3 ? (bl7 ? (bl4 ? 5855071 : 22367) : (bl4 ? 22367 : (bl ? 88 : 87))) : (bl7 ? (bl4 ? 89 : 0) : (bl4 ? 0 : (bl ? 87 : 0))))));
        }

        private int fixedDup2(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 0);
            boolean bl2 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 0);
            boolean bl4 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 1);
            boolean bl5 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl6 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 3);
            return bl6 ? (bl5 ? (bl4 ? (bl3 ? 92 : 23135) : (bl3 ? 89 : 0)) : (bl4 ? (bl3 ? 0x5F5A5F : (bl ? 22871 : 89)) : (bl3 ? 0 : (bl ? 87 : 0)))) : (bl5 ? (bl4 ? (bl3 ? 90 : 95) : (bl2 ? (bl3 ? 5855071 : 22367) : (bl3 ? 87 : 0))) : (bl4 ? (bl3 ? 0 : (bl ? 87 : 0)) : (bl2 ? (bl3 ? 22367 : (bl ? 88 : 87)) : (bl3 ? 0 : (bl ? 87 : 0)))));
        }

        private int fixedDup2_x1(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.isStackEntriesPresentBefore(n, n2 - 0, n2 - 1);
            boolean bl2 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 2);
            boolean bl3 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(n, n3 - 0, n3 - 1);
            boolean bl4 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl5 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(n, n3 - 3, n3 - 4);
            return bl4 ? (bl5 ? (bl3 ? 93 : 22621) : (bl3 ? 0 : (bl ? 88 : 0))) : (bl2 ? (bl5 ? (bl3 ? -1 : 5724253) : (bl3 ? 5724253 : (bl ? 22360 : 87))) : (bl5 ? (bl3 ? 92 : 0) : (bl3 ? 0 : (bl ? 88 : 0))));
        }

        private int fixedDup2_x2(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.isStackEntriesPresentBefore(n, n2 - 0, n2 - 1);
            boolean bl2 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 2);
            boolean bl3 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 3);
            boolean bl4 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(n, n3 - 0, n3 - 1);
            boolean bl5 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 2);
            boolean bl6 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 3);
            boolean bl7 = EvaluationShrinker.this.isStackEntriesNecessaryAfter(n, n3 - 4, n3 - 5);
            return bl5 ? (bl6 ? (bl7 ? (bl4 ? 94 : 22622) : (bl4 ? 0 : (bl ? 88 : 0))) : (bl3 ? (bl7 ? (bl4 ? -1 : 5726046) : (bl4 ? -1 : (bl ? 5726040 : 22367))) : (bl7 ? (bl4 ? 93 : 22621) : (bl4 ? 0 : (bl ? 88 : 0))))) : (bl2 ? (bl6 ? (bl7 ? (bl4 ? -1 : 5724254) : (bl4 ? 5724253 : (bl ? 22360 : 87))) : (bl3 ? (bl7 ? (bl4 ? -1 : 0x58585E) : (bl4 ? 0x58585E : (bl ? 22616 : 88))) : (bl7 ? (bl4 ? -1 : 5724253) : (bl4 ? 5724253 : (bl ? 22360 : 87))))) : (bl6 ? (bl7 ? (bl4 ? 93 : 22621) : (bl4 ? 0 : (bl ? 88 : 0))) : (bl3 ? (bl7 ? (bl4 ? -1 : 5724253) : (bl4 ? 5724253 : (bl ? 22360 : 87))) : (bl7 ? (bl4 ? 92 : 0) : (bl4 ? 0 : (bl ? 88 : 0))))));
        }

        private int fixedSwap(int n, int n2, int n3) {
            boolean bl = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 0);
            boolean bl2 = EvaluationShrinker.this.isStackEntryPresentBefore(n, n2 - 1);
            boolean bl3 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 0);
            boolean bl4 = EvaluationShrinker.this.isStackEntryNecessaryAfter(n, n3 - 1);
            return bl3 ? (bl4 ? 95 : (bl ? 87 : 0)) : (bl2 ? 22367 : 0);
        }
    }

    private class MyVariableInitializationMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyVariableInitializationMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                EvaluationShrinker.this.markVariableInitializers(n, variableInstruction.variableIndex);
            }
        }
    }

    private class MyProducerMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
            EvaluationShrinker.this.markStackProducers(clazz, n, instruction);
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                case 90: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    break;
                }
                case 91: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    break;
                }
                case 92: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 1);
                    break;
                }
                case 93: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 4, 1);
                    break;
                }
                case 94: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 3, 3);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 4, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 5, 1);
                    break;
                }
                case 95: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 0, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(n, 1, 0);
                    break;
                }
                default: {
                    EvaluationShrinker.this.markStackProducers(clazz, n, simpleInstruction);
                }
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                EvaluationShrinker.this.markVariableProducers(n, variableInstruction.variableIndex);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, n, variableInstruction);
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            if (constantInstruction.opcode == -69) {
                EvaluationShrinker.this.markInitialization(n);
            }
            EvaluationShrinker.this.markStackProducers(clazz, n, constantInstruction);
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                EvaluationShrinker.this.markStackEntryAfter(n, 0);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, n, branchInstruction);
            }
        }
    }

    private class MyUnusedParameterSimplifier
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyUnusedParameterSimplifier() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.invocationOffset = n;
                    this.invocationInstruction = constantInstruction;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                }
            }
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept(this);
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            int n = ParameterUsageMarker.getParameterSize(programMethod);
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationShrinker.this.replaceByStaticInvocation(programClass, this.invocationOffset, this.invocationInstruction);
            }
            for (int i = 0; i < n; ++i) {
                if (ParameterUsageMarker.isParameterUsed(programMethod, i)) continue;
                TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(this.invocationOffset);
                int n2 = tracedStack.size() - n + i;
                EvaluationShrinker.this.markStackSimplificationBefore(this.invocationOffset, n2);
            }
        }
    }
}

