/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.univariate;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.univariate.BaseAbstractUnivariateOptimizer;
import org.apache.commons.math3.optimization.univariate.UnivariatePointValuePair;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BrentOptimizer
extends BaseAbstractUnivariateOptimizer {
    private static final double GOLDEN_SECTION = 0.5 * (3.0 - FastMath.sqrt(5.0));
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public BrentOptimizer(double rel, double abs, ConvergenceChecker<UnivariatePointValuePair> checker) {
        super(checker);
        if (rel < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(rel, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (abs <= 0.0) {
            throw new NotStrictlyPositiveException(abs);
        }
        this.relativeThreshold = rel;
        this.absoluteThreshold = abs;
    }

    public BrentOptimizer(double rel, double abs) {
        this(rel, abs, null);
    }

    @Override
    protected UnivariatePointValuePair doOptimize() {
        UnivariatePointValuePair current;
        double x2;
        double b2;
        double a2;
        boolean isMinim = this.getGoalType() == GoalType.MINIMIZE;
        double lo = this.getMin();
        double mid = this.getStartValue();
        double hi = this.getMax();
        ConvergenceChecker<UnivariatePointValuePair> checker = this.getConvergenceChecker();
        if (lo < hi) {
            a2 = lo;
            b2 = hi;
        } else {
            a2 = hi;
            b2 = lo;
        }
        double v2 = x2 = mid;
        double w2 = x2;
        double d2 = 0.0;
        double e2 = 0.0;
        double fx = this.computeObjectiveValue(x2);
        if (!isMinim) {
            fx = -fx;
        }
        double fv = fx;
        double fw = fx;
        UnivariatePointValuePair previous = null;
        UnivariatePointValuePair best = current = new UnivariatePointValuePair(x2, isMinim ? fx : -fx);
        int iter = 0;
        while (true) {
            boolean stop2;
            double m2 = 0.5 * (a2 + b2);
            double tol1 = this.relativeThreshold * FastMath.abs(x2) + this.absoluteThreshold;
            double tol2 = 2.0 * tol1;
            boolean bl = stop2 = FastMath.abs(x2 - m2) <= tol2 - 0.5 * (b2 - a2);
            if (!stop2) {
                double p2 = 0.0;
                double q2 = 0.0;
                double r2 = 0.0;
                double u2 = 0.0;
                if (FastMath.abs(e2) > tol1) {
                    r2 = (x2 - w2) * (fx - fv);
                    q2 = (x2 - v2) * (fx - fw);
                    p2 = (x2 - v2) * q2 - (x2 - w2) * r2;
                    if ((q2 = 2.0 * (q2 - r2)) > 0.0) {
                        p2 = -p2;
                    } else {
                        q2 = -q2;
                    }
                    r2 = e2;
                    e2 = d2;
                    if (p2 > q2 * (a2 - x2) && p2 < q2 * (b2 - x2) && FastMath.abs(p2) < FastMath.abs(0.5 * q2 * r2)) {
                        d2 = p2 / q2;
                        u2 = x2 + d2;
                        if (u2 - a2 < tol2 || b2 - u2 < tol2) {
                            d2 = x2 <= m2 ? tol1 : -tol1;
                        }
                    } else {
                        e2 = x2 < m2 ? b2 - x2 : a2 - x2;
                        d2 = GOLDEN_SECTION * e2;
                    }
                } else {
                    e2 = x2 < m2 ? b2 - x2 : a2 - x2;
                    d2 = GOLDEN_SECTION * e2;
                }
                u2 = FastMath.abs(d2) < tol1 ? (d2 >= 0.0 ? x2 + tol1 : x2 - tol1) : x2 + d2;
                double fu = this.computeObjectiveValue(u2);
                if (!isMinim) {
                    fu = -fu;
                }
                previous = current;
                current = new UnivariatePointValuePair(u2, isMinim ? fu : -fu);
                best = this.best(best, this.best(previous, current, isMinim), isMinim);
                if (checker != null && checker.converged(iter, previous, current)) {
                    return best;
                }
                if (fu <= fx) {
                    if (u2 < x2) {
                        b2 = x2;
                    } else {
                        a2 = x2;
                    }
                    v2 = w2;
                    fv = fw;
                    w2 = x2;
                    fw = fx;
                    x2 = u2;
                    fx = fu;
                } else {
                    if (u2 < x2) {
                        a2 = u2;
                    } else {
                        b2 = u2;
                    }
                    if (fu <= fw || Precision.equals(w2, x2)) {
                        v2 = w2;
                        fv = fw;
                        w2 = u2;
                        fw = fu;
                    } else if (fu <= fv || Precision.equals(v2, x2) || Precision.equals(v2, w2)) {
                        v2 = u2;
                        fv = fu;
                    }
                }
            } else {
                return this.best(best, this.best(previous, current, isMinim), isMinim);
            }
            ++iter;
        }
    }

    private UnivariatePointValuePair best(UnivariatePointValuePair a2, UnivariatePointValuePair b2, boolean isMinim) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (isMinim) {
            return a2.getValue() <= b2.getValue() ? a2 : b2;
        }
        return a2.getValue() >= b2.getValue() ? a2 : b2;
    }
}

