/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt;

import de.treichels.hott.mdlviewer.swt.SwtMdlBrowser;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

class SWTResourceManager {
    private static final HashMap<String, Object> resources = new HashMap();
    private static final Vector<Widget> users = new Vector();
    private static final DisposeListener disposeListener = e2 -> {
        users.remove(e2.getSource());
        if (users.size() == 0) {
            SWTResourceManager.dispose();
        }
    };

    SWTResourceManager() {
    }

    private static void dispose() {
        for (String s2 : resources.keySet()) {
            Object resource = resources.get(s2);
            if (resource instanceof Font) {
                ((Font)resource).dispose();
                continue;
            }
            if (resource instanceof Color) {
                ((Color)resource).dispose();
                continue;
            }
            if (resource instanceof Image) {
                ((Image)resource).dispose();
                continue;
            }
            if (!(resource instanceof Cursor)) continue;
            ((Cursor)resource).dispose();
        }
        resources.clear();
    }

    public static Color getColor(int red, int green, int blue) {
        String name = "COLOR:" + red + "," + green + "," + blue;
        if (resources.containsKey(name)) {
            return (Color)resources.get(name);
        }
        Color color = new Color(Display.getDefault(), red, green, blue);
        resources.put(name, color);
        return color;
    }

    static Font getFont(int size) {
        String fontName = SwtMdlBrowser.WIDGET_FONT_NAME + "|" + size + "|0|false|false";
        if (resources.containsKey(fontName)) {
            return (Font)resources.get(fontName);
        }
        FontData fd = new FontData(SwtMdlBrowser.WIDGET_FONT_NAME, size, 0);
        Font font = new Font((Device)Display.getDefault(), fd);
        resources.put(fontName, font);
        return font;
    }

    public static void registerResourceUser(Widget widget) {
        if (users.contains(widget)) {
            return;
        }
        users.add(widget);
        widget.addDisposeListener(disposeListener);
    }
}

