/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.Analyzer;
import gde.GDE;
import gde.data.AbstractRecord;
import gde.data.AbstractRecordSet;
import gde.data.Record;
import gde.data.TimeSteps;
import gde.device.DeviceConfiguration;
import gde.device.IChannelItem;
import gde.device.IDevice;
import gde.device.ScoreLabelTypes;
import gde.device.TrailTypes;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.config.HistoGraphicsTemplate;
import gde.histo.datasources.HistoSet;
import gde.histo.device.ChannelItems;
import gde.histo.gpslocations.GpsCluster;
import gde.histo.recordings.MeasurementTrail;
import gde.histo.recordings.ScoregroupTrail;
import gde.histo.recordings.SettlementTrail;
import gde.histo.recordings.TrailDataTags;
import gde.histo.recordings.TrailRecord;
import gde.histo.ui.AbstractChartComposite;
import gde.histo.ui.GraphicsComposite;
import gde.histo.ui.HistoExplorer;
import gde.histo.ui.HistoSummaryWindow;
import gde.histo.ui.SummaryComposite;
import gde.histo.utils.GpsCoordinate;
import gde.log.Logger;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.Color;

public final class TrailRecordSet
extends AbstractRecordSet {
    private static final String $CLASS_NAME = TrailRecordSet.class.getName();
    private static final long serialVersionUID = -1580283867987273535L;
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final String BASE_NAME_SEPARATOR = " | ";
    private final Analyzer analyzer;
    private final HistoExplorer presentHistoExplorer = DataExplorer.getInstance().getPresentHistoExplorer();
    private final List<Integer> durations_mm = new ArrayList<Integer>(55);
    private final TrailDataTags dataTags;
    private PickedVaults pickedVaults;
    private HistoGraphicsTemplate template;

    private TrailRecordSet(Analyzer analyzer, String[] recordNames, TimeSteps timeSteps) {
        super(analyzer.getActiveDevice(), analyzer.getActiveDevice().getName() + "_" + analyzer.getActiveChannel().getNumber(), recordNames, timeSteps);
        this.analyzer = analyzer;
        this.dataTags = new TrailDataTags();
        this.template = HistoGraphicsTemplate.createGraphicsTemplate(analyzer);
        this.template.load();
        this.visibleAndDisplayableRecords = new Vector();
        this.displayRecords = new Vector();
        log.fine(() -> " TrailRecordSet(IDevice, int, RecordSet");
    }

    public static synchronized TrailRecordSet createRecordSet(Analyzer analyzer) {
        DeviceConfiguration configuration = analyzer.getActiveDevice().getDeviceConfiguration();
        TimeSteps timeSteps = new TimeSteps(-1.0, 55);
        String[] names = configuration.getMeasurementSettlementScoregroupNames(analyzer.getActiveChannel().getNumber());
        TrailRecordSet newTrailRecordSet = new TrailRecordSet(analyzer, names, timeSteps);
        BiConsumer<Integer, IChannelItem> measurementAction = (idx, itm) -> {
            MeasurementTrail tmpRecord = new MeasurementTrail((int)idx, (IChannelItem)itm, newTrailRecordSet, 55);
            newTrailRecordSet.put(itm.getName(), tmpRecord);
            tmpRecord.setColorDefaultsAndPosition((int)idx);
            log.fine(() -> "added measurement record for " + itm.getName() + " - " + idx);
        };
        BiConsumer<Integer, IChannelItem> settlementAction = (idx, itm) -> {
            SettlementTrail tmpRecord = new SettlementTrail((int)idx, (IChannelItem)itm, newTrailRecordSet, 55);
            newTrailRecordSet.put(itm.getName(), tmpRecord);
            tmpRecord.setColorDefaultsAndPosition((int)idx);
            log.fine(() -> "added settlement record for " + itm.getName() + " - " + idx);
        };
        BiConsumer<Integer, IChannelItem> scoreGroupAction = (idx, itm) -> {
            ScoregroupTrail tmpRecord = new ScoregroupTrail((int)idx, (IChannelItem)itm, newTrailRecordSet, itm.getProperty().size());
            newTrailRecordSet.put(itm.getName(), tmpRecord);
            tmpRecord.setColorDefaultsAndPosition((int)idx);
            log.fine(() -> "added scoregroup record for " + itm.getName() + " - " + idx);
        };
        ChannelItems channelItems = new ChannelItems(analyzer);
        channelItems.processItems(measurementAction, settlementAction, scoreGroupAction);
        newTrailRecordSet.get(0).setRGB("0,0,0");
        return newTrailRecordSet;
    }

    public void refillRecord(TrailRecord record, int trailTextIndex) {
        record.setSelectedTrail(trailTextIndex);
        record.clear();
        record.initializeFromVaults(this.pickedVaults.initialVaults);
    }

    public void refillFromVaults(TreeMap<Long, List<ExtendedVault>> newPickedVaults) {
        this.pickedVaults = new PickedVaults(this, newPickedVaults);
        this.cleanup();
        this.pickedVaults = new PickedVaults(this, newPickedVaults);
        RecordingsCollector collector = new RecordingsCollector();
        collector.defineTrailTypes();
        collector.addVaultsToRecordSet();
        for (String recordName : this.recordNames) {
            TrailRecord trailRecord = this.get(recordName);
            trailRecord.clear();
            trailRecord.setSelectedTrail();
            trailRecord.initializeFromVaults(this.pickedVaults.initialVaults);
        }
        log.finer(() -> "refilled trailRecord size = " + this.get(0).size());
        collector.setGpsLocationsTags();
    }

    public void initializeFromVaults(TreeMap<Long, List<ExtendedVault>> newPickedVaults) {
        this.pickedVaults = new PickedVaults(this, newPickedVaults);
        this.cleanup();
        RecordingsCollector collector = new RecordingsCollector();
        collector.defineTrailTypes();
        collector.addVaultsToRecordSet();
        for (String recordName : this.recordNames) {
            TrailRecord trailRecord = this.get(recordName);
            trailRecord.clear();
            int trailTextOrdinal = this.template != null && this.template.isAvailable() ? Integer.parseInt(this.template.getRecordProperty(recordName, "_trailTextOrdinal", "-1")) : -1;
            trailRecord.setSelectedTrail(trailTextOrdinal);
            trailRecord.initializeFromVaults(this.pickedVaults.initialVaults);
        }
        log.finer(() -> "initial trailRecord size = " + this.get(0).size());
        collector.setGpsLocationsTags();
    }

    public void initializeTrailSelectors() {
        for (String recordName : this.recordNames) {
            TrailRecord trailRecord = this.get(recordName);
            trailRecord.setTrailSelector();
        }
    }

    @Override
    public TrailRecord get(int recordOrdinal) {
        return (TrailRecord)super.get(recordOrdinal);
    }

    @Override
    public TrailRecord get(Object recordName) {
        return (TrailRecord)super.get(recordName);
    }

    @Override
    public TrailRecord put(String recordName, AbstractRecord record) {
        return (TrailRecord)super.put(recordName, record);
    }

    @Override
    @Deprecated
    public int getValueGridRecordOrdinal() {
        return Arrays.asList(this.recordNames).indexOf(this.getValueGridRecordName());
    }

    @Override
    @Deprecated
    public void setValueGridRecordOrdinal(int newValueGridRecordOrdinal) {
        this.setValueGridRecordName(this.recordNames[newValueGridRecordOrdinal]);
    }

    public boolean isValueGridRecord(TrailRecord record) {
        return this.valueGridRecordName.equals(record.getName());
    }

    public String getValueGridRecordName() {
        return this.valueGridRecordName;
    }

    public void setValueGridRecordName(String newValueGridRecordName) {
        String tmpName = newValueGridRecordName;
        if (!this.keySet().contains(newValueGridRecordName)) {
            tmpName = this.recordNames[0];
        }
        this.valueGridRecordName = this.isOneOfSyncableRecord(tmpName) ? this.recordNames[this.getSyncMasterRecordOrdinal(tmpName)] : tmpName;
    }

    @Override
    public void syncScaleOfSyncableRecords() {
        this.scaleSyncedRecords.initSyncedScales(this);
    }

    public synchronized void updateSyncGraphicsScale(GraphicsComposite graphicsComposite) {
        for (TrailRecord trailRecord : this.getVisibleAndDisplayableRecords()) {
            log.finer(() -> "set scale base value " + actualRecord.getName() + " isScaleSynced=" + actualRecord.isScaleSynced());
            graphicsComposite.getChartData(trailRecord).setSyncMaxMinValue();
        }
        for (Map.Entry entry : this.getScaleSyncedRecords().entrySet()) {
            boolean isAffected = false;
            int tmpMin = Integer.MAX_VALUE;
            int tmpMax = Integer.MIN_VALUE;
            for (TrailRecord syncRecord : (Vector)entry.getValue()) {
                if (!syncRecord.isVisible() || !syncRecord.isDisplayable()) continue;
                isAffected = true;
                tmpMin = Math.min(tmpMin, graphicsComposite.getChartData(syncRecord).getSyncMinValue());
                tmpMax = Math.max(tmpMax, graphicsComposite.getChartData(syncRecord).getSyncMaxValue());
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, syncRecord.getName() + " tmpMin  = " + (double)tmpMin / 1000.0 + "; tmpMax  = " + (double)tmpMax / 1000.0);
            }
            for (TrailRecord syncRecord : (Vector)entry.getValue()) {
                graphicsComposite.getChartData(syncRecord).setSyncMinMax(tmpMin, tmpMax);
            }
            if (!isAffected || !log.isLoggable(Level.FINER)) continue;
            log.log(Level.FINER, this.get((Integer)entry.getKey()).getSyncMasterName() + "; syncMin = " + (double)tmpMin / 1000.0 + "; syncMax = " + (double)tmpMax / 1000.0);
        }
    }

    public synchronized void updateSyncSummaryScale(AbstractChartComposite.AbstractChartData summaryData) {
        int recencyLimit = this.analyzer.getSettings().getReminderCount();
        for (TrailRecord trailRecord : this.getDisplayRecords()) {
            SummaryComposite.SummaryLayout summary = (SummaryComposite.SummaryLayout)summaryData.get(trailRecord.getName());
            summary.clear();
            summary.setSyncMinMax(recencyLimit);
            log.finer(() -> actualRecord.getName() + "   summaryMin = " + summary.getSyncMin() + "  summaryMax=" + summary.getSyncMax());
        }
        for (Map.Entry entry : this.getScaleSyncedRecords().entrySet()) {
            SummaryComposite.SummaryLayout summary;
            boolean isAffected = false;
            double tmpMin = Double.MAX_VALUE;
            double tmpMax = -1.7976931348623157E308;
            for (TrailRecord syncRecord : (Vector)entry.getValue()) {
                summary = (SummaryComposite.SummaryLayout)summaryData.get(syncRecord.getName());
                if (syncRecord.getTrailSelector().isOddRangeTrail() || !summary.isSyncMinMaxDefined()) continue;
                isAffected = true;
                tmpMin = Math.min(tmpMin, summary.getSyncMin());
                tmpMax = Math.max(tmpMax, summary.getSyncMax());
                if (!log.isLoggable(Level.FINER)) continue;
                log.log(Level.FINER, syncRecord.getName() + " tmpMin  = " + tmpMin + "; tmpMax  = " + tmpMax);
            }
            if (tmpMin == Double.MAX_VALUE || tmpMax == -1.7976931348623157E308) {
                for (TrailRecord syncRecord : (Vector)entry.getValue()) {
                    if (syncRecord.getTrailSelector().isOddRangeTrail()) continue;
                    summary = (SummaryComposite.SummaryLayout)summaryData.get(syncRecord.getName());
                    summary.resetSyncMinMax();
                }
            } else {
                for (TrailRecord syncRecord : (Vector)entry.getValue()) {
                    if (syncRecord.getTrailSelector().isOddRangeTrail()) continue;
                    summary = (SummaryComposite.SummaryLayout)summaryData.get(syncRecord.getName());
                    summary.setSyncMinMax(tmpMin, tmpMax);
                }
            }
            if (!isAffected || !log.isLoggable(Level.FINER)) continue;
            log.log(Level.FINER, this.get((Integer)entry.getKey()).getSyncMasterName() + "; syncMin = " + tmpMin + "; syncMax = " + tmpMax);
        }
    }

    public void setDisplayable() {
        for (TrailRecord record : this.getValues()) {
            record.setDisplayable();
        }
    }

    @Override
    public synchronized void updateVisibleAndDisplayableRecordsForTable() {
        this.visibleAndDisplayableRecords.removeAllElements();
        this.displayRecords.removeAllElements();
        for (Map.Entry entry : this.entrySet()) {
            TrailRecord record = (TrailRecord)entry.getValue();
            if (!record.isDisplayable()) continue;
            this.getDisplayRecords().add(record);
            if (!record.isVisible()) continue;
            this.getVisibleAndDisplayableRecords().add(record);
        }
    }

    public Vector<TrailRecord> getVisibleAndDisplayableRecordsForTable() {
        return this.analyzer.getSettings().isPartialDataTable() ? this.visibleAndDisplayableRecords : this.displayRecords;
    }

    public Vector<TrailRecord> getVisibleAndDisplayableRecords() {
        return this.visibleAndDisplayableRecords;
    }

    public Vector<TrailRecord> getDisplayRecords() {
        return this.displayRecords;
    }

    public void cleanup() {
        this.timeStep_ms.clear();
        this.durations_mm.clear();
        this.dataTags.clear();
    }

    public synchronized TrailRecord[] getRecordsSortedForDisplay() {
        Vector<TrailRecord> resultRecords = new Vector<TrailRecord>();
        for (TrailRecord record : this.getDisplayRecords()) {
            if (!this.isValueGridRecord(record)) continue;
            resultRecords.add(record);
        }
        for (TrailRecord record : this.getDisplayRecords()) {
            if (this.isValueGridRecord(record)) continue;
            if (record.isScaleSyncMaster()) {
                resultRecords.add(record);
                continue;
            }
            if (!record.isScaleSynced() || record.getSyncMasterRecordOrdinal() < 0 || resultRecords.stream().anyMatch(x -> x.getOrdinal() == record.getSyncMasterRecordOrdinal()) || !record.getParent().isOneSyncableVisible(record.getSyncMasterRecordOrdinal())) continue;
            resultRecords.add(record.getParent().get(record.getSyncMasterRecordOrdinal()));
        }
        for (TrailRecord record : this.getDisplayRecords()) {
            if (this.isValueGridRecord(record) || record.isScaleSyncMaster()) continue;
            resultRecords.add(record);
        }
        return resultRecords.toArray(new TrailRecord[resultRecords.size()]);
    }

    public void saveTemplate() {
        for (TrailRecord record : this.getValues()) {
            record.saveTemplate();
        }
        Color color = this.getValueGridColor();
        String rgb = color.getRGB().red + "," + color.getRGB().green + "," + color.getRGB().blue;
        this.template.setProperty("RecordSet_horizontalGridColor", rgb);
        this.template.setProperty("RecordSet_horizontalGridLineStyle", "" + this.getValueGridLineStyle());
        this.template.setProperty("RecordSet_horizontalGridType", "" + this.getValueGridType());
        if (this.get(this.getValueGridRecordName()) != null) {
            this.template.setProperty("RecordSet_horizontalGridRecordName", this.getValueGridRecordName());
        }
        this.template.setProperty("RecordSet_smartStatistics", "" + this.isSmartStatistics());
        int[] chartWeights = this.presentHistoExplorer.getHistoSummaryTabItem().getChartWeights();
        for (int i = 0; i < chartWeights.length; ++i) {
            this.template.setProperty("RecordSet_chartWeight" + i, "" + chartWeights[i]);
        }
        this.template.setCommentSuffix(this.name + " " + this.description);
        this.template.store();
        log.fine(() -> "creating histo graphics template file in " + String.valueOf(this.template.getTargetFileSubPath()));
    }

    public void applyTemplate(boolean doUpdateVisibilityStatus) {
        if (this.template != null && this.template.isAvailable()) {
            for (TrailRecord record : this.getValues()) {
                record.applyTemplate();
            }
            String color = this.template.getProperty("RecordSet_horizontalGridColor", "128,128,128");
            int r = Integer.parseInt(color.split(",")[0].trim());
            int g = Integer.parseInt(color.split(",")[1].trim());
            int b = Integer.parseInt(color.split(",")[2].trim());
            this.setValueGridColor(GDE.isSystemDarkTheme ? DataExplorer.getInstance().COLOR_BLACK : SWTResourceManager.getColor(r, g, b));
            this.setValueGridLineStyle(Integer.parseInt(this.template.getProperty("RecordSet_horizontalGridLineStyle", "3")));
            this.setValueGridType(Integer.parseInt(this.template.getProperty("RecordSet_horizontalGridType", "0")));
            String gridDefaultRecordName = this.getValues().stream().filter(TrailRecord::isVisible).findFirst().orElse(this.get(0)).getName();
            String gridRecordName = this.template.getProperty("RecordSet_horizontalGridRecordName", gridDefaultRecordName);
            TrailRecord gridRecord = this.get(gridRecordName);
            this.setValueGridRecordName(gridRecord != null && gridRecord.isVisible() ? gridRecordName : gridDefaultRecordName);
            this.setSmartStatistics(Boolean.parseBoolean(this.template.getProperty("RecordSet_smartStatistics", "true")));
            if (GDE.isWithUi()) {
                this.presentHistoExplorer.getHistoSummaryTabItem().setChartWeights(this.getChartWeights());
            }
            log.fine(() -> "applied histo graphics template file " + String.valueOf(this.template.getTargetFileSubPath()));
            if (doUpdateVisibilityStatus) {
                this.setDisplayable();
                this.updateVisibleAndDisplayableRecordsForTable();
            }
        }
    }

    public boolean isSmartStatistics() {
        return Boolean.parseBoolean(this.template.getProperty("RecordSet_smartStatistics", "true"));
    }

    public void setSmartStatistics(boolean isActive) {
        this.template.setProperty("RecordSet_smartStatistics", "" + isActive);
        if (GDE.isWithUi()) {
            DataExplorer.getInstance().getPresentHistoExplorer().updateHistoMenuItems();
        }
    }

    public int[] getChartWeights() {
        int[] chartWeights;
        if (this.isSmartStatistics()) {
            chartWeights = (int[])HistoSummaryWindow.DEFAULT_CHART_WEIGHTS.clone();
            for (int i = 0; i < chartWeights.length; ++i) {
                chartWeights[i] = Integer.parseInt(this.template.getProperty("RecordSet_chartWeight" + i, "" + HistoSummaryWindow.DEFAULT_CHART_WEIGHTS[i]));
            }
        } else {
            chartWeights = HistoSummaryWindow.DEFAULT_CHART_WEIGHTS;
        }
        return chartWeights;
    }

    public HistoGraphicsTemplate getTemplate() {
        return this.template;
    }

    public int getTimeStepSize() {
        return this.timeStep_ms.size();
    }

    public int getIndex(long timestamp_ms) {
        return this.timeStep_ms.getBestIndex(timestamp_ms, Comparator.reverseOrder());
    }

    public List<Integer> getDurations_mm() {
        return this.durations_mm;
    }

    public TrailDataTags getDataTags() {
        return this.dataTags;
    }

    public String getDataTagText(int index, TrailDataTags.DataTag dataTag) {
        return this.dataTags.getText(index, dataTag);
    }

    public long getTopTimeStamp_ms() {
        try {
            return (Long)this.timeStep_ms.firstElement() / 10L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getLowestTimeStamp_ms() {
        try {
            return (Long)this.timeStep_ms.lastElement() / 10L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getDisplayTimeStamp_ms(int index) {
        if (this.analyzer.getSettings().isXAxisReversed()) {
            return (Long)this.timeStep_ms.get(index) / 10L;
        }
        return (Long)this.timeStep_ms.get(this.timeStep_ms.size() - 1 - index) / 10L;
    }

    @Override
    public IDevice getDevice() {
        return this.analyzer.getActiveDevice();
    }

    @Override
    public int getChannelConfigNumber() {
        return this.analyzer.getActiveChannel().getNumber();
    }

    public String getChannelConfigName() {
        return this.analyzer.getActiveChannel().getName();
    }

    private AbstractRecordSet.SyncedRecords<TrailRecord> getScaleSyncedRecords() {
        return this.scaleSyncedRecords;
    }

    public Vector<TrailRecord> getScaleSyncedRecords(int syncMasterRecordOrdinal) {
        return (Vector)this.scaleSyncedRecords.get(syncMasterRecordOrdinal);
    }

    public ExtendedVault getVault(int index) {
        return (ExtendedVault)this.pickedVaults.indexedVaults[index];
    }

    public Collection<TrailRecord> getValues() {
        return this.values();
    }

    public HistoVault[] getIndexedVaults() {
        return this.pickedVaults.indexedVaults;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public final class PickedVaults {
        private final TreeMap<Long, List<ExtendedVault>> initialVaults = new TreeMap(Collections.reverseOrder());
        private final HistoVault[] indexedVaults;

        public PickedVaults(TrailRecordSet this$0, TreeMap<Long, List<ExtendedVault>> initialVaults) {
            this.initialVaults.putAll(initialVaults);
            Stream map1 = this.initialVaults.values().stream().flatMap(Collection::stream).distinct();
            this.indexedVaults = (HistoVault[])map1.toArray(ExtendedVault[]::new);
        }

        GpsCluster defineGpsAverages(TrailRecord latitudeRecord, TrailRecord longitudeRecord) {
            GpsCluster gpsCluster = new GpsCluster();
            for (HistoVault histoVault : this.indexedVaults) {
                Integer latitudePoint = histoVault.getMeasurementPoint(latitudeRecord.getOrdinal(), TrailTypes.Q2.ordinal());
                Integer longitudePoint = histoVault.getMeasurementPoint(longitudeRecord.getOrdinal(), TrailTypes.Q2.ordinal());
                if (latitudePoint != null && longitudePoint != null) {
                    gpsCluster.add(new GpsCoordinate(HistoSet.decodeVaultValue(latitudeRecord.channelItem, (double)latitudePoint.intValue() / 1000.0), HistoSet.decodeVaultValue(longitudeRecord.channelItem, (double)longitudePoint.intValue() / 1000.0)));
                    continue;
                }
                gpsCluster.add(null);
            }
            return gpsCluster;
        }

        public String toString() {
            return "[initialVaults=" + this.initialVaults.size() + ", indexedVaults=" + this.indexedVaults.length + "]";
        }
    }

    final class RecordingsCollector {
        private final Logger log = Logger.getLogger(RecordingsCollector.class.getName());

        RecordingsCollector() {
        }

        void addVaultsToRecordSet() {
            for (HistoVault histoVault : TrailRecordSet.this.pickedVaults.indexedVaults) {
                int duration_mm = histoVault.getScorePoint(ScoreLabelTypes.DURATION_MM.ordinal());
                TrailRecordSet.this.durations_mm.add(duration_mm);
                if (!TrailRecordSet.this.timeStep_ms.addRaw(histoVault.getLogStartTimestamp_ms() * 10L)) {
                    this.log.warning(() -> String.format("Duplicate recordSet  startTimeStamp %,d  %s", histoVault.getLogStartTimestamp_ms(), ((ExtendedVault)histoVault).getLoadFilePath()));
                }
                TrailRecordSet.this.dataTags.add((ExtendedVault)histoVault);
            }
        }

        void setGpsLocationsTags() {
            GpsCluster gpsCluster;
            TrailRecord latitudeRecord = null;
            TrailRecord longitudeRecord = null;
            for (TrailRecord trailRecord : TrailRecordSet.this.getValues()) {
                if (trailRecord.getDataType() == Record.DataType.GPS_LATITUDE) {
                    latitudeRecord = trailRecord;
                } else if (trailRecord.getDataType() == Record.DataType.GPS_LONGITUDE) {
                    longitudeRecord = trailRecord;
                }
                if (latitudeRecord == null || longitudeRecord == null) continue;
                break;
            }
            if (latitudeRecord != null && longitudeRecord != null && (gpsCluster = TrailRecordSet.this.pickedVaults.defineGpsAverages(latitudeRecord, longitudeRecord)).parallelStream().filter(Objects::nonNull).count() > 0L) {
                Thread gpsLocationsThread = new Thread(() -> this.setGpsLocationTags(gpsCluster), "setGpsLocationTags");
                try {
                    gpsLocationsThread.start();
                }
                catch (RuntimeException e) {
                    this.log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }

        private void setGpsLocationTags(GpsCluster gpsCluster) {
            long nanoTime = System.nanoTime();
            gpsCluster.setClusters(TrailRecordSet.this.analyzer.getSettings().getGpsLocationRadius());
            if (gpsCluster.size() > 0) {
                List<String> gpsLocations = gpsCluster.defineGpsLocations(TrailRecordSet.this.analyzer.getSettings().getGpsLocationRadius(), TrailRecordSet.this.analyzer.getDataAccess());
                if (gpsLocations.parallelStream().filter(s -> !s.isEmpty()).count() > 0L) {
                    TrailRecordSet.this.getDataTags().add(gpsLocations);
                }
                if (TrailRecordSet.this.getDataTags().getDataGpsLocations().size() > 0) {
                    if (GDE.isWithUi()) {
                        DataExplorer.getInstance().getPresentHistoExplorer().updateHistoTableWindow(false);
                    }
                    this.log.finer(() -> "fill in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoTime) + " ms!  GPS locations size=" + gpsCluster.getAssignedClusters().values().size());
                }
            }
        }

        void defineTrailTypes() {
            String[] trailRecordNames;
            for (String trailRecordName : trailRecordNames = TrailRecordSet.this.getRecordNames()) {
                TrailRecord trailRecord = TrailRecordSet.this.get(trailRecordName);
                trailRecord.trailSelector.setApplicableTrails();
            }
        }
    }

    @FunctionalInterface
    public static interface ChannelItemAction {
        public void accept(TrailRecordSet var1, Integer var2, IChannelItem var3);
    }
}

