/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.HeaderRpmBlock;
import com.monstarmike.tlmreader.primitives.Ints;
import com.monstarmike.tlmreader.primitives.Shorts;

public class StandardBlock
extends DataBlock {
    private float rpm;
    private short voltageInHunderthOfVolts;
    private short tempInDegreeFahrenheit;
    private short ratioInHunderth = (short)100;
    private byte poles = 1;
    private int rawRpmData;
    private int dbm_A;
    private int dbm_B;

    public StandardBlock(byte[] rawData, HeaderRpmBlock rpmHeader) {
        super(rawData);
        if (rpmHeader != null) {
            this.ratioInHunderth = rpmHeader.getRatioInHunderth();
            this.poles = rpmHeader.getPoles();
        }
        this.decode(rawData);
        this.measurementNames.add("RPM St");
        this.measurementNames.add("Volt St");
        this.measurementNames.add("Temperature St");
        this.measurementNames.add("dbm_A");
        this.measurementNames.add("dbm_B");
        this.measurementUnits.add("1/min");
        this.measurementUnits.add("V");
        this.measurementUnits.add("\u00b0C");
        this.measurementUnits.add("dBm");
        this.measurementUnits.add("dBm");
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof StandardBlock) {
            StandardBlock rpm = (StandardBlock)block;
            return rpm.rawRpmData == this.rawRpmData && rpm.voltageInHunderthOfVolts == this.voltageInHunderthOfVolts && rpm.tempInDegreeFahrenheit == this.tempInDegreeFahrenheit && rpm.dbm_A == this.dbm_A && rpm.dbm_B == this.dbm_B;
        }
        return false;
    }

    public boolean hasValidRpmData() {
        return this.rawRpmData != 65535 && this.rawRpmData != 0;
    }

    public float getRpm() {
        return this.hasValidRpmData() ? this.rpm : 0.0f;
    }

    public boolean hasValidVoltageData() {
        return this.voltageInHunderthOfVolts != Short.MIN_VALUE && this.voltageInHunderthOfVolts != 0;
    }

    public short getVoltageInHunderthOfVolts() {
        return this.voltageInHunderthOfVolts;
    }

    public boolean hasValidTemperatureData() {
        return this.tempInDegreeFahrenheit != Short.MAX_VALUE && this.tempInDegreeFahrenheit != Short.MIN_VALUE && this.tempInDegreeFahrenheit != 0 && (this.tempInDegreeFahrenheit & 0xFC00) == 0;
    }

    public short getTemperatureInDegreeFahrenheit() {
        return this.tempInDegreeFahrenheit;
    }

    public float getTemperatureInThenthOfDegreeCelsius() {
        return this.hasValidTemperatureData() ? (float)(this.tempInDegreeFahrenheit - 32) / 1.8f * 10.0f : 0.0f;
    }

    public int getDbm_A() {
        return this.dbm_A;
    }

    public int getDbm_B() {
        return this.dbm_B;
    }

    private void decode(byte[] rawData) {
        this.rawRpmData = Ints.fromBytes((byte)0, (byte)0, rawData[6], rawData[7]);
        this.rpm = this.rawRpmData == 0 ? 0.0f : 1.0f / (float)this.rawRpmData * 1.2E8f / (float)this.ratioInHunderth * 100.0f / (float)this.poles;
        this.voltageInHunderthOfVolts = Shorts.fromBytes(rawData[8], rawData[9]);
        this.tempInDegreeFahrenheit = Shorts.fromBytes(rawData[10], rawData[11]);
        this.dbm_A = rawData[12];
        this.dbm_B = rawData[13];
        this.measurementValues.add((int)this.getRpm());
        this.measurementValues.add(Integer.valueOf(this.getVoltageInHunderthOfVolts()));
        this.measurementValues.add((int)this.getTemperatureInThenthOfDegreeCelsius());
        this.measurementValues.add(this.getDbm_A());
        this.measurementValues.add(this.getDbm_B());
    }
}

