/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.util.StringUtils;

public class GPSLocationBlock
extends DataBlock {
    private int altitudeLowInTenthOfMeter;
    private int latitude;
    private int longitude;
    private short courseInTenthOfDegree;
    private byte HDOPInTenth;
    private byte flags;

    public GPSLocationBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Altitude low");
        this.measurementNames.add("Latitude");
        this.measurementNames.add("Longitude");
        this.measurementNames.add("Course");
        this.measurementNames.add("HDOPInTenth");
        this.measurementNames.add("GPSFix");
        this.measurementUnits.add("m");
        this.measurementUnits.add("\u00b0 '");
        this.measurementUnits.add("\u00b0 '");
        this.measurementUnits.add("\u00b0");
        this.measurementUnits.add("");
        this.measurementUnits.add("");
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(1.0);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(1.0);
    }

    public GPSLocationBlock(GPSLocationBlock that) {
        super(that);
        this.altitudeLowInTenthOfMeter = that.altitudeLowInTenthOfMeter;
        this.latitude = that.latitude;
        this.longitude = that.longitude;
        this.courseInTenthOfDegree = that.courseInTenthOfDegree;
        this.HDOPInTenth = that.HDOPInTenth;
        this.flags = that.flags;
    }

    public int getAltitudeLowInTenthOfMeter() {
        return this.altitudeLowInTenthOfMeter;
    }

    public int getLatitude() {
        return this.latitude;
    }

    public float getLatitudeInDecimals() {
        int grad = this.latitude / 1000000;
        float minuten = (float)(this.latitude - grad * 1000000) / 10000.0f;
        return (float)grad + minuten / 60.0f;
    }

    public float getLongitudeInDecimals() {
        int grad = this.longitude / 1000000;
        float minuten = (float)(this.longitude - grad * 1000000) / 10000.0f;
        return (float)grad + minuten / 60.0f;
    }

    public int getLongitude() {
        return this.longitude;
    }

    public short getCourseInTenthOfDegree() {
        return this.courseInTenthOfDegree;
    }

    public byte getHDOPInTenth() {
        return this.HDOPInTenth;
    }

    public byte getFlags() {
        return this.flags;
    }

    public int getGPSFix() {
        if ((this.flags & 8) == 8 && (this.flags & 0x20) == 32) {
            return 3;
        }
        if ((this.flags & 8) == 8) {
            return 2;
        }
        return 0;
    }

    private void decode(byte[] rawData) {
        this.altitudeLowInTenthOfMeter = Integer.parseInt(StringUtils.bcdEncodeInverted(rawData, 6, 2));
        this.latitude = Integer.parseInt(StringUtils.bcdEncodeInverted(rawData, 8, 4));
        this.longitude = Integer.parseInt(StringUtils.bcdEncodeInverted(rawData, 12, 4));
        this.courseInTenthOfDegree = Short.parseShort(StringUtils.bcdEncodeInverted(rawData, 16, 2));
        this.HDOPInTenth = Byte.parseByte(StringUtils.bcdEncodeInverted(rawData, 18, 1));
        this.flags = rawData[19];
        this.measurementValues.add((this.getFlags() & 0x80) == 128 ? -1 * this.getAltitudeLowInTenthOfMeter() : this.getAltitudeLowInTenthOfMeter());
        this.measurementValues.add(this.getLatitude());
        this.measurementValues.add((this.getFlags() & 4) == 4 ? 1000000000 + this.getLongitude() : this.getLongitude());
        this.measurementValues.add(Integer.valueOf(this.getCourseInTenthOfDegree()));
        this.measurementValues.add(Integer.valueOf(this.getHDOPInTenth()));
        this.measurementValues.add(this.getGPSFix());
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof GPSLocationBlock) {
            GPSLocationBlock gpsLoc = (GPSLocationBlock)block;
            return gpsLoc.altitudeLowInTenthOfMeter == this.altitudeLowInTenthOfMeter && gpsLoc.latitude == this.latitude && gpsLoc.longitude == this.longitude && gpsLoc.courseInTenthOfDegree == this.courseInTenthOfDegree && gpsLoc.HDOPInTenth == this.HDOPInTenth && gpsLoc.flags == this.flags;
        }
        return false;
    }

    @Override
    public String toString() {
        return "GPSLocationData:  " + this.getTimestamp() + " - Altitude low = " + (double)((this.getFlags() & 0x80) == 128 ? -1 * this.getAltitudeLowInTenthOfMeter() : this.getAltitudeLowInTenthOfMeter()) / 10.0 + ", Latitude = " + this.getLatitudeInDecimals() + ", Longitude = " + this.getLongitudeInDecimals() + ", Course  = " + (double)this.getCourseInTenthOfDegree() / 10.0 + ", HDOP = " + (double)(this.getHDOPInTenth() & 0xFF) / 10.0 + ", GPSFix = " + this.getGPSFix() + ", IS_NORTH = " + ((this.getFlags() & 1) == 1) + ", IS_EAST = " + ((this.getFlags() & 2) == 2) + ", LONGITUDE_GREATER_99 = " + ((this.getFlags() & 4) == 4);
    }
}

