/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class TemperatureBlock
extends DataBlock {
    private short temperatureInFahrenheit;

    public TemperatureBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Temperature T");
        this.measurementUnits.add("\u00b0C");
        this.measurementFactors.add(0.1);
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof TemperatureBlock) {
            TemperatureBlock temp = (TemperatureBlock)block;
            return temp.temperatureInFahrenheit == this.temperatureInFahrenheit;
        }
        return false;
    }

    public short getTemperatureInFahrenheit() {
        return this.temperatureInFahrenheit;
    }

    public short getTemperatureInThenthGradCelsius() {
        return (short)((float)(this.temperatureInFahrenheit - 32) / 1.8f * 10.0f);
    }

    private void decode(byte[] rawData) {
        this.temperatureInFahrenheit = Shorts.fromBytes(rawData[6], rawData[7]);
        this.measurementValues.add(Integer.valueOf(this.getTemperatureInThenthGradCelsius()));
    }
}

