/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.constants.MarginBoxName;
import org.xhtmlrenderer.css.newmatch.PageInfo;
import org.xhtmlrenderer.css.parser.FSFunction;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.MarginBox;
import org.xhtmlrenderer.render.RenderingContext;

public class PageBox {
    private static final MarginArea[] MARGIN_AREA_DEFS = new MarginArea[]{new TopLeftCorner(), new TopMarginArea(), new TopRightCorner(), new LeftMarginArea(), new RightMarginArea(), new BottomLeftCorner(), new BottomMarginArea(), new BottomRightCorner()};
    private static final int LEADING_TRAILING_SPLIT = 5;
    private CalculatedStyle _style;
    private int _top;
    private int _bottom;
    private int _paintingTop;
    private int _paintingBottom;
    private int _pageNo;
    private int _outerPageWidth;
    private PageDimensions _pageDimensions;
    private PageInfo _pageInfo;
    private MarginAreaContainer[] _marginAreas = new MarginAreaContainer[MARGIN_AREA_DEFS.length];
    private Element _metadata;

    public int getWidth(CssContext cssCtx) {
        this.resolvePageDimensions(cssCtx);
        return this._pageDimensions.getWidth();
    }

    public int getHeight(CssContext cssCtx) {
        this.resolvePageDimensions(cssCtx);
        return this._pageDimensions.getHeight();
    }

    private void resolvePageDimensions(CssContext cssCtx) {
        if (this._pageDimensions == null) {
            CalculatedStyle style = this.getStyle();
            int width = style.isLength(CSSName.FS_PAGE_WIDTH) ? (int)style.getFloatPropertyProportionalTo(CSSName.FS_PAGE_WIDTH, 0.0f, cssCtx) : this.resolveAutoPageWidth(cssCtx);
            int height = style.isLength(CSSName.FS_PAGE_HEIGHT) ? (int)style.getFloatPropertyProportionalTo(CSSName.FS_PAGE_HEIGHT, 0.0f, cssCtx) : this.resolveAutoPageHeight(cssCtx);
            if (style.isIdent(CSSName.FS_PAGE_ORIENTATION, IdentValue.LANDSCAPE)) {
                int temp = width;
                width = height;
                height = temp;
            }
            PageDimensions dim = new PageDimensions();
            dim.setWidth(width);
            dim.setHeight(height);
            this._pageDimensions = dim;
        }
    }

    private boolean isUseLetterSize() {
        Locale l2 = Locale.getDefault();
        String county = l2.getCountry();
        return county.equals("US") || county.equals("CA") || county.equals("MX");
    }

    private int resolveAutoPageWidth(CssContext cssCtx) {
        if (this.isUseLetterSize()) {
            return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_WIDTH, "8.5in", 8.5f, (short)8, 0.0f, cssCtx);
        }
        return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_WIDTH, "210mm", 210.0f, (short)7, 0.0f, cssCtx);
    }

    private int resolveAutoPageHeight(CssContext cssCtx) {
        if (this.isUseLetterSize()) {
            return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_HEIGHT, "11in", 11.0f, (short)8, 0.0f, cssCtx);
        }
        return (int)LengthValue.calcFloatProportionalValue(this.getStyle(), CSSName.FS_PAGE_HEIGHT, "297mm", 297.0f, (short)7, 0.0f, cssCtx);
    }

    public int getContentHeight(CssContext cssCtx) {
        int retval = this.getHeight(cssCtx) - this.getMarginBorderPadding(cssCtx, 3) - this.getMarginBorderPadding(cssCtx, 4);
        if (retval <= 0) {
            throw new IllegalArgumentException("The content height cannot be zero or less.  Check your document margin definition.");
        }
        return retval;
    }

    public int getContentWidth(CssContext cssCtx) {
        int retval = this.getWidth(cssCtx) - this.getMarginBorderPadding(cssCtx, 1) - this.getMarginBorderPadding(cssCtx, 2);
        if (retval <= 0) {
            throw new IllegalArgumentException("The content width cannot be zero or less.  Check your document margin definition.");
        }
        return retval;
    }

    public CalculatedStyle getStyle() {
        return this._style;
    }

    public void setStyle(CalculatedStyle style) {
        this._style = style;
    }

    public int getBottom() {
        return this._bottom;
    }

    public int getTop() {
        return this._top;
    }

    public void setTopAndBottom(CssContext cssCtx, int top2) {
        this._top = top2;
        this._bottom = top2 + this.getContentHeight(cssCtx);
    }

    public int getPaintingBottom() {
        return this._paintingBottom;
    }

    public void setPaintingBottom(int paintingBottom) {
        this._paintingBottom = paintingBottom;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this._paintingTop = paintingTop;
    }

    public Rectangle getScreenPaintingBounds(CssContext cssCtx, int additionalClearance) {
        return new Rectangle(additionalClearance, this.getPaintingTop(), this.getWidth(cssCtx), this.getPaintingBottom() - this.getPaintingTop());
    }

    public Rectangle getPrintPaintingBounds(CssContext cssCtx) {
        return new Rectangle(0, 0, this.getWidth(cssCtx), this.getHeight(cssCtx));
    }

    public Rectangle getPagedViewClippingBounds(CssContext cssCtx, int additionalClearance) {
        Rectangle result2 = new Rectangle(additionalClearance + this.getMarginBorderPadding(cssCtx, 1), this.getPaintingTop() + this.getMarginBorderPadding(cssCtx, 3), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx));
        return result2;
    }

    public Rectangle getPrintClippingBounds(CssContext cssCtx) {
        Rectangle result2 = new Rectangle(this.getMarginBorderPadding(cssCtx, 1), this.getMarginBorderPadding(cssCtx, 3), this.getContentWidth(cssCtx), this.getContentHeight(cssCtx));
        --result2.height;
        return result2;
    }

    public RectPropertySet getMargin(CssContext cssCtx) {
        return this.getStyle().getMarginRect(this._outerPageWidth, cssCtx);
    }

    private Rectangle getBorderEdge(int left2, int top2, CssContext cssCtx) {
        RectPropertySet margin = this.getMargin(cssCtx);
        Rectangle result2 = new Rectangle(left2 + (int)margin.left(), top2 + (int)margin.top(), this.getWidth(cssCtx) - (int)margin.left() - (int)margin.right(), this.getHeight(cssCtx) - (int)margin.top() - (int)margin.bottom());
        return result2;
    }

    public void paintBorder(RenderingContext c2, int additionalClearance, short mode) {
        int top2 = 0;
        if (mode == 1) {
            top2 = this.getPaintingTop();
        }
        c2.getOutputDevice().paintBorder(c2, this.getStyle(), this.getBorderEdge(additionalClearance, top2, c2), 15);
    }

    public void paintBackground(RenderingContext c2, int additionalClearance, short mode) {
        Rectangle bounds = mode == 1 ? this.getScreenPaintingBounds(c2, additionalClearance) : this.getPrintPaintingBounds(c2);
        c2.getOutputDevice().paintBackground(c2, this.getStyle(), bounds, bounds, this.getStyle().getBorder(c2));
    }

    public void paintMarginAreas(RenderingContext c2, int additionalClearance, short mode) {
        for (int i2 = 0; i2 < MARGIN_AREA_DEFS.length; ++i2) {
            MarginAreaContainer container = this._marginAreas[i2];
            if (container == null) continue;
            TableBox table = this._marginAreas[i2].getTable();
            Point p2 = container.getArea().getPaintingPosition(c2, this, additionalClearance, mode);
            c2.getOutputDevice().translate(p2.x, p2.y);
            table.getLayer().paint(c2);
            c2.getOutputDevice().translate(-p2.x, -p2.y);
        }
    }

    public int getPageNo() {
        return this._pageNo;
    }

    public void setPageNo(int pageNo) {
        this._pageNo = pageNo;
    }

    public int getOuterPageWidth() {
        return this._outerPageWidth;
    }

    public void setOuterPageWidth(int containingBlockWidth) {
        this._outerPageWidth = containingBlockWidth;
    }

    public int getMarginBorderPadding(CssContext cssCtx, int which) {
        return this.getStyle().getMarginBorderPadding(cssCtx, this.getOuterPageWidth(), which);
    }

    public PageInfo getPageInfo() {
        return this._pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this._pageInfo = pageInfo;
    }

    public Element getMetadata() {
        return this._metadata;
    }

    public void layout(LayoutContext c2) {
        c2.setPage(this);
        this.retrievePageMetadata(c2);
        this.layoutMarginAreas(c2);
    }

    private void retrievePageMetadata(LayoutContext c2) {
        List props = this.getPageInfo().getXMPPropertyList();
        if (props != null && props.size() > 0) {
            for (PropertyDeclaration decl : props) {
                BlockBox metadata2;
                FSFunction func;
                PropertyValue funcVal;
                if (decl.getCSSName() != CSSName.CONTENT) continue;
                PropertyValue value = (PropertyValue)decl.getValue();
                List values2 = value.getValues();
                if (values2.size() != 1 || (funcVal = (PropertyValue)values2.get(0)).getPropertyValueType() != 7 || !BoxBuilder.isElementFunction(func = funcVal.getFunction()) || (metadata2 = BoxBuilder.getRunningBlock(c2, funcVal)) == null) break;
                this._metadata = metadata2.getElement();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutMarginAreas(LayoutContext c2) {
        RectPropertySet margin = this.getMargin(c2);
        for (int i2 = 0; i2 < MARGIN_AREA_DEFS.length; ++i2) {
            MarginArea area = MARGIN_AREA_DEFS[i2];
            Dimension dim = area.getLayoutDimension(c2, this, margin);
            TableBox table = BoxBuilder.createMarginTable(c2, this._pageInfo, area.getMarginBoxNames(), (int)dim.getHeight(), area.getDirection());
            if (table == null) continue;
            table.setContainingBlock(new MarginBox(new Rectangle((int)dim.getWidth(), (int)dim.getHeight())));
            try {
                c2.setNoPageBreak(1);
                c2.reInit(false);
                c2.pushLayer(table);
                c2.getRootLayer().addPage(c2);
                table.layout(c2);
                c2.popLayer();
            }
            finally {
                c2.setNoPageBreak(0);
            }
            this._marginAreas[i2] = new MarginAreaContainer(area, table);
        }
    }

    public boolean isLeftPage() {
        return this._pageNo % 2 != 0;
    }

    public boolean isRightPage() {
        return this._pageNo % 2 == 0;
    }

    public void exportLeadingText(RenderingContext c2, Writer writer) throws IOException {
        for (int i2 = 0; i2 < 5; ++i2) {
            MarginAreaContainer container = this._marginAreas[i2];
            if (container == null) continue;
            container.getTable().exportText(c2, writer);
        }
    }

    public void exportTrailingText(RenderingContext c2, Writer writer) throws IOException {
        for (int i2 = 5; i2 < this._marginAreas.length; ++i2) {
            MarginAreaContainer container = this._marginAreas[i2];
            if (container == null) continue;
            container.getTable().exportText(c2, writer);
        }
    }

    private static class BottomMarginArea
    extends MarginArea {
        public BottomMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.BOTTOM_LEFT, MarginBoxName.BOTTOM_CENTER, MarginBoxName.BOTTOM_RIGHT});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension(page.getContentWidth(c2), (int)margin.bottom());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance + (int)page.getMargin(c2).left();
            if (mode == 1) {
                top2 = page.getPaintingBottom() - (int)page.getMargin(c2).bottom();
            } else if (mode == 2) {
                top2 = page.getHeight(c2) - (int)page.getMargin(c2).bottom();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }
    }

    private static class TopMarginArea
    extends MarginArea {
        public TopMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.TOP_LEFT, MarginBoxName.TOP_CENTER, MarginBoxName.TOP_RIGHT});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension(page.getContentWidth(c2), (int)margin.top());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance + (int)page.getMargin(c2).left();
            if (mode == 1) {
                top2 = page.getPaintingTop();
            } else if (mode == 2) {
                top2 = 0;
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }
    }

    private static class RightMarginArea
    extends MarginArea {
        public RightMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.RIGHT_TOP, MarginBoxName.RIGHT_MIDDLE, MarginBoxName.RIGHT_BOTTOM});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), page.getContentHeight(c2));
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance + page.getWidth(c2) - (int)page.getMargin(c2).right();
            if (mode == 1) {
                top2 = page.getPaintingTop() + (int)page.getMargin(c2).top();
            } else if (mode == 2) {
                top2 = (int)page.getMargin(c2).top();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }

        @Override
        public int getDirection() {
            return 1;
        }
    }

    private static class LeftMarginArea
    extends MarginArea {
        public LeftMarginArea() {
            super(new MarginBoxName[]{MarginBoxName.LEFT_TOP, MarginBoxName.LEFT_MIDDLE, MarginBoxName.LEFT_BOTTOM});
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), page.getContentHeight(c2));
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance;
            if (mode == 1) {
                top2 = page.getPaintingTop() + (int)page.getMargin(c2).top();
            } else if (mode == 2) {
                top2 = (int)page.getMargin(c2).top();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }

        @Override
        public int getDirection() {
            return 1;
        }
    }

    private static class BottomLeftCorner
    extends MarginArea {
        public BottomLeftCorner() {
            super(MarginBoxName.BOTTOM_LEFT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), (int)margin.bottom());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance;
            if (mode == 1) {
                top2 = page.getPaintingBottom() - (int)page.getMargin(c2).bottom();
            } else if (mode == 2) {
                top2 = page.getHeight(c2) - (int)page.getMargin(c2).bottom();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }
    }

    private static class BottomRightCorner
    extends MarginArea {
        public BottomRightCorner() {
            super(MarginBoxName.BOTTOM_RIGHT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.right(), (int)margin.bottom());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance + page.getWidth(c2) - (int)page.getMargin(c2).right();
            if (mode == 1) {
                top2 = page.getPaintingBottom() - (int)page.getMargin(c2).bottom();
            } else if (mode == 2) {
                top2 = page.getHeight(c2) - (int)page.getMargin(c2).bottom();
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }
    }

    private static class TopRightCorner
    extends MarginArea {
        public TopRightCorner() {
            super(MarginBoxName.TOP_RIGHT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.right(), (int)margin.top());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance + page.getWidth(c2) - (int)page.getMargin(c2).right();
            if (mode == 1) {
                top2 = page.getPaintingTop();
            } else if (mode == 2) {
                top2 = 0;
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }
    }

    private static class TopLeftCorner
    extends MarginArea {
        public TopLeftCorner() {
            super(MarginBoxName.TOP_LEFT_CORNER);
        }

        @Override
        public Dimension getLayoutDimension(CssContext c2, PageBox page, RectPropertySet margin) {
            return new Dimension((int)margin.left(), (int)margin.top());
        }

        @Override
        public Point getPaintingPosition(RenderingContext c2, PageBox page, int additionalClearance, short mode) {
            int top2;
            int left2 = additionalClearance;
            if (mode == 1) {
                top2 = page.getPaintingTop();
            } else if (mode == 2) {
                top2 = 0;
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            return new Point(left2, top2);
        }
    }

    private static abstract class MarginArea {
        private final MarginBoxName[] _marginBoxNames;
        private TableBox _table;

        public abstract Dimension getLayoutDimension(CssContext var1, PageBox var2, RectPropertySet var3);

        public abstract Point getPaintingPosition(RenderingContext var1, PageBox var2, int var3, short var4);

        public MarginArea(MarginBoxName marginBoxName) {
            this._marginBoxNames = new MarginBoxName[]{marginBoxName};
        }

        public MarginArea(MarginBoxName[] marginBoxNames) {
            this._marginBoxNames = marginBoxNames;
        }

        public TableBox getTable() {
            return this._table;
        }

        public void setTable(TableBox table) {
            this._table = table;
        }

        public MarginBoxName[] getMarginBoxNames() {
            return this._marginBoxNames;
        }

        public int getDirection() {
            return 2;
        }
    }

    private static class MarginAreaContainer {
        private final MarginArea _area;
        private final TableBox _table;

        public MarginAreaContainer(MarginArea area, TableBox table) {
            this._area = area;
            this._table = table;
        }

        public MarginArea getArea() {
            return this._area;
        }

        public TableBox getTable() {
            return this._table;
        }
    }

    private static final class PageDimensions {
        private int _width;
        private int _height;

        private PageDimensions() {
        }

        public int getHeight() {
            return this._height;
        }

        public void setHeight(int height) {
            this._height = height;
        }

        public int getWidth() {
            return this._width;
        }

        public void setWidth(int width) {
            this._width = width;
        }
    }
}

