/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IEnumTfDisplayAttributeInfo;
import org.eclipse.swt.internal.ole.win32.ITfDisplayAttributeInfo;
import org.eclipse.swt.internal.ole.win32.ITfDisplayAttributeProvider;
import org.eclipse.swt.internal.ole.win32.ITfInputProcessorProfiles;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TF_DISPLAYATTRIBUTE;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int WM_MSIME_MOUSE = OS.RegisterWindowMessage(new TCHAR(0, "MSIMEMouseOperation", true));
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    IME() {
    }

    public IME(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    TF_DISPLAYATTRIBUTE getDisplayAttribute(short langid, int attInfo) {
        long[] ppv = new long[1];
        int hr = COM.CoCreateInstance(COM.CLSID_TF_InputProcessorProfiles, 0L, 1, COM.IID_ITfInputProcessorProfiles, ppv);
        TF_DISPLAYATTRIBUTE pda = null;
        if (hr == 0) {
            ITfInputProcessorProfiles pProfiles = new ITfInputProcessorProfiles(ppv[0]);
            GUID pclsid = new GUID();
            GUID pguidProfile = new GUID();
            hr = pProfiles.GetDefaultLanguageProfile(langid, COM.GUID_TFCAT_TIP_KEYBOARD, pclsid, pguidProfile);
            if (hr == 0 && (hr = COM.CoCreateInstance(pclsid, 0L, 1, COM.IID_ITfDisplayAttributeProvider, ppv)) == 0) {
                ITfDisplayAttributeProvider pProvider = new ITfDisplayAttributeProvider(ppv[0]);
                hr = pProvider.EnumDisplayAttributeInfo(ppv);
                if (hr == 0) {
                    IEnumTfDisplayAttributeInfo pEnum = new IEnumTfDisplayAttributeInfo(ppv[0]);
                    TF_DISPLAYATTRIBUTE tempPda = new TF_DISPLAYATTRIBUTE();
                    while ((hr = pEnum.Next(1, ppv, null)) == 0) {
                        ITfDisplayAttributeInfo pDispInfo = new ITfDisplayAttributeInfo(ppv[0]);
                        pDispInfo.GetAttributeInfo(tempPda);
                        pDispInfo.Release();
                        if (tempPda.bAttr != attInfo) continue;
                        pda = tempPda;
                        break;
                    }
                    pEnum.Release();
                }
                pProvider.Release();
            }
            pProfiles.Release();
        }
        if (pda == null) {
            pda = new TF_DISPLAYATTRIBUTE();
            switch (attInfo) {
                case 0: {
                    pda.lsStyle = 4;
                    break;
                }
                case 1: 
                case 2: {
                    pda.lsStyle = 1;
                    pda.fBoldLine = attInfo == 1;
                }
            }
        }
        return pda;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] result2 = new int[this.ranges.length];
        int i2 = 0;
        while (i2 < result2.length) {
            result2[i2] = this.ranges[i2] + this.startOffset;
            ++i2;
        }
        return result2;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] result2 = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, result2, 0, this.styles.length);
        return result2;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        long layout = OS.GetKeyboardLayout(0);
        short langID = (short)OS.LOWORD(layout);
        return OS.PRIMARYLANGID(langID) == 18;
    }

    boolean isInlineEnabled() {
        return OS.IsDBLocale && this.hooks(43);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int offset) {
        this.checkWidget();
        if (offset < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = offset;
        }
    }

    LRESULT WM_IME_COMPOSITION(long wParam, long lParam) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        if (hIMC != 0L) {
            Event event;
            int length;
            char[] buffer = null;
            if ((lParam & 0x800L) != 0L) {
                length = OS.ImmGetCompositionString(hIMC, 2048, null, 0);
                if (length > 0) {
                    buffer = new char[length / 2];
                    OS.ImmGetCompositionString(hIMC, 2048, buffer, length);
                    if (this.startOffset == -1) {
                        event = new Event();
                        event.detail = 3;
                        this.sendEvent(43, event);
                        this.startOffset = event.start;
                    }
                    event = new Event();
                    event.detail = 1;
                    event.start = this.startOffset;
                    event.end = this.startOffset + this.text.length();
                    this.text = buffer != null ? new String(buffer) : "";
                    event.text = this.text;
                    this.commitCount = this.text.length();
                    this.sendEvent(43, event);
                    String chars = this.text;
                    this.text = "";
                    this.startOffset = -1;
                    this.commitCount = 0;
                    if (event.doit) {
                        Display display = this.display;
                        display.lastKey = 0;
                        display.lastDead = false;
                        display.lastNull = false;
                        display.lastVirtual = false;
                        length = chars.length();
                        int i2 = 0;
                        while (i2 < length) {
                            char c2 = chars.charAt(i2);
                            display.lastAscii = c2;
                            event = new Event();
                            event.character = c2;
                            this.parent.sendEvent(1, event);
                            ++i2;
                        }
                    }
                }
                if ((lParam & 8L) == 0L) {
                    return LRESULT.ONE;
                }
            }
            buffer = null;
            if ((lParam & 8L) != 0L) {
                length = OS.ImmGetCompositionString(hIMC, 8, null, 0);
                if (length > 0) {
                    buffer = new char[length / 2];
                    OS.ImmGetCompositionString(hIMC, 8, buffer, length);
                    if ((lParam & 0x80L) != 0L) {
                        this.caretOffset = OS.ImmGetCompositionString(hIMC, 128, null, 0);
                    }
                    int[] clauses = null;
                    if ((lParam & 0x20L) != 0L && (length = OS.ImmGetCompositionString(hIMC, 32, null, 0)) > 0) {
                        clauses = new int[length / 4];
                        OS.ImmGetCompositionString(hIMC, 32, clauses, length);
                    }
                    if ((lParam & 0x10L) != 0L && clauses != null && (length = OS.ImmGetCompositionString(hIMC, 16, null, 0)) > 0) {
                        byte[] attrs = new byte[length];
                        OS.ImmGetCompositionString(hIMC, 16, attrs, length);
                        length = clauses.length - 1;
                        this.ranges = new int[length * 2];
                        this.styles = new TextStyle[length];
                        long layout = OS.GetKeyboardLayout(0);
                        short langID = (short)OS.LOWORD(layout);
                        TF_DISPLAYATTRIBUTE attr = null;
                        TextStyle style = null;
                        int i3 = 0;
                        while (i3 < length) {
                            this.ranges[i3 * 2] = clauses[i3];
                            this.ranges[i3 * 2 + 1] = clauses[i3 + 1] - 1;
                            this.styles[i3] = style = new TextStyle();
                            if (clauses[i3] >= 0 && clauses[i3] < attrs.length && (attr = this.getDisplayAttribute(langID, attrs[clauses[i3]])) != null) {
                                int colorRef;
                                switch (attr.crText.type) {
                                    case 2: {
                                        style.foreground = Color.win32_new(this.display, attr.crText.cr);
                                        break;
                                    }
                                    case 1: {
                                        colorRef = OS.GetSysColor(attr.crText.cr);
                                        style.foreground = Color.win32_new(this.display, colorRef);
                                    }
                                }
                                switch (attr.crBk.type) {
                                    case 2: {
                                        style.background = Color.win32_new(this.display, attr.crBk.cr);
                                        break;
                                    }
                                    case 1: {
                                        colorRef = OS.GetSysColor(attr.crBk.cr);
                                        style.background = Color.win32_new(this.display, colorRef);
                                    }
                                }
                                switch (attr.crLine.type) {
                                    case 2: {
                                        style.underlineColor = Color.win32_new(this.display, attr.crLine.cr);
                                        break;
                                    }
                                    case 1: {
                                        colorRef = OS.GetSysColor(attr.crLine.cr);
                                        style.underlineColor = Color.win32_new(this.display, colorRef);
                                    }
                                }
                                style.underline = attr.lsStyle != 0;
                                switch (attr.lsStyle) {
                                    case 4: {
                                        style.underlineStyle = 3;
                                        break;
                                    }
                                    case 3: {
                                        style.underlineStyle = 131072;
                                        break;
                                    }
                                    case 2: {
                                        style.underlineStyle = 65536;
                                        break;
                                    }
                                    case 1: {
                                        style.underlineStyle = attr.fBoldLine ? 196608 : 0;
                                    }
                                }
                            }
                            ++i3;
                        }
                    }
                }
                OS.ImmReleaseContext(hwnd, hIMC);
            }
            int end = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                event = new Event();
                event.detail = 3;
                this.sendEvent(43, event);
                this.startOffset = event.start;
                end = event.end;
            }
            event = new Event();
            event.detail = 1;
            event.start = this.startOffset;
            event.end = end;
            this.text = buffer != null ? new String(buffer) : "";
            event.text = this.text;
            this.sendEvent(43, event);
            if (this.text.length() == 0) {
                this.startOffset = -1;
                this.ranges = null;
                this.styles = null;
            }
        }
        return LRESULT.ONE;
    }

    LRESULT WM_IME_COMPOSITION_START(long wParam, long lParam) {
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_IME_ENDCOMPOSITION(long wParam, long lParam) {
        this.startOffset = -1;
        this.caretOffset = 0;
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        long hKL;
        short langID;
        if (wParam == 25L && OS.PRIMARYLANGID(langID = (short)OS.LOWORD(hKL = OS.GetKeyboardLayout(0))) == 18) {
            Event event = new Event();
            event.detail = 3;
            this.sendEvent(43, event);
            if (event.start == event.end) {
                event.text = null;
                event.end = event.start + 1;
                this.sendEvent(43, event);
            }
            if (event.text != null && event.text.length() > 0) {
                TCHAR buffer;
                long hwnd;
                long hIMC;
                long rc;
                int length = event.text.length();
                if (length > 1) {
                    event.end = event.start + 1;
                }
                if ((rc = OS.ImmEscape(hKL, hIMC = OS.ImmGetContext(hwnd = this.parent.handle), 4104, buffer = new TCHAR(0, event.text, true))) != 0L) {
                    this.sendEvent(43, event);
                }
            }
        }
        return null;
    }

    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        if (hIMC != 0L) {
            if (OS.ImmGetOpenStatus(hIMC)) {
                OS.ImmNotifyIME(hIMC, 21, 1, 0);
            }
            OS.ImmReleaseContext(hwnd, hIMC);
        }
        return null;
    }

    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        long hwnd = this.parent.handle;
        long hIMC = OS.ImmGetContext(hwnd);
        if (hIMC != 0L) {
            if (OS.ImmGetOpenStatus(hIMC) && OS.ImmGetCompositionString(hIMC, 8, null, 0) > 0) {
                Event event = new Event();
                event.detail = 2;
                event.setLocationInPixels(OS.GET_X_LPARAM(lParam), OS.GET_Y_LPARAM(lParam));
                this.sendEvent(43, event);
                int offset = event.index;
                int length = this.text.length();
                if (offset != -1 && this.startOffset != -1 && this.startOffset <= offset && offset < this.startOffset + length) {
                    long imeWnd = OS.ImmGetDefaultIMEWnd(hwnd);
                    offset = event.index + event.count - this.startOffset;
                    int trailing = event.count > 0 ? 1 : 2;
                    long param2 = OS.MAKEWPARAM(OS.MAKEWORD(1, trailing), offset);
                    OS.SendMessage(imeWnd, WM_MSIME_MOUSE, param2, hIMC);
                } else {
                    OS.ImmNotifyIME(hIMC, 21, 1, 0);
                }
            }
            OS.ImmReleaseContext(hwnd, hIMC);
        }
        return null;
    }
}

