/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.histo.datasources.HistoSet;
import gde.histo.recordings.HistoTableMapper;
import gde.histo.recordings.TrailDataTags;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.ui.ExclusionActivity;
import gde.histo.ui.HistoExplorer;
import gde.histo.ui.menu.AbstractTabAreaContextMenu;
import gde.histo.ui.menu.TableTabAreaContextMenu;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class HistoTableWindow
extends CTabItem {
    private static final String $CLASS_NAME = HistoTableWindow.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int TEXT_EXTENT_FACTOR = 6;
    private final HistoExplorer presentHistoExplorer = DataExplorer.getInstance().getPresentHistoExplorer();
    private final Channels channels = Channels.getInstance();
    private final Settings settings = Settings.getInstance();
    private final CTabFolder tabFolder;
    private final Menu popupmenu;
    private final AbstractTabAreaContextMenu contextMenu;
    private Table dataTable;
    private TableCursor cursor;
    private Vector<Integer> rowVector = new Vector(2);
    private Vector<Integer> topindexVector = new Vector(2);

    private HistoTableWindow(CTabFolder dataTab, int style, int position) {
        super(dataTab, style, position);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.tabFolder = dataTab;
        this.setFont(SWTResourceManager.getFont((Control)DataExplorer.getInstance(), GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0793"));
        this.popupmenu = new Menu((Decorations)DataExplorer.getInstance().getShell(), 8);
        this.contextMenu = new TableTabAreaContextMenu();
    }

    public static HistoTableWindow create(CTabFolder dataTab, int style, int position) {
        HistoTableWindow window = new HistoTableWindow(dataTab, style, position);
        window.dataTable = new Table((Composite)window.tabFolder, 268503042);
        window.setControl((Control)window.dataTable);
        window.dataTable.setLinesVisible(true);
        window.dataTable.setHeaderVisible(true);
        window.initGui();
        return window;
    }

    private void initGui() {
        TableEditor editor = new TableEditor(this.dataTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.cursor = new TableCursor(this.dataTable, 0);
        this.cursor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                log.finest(() -> "cursor.keyReleased, keycode: " + event.keyCode);
                if (event.stateMask == SWT.MOD1) {
                    switch (event.keyCode) {
                        case 0x1000007: {
                            HistoTableWindow.this.cursor.setSelection(0, 0);
                            break;
                        }
                        case 0x1000008: {
                            HistoTableWindow.this.cursor.setSelection(HistoTableWindow.this.dataTable.getItemCount() - 1, HistoTableWindow.this.dataTable.getColumnCount() - 1);
                            break;
                        }
                        case 99: {
                            HistoTableWindow.this.dataTable.getSelectionCount();
                            HistoTableWindow.this.dataTable.getSelectionIndices();
                            StringBuilder sb = new StringBuilder();
                            int columns = HistoTableWindow.this.dataTable.getColumnCount();
                            for (int i = 0; i < columns; ++i) {
                                sb.append(HistoTableWindow.this.dataTable.getColumn(i).getText().trim()).append('\t');
                            }
                            sb.deleteCharAt(sb.length() - 1).append('\n');
                            for (TableItem tmpItem : HistoTableWindow.this.dataTable.getSelection()) {
                                for (int i = 0; i < columns; ++i) {
                                    sb.append(tmpItem.getText(i).trim()).append('\t');
                                }
                                sb.deleteCharAt(sb.length() - 1).append('\n');
                            }
                            Clipboard cb = new Clipboard(GDE.display);
                            String textData = sb.toString();
                            TextTransfer textTransfer = TextTransfer.getInstance();
                            cb.setContents(new Object[]{textData}, new Transfer[]{textTransfer});
                        }
                    }
                } else if ((event.stateMask & SWT.MOD2) != 0 && (event.stateMask & SWT.MOD1) != 0) {
                    switch (event.keyCode) {
                        case 0x1000007: {
                            HistoTableWindow.this.cursor.setSelection(0, HistoTableWindow.this.cursor.getColumn());
                            break;
                        }
                        case 0x1000008: {
                            HistoTableWindow.this.cursor.setSelection(HistoTableWindow.this.dataTable.getItemCount() - 1, HistoTableWindow.this.cursor.getColumn());
                        }
                    }
                } else if (event.stateMask == 0) {
                    switch (event.keyCode) {
                        case 0x1000007: {
                            this.workaroundTableCursor(0);
                            break;
                        }
                        case 0x1000008: {
                            this.workaroundTableCursor(HistoTableWindow.this.dataTable.getColumnCount() - 1);
                        }
                    }
                }
                if (HistoTableWindow.this.cursor.getRow() != null && ((event.stateMask & SWT.MOD1) == 0 && event.character != 'c' || (event.stateMask & SWT.MOD1) == 0 && event.character != 'a')) {
                    HistoTableWindow.this.updateVector(HistoTableWindow.this.dataTable.indexOf(HistoTableWindow.this.cursor.getRow()), HistoTableWindow.this.dataTable.getTopIndex());
                    HistoTableWindow.this.dataTable.setSelection(new TableItem[]{HistoTableWindow.this.cursor.getRow()});
                }
            }

            private void workaroundTableCursor(int col) {
                int row = HistoTableWindow.this.rowVector.get(0);
                log.finer(() -> "Setting selection to row: " + row);
                HistoTableWindow.this.cursor.setSelection(row, col);
                log.finer(() -> "Setting top index: " + String.valueOf(HistoTableWindow.this.topindexVector.get(0)));
                HistoTableWindow.this.dataTable.setTopIndex(HistoTableWindow.this.topindexVector.get(0).intValue());
                HistoTableWindow.this.cursor.setVisible(true);
            }

            public void keyPressed(KeyEvent event) {
                log.log(Level.FINEST, "cursor.keyPressed ", event);
                if (!(HistoTableWindow.this.cursor.getRow() == null || event.stateMask == SWT.MOD1 && event.keyCode != 153 || event.stateMask == SWT.MOD1 && event.keyCode != 151 || event.keyCode == SWT.MOD1)) {
                    HistoTableWindow.this.dataTable.setSelection(new TableItem[]{HistoTableWindow.this.cursor.getRow()});
                } else if (HistoTableWindow.this.cursor.getRow() != null && (event.stateMask & SWT.MOD1) == SWT.MOD1 && event.keyCode == 97) {
                    HistoTableWindow.this.dataTable.setSelection(HistoTableWindow.this.dataTable.getItems());
                }
                if (event.keyCode == SWT.MOD2 && (event.stateMask & SWT.MOD2) == 0 && (event.stateMask & SWT.MOD1) == 0 && (event.stateMask & SWT.MOD3) == 0) {
                    HistoTableWindow.this.cursor.setVisible(false);
                    if (HistoTableWindow.this.cursor.getRow() != null) {
                        HistoTableWindow.this.dataTable.setSelection(new TableItem[]{HistoTableWindow.this.cursor.getRow()});
                    }
                }
            }
        });
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TrailRecordSet trailRecordSet;
                log.log(Level.FINEST, "cursor.widgetSelected ", event);
                if (HistoTableWindow.this.cursor.getRow() != null) {
                    HistoTableWindow.this.updateVector(HistoTableWindow.this.dataTable.indexOf(HistoTableWindow.this.cursor.getRow()), HistoTableWindow.this.dataTable.getTopIndex());
                }
                trailRecordSet = Channels.getInstance().getActiveChannel() != null ? (trailRecordSet = HistoTableWindow.this.presentHistoExplorer.getTrailRecordSet()) : null;
                int rowNumber = HistoTableWindow.this.dataTable.indexOf(HistoTableWindow.this.cursor.getRow());
                int columnNumber = HistoTableWindow.this.cursor.getColumn();
                log.finer(() -> "row=" + rowNumber + "  column=" + columnNumber);
                if (HistoTableWindow.this.dataTable.getColumnCount() <= 2 || columnNumber < 2 || trailRecordSet == null || trailRecordSet.isEmpty()) {
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.IS_CURSOR_IN_CANVAS.name(), null);
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)"");
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)"");
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)"");
                } else {
                    int index = HistoTableWindow.this.settings.isXAxisReversed() ? columnNumber - 2 : HistoTableWindow.this.dataTable.getColumnCount() - columnNumber - 1;
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.IS_CURSOR_IN_CANVAS.name(), (Object)"true");
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_LINK_PATH.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.LINK_PATH));
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.FILE_PATH));
                    HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.RECORDSET_BASE_NAME.name(), (Object)trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.RECORDSET_BASE_NAME));
                }
                HistoTableWindow.this.popupmenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.EXCLUDED_LIST.name(), (Object)Arrays.stream(ExclusionActivity.getExcludedTrusses()).collect(Collectors.joining(",")));
                log.finer(() -> "DataTag.FILE_PATH=" + String.valueOf(HistoTableWindow.this.popupmenu.getData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.name())));
            }
        });
        this.dataTable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.dataTable.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINER, "dataTable.helpRequested ", evt);
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_95.html");
            }
        });
        this.dataTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (HistoTableWindow.this.presentHistoExplorer.hasRecords()) {
                    TrailRecordSet trailRecordSet = HistoTableWindow.this.presentHistoExplorer.getTrailRecordSet();
                    TableItem item = (TableItem)event.item;
                    Vector<TrailRecord> currentRecords = trailRecordSet.getVisibleAndDisplayableRecordsForTable();
                    try {
                        if (HistoTableWindow.this.dataTable.indexOf(item) < currentRecords.size()) {
                            int index = HistoTableWindow.this.dataTable.indexOf(item);
                            TrailRecord trailRecord = currentRecords.get(index);
                            item.setText(HistoTableMapper.getTableRow(trailRecord));
                        } else if (HistoTableWindow.this.settings.isDisplayTags()) {
                            int index = HistoTableWindow.this.dataTable.indexOf(item) - currentRecords.size();
                            int channelNumber = Analyzer.getInstance().getActiveChannel().getNumber();
                            HistoTableMapper.DisplayTag[] activeDisplayTags = trailRecordSet.getDataTags().getActiveDisplayTags(channelNumber).toArray(new HistoTableMapper.DisplayTag[0]);
                            item.setText(HistoTableMapper.getTableTagRow(trailRecordSet, activeDisplayTags[index]));
                        }
                    }
                    catch (Exception e) {
                        log.warning(() -> "index of item outside data table array bounds");
                    }
                }
            }
        });
        this.dataTable.addKeyListener(new KeyListener(){
            int selectionFlowIndex = 0;

            private void workaroundTableCursor(int col) {
                int row = HistoTableWindow.this.rowVector.get(HistoTableWindow.this.rowVector.size() - 1);
                log.log(Level.FINER, "Setting selection to row: ", row);
                HistoTableWindow.this.cursor.setSelection(row, col);
                log.finer(() -> "Setting top index: " + String.valueOf(HistoTableWindow.this.topindexVector.get(0)));
                HistoTableWindow.this.dataTable.setTopIndex(HistoTableWindow.this.topindexVector.get(HistoTableWindow.this.topindexVector.size() - 1).intValue());
                HistoTableWindow.this.cursor.setVisible(true);
                HistoTableWindow.this.cursor.setFocus();
            }

            public void keyReleased(KeyEvent event) {
                log.finest(() -> "dataTable.keyReleased, keycode: " + event.keyCode);
                if (event.keyCode == SWT.MOD2 && HistoTableWindow.this.rowVector.size() > 0) {
                    int rowIndex = HistoTableWindow.this.rowVector.get(HistoTableWindow.this.rowVector.size() - 1) + this.selectionFlowIndex;
                    rowIndex = rowIndex < 0 ? 0 : (rowIndex > HistoTableWindow.this.dataTable.getItems().length - 1 ? HistoTableWindow.this.dataTable.getItems().length - 1 : rowIndex);
                    HistoTableWindow.this.updateVector(rowIndex, HistoTableWindow.this.dataTable.getTopIndex());
                    this.workaroundTableCursor(HistoTableWindow.this.cursor.getColumn());
                    this.selectionFlowIndex = 0;
                    switch (event.keyCode) {
                        default: 
                    }
                }
            }

            public void keyPressed(KeyEvent event) {
                log.finest(() -> "dataTable.keyPressed, keycode: " + event.keyCode);
                if (event.stateMask == SWT.MOD2 && (event.stateMask & SWT.MOD1) == 0 && (event.stateMask & SWT.MOD3) == 0) {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            --this.selectionFlowIndex;
                            break;
                        }
                        case 0x1000002: {
                            ++this.selectionFlowIndex;
                        }
                    }
                }
            }
        });
        this.contextMenu.createMenu(this.popupmenu);
        this.cursor.setMenu(this.popupmenu);
    }

    public boolean isVisible() {
        return this.dataTable.isVisible();
    }

    private void updateVector(int row, int topindex) {
        if (this.rowVector.size() == 2) {
            this.rowVector.remove(0);
            this.topindexVector.remove(0);
        }
        this.rowVector.addElement(row);
        this.topindexVector.addElement(topindex);
    }

    public boolean isHeaderTextValid() {
        String[] tableHeaderRow;
        if (this.presentHistoExplorer.hasRecords() && (tableHeaderRow = HistoTableMapper.getTableHeaderRow(this.presentHistoExplorer.getTrailRecordSet())).length == this.dataTable.getColumnCount() - 2) {
            boolean isValid = true;
            for (int i = 0; i < tableHeaderRow.length && (isValid = tableHeaderRow[i].equals(this.dataTable.getColumn(i + 2).getText())); ++i) {
            }
            return isValid;
        }
        return false;
    }

    public boolean isRowTextAndTrailValid() {
        boolean isValid = false;
        if (this.presentHistoExplorer.hasRecords()) {
            TrailRecordSet trailRecordSet = this.presentHistoExplorer.getTrailRecordSet();
            for (int j = 0; j < this.dataTable.getItems().length; ++j) {
                TableItem tableItem = this.dataTable.getItems()[j];
                int index = this.dataTable.indexOf(tableItem);
                if (this.dataTable.indexOf(tableItem) < trailRecordSet.getVisibleAndDisplayableRecordsForTable().size()) {
                    TrailRecord trailRecord = trailRecordSet.getVisibleAndDisplayableRecordsForTable().get(index);
                    isValid = tableItem.getText().equals(trailRecord.getTableRowHeader()) && tableItem.getText(1).equals(trailRecord.getTrailSelector().getTrailText());
                } else {
                    isValid = tableItem.getText().isEmpty();
                }
                if (!isValid) break;
            }
        }
        return isValid;
    }

    public void setHeader() {
        this.dataTable.removeAll();
        for (TableColumn tableColumn : this.dataTable.getColumns()) {
            tableColumn.dispose();
        }
        this.dataTable.setItemCount(0);
        String recordTitle = Messages.getString("GDE_MSGT0749");
        TableColumn recordsColumn = new TableColumn(this.dataTable, 0x1000000);
        recordsColumn.setWidth((int)((double)(recordTitle.length() * 6 * 15) / 10.0));
        recordsColumn.setText(recordTitle);
        String curveTypeHeader = Messages.getString("GDE_MSGT0828");
        recordsColumn = new TableColumn(this.dataTable, 16384);
        recordsColumn.setWidth((int)((double)(curveTypeHeader.length() * 6 * 15) / 10.0));
        recordsColumn.setText(curveTypeHeader);
        Channel activeChannel = this.channels.getActiveChannel();
        HistoSet histoSet = this.presentHistoExplorer.getHistoSet();
        if (activeChannel != null && histoSet != null && histoSet.getTrailRecordSet() != null) {
            String[] tableHeaderRow = HistoTableMapper.getTableHeaderRow(histoSet.getTrailRecordSet());
            if (tableHeaderRow.length > 0) {
                for (String headerString : tableHeaderRow) {
                    TableColumn column = new TableColumn(this.dataTable, 0x1000000);
                    column.setWidth((int)((double)(headerString.length() * 6 * 21) / 20.0));
                    column.setText(headerString.intern());
                }
            } else if (System.getProperty("os.name", "").toLowerCase().startsWith("linux")) {
                TableColumn column = new TableColumn(this.dataTable, 0x1000000);
                column.setWidth(100);
            }
        }
        log.log(Level.FINER, "dataTable.getColumnCount() ", this.dataTable.getColumnCount());
    }

    public void setRowCount(int count) {
        DataExplorer.getInstance().getPresentHistoExplorer().paintVolatileStatusMessage();
        this.dataTable.setItemCount(count);
    }

    public synchronized void cleanTable() {
        if (this.dataTable != null && !this.dataTable.isDisposed()) {
            this.dataTable.removeAll();
            for (TableColumn tableColumn : this.dataTable.getColumns()) {
                tableColumn.dispose();
            }
        }
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.dataTable.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.dataTable.print(imageGC);
        if (GDE.IS_MAC) {
            this.dataTable.print(imageGC);
        }
        imageGC.dispose();
        return tabContentImage;
    }

    public int getTableLength() {
        return this.dataTable.getItems().length;
    }
}

