/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

class BiDiagonalTransformer {
    private final double[][] householderVectors;
    private final double[] main;
    private final double[] secondary;
    private RealMatrix cachedU;
    private RealMatrix cachedB;
    private RealMatrix cachedV;

    BiDiagonalTransformer(RealMatrix matrix) {
        int m2 = matrix.getRowDimension();
        int n2 = matrix.getColumnDimension();
        int p2 = FastMath.min(m2, n2);
        this.householderVectors = matrix.getData();
        this.main = new double[p2];
        this.secondary = new double[p2 - 1];
        this.cachedU = null;
        this.cachedB = null;
        this.cachedV = null;
        if (m2 >= n2) {
            this.transformToUpperBiDiagonal();
        } else {
            this.transformToLowerBiDiagonal();
        }
    }

    public RealMatrix getU() {
        if (this.cachedU == null) {
            int k2;
            int m2 = this.householderVectors.length;
            int n2 = this.householderVectors[0].length;
            int p2 = this.main.length;
            int diagOffset = m2 >= n2 ? 0 : 1;
            double[] diagonal = m2 >= n2 ? this.main : this.secondary;
            double[][] ua = new double[m2][m2];
            for (k2 = m2 - 1; k2 >= p2; --k2) {
                ua[k2][k2] = 1.0;
            }
            for (k2 = p2 - 1; k2 >= diagOffset; --k2) {
                double[] hK = this.householderVectors[k2];
                ua[k2][k2] = 1.0;
                if (hK[k2 - diagOffset] == 0.0) continue;
                for (int j2 = k2; j2 < m2; ++j2) {
                    int i2;
                    double alpha = 0.0;
                    for (i2 = k2; i2 < m2; ++i2) {
                        alpha -= ua[i2][j2] * this.householderVectors[i2][k2 - diagOffset];
                    }
                    alpha /= diagonal[k2 - diagOffset] * hK[k2 - diagOffset];
                    for (i2 = k2; i2 < m2; ++i2) {
                        double[] dArray = ua[i2];
                        int n3 = j2;
                        dArray[n3] = dArray[n3] + -alpha * this.householderVectors[i2][k2 - diagOffset];
                    }
                }
            }
            if (diagOffset > 0) {
                ua[0][0] = 1.0;
            }
            this.cachedU = MatrixUtils.createRealMatrix(ua);
        }
        return this.cachedU;
    }

    public RealMatrix getB() {
        if (this.cachedB == null) {
            int m2 = this.householderVectors.length;
            int n2 = this.householderVectors[0].length;
            double[][] ba = new double[m2][n2];
            for (int i2 = 0; i2 < this.main.length; ++i2) {
                ba[i2][i2] = this.main[i2];
                if (m2 < n2) {
                    if (i2 <= 0) continue;
                    ba[i2][i2 - 1] = this.secondary[i2 - 1];
                    continue;
                }
                if (i2 >= this.main.length - 1) continue;
                ba[i2][i2 + 1] = this.secondary[i2];
            }
            this.cachedB = MatrixUtils.createRealMatrix(ba);
        }
        return this.cachedB;
    }

    public RealMatrix getV() {
        if (this.cachedV == null) {
            int k2;
            int m2 = this.householderVectors.length;
            int n2 = this.householderVectors[0].length;
            int p2 = this.main.length;
            int diagOffset = m2 >= n2 ? 1 : 0;
            double[] diagonal = m2 >= n2 ? this.secondary : this.main;
            double[][] va = new double[n2][n2];
            for (k2 = n2 - 1; k2 >= p2; --k2) {
                va[k2][k2] = 1.0;
            }
            for (k2 = p2 - 1; k2 >= diagOffset; --k2) {
                double[] hK = this.householderVectors[k2 - diagOffset];
                va[k2][k2] = 1.0;
                if (hK[k2] == 0.0) continue;
                for (int j2 = k2; j2 < n2; ++j2) {
                    int i2;
                    double beta = 0.0;
                    for (i2 = k2; i2 < n2; ++i2) {
                        beta -= va[i2][j2] * hK[i2];
                    }
                    beta /= diagonal[k2 - diagOffset] * hK[k2];
                    for (i2 = k2; i2 < n2; ++i2) {
                        double[] dArray = va[i2];
                        int n3 = j2;
                        dArray[n3] = dArray[n3] + -beta * hK[i2];
                    }
                }
            }
            if (diagOffset > 0) {
                va[0][0] = 1.0;
            }
            this.cachedV = MatrixUtils.createRealMatrix(va);
        }
        return this.cachedV;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    double[] getMainDiagonalRef() {
        return this.main;
    }

    double[] getSecondaryDiagonalRef() {
        return this.secondary;
    }

    boolean isUpperBiDiagonal() {
        return this.householderVectors.length >= this.householderVectors[0].length;
    }

    private void transformToUpperBiDiagonal() {
        int m2 = this.householderVectors.length;
        int n2 = this.householderVectors[0].length;
        for (int k2 = 0; k2 < n2; ++k2) {
            double b2;
            int j2;
            double a2;
            double xNormSqr = 0.0;
            for (int i2 = k2; i2 < m2; ++i2) {
                double c2 = this.householderVectors[i2][k2];
                xNormSqr += c2 * c2;
            }
            double[] hK = this.householderVectors[k2];
            this.main[k2] = a2 = hK[k2] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a2 != 0.0) {
                int n3 = k2;
                hK[n3] = hK[n3] - a2;
                for (j2 = k2 + 1; j2 < n2; ++j2) {
                    double[] hI;
                    int i3;
                    double alpha = 0.0;
                    for (i3 = k2; i3 < m2; ++i3) {
                        hI = this.householderVectors[i3];
                        alpha -= hI[j2] * hI[k2];
                    }
                    alpha /= a2 * this.householderVectors[k2][k2];
                    for (i3 = k2; i3 < m2; ++i3) {
                        hI = this.householderVectors[i3];
                        int n4 = j2;
                        hI[n4] = hI[n4] - alpha * hI[k2];
                    }
                }
            }
            if (k2 >= n2 - 1) continue;
            xNormSqr = 0.0;
            for (j2 = k2 + 1; j2 < n2; ++j2) {
                double c3 = hK[j2];
                xNormSqr += c3 * c3;
            }
            this.secondary[k2] = b2 = hK[k2 + 1] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (b2 == 0.0) continue;
            int n5 = k2 + 1;
            hK[n5] = hK[n5] - b2;
            for (int i4 = k2 + 1; i4 < m2; ++i4) {
                int j3;
                double[] hI = this.householderVectors[i4];
                double beta = 0.0;
                for (j3 = k2 + 1; j3 < n2; ++j3) {
                    beta -= hI[j3] * hK[j3];
                }
                beta /= b2 * hK[k2 + 1];
                for (j3 = k2 + 1; j3 < n2; ++j3) {
                    int n6 = j3;
                    hI[n6] = hI[n6] - beta * hK[j3];
                }
            }
        }
    }

    private void transformToLowerBiDiagonal() {
        int m2 = this.householderVectors.length;
        int n2 = this.householderVectors[0].length;
        for (int k2 = 0; k2 < m2; ++k2) {
            double b2;
            double a2;
            double[] hK = this.householderVectors[k2];
            double xNormSqr = 0.0;
            for (int j2 = k2; j2 < n2; ++j2) {
                double c2 = hK[j2];
                xNormSqr += c2 * c2;
            }
            this.main[k2] = a2 = hK[k2] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (a2 != 0.0) {
                int n3 = k2;
                hK[n3] = hK[n3] - a2;
                for (int i2 = k2 + 1; i2 < m2; ++i2) {
                    int j3;
                    double[] hI = this.householderVectors[i2];
                    double alpha = 0.0;
                    for (j3 = k2; j3 < n2; ++j3) {
                        alpha -= hI[j3] * hK[j3];
                    }
                    alpha /= a2 * this.householderVectors[k2][k2];
                    for (j3 = k2; j3 < n2; ++j3) {
                        int n4 = j3;
                        hI[n4] = hI[n4] - alpha * hK[j3];
                    }
                }
            }
            if (k2 >= m2 - 1) continue;
            double[] hKp1 = this.householderVectors[k2 + 1];
            xNormSqr = 0.0;
            for (int i3 = k2 + 1; i3 < m2; ++i3) {
                double c3 = this.householderVectors[i3][k2];
                xNormSqr += c3 * c3;
            }
            this.secondary[k2] = b2 = hKp1[k2] > 0.0 ? -FastMath.sqrt(xNormSqr) : FastMath.sqrt(xNormSqr);
            if (b2 == 0.0) continue;
            int n5 = k2;
            hKp1[n5] = hKp1[n5] - b2;
            for (int j4 = k2 + 1; j4 < n2; ++j4) {
                double[] hI;
                int i4;
                double beta = 0.0;
                for (i4 = k2 + 1; i4 < m2; ++i4) {
                    hI = this.householderVectors[i4];
                    beta -= hI[j4] * hI[k2];
                }
                beta /= b2 * hKp1[k2];
                for (i4 = k2 + 1; i4 < m2; ++i4) {
                    hI = this.householderVectors[i4];
                    int n6 = j4;
                    hI[n6] = hI[n6] - beta * hI[k2];
                }
            }
        }
    }
}

