/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.DOMDocument;
import org.eclipse.swt.internal.cocoa.DOMKeyboardEvent;
import org.eclipse.swt.internal.cocoa.DOMMouseEvent;
import org.eclipse.swt.internal.cocoa.DOMWheelEvent;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSError;
import org.eclipse.swt.internal.cocoa.NSHTTPCookie;
import org.eclipse.swt.internal.cocoa.NSHTTPCookieStorage;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableURLRequest;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSURLAuthenticationChallenge;
import org.eclipse.swt.internal.cocoa.NSURLCredential;
import org.eclipse.swt.internal.cocoa.NSURLDownload;
import org.eclipse.swt.internal.cocoa.NSURLProtectionSpace;
import org.eclipse.swt.internal.cocoa.NSURLRequest;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SFCertificateTrustPanel;
import org.eclipse.swt.internal.cocoa.SWTWebViewDelegate;
import org.eclipse.swt.internal.cocoa.WebDataSource;
import org.eclipse.swt.internal.cocoa.WebDocumentRepresentation;
import org.eclipse.swt.internal.cocoa.WebFrame;
import org.eclipse.swt.internal.cocoa.WebFrameView;
import org.eclipse.swt.internal.cocoa.WebOpenPanelResultListener;
import org.eclipse.swt.internal.cocoa.WebPolicyDecisionListener;
import org.eclipse.swt.internal.cocoa.WebPreferences;
import org.eclipse.swt.internal.cocoa.WebScriptObject;
import org.eclipse.swt.internal.cocoa.WebView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    WebView webView;
    WebPreferences preferences;
    SWTWebViewDelegate delegate;
    boolean loadingText;
    boolean untrustedText;
    String lastHoveredLinkURL;
    String lastNavigateURL;
    String html;
    int identifier;
    int resourceCount;
    String url = "";
    Point location;
    Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    int lastMouseMoveX;
    int lastMouseMoveY;
    static int delegateClass;
    static boolean Initialized;
    static Callback Callback3;
    static Callback Callback4;
    static Callback Callback5;
    static Callback Callback6;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String AGENT_STRING = "Safari/522.0";
    static final String URI_FILEROOT = "file:///";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String ABOUT_BLANK = "about:blank";
    static final String HEADER_SETCOOKIE = "Set-Cookie";
    static final String POST = "POST";
    static final String USER_AGENT = "user-agent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final byte[] SWT_OBJECT;
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";

    WebKit() {
    }

    public void create(Composite composite, int n) {
        Class<?> clazz;
        if (delegateClass == 0) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            clazz = this.getClass();
            Callback3 = new Callback(clazz, "browserProc", 3);
            int n7 = Callback3.getAddress();
            if (n7 == 0) {
                SWT.error(3);
            }
            if ((n6 = (Callback4 = new Callback(clazz, "browserProc", 4)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((n5 = (Callback5 = new Callback(clazz, "browserProc", 5)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((n4 = (Callback6 = new Callback(clazz, "browserProc", 6)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((n3 = (Callback7 = new Callback(clazz, "browserProc", 7)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((n2 = OS.CALLBACK_webView_setFrame_(n6)) == 0) {
                SWT.error(3);
            }
            String string = "SWTWebViewDelegate";
            byte[] byArray = new byte[]{42, 0};
            int n8 = C.PTR_SIZEOF;
            int n9 = C.PTR_SIZEOF == 4 ? 2 : 3;
            delegateClass = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
            OS.class_addIvar(delegateClass, SWT_OBJECT, n8, (byte)n9, byArray);
            OS.class_addMethod(delegateClass, OS.sel_webView_didChangeLocationWithinPageForFrame_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didFailProvisionalLoadWithError_forFrame_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didFinishLoadForFrame_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didReceiveTitle_forFrame_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didStartProvisionalLoadForFrame_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didCommitLoadForFrame_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didFinishLoadingFromDataSource_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didReceiveAuthenticationChallenge_fromDataSource_, n4, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didFailLoadingWithError_fromDataSource_, n4, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_identifierForInitialRequest_fromDataSource_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_willSendRequest_redirectResponse_fromDataSource_, n3, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_createWebViewWithRequest_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webViewShow_, n7, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webViewClose_, n7, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_contextMenuItemsForElement_defaultMenuItems_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_setStatusBarVisible_, n6, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setResizable_, n6, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setToolbarsVisible_, n6, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setStatusText_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webViewFocus_, n7, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webViewUnfocus_, n7, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptAlertPanelWithMessage_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptConfirmPanelWithMessage_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runOpenPanelForFileButtonWithResultListener_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_mouseDidMoveOverElement_modifierFlags_, n5, "@:@@I");
            OS.class_addMethod(delegateClass, OS.sel_webView_printFrameView_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForMIMEType_request_frame_decisionListener_, n3, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForNavigationAction_request_frame_decisionListener_, n3, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener_, n3, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_unableToImplementPolicyWithError_frame_, n5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_download_decideDestinationWithSuggestedFilename_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_handleEvent_, n7, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_setFrame_, n2, "@:@{NSRect}");
            OS.class_addMethod(delegateClass, OS.sel_webView_windowScriptObjectAvailable_, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_callJava, n4, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_callRunBeforeUnloadConfirmPanelWithMessage, n6, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_createPanelDidEnd, n5, "@:@@@");
            OS.objc_registerClassPair(delegateClass);
            int n10 = OS.objc_getMetaClass(string);
            OS.class_addMethod(n10, OS.sel_isSelectorExcludedFromWebScript_, n7, "@:@");
            OS.class_addMethod(n10, OS.sel_webScriptNameForSelector_, n7, "@:@");
        }
        this.browser.setData(WEBKIT_EVENTS_FIX_KEY);
        clazz = (WebView)new WebView().alloc();
        if (clazz == null) {
            SWT.error(2);
        }
        ((WebView)((Object)clazz)).initWithFrame(this.browser.view.frame(), null, null);
        ((NSView)((Object)clazz)).setAutoresizingMask(18);
        if (((NSObject)((Object)clazz)).respondsToSelector(OS.sel__setDashboardBehavior)) {
            OS.objc_msgSend(((WebView)((Object)clazz)).id, OS.sel__setDashboardBehavior, 2, 1);
        }
        final SWTWebViewDelegate sWTWebViewDelegate = (SWTWebViewDelegate)new SWTWebViewDelegate().alloc().init();
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{sWTWebViewDelegate, this.browser});
        this.delegate = sWTWebViewDelegate;
        this.webView = clazz;
        this.browser.view.addSubview((NSView)((Object)clazz));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: {
                        WebKit.this.webView.window().makeFirstResponder(WebKit.this.webView);
                        break;
                    }
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        if (!WebKit.this.browser.isDisposed()) {
                            if (!WebKit.this.browser.isClosing) {
                                WebKit.this.close(false);
                            }
                            event.display.setData(WebKit.ADD_WIDGET_KEY, new Object[]{sWTWebViewDelegate, null});
                        }
                        WebKit.this.webView.setFrameLoadDelegate(null);
                        WebKit.this.webView.setResourceLoadDelegate(null);
                        WebKit.this.webView.setUIDelegate(null);
                        WebKit.this.webView.setPolicyDelegate(null);
                        WebKit.this.webView.setDownloadDelegate(null);
                        WebKit.this.webView.release();
                        WebKit.this.webView = null;
                        WebKit.this.delegate.release();
                        WebKit.this.delegate = null;
                        WebKit.this.html = null;
                        WebKit.this.lastNavigateURL = null;
                        WebKit.this.lastHoveredLinkURL = null;
                        Enumeration enumeration = WebKit.this.functions.elements();
                        while (enumeration.hasMoreElements()) {
                            ((BrowserFunction)enumeration.nextElement()).dispose(false);
                        }
                        WebKit.this.functions = null;
                        if (WebKit.this.preferences != null) {
                            WebKit.this.preferences.release();
                        }
                        WebKit.this.preferences = null;
                        break;
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(15, listener);
        ((WebView)((Object)clazz)).setFrameLoadDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setResourceLoadDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setUIDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setPolicyDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setDownloadDelegate(sWTWebViewDelegate);
        ((WebView)((Object)clazz)).setApplicationNameForUserAgent(NSString.stringWith(AGENT_STRING));
        if (!Initialized) {
            Initialized = true;
            WebPreferences.standardPreferences().setJavaEnabled(false);
        }
    }

    public boolean back() {
        this.html = null;
        return this.webView.goBack();
    }

    static int browserProc(int n, int n2, int n3) {
        Display display;
        if (n == delegateClass) {
            if (n2 == OS.sel_isSelectorExcludedFromWebScript_) {
                return WebKit.isSelectorExcludedFromWebScript(n3) ? 1 : 0;
            }
            if (n2 == OS.sel_webScriptNameForSelector_) {
                return WebKit.webScriptNameForSelector(n3);
            }
        }
        if ((display = Display.getCurrent()) == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (n2 == OS.sel_webViewShow_) {
            webKit.webViewShow(n3);
        } else if (n2 == OS.sel_webViewClose_) {
            webKit.webViewClose(n3);
        } else if (n2 == OS.sel_webViewFocus_) {
            webKit.webViewFocus(n3);
        } else if (n2 == OS.sel_webViewUnfocus_) {
            webKit.webViewUnfocus(n3);
        } else if (n2 == OS.sel_handleEvent_) {
            webKit.handleEvent(n3);
        }
        return 0;
    }

    static int browserProc(int n, int n2, int n3, int n4) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (n2 == OS.sel_webView_didChangeLocationWithinPageForFrame_) {
            webKit.webView_didChangeLocationWithinPageForFrame(n3, n4);
        } else if (n2 == OS.sel_webView_didFinishLoadForFrame_) {
            webKit.webView_didFinishLoadForFrame(n3, n4);
        } else if (n2 == OS.sel_webView_didStartProvisionalLoadForFrame_) {
            webKit.webView_didStartProvisionalLoadForFrame(n3, n4);
        } else if (n2 == OS.sel_webView_didCommitLoadForFrame_) {
            webKit.webView_didCommitLoadForFrame(n3, n4);
        } else if (n2 == OS.sel_webView_setFrame_) {
            webKit.webView_setFrame(n3, n4);
        } else {
            if (n2 == OS.sel_webView_createWebViewWithRequest_) {
                return webKit.webView_createWebViewWithRequest(n3, n4);
            }
            if (n2 == OS.sel_webView_setStatusBarVisible_) {
                webKit.webView_setStatusBarVisible(n3, n4 != 0);
            } else if (n2 == OS.sel_webView_setResizable_) {
                webKit.webView_setResizable(n3, n4 != 0);
            } else if (n2 == OS.sel_webView_setStatusText_) {
                webKit.webView_setStatusText(n3, n4);
            } else if (n2 == OS.sel_webView_setToolbarsVisible_) {
                webKit.webView_setToolbarsVisible(n3, n4 != 0);
            } else if (n2 == OS.sel_webView_runJavaScriptAlertPanelWithMessage_) {
                webKit.webView_runJavaScriptAlertPanelWithMessage(n3, n4);
            } else {
                if (n2 == OS.sel_webView_runJavaScriptConfirmPanelWithMessage_) {
                    return webKit.webView_runJavaScriptConfirmPanelWithMessage(n3, n4);
                }
                if (n2 == OS.sel_webView_runOpenPanelForFileButtonWithResultListener_) {
                    webKit.webView_runOpenPanelForFileButtonWithResultListener(n3, n4);
                } else if (n2 == OS.sel_download_decideDestinationWithSuggestedFilename_) {
                    webKit.download_decideDestinationWithSuggestedFilename(n3, n4);
                } else if (n2 == OS.sel_webView_printFrameView_) {
                    webKit.webView_printFrameView(n3, n4);
                } else if (n2 == OS.sel_webView_windowScriptObjectAvailable_) {
                    webKit.webView_windowScriptObjectAvailable(n3, n4);
                } else if (n2 == OS.sel_callRunBeforeUnloadConfirmPanelWithMessage) {
                    return webKit.callRunBeforeUnloadConfirmPanelWithMessage((int)n3, (int)n4).id;
                }
            }
        }
        return 0;
    }

    static int browserProc(int n, int n2, int n3, int n4, int n5) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (n2 == OS.sel_webView_didFailProvisionalLoadWithError_forFrame_) {
            webKit.webView_didFailProvisionalLoadWithError_forFrame(n3, n4, n5);
        } else if (n2 == OS.sel_webView_didReceiveTitle_forFrame_) {
            webKit.webView_didReceiveTitle_forFrame(n3, n4, n5);
        } else if (n2 == OS.sel_webView_resource_didFinishLoadingFromDataSource_) {
            webKit.webView_resource_didFinishLoadingFromDataSource(n3, n4, n5);
        } else {
            if (n2 == OS.sel_webView_identifierForInitialRequest_fromDataSource_) {
                return webKit.webView_identifierForInitialRequest_fromDataSource(n3, n4, n5);
            }
            if (n2 == OS.sel_webView_contextMenuItemsForElement_defaultMenuItems_) {
                return webKit.webView_contextMenuItemsForElement_defaultMenuItems(n3, n4, n5);
            }
            if (n2 == OS.sel_webView_mouseDidMoveOverElement_modifierFlags_) {
                webKit.webView_mouseDidMoveOverElement_modifierFlags(n3, n4, n5);
            } else if (n2 == OS.sel_webView_unableToImplementPolicyWithError_frame_) {
                webKit.webView_unableToImplementPolicyWithError_frame(n3, n4, n5);
            } else {
                if (n2 == OS.sel_webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame_) {
                    return webKit.webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(n3, n4, n5) ? 1 : 0;
                }
                if (n2 == OS.sel_webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_) {
                    webKit.webView_runJavaScriptAlertPanelWithMessage(n3, n4);
                } else {
                    if (n2 == OS.sel_webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_) {
                        return webKit.webView_runJavaScriptConfirmPanelWithMessage(n3, n4);
                    }
                    if (n2 == OS.sel_createPanelDidEnd) {
                        webKit.createPanelDidEnd(n3, n4, n5);
                    }
                }
            }
        }
        return 0;
    }

    static int browserProc(int n, int n2, int n3, int n4, int n5, int n6) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (n2 == OS.sel_webView_resource_didFailLoadingWithError_fromDataSource_) {
            webKit.webView_resource_didFailLoadingWithError_fromDataSource(n3, n4, n5, n6);
        } else if (n2 == OS.sel_webView_resource_didReceiveAuthenticationChallenge_fromDataSource_) {
            webKit.webView_resource_didReceiveAuthenticationChallenge_fromDataSource(n3, n4, n5, n6);
        } else if (n2 == OS.sel_callJava) {
            NSObject nSObject = webKit.callJava(n3, n4, n5, n6);
            return nSObject == null ? 0 : nSObject.id;
        }
        return 0;
    }

    static int browserProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (n2 == OS.sel_webView_resource_willSendRequest_redirectResponse_fromDataSource_) {
            return webKit.webView_resource_willSendRequest_redirectResponse_fromDataSource(n3, n4, n5, n6, n7);
        }
        if (n2 == OS.sel_webView_decidePolicyForMIMEType_request_frame_decisionListener_) {
            webKit.webView_decidePolicyForMIMEType_request_frame_decisionListener(n3, n4, n5, n6, n7);
        } else if (n2 == OS.sel_webView_decidePolicyForNavigationAction_request_frame_decisionListener_) {
            webKit.webView_decidePolicyForNavigationAction_request_frame_decisionListener(n3, n4, n5, n6, n7);
        } else if (n2 == OS.sel_webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener_) {
            webKit.webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener(n3, n4, n5, n6, n7);
        }
        return 0;
    }

    static boolean isSelectorExcludedFromWebScript(int n) {
        return n != OS.sel_callJava && n != OS.sel_callRunBeforeUnloadConfirmPanelWithMessage;
    }

    static int webScriptNameForSelector(int n) {
        if (n == OS.sel_callJava) {
            return NSString.stringWith((String)"callJava").id;
        }
        if (n == OS.sel_callRunBeforeUnloadConfirmPanelWithMessage) {
            return NSString.stringWith((String)"callRunBeforeUnloadConfirmPanelWithMessage").id;
        }
        return 0;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        if (!this.jsEnabled) {
            return true;
        }
        String string = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer stringBuffer = new StringBuffer("function ");
        stringBuffer.append(string);
        stringBuffer.append("(win) {\n");
        stringBuffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuffer.append("if (str != null) { ");
            stringBuffer.append("var result = window.external.callRunBeforeUnloadConfirmPanelWithMessage(str);");
            stringBuffer.append("if (!result) return false;}");
        }
        stringBuffer.append("} catch (e) {}}");
        stringBuffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuffer.append(string);
        stringBuffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        Boolean bl2 = (Boolean)this.evaluate("return " + string + "(window);");
        if (bl2 == null) {
            return false;
        }
        return bl2;
    }

    public boolean execute(String string) {
        WebFrame webFrame = this.webView.mainFrame();
        int n = webFrame.globalContext();
        byte[] byArray = null;
        try {
            byArray = (string + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (string + '\u0000').getBytes();
        }
        int n2 = OS.JSStringCreateWithUTF8CString(byArray);
        try {
            byArray = (this.getUrl() + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (this.getUrl() + '\u0000').getBytes();
        }
        int n3 = OS.JSStringCreateWithUTF8CString(byArray);
        int n4 = OS.JSEvaluateScript(n, n2, 0, n3, 0, null);
        OS.JSStringRelease(n3);
        OS.JSStringRelease(n2);
        return n4 != 0;
    }

    public boolean forward() {
        this.html = null;
        return this.webView.goForward();
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        WebFrame webFrame = this.webView.mainFrame();
        WebDataSource webDataSource = webFrame.dataSource();
        if (webDataSource == null) {
            return "";
        }
        WebDocumentRepresentation webDocumentRepresentation = webDataSource.representation();
        if (webDocumentRepresentation == null) {
            return "";
        }
        NSString nSString = webDocumentRepresentation.documentSource();
        if (nSString == null) {
            return "";
        }
        return nSString.getString();
    }

    public String getUrl() {
        if (this.url.length() == 0) {
            return ABOUT_BLANK;
        }
        return this.url;
    }

    public boolean isBackEnabled() {
        return this.webView.canGoBack();
    }

    public boolean isForwardEnabled() {
        return this.webView.canGoForward();
    }

    public void refresh() {
        this.html = null;
        this.webView.reload(null);
    }

    public boolean setText(String string, boolean bl) {
        boolean bl2 = this.html != null;
        this.html = string;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        NSURL nSURL = NSURL.URLWithString(NSString.stringWith(ABOUT_BLANK));
        NSURLRequest nSURLRequest = NSURLRequest.requestWithURL(nSURL);
        WebFrame webFrame = this.webView.mainFrame();
        webFrame.loadRequest(nSURLRequest);
        return true;
    }

    public boolean setUrl(String string, String string2, String[] stringArray) {
        Object object;
        Object object2;
        this.html = null;
        this.lastNavigateURL = string;
        if (string.indexOf(47) == 0) {
            string = PROTOCOL_FILE + string;
        } else if (string.indexOf(58) == -1) {
            string = PROTOCOL_HTTP + string;
        }
        NSString nSString = NSString.stringWith(string);
        NSString nSString2 = NSString.stringWith("%#");
        int n = OS.CFURLCreateStringByAddingPercentEscapes(0, nSString.id, nSString2.id, 0, 0x8000100);
        NSString nSString3 = new NSString(n);
        NSURL nSURL = NSURL.URLWithString(nSString3);
        OS.CFRelease(n);
        NSMutableURLRequest nSMutableURLRequest = (NSMutableURLRequest)NSMutableURLRequest.requestWithURL(nSURL);
        if (string2 != null) {
            nSMutableURLRequest.setHTTPMethod(NSString.stringWith(POST));
            object2 = string2.getBytes();
            object = NSData.dataWithBytes((byte[])object2, ((Object)object2).length);
            nSMutableURLRequest.setHTTPBody((NSData)object);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                object = stringArray[i];
                if (object == null || (n2 = ((String)object).indexOf(58)) == -1) continue;
                String string3 = ((String)object).substring(0, n2).trim();
                String string4 = ((String)object).substring(n2 + 1).trim();
                if (string3.length() <= 0 || string4.length() <= 0) continue;
                if (string3.equalsIgnoreCase(USER_AGENT)) {
                    this.webView.setCustomUserAgent(NSString.stringWith(string4));
                    continue;
                }
                nSMutableURLRequest.setValue(NSString.stringWith(string4), NSString.stringWith(string3));
            }
        }
        object2 = this.webView.mainFrame();
        ((WebFrame)object2).loadRequest(nSMutableURLRequest);
        this.webView.setCustomUserAgent(null);
        return true;
    }

    public void stop() {
        this.html = null;
        this.webView.stopLoading(null);
    }

    boolean translateMnemonics() {
        return false;
    }

    void webView_didChangeLocationWithinPageForFrame(int n, int n2) {
        int n3;
        TypedEvent typedEvent;
        boolean bl;
        WebFrame webFrame = new WebFrame(n2);
        WebDataSource webDataSource = webFrame.dataSource();
        NSMutableURLRequest nSMutableURLRequest = webDataSource.request();
        NSURL nSURL = nSMutableURLRequest.URL();
        NSString nSString = nSURL.absoluteString();
        int n4 = nSString.length();
        if (n4 == 0) {
            return;
        }
        String string = nSString.getString();
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n4 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n4) == '#') {
                string = ABOUT_BLANK + string.substring(n4);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl2 = bl = n2 == this.webView.mainFrame().id;
        if (bl) {
            typedEvent = new StatusTextEvent(this.browser);
            typedEvent.display = display;
            typedEvent.widget = this.browser;
            typedEvent.text = string;
            for (n3 = 0; n3 < this.statusTextListeners.length; ++n3) {
                this.statusTextListeners[n3].changed((StatusTextEvent)typedEvent);
            }
        }
        typedEvent = new LocationEvent(this.browser);
        ((LocationEvent)typedEvent).display = display;
        ((LocationEvent)typedEvent).widget = this.browser;
        ((LocationEvent)typedEvent).location = string;
        ((LocationEvent)typedEvent).top = bl;
        for (n3 = 0; n3 < this.locationListeners.length; ++n3) {
            this.locationListeners[n3].changed((LocationEvent)typedEvent);
        }
    }

    void webView_didFailProvisionalLoadWithError_forFrame(int n, int n2, int n3) {
        Object object;
        Object object2;
        Object object3;
        id id2;
        NSError nSError;
        int n4;
        if (n3 == this.webView.mainFrame().id) {
            this.identifier = 0;
        }
        if (-1000 < (n4 = (nSError = new NSError(n2)).code())) {
            return;
        }
        NSURL nSURL = null;
        NSDictionary nSDictionary = nSError.userInfo();
        if (nSDictionary != null && (id2 = nSDictionary.valueForKey(NSString.stringWith("NSErrorFailingURLKey"))) != null) {
            nSURL = new NSURL(id2);
        }
        if (nSURL != null && -1204 <= n4 && n4 <= -1200) {
            id2 = nSDictionary.objectForKey(NSString.stringWith("NSErrorPeerCertificateChainKey"));
            object3 = new int[1];
            object2 = new int[1];
            object = new int[1];
            boolean bl = false;
            int n5 = OS.SecPolicySearchCreate(3, 0, 0, (int[])object3);
            if (n5 == 0 && object3[0] != false && (n5 = OS.SecPolicySearchCopyNext((int)object3[0], (int[])object2)) == 0 && object2[0] != false && (n5 = OS.SecTrustCreateWithCertificates(id2.id, (int)object2[0], (int[])object)) == 0 && object[0] != false) {
                SFCertificateTrustPanel sFCertificateTrustPanel = SFCertificateTrustPanel.sharedCertificateTrustPanel();
                String string = nSURL.absoluteString().getString();
                String string2 = Compatibility.getMessage("SWT_InvalidCert_Message", new Object[]{string});
                sFCertificateTrustPanel.setAlternateButtonTitle(NSString.stringWith(Compatibility.getMessage("SWT_Cancel")));
                sFCertificateTrustPanel.setShowsHelp(true);
                nSURL.retain();
                NSWindow nSWindow = this.browser.getShell().view.window();
                sFCertificateTrustPanel.beginSheetForWindow(nSWindow, this.delegate, OS.sel_createPanelDidEnd, nSURL.id, (int)object[0], NSString.stringWith(string2));
                bl = true;
            }
            if (object[0] != 0) {
                OS.CFRelease(object[0]);
            }
            if (object2[0] != false) {
                OS.CFRelease((int)object2[0]);
            }
            if (object3[0] != false) {
                OS.CFRelease((int)object3[0]);
            }
            if (bl) {
                return;
            }
        }
        if ((id2 = nSError.localizedDescription()) != null) {
            object3 = ((NSString)id2).getString();
            object2 = nSURL != null ? nSURL.absoluteString().getString() + "\n\n" : "";
            object2 = (String)object2 + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{object3});
            object = new MessageBox(this.browser.getShell(), 33);
            ((MessageBox)object).setMessage((String)object2);
            ((MessageBox)object).open();
        }
    }

    void createPanelDidEnd(int n, int n2, int n3) {
        NSURL nSURL = new NSURL(n3);
        nSURL.autorelease();
        if (n2 != 1) {
            return;
        }
        int n4 = OS.class_getClassMethod(OS.class_NSURLRequest, OS.sel_setAllowsAnyHTTPSCertificate);
        if (n4 != 0) {
            OS.objc_msgSend(OS.class_NSURLRequest, OS.sel_setAllowsAnyHTTPSCertificate, 1, nSURL.host().id);
            this.setUrl(nSURL.absoluteString().getString(), null, null);
        }
    }

    void webView_didFinishLoadForFrame(int n, int n2) {
        if (n2 == this.webView.mainFrame().id) {
            Object object;
            NSObject nSObject;
            NSObject nSObject2;
            Object object2;
            if (this.html != null && this.getUrl().startsWith(ABOUT_BLANK)) {
                this.loadingText = true;
                object2 = NSString.stringWith(this.html);
                nSObject2 = this.untrustedText ? NSString.stringWith(ABOUT_BLANK) : NSString.stringWith(URI_FILEROOT);
                nSObject = NSURL.URLWithString((NSString)nSObject2);
                object = this.webView.mainFrame();
                ((WebFrame)object).loadHTMLString((NSString)object2, (NSURL)nSObject);
                this.html = null;
            }
            if (!this.loadingText) {
                object2 = this.browser.getDisplay();
                nSObject2 = new WebFrame(n2);
                nSObject = nSObject2.dataSource();
                if (nSObject != null && (object = nSObject.pageTitle()) == null) {
                    TitleEvent titleEvent = new TitleEvent(this.browser);
                    titleEvent.display = object2;
                    titleEvent.widget = this.browser;
                    titleEvent.title = this.getUrl();
                    for (int i = 0; i < this.titleListeners.length; ++i) {
                        this.titleListeners[i].changed(titleEvent);
                    }
                    if (this.browser.isDisposed()) {
                        return;
                    }
                }
                object = new ProgressEvent(this.browser);
                ((ProgressEvent)object).display = object2;
                ((ProgressEvent)object).widget = this.browser;
                ((ProgressEvent)object).current = 100;
                ((ProgressEvent)object).total = 100;
                for (int i = 0; i < this.progressListeners.length; ++i) {
                    this.progressListeners[i].completed((ProgressEvent)object);
                }
            }
            this.loadingText = false;
            if (this.browser.isDisposed()) {
                return;
            }
            this.identifier = 0;
        }
    }

    void hookDOMKeyListeners(int n) {
        WebFrame webFrame = new WebFrame(n);
        DOMDocument dOMDocument = webFrame.DOMDocument();
        if (dOMDocument == null) {
            return;
        }
        NSString nSString = NSString.stringWith(DOMEVENT_KEYDOWN);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_KEYUP);
        dOMDocument.addEventListener(nSString, this.delegate, false);
    }

    void hookDOMMouseListeners(int n) {
        WebFrame webFrame = new WebFrame(n);
        DOMDocument dOMDocument = webFrame.DOMDocument();
        if (dOMDocument == null) {
            return;
        }
        NSString nSString = NSString.stringWith(DOMEVENT_MOUSEDOWN);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_MOUSEUP);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_MOUSEMOVE);
        dOMDocument.addEventListener(nSString, this.delegate, false);
        nSString = NSString.stringWith(DOMEVENT_MOUSEWHEEL);
        dOMDocument.addEventListener(nSString, this.delegate, false);
    }

    void webView_didReceiveTitle_forFrame(int n, int n2, int n3) {
        if (n3 == this.webView.mainFrame().id) {
            NSString nSString = new NSString(n2);
            String string = nSString.getString();
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            for (int i = 0; i < this.titleListeners.length; ++i) {
                this.titleListeners[i].changed(titleEvent);
            }
        }
    }

    void webView_didStartProvisionalLoadForFrame(int n, int n2) {
    }

    void webView_didCommitLoadForFrame(int n, int n2) {
        Object object;
        boolean bl;
        WebFrame webFrame = new WebFrame(n2);
        WebDataSource webDataSource = webFrame.dataSource();
        NSMutableURLRequest nSMutableURLRequest = webDataSource.request();
        NSURL nSURL = nSMutableURLRequest.URL();
        NSString nSString = nSURL.absoluteString();
        int n3 = nSString.length();
        if (n3 == 0) {
            return;
        }
        String string = nSString.getString();
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n3 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n3) == '#') {
                string = ABOUT_BLANK + string.substring(n3);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl2 = bl = n2 == this.webView.mainFrame().id;
        if (bl) {
            Object object2;
            this.resourceCount = 0;
            this.url = string;
            if (string.startsWith(ABOUT_BLANK) && this.html != null) {
                return;
            }
            object = this.functions.elements();
            while (object.hasMoreElements()) {
                object2 = (BrowserFunction)object.nextElement();
                this.execute(((BrowserFunction)object2).functionString);
            }
            object2 = new ProgressEvent(this.browser);
            ((ProgressEvent)object2).display = display;
            ((ProgressEvent)object2).widget = this.browser;
            ((ProgressEvent)object2).current = 1;
            ((ProgressEvent)object2).total = 100;
            for (int i = 0; i < this.progressListeners.length; ++i) {
                this.progressListeners[i].changed((ProgressEvent)object2);
            }
            if (this.browser.isDisposed()) {
                return;
            }
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = display;
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            for (int i = 0; i < this.statusTextListeners.length; ++i) {
                this.statusTextListeners[i].changed(statusTextEvent);
            }
            if (this.browser.isDisposed()) {
                return;
            }
            this.hookDOMKeyListeners(n2);
        }
        this.hookDOMMouseListeners(n2);
        object = new LocationEvent(this.browser);
        ((LocationEvent)object).display = display;
        ((LocationEvent)object).widget = this.browser;
        ((LocationEvent)object).location = string;
        ((LocationEvent)object).top = bl;
        for (int i = 0; i < this.locationListeners.length; ++i) {
            this.locationListeners[i].changed((LocationEvent)object);
        }
    }

    void webView_windowScriptObjectAvailable(int n, int n2) {
        NSObject nSObject = new NSObject(n2);
        NSString nSString = NSString.stringWith("external");
        nSObject.setValue(this.delegate, nSString);
    }

    void webView_resource_didFinishLoadingFromDataSource(int n, int n2, int n3) {
    }

    void webView_resource_didFailLoadingWithError_fromDataSource(int n, int n2, int n3, int n4) {
    }

    void webView_resource_didReceiveAuthenticationChallenge_fromDataSource(int n, int n2, int n3, int n4) {
        String string;
        NSURLProtectionSpace nSURLProtectionSpace;
        String string2;
        boolean bl;
        int n5;
        int n6;
        int n7;
        NSURLAuthenticationChallenge nSURLAuthenticationChallenge = new NSURLAuthenticationChallenge(n3);
        if (nSURLAuthenticationChallenge.previousFailureCount() < 3) {
            for (n7 = 0; n7 < this.authenticationListeners.length; ++n7) {
                AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
                authenticationEvent.location = this.lastNavigateURL;
                this.authenticationListeners[n7].authenticate(authenticationEvent);
                if (!authenticationEvent.doit) {
                    id id2 = nSURLAuthenticationChallenge.sender();
                    OS.objc_msgSend(id2.id, OS.sel_cancelAuthenticationChallenge_, n3);
                    return;
                }
                if (authenticationEvent.user == null || authenticationEvent.password == null) continue;
                id id3 = nSURLAuthenticationChallenge.sender();
                NSString nSString = NSString.stringWith(authenticationEvent.user);
                NSString nSString2 = NSString.stringWith(authenticationEvent.password);
                NSURLCredential nSURLCredential = NSURLCredential.credentialWithUser(nSString, nSString2, 1);
                OS.objc_msgSend(id3.id, OS.sel_useCredential_forAuthenticationChallenge_, nSURLCredential.id, n3);
                return;
            }
        }
        if ((n7 = OS.class_WebPanelAuthenticationHandler) != 0 && (n6 = OS.class_getClassMethod(n7, OS.sel_sharedHandler)) != 0 && (n5 = OS.objc_msgSend(n7, OS.sel_sharedHandler)) != 0) {
            OS.objc_msgSend(n5, OS.sel_startAuthentication, n3, this.webView.window().id);
            return;
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        NSURLCredential nSURLCredential = nSURLAuthenticationChallenge.proposedCredential();
        if (nSURLCredential != null) {
            stringArray[0] = nSURLCredential.user().getString();
            if (nSURLCredential.hasPassword()) {
                stringArray2[0] = nSURLCredential.password().getString();
            }
        }
        if (!(bl = this.showAuthenticationDialog(stringArray, stringArray2, string2 = (nSURLProtectionSpace = nSURLAuthenticationChallenge.protectionSpace()).host().getString() + ':' + nSURLProtectionSpace.port(), string = nSURLProtectionSpace.realm().getString()))) {
            id id4 = nSURLAuthenticationChallenge.sender();
            OS.objc_msgSend(id4.id, OS.sel_cancelAuthenticationChallenge_, n3);
            return;
        }
        id id5 = nSURLAuthenticationChallenge.sender();
        NSString nSString = NSString.stringWith(stringArray[0]);
        NSString nSString3 = NSString.stringWith(stringArray2[0]);
        NSURLCredential nSURLCredential2 = NSURLCredential.credentialWithUser(nSString, nSString3, 1);
        OS.objc_msgSend(id5.id, OS.sel_useCredential_forAuthenticationChallenge_, nSURLCredential2.id, n3);
    }

    boolean showAuthenticationDialog(final String[] stringArray, final String[] stringArray2, String string, String string2) {
        final Shell shell = new Shell(this.browser.getShell());
        shell.setLayout(new GridLayout());
        String string3 = SWT.getMessage("SWT_Authentication_Required");
        shell.setText(string3);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{string2, string}));
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n2, n);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        Label label2 = new Label(shell, 0);
        label2.setText(SWT.getMessage("SWT_Username"));
        final Text text = new Text(shell, 2048);
        if (stringArray[0] != null) {
            text.setText(stringArray[0]);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData(gridData);
        Label label3 = new Label(shell, 0);
        label3.setText(SWT.getMessage("SWT_Password"));
        final Text text2 = new Text(shell, 0x400800);
        if (stringArray2[0] != null) {
            text2.setText(stringArray2[0]);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text2.setLayoutData(gridData);
        final boolean[] blArray = new boolean[1];
        final Button[] buttonArray = new Button[2];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                stringArray[0] = text.getText();
                stringArray2[0] = text2.getText();
                blArray[0] = event.widget == buttonArray[1];
                shell.close();
            }
        };
        Composite composite = new Composite(shell, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(2, true));
        buttonArray[0] = new Button(composite, 8);
        buttonArray[0].setText(SWT.getMessage("SWT_Cancel"));
        buttonArray[0].setLayoutData(new GridData(768));
        buttonArray[0].addListener(13, listener);
        buttonArray[1] = new Button(composite, 8);
        buttonArray[1].setText(SWT.getMessage("SWT_OK"));
        buttonArray[1].setLayoutData(new GridData(768));
        buttonArray[1].addListener(13, listener);
        shell.setDefaultButton(buttonArray[1]);
        shell.pack();
        shell.open();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return blArray[0];
    }

    int webView_identifierForInitialRequest_fromDataSource(int n, int n2, int n3) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        progressEvent.current = this.resourceCount;
        progressEvent.total = Math.max(this.resourceCount, 100);
        for (int i = 0; i < this.progressListeners.length; ++i) {
            this.progressListeners[i].changed(progressEvent);
        }
        if (this.browser.isDisposed()) {
            return 0;
        }
        NSNumber nSNumber = NSNumber.numberWithInt(this.resourceCount++);
        if (this.identifier == 0) {
            WebDataSource webDataSource = new WebDataSource(n3);
            WebFrame webFrame = webDataSource.webFrame();
            if (webFrame.id == this.webView.mainFrame().id) {
                this.identifier = nSNumber.id;
            }
        }
        return nSNumber.id;
    }

    int webView_resource_willSendRequest_redirectResponse_fromDataSource(int n, int n2, int n3, int n4, int n5) {
        NSURLRequest nSURLRequest = new NSURLRequest(n3);
        NSURL nSURL = nSURLRequest.URL();
        if (nSURL.isFileURL()) {
            NSMutableURLRequest nSMutableURLRequest = new NSMutableURLRequest(nSURLRequest.mutableCopy());
            nSMutableURLRequest.autorelease();
            nSMutableURLRequest.setCachePolicy(1);
            return nSMutableURLRequest.id;
        }
        return n3;
    }

    int webView_createWebViewWithRequest(int n, int n2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            for (int i = 0; i < this.openWindowListeners.length; ++i) {
                this.openWindowListeners[i].open(windowEvent);
            }
        }
        WebView webView = null;
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            webView = ((WebKit)((Browser)widget).webBrowser).webView;
            if (n2 != 0) {
                WebFrame webFrame = webView.mainFrame();
                webFrame.loadRequest(new NSURLRequest(n2));
            }
        }
        return webView != null ? webView.id : 0;
    }

    void webViewShow(int n) {
        Shell shell = this.browser.getShell();
        Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = true;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        for (int i = 0; i < this.visibilityWindowListeners.length; ++i) {
            this.visibilityWindowListeners[i].show(windowEvent);
        }
        this.location = null;
        this.size = null;
    }

    void webView_setFrame(int n, int n2) {
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, n2, NSRect.sizeof);
        Rectangle rectangle = this.browser.getDisplay().getBounds();
        this.location = new Point((int)nSRect.x, rectangle.height - (int)nSRect.y - (int)nSRect.height);
        this.size = new Point((int)nSRect.width, (int)nSRect.height);
    }

    void webViewFocus(int n) {
    }

    void webViewUnfocus(int n) {
    }

    NSNumber callRunBeforeUnloadConfirmPanelWithMessage(int n, int n2) {
        boolean bl = this.webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(0, n, 0);
        return NSNumber.numberWithBool(bl);
    }

    boolean webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(int n, int n2, int n3) {
        NSString nSString = new NSString(n2);
        StringBuffer stringBuffer = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        stringBuffer.append("\n\n");
        stringBuffer.append(nSString.getString());
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 268435748);
        messageBox.setMessage(stringBuffer.toString());
        return messageBox.open() == 32;
    }

    void webView_runJavaScriptAlertPanelWithMessage(int n, int n2) {
        NSString nSString = new NSString(n2);
        String string = nSString.getString();
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        messageBox.open();
    }

    int webView_runJavaScriptConfirmPanelWithMessage(int n, int n2) {
        NSString nSString = new NSString(n2);
        String string = nSString.getString();
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void webView_runOpenPanelForFileButtonWithResultListener(int n, int n2) {
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 0);
        String string = fileDialog.open();
        WebOpenPanelResultListener webOpenPanelResultListener = new WebOpenPanelResultListener(n2);
        if (string == null) {
            webOpenPanelResultListener.cancel();
            return;
        }
        webOpenPanelResultListener.chooseFilename(NSString.stringWith(string));
    }

    void webViewClose(int n) {
        Shell shell = this.browser.getShell();
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        for (int i = 0; i < this.closeWindowListeners.length; ++i) {
            this.closeWindowListeners[i].close(windowEvent);
        }
        this.browser.dispose();
        if (shell.isDisposed()) {
            return;
        }
        Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
    }

    int webView_contextMenuItemsForElement_defaultMenuItems(int n, int n2, int n3) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        Menu menu = this.browser.getMenu();
        if (!event.doit) {
            return 0;
        }
        if (menu != null && !menu.isDisposed()) {
            if (event.x != point.x || event.y != point.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return n3;
    }

    void webView_setStatusBarVisible(int n, boolean bl) {
        this.statusBar = bl;
    }

    void webView_setStatusText(int n, int n2) {
        NSString nSString = new NSString(n2);
        int n3 = nSString.length();
        if (n3 == 0) {
            return;
        }
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = nSString.getString();
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            this.statusTextListeners[i].changed(statusTextEvent);
        }
    }

    void webView_setResizable(int n, boolean bl) {
    }

    void webView_setToolbarsVisible(int n, boolean bl) {
        this.toolBar = bl;
    }

    void webView_mouseDidMoveOverElement_modifierFlags(int n, int n2, int n3) {
        if (n2 == 0) {
            return;
        }
        NSDictionary nSDictionary = new NSDictionary(n2);
        NSString nSString = NSString.stringWith(WebElementLinkURLKey);
        id id2 = nSDictionary.valueForKey(nSString);
        if (id2 == null) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            for (int i = 0; i < this.statusTextListeners.length; ++i) {
                this.statusTextListeners[i].changed(statusTextEvent);
            }
            return;
        }
        NSString nSString2 = new NSURL(id2.id).absoluteString();
        int n4 = nSString2.length();
        String string = n4 == 0 ? "" : nSString2.getString();
        if (string.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = string;
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = string;
        for (int i = 0; i < this.statusTextListeners.length; ++i) {
            this.statusTextListeners[i].changed(statusTextEvent);
        }
    }

    void webView_printFrameView(int n, int n2) {
        WebFrameView webFrameView = new WebFrameView(n2);
        boolean bl = webFrameView.documentViewShouldHandlePrint();
        if (bl) {
            webFrameView.printDocumentView();
            return;
        }
        NSPrintInfo nSPrintInfo = NSPrintInfo.sharedPrintInfo();
        NSPrintOperation nSPrintOperation = webFrameView.printOperationWithPrintInfo(nSPrintInfo);
        if (nSPrintOperation != null) {
            nSPrintOperation.runOperation();
        }
    }

    void webView_decidePolicyForMIMEType_request_frame_decisionListener(int n, int n2, int n3, int n4, int n5) {
        boolean bl = WebView.canShowMIMEType(new NSString(n2));
        WebPolicyDecisionListener webPolicyDecisionListener = new WebPolicyDecisionListener(n5);
        if (bl) {
            webPolicyDecisionListener.use();
        } else {
            webPolicyDecisionListener.download();
        }
    }

    void webView_decidePolicyForNavigationAction_request_frame_decisionListener(int n, int n2, int n3, int n4, int n5) {
        NSURL nSURL = new NSURLRequest(n3).URL();
        WebPolicyDecisionListener webPolicyDecisionListener = new WebPolicyDecisionListener(n5);
        if (this.loadingText) {
            webPolicyDecisionListener.use();
            return;
        }
        if (nSURL == null) {
            webPolicyDecisionListener.ignore();
            return;
        }
        if (nSURL.isFileURL() && this.getUrl().startsWith(ABOUT_BLANK) && this.untrustedText) {
            webPolicyDecisionListener.ignore();
            return;
        }
        NSString nSString = nSURL.absoluteString();
        String string = nSString.getString();
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            int n6 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n6) == '#') {
                string = ABOUT_BLANK + string.substring(n6);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = string;
        locationEvent.doit = true;
        if (this.locationListeners != null) {
            for (int i = 0; i < this.locationListeners.length; ++i) {
                this.locationListeners[i].changing(locationEvent);
            }
        }
        if (locationEvent.doit) {
            if (this.jsEnabled != this.jsEnabledOnNextPage) {
                this.jsEnabled = this.jsEnabledOnNextPage;
                if (this.preferences == null) {
                    this.preferences = (WebPreferences)new WebPreferences().alloc().init();
                    this.webView.setPreferences(this.preferences);
                }
                this.preferences.setJavaScriptEnabled(this.jsEnabled);
            }
            webPolicyDecisionListener.use();
            this.lastNavigateURL = string;
        } else {
            webPolicyDecisionListener.ignore();
        }
    }

    void webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener(int n, int n2, int n3, int n4, int n5) {
        WebPolicyDecisionListener webPolicyDecisionListener = new WebPolicyDecisionListener(n5);
        webPolicyDecisionListener.use();
    }

    void webView_unableToImplementPolicyWithError_frame(int n, int n2, int n3) {
    }

    void download_decideDestinationWithSuggestedFilename(int n, int n2) {
        NSString nSString = new NSString(n2);
        String string = nSString.getString();
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
        fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        NSURLDownload nSURLDownload = new NSURLDownload(n);
        if (string2 == null) {
            nSURLDownload.cancel();
            return;
        }
        nSURLDownload.setDestination(NSString.stringWith(string2), true);
    }

    void handleEvent(int n) {
        NSString nSString = new NSString(OS.objc_msgSend(n, OS.sel_type));
        String string = nSString.getString();
        if (DOMEVENT_KEYDOWN.equals(string) || DOMEVENT_KEYUP.equals(string)) {
            int n2;
            int n3;
            int n4;
            DOMKeyboardEvent dOMKeyboardEvent = new DOMKeyboardEvent(n);
            boolean bl = dOMKeyboardEvent.ctrlKey();
            boolean bl2 = dOMKeyboardEvent.shiftKey();
            boolean bl3 = dOMKeyboardEvent.altKey();
            boolean bl4 = dOMKeyboardEvent.metaKey();
            int n5 = dOMKeyboardEvent.keyCode();
            int n6 = dOMKeyboardEvent.charCode();
            Event event = new Event();
            event.widget = this.browser;
            event.type = n4 = DOMEVENT_KEYDOWN.equals(string) ? 1 : 2;
            event.keyCode = n3 = this.translateKey(n5);
            event.character = (char)n6;
            event.stateMask = n2 = (bl3 ? 65536 : 0) | (bl ? 262144 : 0) | (bl2 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
            boolean bl5 = true;
            if (event.type == 1) {
                bl5 = this.sendKeyEvent(event);
            } else {
                this.browser.notifyListeners(event.type, event);
                bl5 = event.doit;
            }
            if (!bl5) {
                dOMKeyboardEvent.preventDefault();
            } else if (n4 == 1 && n2 == 0x400000) {
                if (n3 == 118) {
                    this.webView.paste(this.webView);
                    dOMKeyboardEvent.preventDefault();
                } else if (n3 == 99) {
                    this.webView.copy(this.webView);
                    dOMKeyboardEvent.preventDefault();
                } else if (n3 == 120) {
                    this.webView.cut(this.webView);
                    dOMKeyboardEvent.preventDefault();
                }
            }
            return;
        }
        if (DOMEVENT_MOUSEWHEEL.equals(string)) {
            DOMWheelEvent dOMWheelEvent = new DOMWheelEvent(n);
            int n7 = dOMWheelEvent.screenX();
            int n8 = dOMWheelEvent.screenY();
            Point point = new Point(n7, n8);
            point = this.browser.getDisplay().map(null, (Control)this.browser, point);
            int n9 = dOMWheelEvent.wheelDelta();
            boolean bl = dOMWheelEvent.ctrlKey();
            boolean bl6 = dOMWheelEvent.shiftKey();
            boolean bl7 = dOMWheelEvent.altKey();
            boolean bl8 = dOMWheelEvent.metaKey();
            Event event = new Event();
            event.type = 37;
            event.widget = this.browser;
            event.x = point.x;
            event.y = point.y;
            event.count = n9 / 120;
            event.stateMask = (bl7 ? 65536 : 0) | (bl ? 262144 : 0) | (bl6 ? 131072 : 0) | (bl8 ? 0x400000 : 0);
            this.browser.notifyListeners(event.type, event);
            return;
        }
        DOMMouseEvent dOMMouseEvent = new DOMMouseEvent(n);
        int n10 = dOMMouseEvent.screenX();
        int n11 = dOMMouseEvent.screenY();
        Point point = new Point(n10, n11);
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        int n12 = dOMMouseEvent.detail();
        short s = dOMMouseEvent.button();
        boolean bl = dOMMouseEvent.ctrlKey();
        boolean bl9 = dOMMouseEvent.shiftKey();
        boolean bl10 = dOMMouseEvent.altKey();
        boolean bl11 = dOMMouseEvent.metaKey();
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = (bl10 ? 65536 : 0) | (bl ? 262144 : 0) | (bl9 ? 131072 : 0) | (bl11 ? 0x400000 : 0);
        if (DOMEVENT_MOUSEDOWN.equals(string)) {
            event.type = 3;
            event.button = s + 1;
            event.count = n12;
        } else if (DOMEVENT_MOUSEUP.equals(string)) {
            event.type = 4;
            event.button = s + 1;
            event.count = n12;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        } else if (DOMEVENT_MOUSEMOVE.equals(string)) {
            if (event.x == this.lastMouseMoveX && event.y == this.lastMouseMoveY) {
                return;
            }
            event.type = 5;
            this.lastMouseMoveX = event.x;
            this.lastMouseMoveY = event.y;
        }
        this.browser.notifyListeners(event.type, event);
        if (n12 == 2 && DOMEVENT_MOUSEDOWN.equals(string)) {
            event = new Event();
            event.widget = this.browser;
            event.x = point.x;
            event.y = point.y;
            event.stateMask = (bl10 ? 65536 : 0) | (bl ? 262144 : 0) | (bl9 ? 131072 : 0) | (bl11 ? 0x400000 : 0);
            event.type = 8;
            event.button = s + 1;
            event.count = n12;
            this.browser.notifyListeners(event.type, event);
        }
    }

    Object convertToJava(int n) {
        NSObject nSObject;
        NSObject nSObject2 = new NSObject(n);
        int n2 = OS.objc_lookUpClass("NSString");
        if (nSObject2.isKindOfClass(n2)) {
            NSString nSString = new NSString(n);
            return nSString.getString();
        }
        n2 = OS.objc_lookUpClass("NSNumber");
        if (nSObject2.isKindOfClass(n2)) {
            nSObject = new NSNumber(n);
            int n3 = ((NSValue)nSObject).objCType();
            byte[] byArray = new byte[1];
            OS.memmove(byArray, n3, 1);
            if (byArray[0] == 99 || byArray[0] == 66) {
                return new Boolean(((NSNumber)nSObject).boolValue());
            }
            if ("islqISLQfd".indexOf(byArray[0]) != -1) {
                return new Double(((NSNumber)nSObject).doubleValue());
            }
        }
        if (nSObject2.isKindOfClass(n2 = OS.objc_lookUpClass("WebScriptObject"))) {
            nSObject = new WebScriptObject(n);
            id id2 = nSObject.valueForKey(NSString.stringWith("length"));
            if (id2 == null) {
                SWT.error(5);
            }
            int n4 = new NSNumber(id2).intValue();
            Object[] objectArray = new Object[n4];
            for (int i = 0; i < n4; ++i) {
                id id3 = ((WebScriptObject)nSObject).webScriptValueAtIndex(i);
                if (id3 == null) continue;
                objectArray[i] = this.convertToJava(id3.id);
            }
            return objectArray;
        }
        n2 = OS.objc_lookUpClass("WebUndefined");
        if (nSObject2.isKindOfClass(n2)) {
            return null;
        }
        SWT.error(5);
        return null;
    }

    NSObject convertToJS(Object object) {
        if (object == null) {
            int n = OS.objc_msgSend(OS.class_NSNull, OS.sel_null);
            return n != 0 ? new NSObject(n) : null;
        }
        if (object instanceof String) {
            return NSString.stringWith((String)object);
        }
        if (object instanceof Boolean) {
            return NSNumber.numberWithBool((Boolean)object);
        }
        if (object instanceof Number) {
            return NSNumber.numberWithDouble(((Number)object).doubleValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(n);
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray[i];
                nSMutableArray.addObject(this.convertToJS(object2));
            }
            return nSMutableArray;
        }
        SWT.error(51);
        return null;
    }

    NSObject callJava(int n, int n2, int n3, int n4) {
        Object object = null;
        NSObject nSObject = new NSObject(n);
        int n5 = OS.objc_lookUpClass("NSNumber");
        if (nSObject.isKindOfClass(n5)) {
            NSNumber nSNumber = new NSNumber(n);
            Integer n6 = new Integer(nSNumber.intValue());
            nSObject = new NSObject(n2);
            n5 = OS.objc_lookUpClass("NSString");
            if (nSObject.isKindOfClass(n5)) {
                NSString nSString = new NSString(n2);
                BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n6);
                if (browserFunction != null && nSString.getString().equals(browserFunction.token)) {
                    try {
                        Object object2 = this.convertToJava(n3);
                        if (object2 instanceof Object[]) {
                            Object[] objectArray = (Object[])object2;
                            try {
                                object = browserFunction.function(objectArray);
                            }
                            catch (Exception exception) {
                                object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (browserFunction.isEvaluate) {
                            browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                        }
                        object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                    }
                }
            }
        }
        try {
            return this.convertToJS(object);
        }
        catch (SWTException sWTException) {
            return this.convertToJS(WebBrowser.CreateErrorString(sWTException.getLocalizedMessage()));
        }
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        NativeClearSessions = new Runnable(){

            public void run() {
                NSHTTPCookieStorage nSHTTPCookieStorage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
                NSArray nSArray = nSHTTPCookieStorage.cookies();
                int n = nSArray.count();
                for (int i = 0; i < n; ++i) {
                    NSHTTPCookie nSHTTPCookie = new NSHTTPCookie(nSArray.objectAtIndex(i));
                    if (!nSHTTPCookie.isSessionOnly()) continue;
                    nSHTTPCookieStorage.deleteCookie(nSHTTPCookie);
                }
            }
        };
        NativeGetCookie = new Runnable(){

            public void run() {
                NSURL nSURL;
                NSHTTPCookieStorage nSHTTPCookieStorage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
                NSArray nSArray = nSHTTPCookieStorage.cookiesForURL(nSURL = NSURL.URLWithString(NSString.stringWith(WebBrowser.CookieUrl)));
                int n = nSArray.count();
                if (n == 0) {
                    return;
                }
                NSString nSString = NSString.stringWith(WebBrowser.CookieName);
                for (int i = 0; i < n; ++i) {
                    NSHTTPCookie nSHTTPCookie = new NSHTTPCookie(nSArray.objectAtIndex(i));
                    if (nSHTTPCookie.name().compare(nSString) != 0) continue;
                    WebBrowser.CookieValue = nSHTTPCookie.value().getString();
                    return;
                }
            }
        };
        NativeSetCookie = new Runnable(){

            public void run() {
                NSURL nSURL = NSURL.URLWithString(NSString.stringWith(WebBrowser.CookieUrl));
                NSMutableDictionary nSMutableDictionary = NSMutableDictionary.dictionaryWithCapacity(1);
                nSMutableDictionary.setValue(NSString.stringWith(WebBrowser.CookieValue), NSString.stringWith(WebKit.HEADER_SETCOOKIE));
                NSArray nSArray = NSHTTPCookie.cookiesWithResponseHeaderFields(nSMutableDictionary, nSURL);
                if (nSArray.count() == 0) {
                    return;
                }
                NSHTTPCookieStorage nSHTTPCookieStorage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
                NSHTTPCookie nSHTTPCookie = new NSHTTPCookie(nSArray.objectAtIndex(0));
                nSHTTPCookieStorage.setCookie(nSHTTPCookie);
                WebBrowser.CookieResult = true;
            }
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
        }
        NativePendingCookies = null;
    }
}

