/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;

public class PlatformUtil {
    private static final String os;
    private static final String version;
    private static final boolean embedded;
    private static final String embeddedType;
    private static final boolean useEGL;
    private static final boolean doEGLCompositing;
    private static String javafxPlatform;
    private static final boolean ANDROID;
    private static final boolean WINDOWS;
    private static final boolean WINDOWS_VISTA_OR_LATER;
    private static final boolean WINDOWS_7_OR_LATER;
    private static final boolean MAC;
    private static final boolean LINUX;
    private static final boolean SOLARIS;
    private static final boolean IOS;
    private static final boolean STATIC_BUILD;

    private static boolean versionNumberGreaterThanOrEqualTo(float f2) {
        try {
            return Float.parseFloat(version) >= f2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean isWinVistaOrLater() {
        return WINDOWS_VISTA_OR_LATER;
    }

    public static boolean isWin7OrLater() {
        return WINDOWS_7_OR_LATER;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    public static boolean useEGL() {
        return useEGL;
    }

    public static boolean useEGLWindowComposition() {
        return doEGLCompositing;
    }

    public static boolean useGLES2() {
        String string2 = AccessController.doPrivileged(() -> System.getProperty("use.gles2"));
        return "true".equals(string2);
    }

    public static boolean isSolaris() {
        return SOLARIS;
    }

    public static boolean isUnix() {
        return LINUX || SOLARIS;
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static String getEmbeddedType() {
        return embeddedType;
    }

    public static boolean isIOS() {
        return IOS;
    }

    public static boolean isStaticBuild() {
        return STATIC_BUILD;
    }

    private static void loadPropertiesFromFile(File file) {
        Object object;
        Properties properties2 = new Properties();
        try {
            object = new FileInputStream(file);
            properties2.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (javafxPlatform == null) {
            javafxPlatform = properties2.getProperty("javafx.platform");
        }
        object = javafxPlatform + ".";
        int n2 = ((String)object).length();
        boolean bl = false;
        for (Object object2 : properties2.keySet()) {
            String string2 = (String)object2;
            if (!string2.startsWith((String)object)) continue;
            bl = true;
            String string3 = string2.substring(n2);
            if (System.getProperty(string3) != null) continue;
            String string4 = properties2.getProperty(string2);
            System.setProperty(string3, string4);
        }
        if (!bl) {
            System.err.println("Warning: No settings found for javafx.platform='" + javafxPlatform + "'");
        }
    }

    private static File getRTDir() {
        try {
            String string2 = "PlatformUtil.class";
            Class<PlatformUtil> clazz = PlatformUtil.class;
            URL uRL = clazz.getResource(string2);
            if (uRL == null) {
                return null;
            }
            String string3 = uRL.toString();
            if (!string3.startsWith("jar:file:") || string3.indexOf(33) == -1) {
                return null;
            }
            String string4 = string3.substring(4, string3.lastIndexOf(33));
            int n2 = Math.max(string4.lastIndexOf(47), string4.lastIndexOf(92));
            return new File(new URL(string4.substring(0, n2 + 1)).getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static void loadProperties() {
        String string2 = System.getProperty("java.vm.name");
        String string3 = System.getProperty("os.arch");
        if (!(javafxPlatform != null || string3 != null && string3.equals("arm") || string2 != null && string2.indexOf("Embedded") > 0)) {
            return;
        }
        AccessController.doPrivileged(() -> {
            File file = PlatformUtil.getRTDir();
            String string2 = "javafx.platform.properties";
            File file2 = new File(file, "javafx.platform.properties");
            if (file2.exists()) {
                PlatformUtil.loadPropertiesFromFile(file2);
                return null;
            }
            String string3 = System.getProperty("java.home");
            File file3 = new File(string3, "lib" + File.separator + "javafx.platform.properties");
            if (file3.exists()) {
                PlatformUtil.loadPropertiesFromFile(file3);
                return null;
            }
            String string4 = System.getProperty("javafx.runtime.path");
            File file4 = new File(string4, File.separator + "javafx.platform.properties");
            if (file4.exists()) {
                PlatformUtil.loadPropertiesFromFile(file4);
                return null;
            }
            return null;
        });
    }

    public static boolean isAndroid() {
        return ANDROID;
    }

    static {
        boolean bl;
        boolean bl2;
        String string2;
        boolean bl3;
        String string3;
        os = System.getProperty("os.name");
        version = System.getProperty("os.version");
        javafxPlatform = string3 = AccessController.doPrivileged(() -> System.getProperty("javafx.platform"));
        PlatformUtil.loadProperties();
        embedded = bl3 = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.isEmbedded")).booleanValue();
        embeddedType = string2 = AccessController.doPrivileged(() -> System.getProperty("embedded"));
        useEGL = bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("use.egl")).booleanValue();
        doEGLCompositing = useEGL ? (bl = AccessController.doPrivileged(() -> Boolean.getBoolean("doNativeComposite")).booleanValue()) : false;
        ANDROID = "android".equals(javafxPlatform) || "Dalvik".equals(System.getProperty("java.vm.name"));
        WINDOWS = os.startsWith("Windows");
        WINDOWS_VISTA_OR_LATER = WINDOWS && PlatformUtil.versionNumberGreaterThanOrEqualTo(6.0f);
        WINDOWS_7_OR_LATER = WINDOWS && PlatformUtil.versionNumberGreaterThanOrEqualTo(6.1f);
        MAC = os.startsWith("Mac");
        LINUX = os.startsWith("Linux") && !ANDROID;
        SOLARIS = os.startsWith("SunOS");
        IOS = os.startsWith("iOS");
        STATIC_BUILD = "Substrate VM".equals(System.getProperty("java.vm.name"));
    }
}

