/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.histo.datasources.DirectoryScanner;
import gde.histo.datasources.HistoSet;
import gde.histo.recordings.TrailDataTags;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.ui.AbstractChartWindow;
import gde.histo.ui.HistoGraphicsWindow;
import gde.histo.ui.HistoSummaryWindow;
import gde.histo.ui.HistoTableWindow;
import gde.histo.ui.VolatileStatusMessage;
import gde.histo.ui.datasources.SupplementObjectFolder;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class HistoExplorer {
    static final String $CLASS_NAME = HistoExplorer.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int VOLATILE_STATUS_CYCLES = 3;
    private final DataExplorer application = DataExplorer.getInstance();
    private final Settings settings = Settings.getInstance();
    private final CTabFolder displayTab;
    private final HistoSet histoSet;
    private VolatileStatusMessage volatileStatusMessage = null;
    private List<AbstractChartWindow> chartTabItems = new ArrayList<AbstractChartWindow>();
    private List<HistoTableWindow> tableTabItems = new ArrayList<HistoTableWindow>();

    public HistoExplorer(CTabFolder displayTab) {
        this.displayTab = displayTab;
        this.settings.setHistoActive(true);
        this.histoSet = new HistoSet();
    }

    public void initHisto() {
        SupplementObjectFolder.checkAndCreate();
        SupplementObjectFolder.updateLogMirror();
        int tabLength = this.displayTab.getItems().length;
        int positionS = tabLength < 7 ? tabLength : 7;
        this.chartTabItems.add(HistoSummaryWindow.create(this.displayTab, 0, positionS));
        int positionT = tabLength < 8 ? tabLength : 8;
        this.tableTabItems.add(HistoTableWindow.create(this.displayTab, 0, positionT));
        if (Analyzer.getInstance().getActiveChannel() != null) {
            this.updateHistoTabs(HistoSet.RebuildStep.A_HISTOSET);
        }
    }

    public void disposeHisto() {
        for (AbstractChartWindow chartWindow : this.chartTabItems) {
            chartWindow.dispose();
        }
        this.chartTabItems.clear();
        for (HistoTableWindow tableWindow : this.tableTabItems) {
            tableWindow.dispose();
        }
        this.tableTabItems.clear();
        this.cleanup();
    }

    public synchronized void resetHisto() {
        DirectoryScanner.closeWatchDir();
        SupplementObjectFolder.checkAndCreate();
        SupplementObjectFolder.updateLogMirror();
        for (AbstractChartWindow c : this.chartTabItems) {
            this.resetWindowHeaderAndMeasuring(c);
        }
        this.volatileStatusMessage = null;
        this.histoSet.initialize();
        this.updateHistoTabs(HistoSet.RebuildStep.A_HISTOSET);
    }

    public boolean hasRecords() {
        TrailRecordSet activeRecordSet = this.getHistoSet().getTrailRecordSet();
        return activeRecordSet != null ? activeRecordSet.size() > 0 : false;
    }

    public synchronized void updateHistoTableWindow(final boolean forceClean) {
        if (this.displayTab != null && !(this.displayTab.getSelection() instanceof HistoTableWindow)) {
            return;
        }
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                for (HistoTableWindow c : HistoExplorer.this.tableTabItems) {
                    TrailRecordSet trailRecordSet;
                    if (forceClean || !c.isRowTextAndTrailValid() || !c.isHeaderTextValid()) {
                        c.setHeader();
                    }
                    if ((trailRecordSet = HistoExplorer.this.histoSet.getTrailRecordSet()) == null) continue;
                    int tableRowCount = trailRecordSet.getVisibleAndDisplayableRecordsForTable().size();
                    if (HistoExplorer.this.settings.isDisplayTags()) {
                        TrailDataTags dataTags = trailRecordSet.getDataTags();
                        int channelNumber = Analyzer.getInstance().getActiveChannel().getNumber();
                        dataTags.defineActiveDisplayTags(channelNumber);
                        if (dataTags.getActiveDisplayTags(channelNumber) != null) {
                            tableRowCount += dataTags.getActiveDisplayTags(channelNumber).size();
                        }
                    }
                    c.setRowCount(tableRowCount);
                }
            }
        });
    }

    public void scrollSummaryComposite() {
        if (this.isHistoChartWindowVisible()) {
            ((AbstractChartWindow)this.displayTab.getSelection()).scrollComposite();
        }
    }

    public void updateHistoChartWindow(final boolean redrawCurveSelector) {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            CTabItem activeTab = this.displayTab.getSelection();
            if (!(activeTab instanceof AbstractChartWindow)) {
                return;
            }
            if (!((AbstractChartWindow)activeTab).isActiveCurveSelectorContextMenu()) {
                ((AbstractChartWindow)activeTab).redrawGraphics(redrawCurveSelector);
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    CTabItem activeTab = HistoExplorer.this.displayTab.getSelection();
                    if (!(activeTab instanceof AbstractChartWindow)) {
                        return;
                    }
                    if (!((AbstractChartWindow)activeTab).isActiveCurveSelectorContextMenu()) {
                        ((AbstractChartWindow)activeTab).redrawGraphics(redrawCurveSelector);
                    }
                }
            });
        }
    }

    public boolean isHistoChartWindowVisible() {
        return this.displayTab.getSelection() instanceof AbstractChartWindow;
    }

    public boolean isHistoTableWindowVisible() {
        return this.displayTab.getSelection() instanceof HistoTableWindow;
    }

    public boolean isHistoWindowVisible() {
        if (this.displayTab == null) {
            return false;
        }
        return this.displayTab.getSelection() instanceof AbstractChartWindow || this.displayTab.getSelection() instanceof HistoTableWindow;
    }

    public void updateHistoTabs() {
        this.updateHistoTabs(HistoSet.RebuildStep.B_HISTOVAULTS);
    }

    public void updateHistoTabs(boolean createRecordSet, boolean rebuildTrails, boolean updateSelector) {
        this.updateHistoTabs(createRecordSet ? HistoSet.RebuildStep.C_TRAILRECORDSET : (rebuildTrails ? HistoSet.RebuildStep.D_TRAIL_DATA : (updateSelector ? HistoSet.RebuildStep.E_USER_INTERFACE : HistoSet.RebuildStep.G_SELECTOR_COMBO)));
    }

    private void updateHistoTabs(final HistoSet.RebuildStep rebuildStep) {
        if (Analyzer.getInstance().getActiveChannel() == null) {
            return;
        }
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "initial size=", this.getTrailRecordSet() != null ? this.getTrailRecordSet().getDisplayRecords().size() + "  " + this.getTrailRecordSet().getVisibleAndDisplayableRecords().size() : "0   0");
            }
            if (this.isHistoWindowVisible()) {
                Thread rebuilThread = new Thread(() -> this.rebuildHisto(rebuildStep), "rebuild4Screening");
                try {
                    rebuilThread.start();
                }
                catch (RuntimeException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "rebuild size=", this.getTrailRecordSet() != null ? this.getTrailRecordSet().getDisplayRecords().size() + "  " + this.getTrailRecordSet().getVisibleAndDisplayableRecords().size() : "0   0");
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (HistoExplorer.this.isHistoWindowVisible()) {
                        Thread rebuilThread = new Thread(() -> HistoExplorer.this.rebuildHisto(rebuildStep), "rebuild4Screening");
                        try {
                            rebuilThread.start();
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
            });
        }
    }

    public synchronized void rebuildHisto(HistoSet.RebuildStep rebuildStep) {
        block4: {
            boolean isRebuilt = false;
            try {
                isRebuilt = this.histoSet.rebuild4Screening(rebuildStep);
                if (isRebuilt || rebuildStep == HistoSet.RebuildStep.E_USER_INTERFACE || rebuildStep == HistoSet.RebuildStep.G_SELECTOR_COMBO) {
                    if (this.histoSet.getTrailRecordSet() != null) {
                        this.histoSet.getTrailRecordSet().setDisplayable();
                        this.histoSet.getTrailRecordSet().updateVisibleAndDisplayableRecordsForTable();
                    }
                    log.fine(() -> String.format("updateHistoChartWindow %b - updateHistoTableWindow %b", rebuildStep != HistoSet.RebuildStep.G_SELECTOR_COMBO, rebuildStep.scopeOfWork >= HistoSet.RebuildStep.E_USER_INTERFACE.scopeOfWork));
                    this.updateHistoChartWindow(rebuildStep != HistoSet.RebuildStep.G_SELECTOR_COMBO);
                    this.updateHistoTableWindow(rebuildStep.scopeOfWork >= HistoSet.RebuildStep.E_USER_INTERFACE.scopeOfWork);
                }
                this.histoSet.setRebuildStepInvisibleTabs(rebuildStep, isRebuilt);
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                if (!GDE.isWithUi()) break block4;
                this.application.openMessageDialog(Messages.getString("GDE_MSGE0007") + e.getMessage());
            }
        }
    }

    private void resetWindowHeaderAndMeasuring(final AbstractChartWindow tabItem) {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            tabItem.clearHeaderAndComment();
            tabItem.cleanMeasuring();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    tabItem.clearHeaderAndComment();
                    tabItem.cleanMeasuring();
                }
            });
        }
    }

    public void enableCurveSurvey(boolean enabled) {
        this.settings.setCurveSurvey(enabled);
    }

    public void enablePartialDataTable(boolean enabled) {
        this.settings.setPartialDataTable(enabled);
    }

    public void updateVisibleTab(SelectionEvent evt) {
        this.cleanMeasurePopUp();
        if (this.isHistoChartWindowVisible()) {
            log.log(Level.FINER, "HistoChartWindow in displayTab.widgetSelected, event=", evt);
            this.updateHistoTabs(this.histoSet.getRebuildStepInvisibleTab());
        } else if (this.isHistoTableWindowVisible()) {
            log.log(Level.FINER, "HistoTableWindow in displayTab.widgetSelected, event=", evt);
            this.updateHistoTabs(HistoSet.RebuildStep.E_USER_INTERFACE);
        }
    }

    public void cleanMeasurePopUp() {
        for (AbstractChartWindow c : this.chartTabItems) {
            c.cleanMeasuring();
        }
    }

    public void updateGraphicsWindow(boolean refreshCurveSelector) {
        if (this.displayTab.getSelection() instanceof AbstractChartWindow) {
            ((AbstractChartWindow)this.displayTab.getSelection()).redrawGraphics(refreshCurveSelector);
        }
    }

    public void setInnerAreaBackground(Color innerAreaBackground) {
        this.settings.setObjectDescriptionInnerAreaBackground(innerAreaBackground);
        for (AbstractChartWindow c : this.chartTabItems) {
            c.setCurveAreaBackground(innerAreaBackground);
        }
    }

    public void setBorderColor(Color borderColor) {
        this.settings.setCurveGraphicsBorderColor(borderColor);
        for (AbstractChartWindow c : this.chartTabItems) {
            c.setCurveAreaBorderColor(borderColor);
        }
    }

    public void setTimeLineColor(Color timeLineColor) {
        this.settings.setTimeLineColor(timeLineColor);
        for (AbstractChartWindow c : this.chartTabItems) {
            c.setTimeLineColor(timeLineColor);
        }
    }

    public void setHeaderCommentColor(Color newColor) {
        this.settings.setHeaderCommentColor(newColor);
        for (AbstractChartWindow c : this.chartTabItems) {
            c.setHeaderCommentColor(newColor);
        }
    }

    public void setSurroundingBackground(Color surroundingBackground) {
        this.settings.setUtilitySurroundingBackground(surroundingBackground);
        for (AbstractChartWindow c : this.chartTabItems) {
            c.setSurroundingBackground(surroundingBackground);
        }
    }

    public void enableGraphicsHeader(boolean enabled) {
        for (AbstractChartWindow c : this.chartTabItems) {
            c.enableGraphicsHeader(enabled);
        }
    }

    public void enableRecordSetComment(boolean enabled) {
        for (AbstractChartWindow c : this.chartTabItems) {
            c.enableRecordSetComment(enabled);
        }
    }

    public void enableCurveSelector(boolean enabled) {
        for (AbstractChartWindow c : this.chartTabItems) {
            c.enableCurveSelector(enabled);
        }
    }

    public Optional<Image> getGraphicsPrintImage() {
        return this.isHistoChartWindowVisible() ? Optional.of(((AbstractChartWindow)this.displayTab.getSelection()).getGraphicsPrintImage()) : Optional.empty();
    }

    public Optional<Image> getContentAsImage() {
        Image graphicsImage = null;
        if (this.isHistoChartWindowVisible()) {
            graphicsImage = ((AbstractChartWindow)this.displayTab.getSelection()).getContentAsImage();
        } else if (this.isHistoTableWindowVisible()) {
            graphicsImage = ((HistoTableWindow)this.displayTab.getSelection()).getContentAsImage();
        }
        return Optional.ofNullable(graphicsImage);
    }

    public Image getHistoGraphicsContentAsImage() {
        return this.chartTabItems.stream().filter(c -> c instanceof HistoGraphicsWindow).findFirst().map(AbstractChartWindow::getContentAsImage).orElseThrow(UnsupportedOperationException::new);
    }

    public Image getHistoSummaryContentAsImage() {
        return this.chartTabItems.stream().filter(c -> c instanceof HistoSummaryWindow).findFirst().map(AbstractChartWindow::getContentAsImage).orElseThrow(UnsupportedOperationException::new);
    }

    public Image getHistoTableContentAsImage() {
        return this.tableTabItems.stream().findFirst().map(HistoTableWindow::getContentAsImage).orElseThrow(UnsupportedOperationException::new);
    }

    public HistoSet getHistoSet() {
        return this.histoSet;
    }

    @Nullable
    public TrailRecordSet getTrailRecordSet() {
        return this.histoSet.getTrailRecordSet();
    }

    public HistoSummaryWindow getHistoSummaryTabItem() {
        return (HistoSummaryWindow)this.chartTabItems.stream().filter(c -> c instanceof HistoSummaryWindow).findFirst().orElseThrow(UnsupportedOperationException::new);
    }

    public AbstractChartWindow getActiveHistoChartTabItem() {
        return (AbstractChartWindow)this.displayTab.getSelection();
    }

    public void updateHistoMenuItems() {
        if (!this.hasRecords()) {
            return;
        }
        final boolean isSmartStatistics = this.getTrailRecordSet().isSmartStatistics();
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.application.getMenuBar().getSmartStatisticsItem().setSelection(isSmartStatistics);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    HistoExplorer.this.application.getMenuBar().getSmartStatisticsItem().setSelection(isSmartStatistics);
                }
            });
        }
    }

    public void cleanup() {
        DirectoryScanner.closeWatchDir();
    }

    public void setVolatileStatusMessage(String message, int swtColor) {
        if (this.volatileStatusMessage == null || !this.volatileStatusMessage.isIdentical(message, swtColor)) {
            this.volatileStatusMessage = new VolatileStatusMessage(message, swtColor, 3);
            if (this.isHistoWindowVisible()) {
                DataExplorer.getInstance().setStatusMessage(this.volatileStatusMessage.getTextLine(), this.volatileStatusMessage.getColor());
            }
        }
    }

    public VolatileStatusMessage getVolatileStatusMessage() {
        return this.volatileStatusMessage;
    }

    public void paintVolatileStatusMessage() {
        if (this.volatileStatusMessage != null && !this.volatileStatusMessage.isExpired()) {
            String consumedTextLine = this.volatileStatusMessage.getTextLine();
            DataExplorer.getInstance().setStatusMessage(consumedTextLine, this.volatileStatusMessage.getColor());
            if (this.volatileStatusMessage.isExpired()) {
                this.volatileStatusMessage = null;
                if (this.isHistoTableWindowVisible()) {
                    DataExplorer.getInstance().setStatusMessage("");
                }
            } else {
                DataExplorer.getInstance().setStatusMessage(consumedTextLine, this.volatileStatusMessage.getColor());
            }
        }
    }

    public void updateColorSchema() {
        for (AbstractChartWindow chartTabItem : this.chartTabItems) {
            if (!(chartTabItem instanceof HistoSummaryWindow)) continue;
            chartTabItem.updateColorSchema();
        }
    }
}

