/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.smmodellbau.LiPoWatchDialog;
import gde.exception.CheckSumMissmatchException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.Checksum;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class LiPoWatchSerialPort
extends DeviceCommPort {
    static final Logger log = Logger.getLogger(LiPoWatchSerialPort.class.getName());
    public static final String NUMBER_RECORD = "number_record";
    public static final String TIME_MILLI_SEC = "time_ms";
    static final byte[] COMMAND_QUERY_STATE = new byte[]{84};
    static final byte[] COMMAND_RESET = new byte[]{114};
    static final byte[] COMMAND_READ_DATA = new byte[]{108};
    static final byte[] COMMAND_REPEAT = new byte[]{119};
    static final byte[] COMMAND_DELETE = new byte[]{-64, 4, 1, 3, 8};
    static final byte[] COMMAND_QUERY_CONFIG = new byte[]{-64, 4, 1, 1, 6};
    static final byte[] COMMAND_LIVE_VALUES = new byte[]{118};
    static final byte[] COMMAND_START_LOGGING = new byte[]{83};
    static final byte[] COMMAND_STOP_LOGGING = new byte[]{115};
    static final byte[] COMMAND_BEGIN_XFER = new byte[]{-64};
    static final byte[] COMMAND_END_XFER = new byte[]{69};
    static final byte[] COMMAND_PREPARE_DELETE = new byte[]{120, 121, 49};
    static final byte[] COMMAND_PREPARE_SET_CONFIG = new byte[]{120, 121, -89};
    static final byte DATA_STATE_WAITING = 87;
    static final byte DATA_STATE_READY = 70;
    static final byte DATA_STATE_OK = 106;
    static final int DATA_LENGTH_BYTES = 47;
    boolean isLoggingActive = false;
    boolean isTransmitFinished = false;
    int reveiceErrors = 0;

    public LiPoWatchSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public Vector<Vector<byte[]>> getData(LiPoWatchDialog dialog) throws Exception {
        boolean isPortOpenedByMe = false;
        Vector<Vector<byte[]>> dataCollection = new Vector<Vector<byte[]>>();
        int numberLess4measurements = 0;
        try {
            int numberRecordSet;
            int memoryUsed;
            log.log(Level.FINE, "start");
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            this.reveiceErrors = 0;
            if (this.waitDataReady()) {
                int memoryLeft;
                byte[] readBuffer = this.readConfiguration();
                memoryUsed = memoryLeft = ((readBuffer[8] & 0xFF) << 24) + ((readBuffer[7] & 0xFF) << 16) + ((readBuffer[6] & 0xFF) << 8) + (readBuffer[5] & 0xFF);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "memoryUsed = " + memoryLeft);
                }
                this.write(COMMAND_RESET);
                dialog.setReadDataProgressBar(0);
                Vector<byte[]> telegrams = new Vector<byte[]>();
                numberRecordSet = 1;
                int redCounter = 0;
                int memoryRed = 0;
                int dataLength = 7;
                int dataSetType = 1;
                while ((memoryLeft -= dataLength - 7) > 0) {
                    readBuffer = this.readSingleTelegramm();
                    dataLength = readBuffer[0] & 0x7F;
                    dataSetType = readBuffer[9] & 0xF;
                    if (dataSetType == 0) {
                        int time_ms = ((readBuffer[4] & 0xFF) << 24) + ((readBuffer[3] & 0xFF) << 16) + ((readBuffer[2] & 0xFF) << 8) + (readBuffer[1] & 0xFF);
                        if (numberRecordSet == (readBuffer[10] & 0xFF) + 1) {
                            telegrams.add(readBuffer);
                        } else {
                            if (telegrams.size() > 4) {
                                dataCollection.add(telegrams);
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, "dataCollection.put = " + numberRecordSet);
                                }
                            } else {
                                ++numberLess4measurements;
                            }
                            numberRecordSet = (readBuffer[10] & 0xFF) + 1;
                            telegrams = new Vector();
                            telegrams.add(readBuffer);
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "numberRecordSet = " + numberRecordSet + " time_ms = " + time_ms + " memoryLeft = " + memoryLeft);
                        }
                        memoryRed += dataLength - 7;
                        if (++redCounter % 5 == 0) {
                            dialog.updateDataGatherProgress(memoryRed, numberRecordSet, this.reveiceErrors, numberLess4measurements, memoryUsed);
                        }
                        if (!this.isTransmitFinished) continue;
                        log.log(Level.WARNING, "transmission stopped by user");
                        break;
                    }
                    memoryRed += dataLength - 7;
                }
                if (telegrams.size() > 4) {
                    dataCollection.add(telegrams);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "dataCollection.put = " + numberRecordSet);
                    }
                } else {
                    ++numberLess4measurements;
                }
            } else {
                throw new IOException(Messages.getString((String)"GDE_MSGE0026"));
            }
            dialog.updateDataGatherProgress(memoryUsed, numberRecordSet, this.reveiceErrors, numberLess4measurements, memoryUsed);
            log.log(Level.FINE, "end");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
            log.log(Level.FINE, "stop");
        }
        return dataCollection;
    }

    public byte[] readSingleTelegramm() throws Exception {
        byte[] tmp1ReadBuffer = new byte[1];
        byte[] readBuffer = new byte[1];
        int length = 0;
        try {
            this.write(COMMAND_READ_DATA);
            this.read(tmp1ReadBuffer, 2000);
            length = tmp1ReadBuffer[0] & 0x7F;
            byte[] tmp2ReadBuffer = new byte[length - 1];
            this.read(tmp2ReadBuffer, 4000);
            readBuffer = new byte[length];
            readBuffer[0] = tmp1ReadBuffer[0];
            System.arraycopy(tmp2ReadBuffer, 0, readBuffer, 1, length - 1);
            if (!this.isChecksumOK(readBuffer)) {
                readBuffer = this.readRetry(tmp1ReadBuffer);
            }
        }
        catch (Throwable e) {
            readBuffer = this.readRetry(tmp1ReadBuffer);
        }
        return readBuffer;
    }

    byte[] readRetry(byte[] tmp1ReadBuffer) throws IOException, TimeOutException, CheckSumMissmatchException {
        ++this.reveiceErrors;
        this.write(COMMAND_REPEAT);
        log.log(Level.WARNING, "errors = " + this.reveiceErrors);
        this.read(tmp1ReadBuffer, 2000);
        int length = tmp1ReadBuffer[0] & 0x7F;
        byte[] tmp2ReadBuffer = new byte[length - 1];
        this.read(tmp2ReadBuffer, 4000);
        byte[] readBuffer = new byte[length];
        readBuffer[0] = tmp1ReadBuffer[0];
        System.arraycopy(tmp2ReadBuffer, 0, readBuffer, 1, length - 1);
        this.verifyChecksum(readBuffer);
        return readBuffer;
    }

    public boolean wait4LiveData(int retrys) throws Exception {
        byte[] tmp1ReadBuffer;
        boolean isLiveDataAvailable = false;
        if (this.isConnected()) {
            this.application.setCursor(SWTResourceManager.getCursor((int)1));
            while (this.getAvailableBytes() < 10 && retrys-- > 0) {
                this.write(COMMAND_LIVE_VALUES);
                WaitTimer.delay((long)250L);
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "retryLimit = " + retrys);
            }
            tmp1ReadBuffer = new byte[1];
            this.read(tmp1ReadBuffer, 1000);
            int length = tmp1ReadBuffer[0] & 0x7F;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "length = " + length);
            }
        } else {
            throw new Exception(Messages.getString((String)"GDE_MSGE0031"));
        }
        this.read(new byte[(tmp1ReadBuffer[0] & 0x7F) - 1], 1000);
        isLiveDataAvailable = true;
        this.application.setCursor(SWTResourceManager.getCursor((int)0));
        return isLiveDataAvailable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] queryLiveData() throws Exception {
        byte[] tmp1ReadBuffer = new byte[1];
        int length = 0;
        if (!this.isConnected()) throw new Exception(Messages.getString((String)"GDE_MSGE0031"));
        try {
            this.write(COMMAND_LIVE_VALUES);
            this.read(tmp1ReadBuffer, 2000);
            length = tmp1ReadBuffer[0] & 0x7F;
            byte[] tmp2ReadBuffer = new byte[length - 1];
            this.read(tmp2ReadBuffer, 4000);
            byte[] readBuffer = new byte[length];
            readBuffer[0] = tmp1ReadBuffer[0];
            System.arraycopy(tmp2ReadBuffer, 0, readBuffer, 1, length - 1);
            if (this.isChecksumOK(readBuffer)) return readBuffer;
            this.write(COMMAND_LIVE_VALUES);
            this.read(tmp1ReadBuffer, 2000);
            length = tmp1ReadBuffer[0] & 0x7F;
            tmp2ReadBuffer = new byte[length - 1];
            this.read(tmp2ReadBuffer, 4000);
            readBuffer = new byte[length];
            readBuffer[0] = tmp1ReadBuffer[0];
            System.arraycopy(tmp2ReadBuffer, 0, readBuffer, 1, length - 1);
            this.verifyChecksum(readBuffer);
            return readBuffer;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    public boolean startLogging() throws Exception {
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
                this.checkConnectionStatus();
            }
            this.write(COMMAND_START_LOGGING);
            this.isLoggingActive = true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.close();
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return this.isLoggingActive;
    }

    public boolean stopLogging() throws Exception {
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            this.write(COMMAND_STOP_LOGGING);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.close();
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return !this.isLoggingActive;
    }

    public synchronized boolean clearMemory() throws Exception {
        boolean success;
        block7: {
            success = false;
            try {
                if (this.isConnected()) break block7;
                this.open();
                if (this.waitDataReady()) {
                    this.write(COMMAND_DELETE);
                    byte[] readBuffer = new byte[1];
                    readBuffer = this.read(readBuffer, 5000);
                    if (readBuffer[0] != 106) {
                        success = true;
                    }
                    break block7;
                }
                throw new IOException(Messages.getString((String)"GDE_MSGE0032"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                this.close();
            }
        }
        return success;
    }

    public synchronized boolean setConfiguration(byte[] updateBuffer) throws Exception {
        boolean success;
        block10: {
            success = false;
            boolean isPortOpenedByMe = false;
            try {
                if (!this.isConnected()) {
                    this.open();
                    isPortOpenedByMe = true;
                }
                if (this.checkConnectionStatus()) {
                    if (this.checkDataReady()) {
                        this.write(updateBuffer);
                        byte[] readBuffer = new byte[1];
                        readBuffer = this.read(readBuffer, 5000);
                        if (readBuffer[0] == 106) {
                            success = true;
                        }
                        break block10;
                    }
                    throw new IOException(Messages.getString((String)"GDE_MSGE0032"));
                }
                throw new IOException(Messages.getString((String)"GDE_MSGE0033"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                if (isPortOpenedByMe) {
                    this.close();
                }
            }
        }
        return success;
    }

    public byte[] readConfiguration() throws Exception {
        byte[] readBuffer;
        block9: {
            readBuffer = new byte[49];
            boolean isPortOpenedByMe = false;
            try {
                if (!this.isConnected()) {
                    this.open();
                    isPortOpenedByMe = true;
                }
                if (this.checkConnectionStatus()) {
                    if (this.waitDataReady()) {
                        this.write(COMMAND_QUERY_CONFIG);
                        this.read(readBuffer, 4000);
                        this.verifyChecksum(readBuffer);
                        break block9;
                    }
                    throw new IOException(Messages.getString((String)"GDE_MSGE0033"));
                }
                throw new IOException(Messages.getString((String)"GDE_MSGE0032"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            finally {
                if (isPortOpenedByMe) {
                    this.close();
                }
            }
        }
        return readBuffer;
    }

    public synchronized boolean checkConnectionStatus() throws IOException, TimeOutException {
        boolean isConnect = false;
        int counter = 50;
        while (!isConnect && counter-- > 0) {
            this.write(COMMAND_QUERY_STATE);
            byte[] buffer = new byte[1];
            WaitTimer.delay((long)100L);
            if ((buffer = this.read(buffer, 2000))[0] != 87 && buffer[0] != 70) continue;
            isConnect = true;
        }
        return isConnect;
    }

    public boolean checkDataReady() throws Exception {
        boolean isReady = false;
        int counter = 50;
        while (!isReady && counter-- > 0) {
            this.write(COMMAND_QUERY_STATE);
            WaitTimer.delay((long)100L);
            byte[] buffer = new byte[1];
            if ((buffer = this.read(buffer, 2000))[0] != 70) continue;
            isReady = true;
        }
        return isReady;
    }

    public boolean waitDataReady() throws Exception {
        boolean isReady = false;
        isReady = this.checkDataReady();
        return isReady;
    }

    private void verifyChecksum(byte[] readBuffer) throws CheckSumMissmatchException {
        int checkSum = 0;
        int checkSumData = 0;
        int length = readBuffer[0] & 0x7F;
        checkSum = Checksum.ADD((byte[])readBuffer, (int)2) + 1;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "checkSum = " + checkSum);
        }
        checkSumData = ((readBuffer[length - 2] & 0xFF) << 8) + (readBuffer[length - 1] & 0xFF);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "checkSumData = " + checkSumData);
        }
        if (checkSum != checkSumData) {
            throw new CheckSumMissmatchException(Messages.getString((String)"GDE_MSGE0034", (Object[])new Object[]{checkSum, checkSumData}));
        }
    }

    private boolean isChecksumOK(byte[] readBuffer) {
        int checkSum = 0;
        int checkSumLast2Bytes = 0;
        checkSum = Checksum.ADD((byte[])readBuffer, (int)2) + 1;
        checkSumLast2Bytes = ((readBuffer[readBuffer.length - 2] & 0xFF) << 8) + (readBuffer[readBuffer.length - 1] & 0xFF);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "checkSum = " + checkSum + " checkSumLast2Bytes = " + checkSumLast2Bytes);
        }
        return checkSum == checkSumLast2Bytes;
    }

    public void setTransmitFinished(boolean isFinished) {
        this.isTransmitFinished = isFinished;
    }

    public boolean isTransmitFinished() {
        return this.isTransmitFinished;
    }
}

