/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.skyrc.D200neo;
import gde.device.skyrc.Q200UsbPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.WaitTimer;
import java.util.logging.Logger;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbNotClaimedException;

public class X200neoGathererThread
extends Thread {
    protected static final int USB_QUERY_DELAY = GDE.IS_WINDOWS ? 70 : 160;
    static final String $CLASS_NAME = X200neoGathererThread.class.getName();
    static final Logger log = Logger.getLogger(X200neoGathererThread.class.getName());
    static final int WAIT_TIME_RETRYS = 3600;
    final DataExplorer application;
    final Settings settings;
    final Q200UsbPort usbPort;
    final D200neo device;
    final DeviceDialog dialog;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    boolean isPortOpenedByLiveGatherer = false;
    boolean isGatheredRecordSetVisible = true;
    boolean isCollectDataStopped = false;
    UsbInterface usbInterface = null;
    boolean isProgrammExecuting1 = false;
    boolean isProgrammExecuting2 = false;
    boolean isProgrammExecuting3 = false;
    boolean isProgrammExecuting4 = false;
    boolean[] isAlerted4Finish = new boolean[]{false, false, false, false};
    int retryCounter = 3600;
    int numChannels = 2;
    int lastNumberDisplayableRecords = 0;

    public X200neoGathererThread(DataExplorer currentApplication, D200neo useDevice, Q200UsbPort useSerialPort, int channelConfigNumber, DeviceDialog useDialog) throws ApplicationConfigurationException, UsbDisconnectedException, UsbException {
        super("dataGatherer");
        this.application = currentApplication;
        this.settings = Settings.getInstance();
        this.device = useDevice;
        this.device.resetEnergy = new int[]{5, 5, 5, 5};
        this.dialog = useDialog;
        this.usbPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        if (!this.usbPort.isConnected()) {
            this.usbInterface = this.usbPort.openUsbPort(this.device);
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
        this.numChannels = this.channels.getChannelNames().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String $METHOD_NAME = "run";
            RecordSet recordSet1 = null;
            RecordSet recordSet2 = null;
            RecordSet recordSet3 = null;
            RecordSet recordSet4 = null;
            int[] points1 = new int[this.device.getNumberOfMeasurements(1)];
            int[] points2 = new int[this.device.getNumberOfMeasurements(2)];
            int[] points3 = new int[this.device.getNumberOfMeasurements(3)];
            int[] points4 = new int[this.device.getNumberOfMeasurements(4)];
            int lastEnergie1 = 0;
            int lastEnergie2 = 0;
            int lastEnergie3 = 0;
            int lastEnergie4 = 0;
            this.isProgrammExecuting1 = false;
            this.isProgrammExecuting2 = false;
            this.isProgrammExecuting3 = false;
            this.isProgrammExecuting4 = false;
            long lastCycleTime = 0L;
            byte[] dataBuffer1 = null;
            byte[] dataBuffer2 = null;
            byte[] dataBuffer3 = null;
            byte[] dataBuffer4 = null;
            byte[] channelBuffer1 = null;
            byte[] channelBuffer2 = null;
            byte[] channelBuffer3 = null;
            byte[] channelBuffer4 = null;
            String recordSetKey1 = Messages.getString((String)"GDE_MSGT0272");
            String recordSetKey2 = Messages.getString((String)"GDE_MSGT0272");
            String recordSetKey3 = Messages.getString((String)"GDE_MSGT0272");
            String recordSetKey4 = Messages.getString((String)"GDE_MSGT0272");
            this.isCollectDataStopped = false;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
            }
            lastCycleTime = System.nanoTime() / 1000000L;
            while (!this.isCollectDataStopped && this.usbPort.isConnected()) {
                try {
                    if (this.application != null) {
                        this.application.setSerialTxOn();
                    }
                    if (this.application != null) {
                        this.application.setSerialRxOn();
                    }
                    if (this.usbPort.isConnected() && this.numChannels >= 1) {
                        if (this.isProgrammExecuting1) {
                            dataBuffer1 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryOperationData.CHANNEL_A.value());
                            this.isProgrammExecuting1 = this.device.isProcessing(1, channelBuffer1, dataBuffer1);
                        } else {
                            dataBuffer1 = null;
                            channelBuffer1 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryChannelData.CHANNEL_A.value());
                            this.isProgrammExecuting1 = this.device.isProcessing(1, channelBuffer1, dataBuffer1);
                        }
                    }
                    WaitTimer.delay((long)USB_QUERY_DELAY);
                    if (this.usbPort.isConnected() && this.numChannels >= 2) {
                        if (this.isProgrammExecuting2) {
                            dataBuffer2 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryOperationData.CHANNEL_B.value());
                            this.isProgrammExecuting2 = this.device.isProcessing(2, channelBuffer2, dataBuffer2);
                        } else {
                            dataBuffer2 = null;
                            channelBuffer2 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryChannelData.CHANNEL_B.value());
                            this.isProgrammExecuting2 = this.device.isProcessing(2, channelBuffer2, dataBuffer2);
                        }
                    }
                    if (this.application != null) {
                        this.application.setSerialTxOff();
                    }
                    WaitTimer.delay((long)USB_QUERY_DELAY);
                    if (this.usbPort.isConnected() && this.numChannels >= 3) {
                        if (this.isProgrammExecuting3) {
                            dataBuffer3 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryOperationData.CHANNEL_C.value());
                            this.isProgrammExecuting3 = this.device.isProcessing(3, channelBuffer3, dataBuffer3);
                        } else {
                            dataBuffer3 = null;
                            channelBuffer3 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryChannelData.CHANNEL_C.value());
                            this.isProgrammExecuting3 = this.device.isProcessing(3, channelBuffer3, dataBuffer3);
                        }
                    }
                    WaitTimer.delay((long)USB_QUERY_DELAY);
                    if (this.usbPort.isConnected() && this.numChannels >= 4) {
                        if (this.isProgrammExecuting4) {
                            dataBuffer4 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryOperationData.CHANNEL_D.value());
                            this.isProgrammExecuting4 = this.device.isProcessing(4, channelBuffer4, dataBuffer4);
                        } else {
                            dataBuffer4 = null;
                            channelBuffer4 = this.usbPort.getData(this.usbInterface, Q200UsbPort.QueryChannelData.CHANNEL_D.value());
                            this.isProgrammExecuting4 = this.device.isProcessing(4, channelBuffer4, dataBuffer4);
                        }
                    }
                    if (this.application != null) {
                        this.application.setSerialRxOff();
                    }
                    if (this.isProgrammExecuting1 || this.isProgrammExecuting2 || this.isProgrammExecuting3 || this.isProgrammExecuting4) {
                        lastEnergie1 = points1[4];
                        points1 = new int[this.device.getNumberOfMeasurements(1)];
                        if (this.numChannels >= 2) {
                            lastEnergie2 = points2[4];
                            points2 = new int[this.device.getNumberOfMeasurements(2)];
                        }
                        if (this.numChannels >= 3) {
                            lastEnergie3 = points3[4];
                            points3 = new int[this.device.getNumberOfMeasurements(3)];
                        }
                        if (this.numChannels >= 4) {
                            lastEnergie4 = points4[4];
                            points4 = new int[this.device.getNumberOfMeasurements(4)];
                        }
                        if (this.isProgrammExecuting1 && channelBuffer1 != null && dataBuffer1 != null) {
                            points1[4] = lastEnergie1;
                            Object[] ch1 = this.processDataChannel(1, recordSet1, recordSetKey1, channelBuffer1, dataBuffer1, points1);
                            recordSet1 = (RecordSet)ch1[0];
                            recordSetKey1 = (String)ch1[1];
                        }
                        if (this.isProgrammExecuting2 && channelBuffer2 != null && dataBuffer2 != null) {
                            points2[4] = lastEnergie2;
                            Object[] ch2 = this.processDataChannel(2, recordSet2, recordSetKey2, channelBuffer2, dataBuffer2, points2);
                            recordSet2 = (RecordSet)ch2[0];
                            recordSetKey2 = (String)ch2[1];
                        }
                        if (this.isProgrammExecuting3 && channelBuffer3 != null && dataBuffer3 != null) {
                            points3[4] = lastEnergie3;
                            Object[] ch3 = this.processDataChannel(3, recordSet3, recordSetKey3, channelBuffer3, dataBuffer3, points3);
                            recordSet3 = (RecordSet)ch3[0];
                            recordSetKey3 = (String)ch3[1];
                        }
                        if (this.isProgrammExecuting4 && channelBuffer4 != null && dataBuffer4 != null) {
                            points4[4] = lastEnergie4;
                            Object[] ch4 = this.processDataChannel(4, recordSet4, recordSetKey4, channelBuffer4, dataBuffer4, points4);
                            recordSet4 = (RecordSet)ch4[0];
                            recordSetKey4 = (String)ch4[1];
                        }
                        this.application.setStatusMessage("");
                    } else {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3600"));
                        log.logp(Level.FINE, $CLASS_NAME, "run", "wait for device activation ...");
                        if (0 >= --this.retryCounter) {
                            log.log(Level.FINE, "device activation timeout");
                            this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3601"));
                            this.stopDataGatheringThread(false, null);
                        }
                    }
                }
                catch (DataInconsitsentException e) {
                    String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                    this.cleanup(message);
                }
                catch (Throwable e) {
                    if (e instanceof TimeOutException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3600"));
                        if (log.isLoggable(Level.FINE)) {
                            log.logp(Level.FINE, $CLASS_NAME, "run", Messages.getString((String)"GDE_MSGI3600"));
                        }
                    }
                    if (e instanceof UsbNotClaimedException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{e.getClass().getSimpleName() + " : " + e.getMessage()}));
                        this.stopDataGatheringThread(false, e);
                    }
                    if (e instanceof UsbDisconnectedException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{e.getClass().getSimpleName() + " : " + e.getMessage()}));
                        this.stopDataGatheringThread(false, e);
                    }
                    if (e instanceof UsbException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGE0050"));
                        this.stopDataGatheringThread(false, e);
                    }
                    log.log(Level.FINE, "data gathering end detected");
                    this.stopDataGatheringThread(true, e);
                }
                long delay = (lastCycleTime += 1000L) - System.nanoTime() / 1000000L;
                if (delay > 0L) {
                    WaitTimer.delay((long)delay);
                }
                if (!log.isLoggable(Level.TIME)) continue;
                log.log(Level.TIME, String.format("delay = %d", delay));
            }
            this.application.setStatusMessage("");
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
            }
            if (!this.isCollectDataStopped) {
                this.stopDataGatheringThread(false, null);
            }
        }
        finally {
            try {
                if (this.usbInterface != null) {
                    this.device.usbPort.closeUsbPort(this.usbInterface);
                    log.log(Level.FINE, "USB interface closed");
                }
            }
            catch (UsbException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private Object[] processDataChannel(int number, RecordSet recordSet, String processRecordSetKey, byte[] channelBuffer, byte[] dataBuffer, int[] points) throws DataInconsitsentException {
        Channel channel;
        String $METHOD_NAME = "processOutlet";
        Object[] result = new Object[2];
        String processTypeName = this.device.getProcessingTypeName(channelBuffer);
        String processSubTypeName = this.device.getProcessSubTypeName(channelBuffer, dataBuffer);
        String processBatteryTypeName = this.device.getProcessingBatteryTypeName(channelBuffer);
        int processSubType = this.device.getProcessSubType(channelBuffer, dataBuffer);
        dataBuffer[1] = this.device.resetEnergy[number - 1] != processSubType || processSubType == 2 ? (processSubType == 2 ? -1 : 1) : 0;
        this.device.resetEnergy[number - 1] = processSubType;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Channel = " + number + " : processTypeName = " + processTypeName + " processSubType = " + processSubTypeName);
        }
        if ((channel = (Channel)this.channels.get((Object)number)) != null) {
            RecordSet activeRecordSet;
            if (recordSet == null || !processRecordSetKey.contains(processTypeName) || !processRecordSetKey.contains(processSubTypeName)) {
                this.application.setStatusMessage("");
                StringBuilder extend = new StringBuilder();
                if (!this.device.isContinuousRecordSet()) {
                    int cycleNumber;
                    int batterieType = this.device.getBatteryType(channelBuffer);
                    int processingType = this.device.getProcessingType(channelBuffer);
                    if ((batterieType == 4 || batterieType == 5) && processingType == 4 && (cycleNumber = this.device.getCycleNumber(dataBuffer) + 1) >= 0) {
                        extend.append("[").append(processSubTypeName).append(":").append(cycleNumber).append("]");
                    }
                }
                processRecordSetKey = String.format("%d) %s - %s %s", channel.getNextRecordSetNumber(), processBatteryTypeName, processTypeName, extend.toString());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, number + " : processRecordSetKey = " + processRecordSetKey);
                }
                processRecordSetKey = processRecordSetKey.length() <= 40 ? processRecordSetKey : processRecordSetKey.substring(0, 40);
                channel.put((Object)processRecordSetKey, (Object)RecordSet.createRecordSet((String)processRecordSetKey, (IDevice)this.application.getActiveDevice(), (int)channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                if (channel.getType() == ChannelTypes.TYPE_CONFIG) {
                    channel.applyTemplate(processRecordSetKey, false);
                } else {
                    channel.applyTemplateBasics(processRecordSetKey);
                }
                log.logp(Level.FINE, $CLASS_NAME, "processOutlet", processRecordSetKey + " created for channel " + channel.getName());
                recordSet = (RecordSet)channel.get((Object)processRecordSetKey);
                recordSet.setAllDisplayable();
                this.channels.switchChannel(channel.getNumber(), processRecordSetKey);
                channel.switchRecordSet(processRecordSetKey);
                String description = String.format("%s%s%s %s;", recordSet.getRecordSetDescription(), GDE.LINE_SEPARATOR, this.device.getHarwareString(number), this.device.getFirmwareString(number));
                recordSet.setRecordSetDescription(description);
                dataBuffer[1] = 1;
            }
            dataBuffer[0] = (byte)this.device.getBatteryType(channelBuffer);
            recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
            if (recordSet.get(0).realSize() < 3 || recordSet.get(0).realSize() % 10 == 0) {
                this.device.updateVisibilityStatus(recordSet, true);
            }
            if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null && recordSet.size() > 0 && recordSet.isChildOfActiveChannel() && recordSet.equals((Object)activeRecordSet)) {
                this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != activeRecordSet.getConfiguredDisplayable());
                this.lastNumberDisplayableRecords = activeRecordSet.getConfiguredDisplayable();
            }
        }
        result[0] = recordSet;
        result[1] = processRecordSetKey;
        return result;
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        RecordSet recordSet;
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.usbPort != null && this.usbPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.usbPort.getXferErrors() + " number of errors occured!");
        }
        if (this.usbPort != null && this.usbPort.isConnected() && this.isPortOpenedByLiveGatherer && this.usbPort.isConnected()) {
            try {
                this.usbPort.closeUsbPort(null);
            }
            catch (UsbException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if ((recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGT3603"));
            }
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}) + Messages.getString((String)"GDE_MSGT3602"));
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026") + Messages.getString((String)"GDE_MSGT3602"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.usbPort.isConnected()) {
            try {
                this.usbPort.closeUsbPort(null);
            }
            catch (UsbException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, false);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialogAsync(message);
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        X200neoGathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        X200neoGathererThread.this.application.updateStatisticsData();
                        X200neoGathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        X200neoGathererThread.this.application.openMessageDialogAsync(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialogAsync(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    public UsbInterface getUsbInterface() {
        return this.usbInterface;
    }
}

