/*
 * Decompiled with CFR 0.152.
 */
package gde.device.peaktech;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeakTechSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = PeakTechSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    final byte endByte = this.device.getDataBlockEnding()[this.device.getDataBlockEnding().length - 1];
    final byte endByte_1 = this.device.getDataBlockEnding().length == 2 ? this.device.getDataBlockEnding()[0] : (byte)0;
    final int timeout;
    final int dataLength = Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO));
    boolean isInSync = true;
    static final int xferErrorLimit = 10;

    public PeakTechSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
        this.timeout = this.device.getDeviceConfiguration().getReadTimeOut();
    }

    public byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[this.dataLength];
        byte[] answer = new byte[this.dataLength];
        boolean isPortOpenedByMe = false;
        try {
            if (!this.isConnected()) {
                this.open();
                isPortOpenedByMe = true;
            }
            answer = this.read(answer, 5000);
            if (log.isLoggable(gde.log.Level.FINER)) {
                log.log(gde.log.Level.FINER, StringHelper.byte2Hex4CharString((byte[])answer, (int)answer.length));
            }
            while ((answer[this.dataLength - 1] & 0xFF) != this.endByte && (answer[this.dataLength - 2] & 0xFF) != this.endByte_1) {
                this.isInSync = false;
                log.log(gde.log.Level.WARNING, "Answer needs synchronization, does not end with CRLF");
                log.log(gde.log.Level.WARNING, StringHelper.byte2Hex4CharString((byte[])answer, (int)answer.length));
                for (int i = 1; i < answer.length; ++i) {
                    if ((answer[i] & 0xFF) != this.endByte || (answer[i - 1] & 0xFF) != this.endByte_1) continue;
                    log.log(gde.log.Level.WARNING, String.format("CRLF found at position %d", i));
                    System.arraycopy(answer, i + 1, data, 0, this.dataLength - 1 - i);
                    answer = new byte[i + 1];
                    answer = this.read(answer, 3000);
                    log.log(gde.log.Level.WARNING, "Reading missing bytes to get in sync");
                    log.log(gde.log.Level.WARNING, StringHelper.byte2Hex4CharString((byte[])answer, (int)answer.length));
                    System.arraycopy(answer, 0, data, this.dataLength - 1 - i, i + 1);
                    this.isInSync = true;
                    log.logp(gde.log.Level.WARNING, $CLASS_NAME, "getData", "----> receive sync finished");
                    break;
                }
                if ((answer[0] & 0xFF) == this.endByte || (answer[answer.length - 1] & 0xFF) == this.endByte_1) {
                    log.log(gde.log.Level.WARNING, "LF found at position 0");
                    System.arraycopy(answer, 1, data, 0, this.dataLength - 2);
                    answer = new byte[1];
                    answer = this.read(answer, 3000);
                    log.log(gde.log.Level.WARNING, "Reading missing byte to get in sync");
                    log.log(gde.log.Level.WARNING, StringHelper.byte2Hex4CharString((byte[])answer, (int)answer.length));
                    data[this.dataLength - 1] = answer[0];
                    this.isInSync = true;
                    log.logp(gde.log.Level.WARNING, $CLASS_NAME, "getData", "----> receive sync finished");
                    log.log(gde.log.Level.WARNING, StringHelper.byte2Hex4CharString((byte[])data, (int)data.length));
                }
                if (!this.isInSync) continue;
                answer = new byte[this.dataLength];
                answer = this.read(answer, 3000);
                if (!log.isLoggable(gde.log.Level.FINER)) break;
                log.log(Level.FINER, StringHelper.byte2Hex4CharString((byte[])answer, (int)answer.length));
                break;
            }
            if ((answer[this.dataLength - 1] & 0xFF) != this.endByte && (answer[this.dataLength - 2] & 0xFF) != this.endByte_1) {
                log.logp(gde.log.Level.WARNING, $CLASS_NAME, "getData", "=====> data end does not match, number of errors = " + this.getXferErrors());
                this.addXferError();
                if (this.getXferErrors() > 0 && this.getXferErrors() % 10 == 0) {
                    log.logp(gde.log.Level.WARNING, $CLASS_NAME, "getData", "Number of tranfer error exceed the acceptable limit! number errors = " + this.getXferErrors());
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW0045", (Object[])new Object[]{"SerialPortException", this.getXferErrors()}));
                    throw new SerialPortException(Messages.getString((String)"GDE_MSGW0045", (Object[])new Object[]{"SerialPortException", this.getXferErrors()}));
                }
                WaitTimer.delay((long)1000L);
                data = this.getData();
            } else {
                System.arraycopy(answer, 0, data, 0, this.dataLength);
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.log(gde.log.Level.SEVERE, e.getMessage());
            }
            throw e;
        }
        finally {
            if (isPortOpenedByMe) {
                this.close();
            }
        }
        return data;
    }
}

