/*
 * Decompiled with CFR 0.152.
 */
package gde;

import com.sun.istack.Nullable;
import gde.DataAccess;
import gde.Explorer;
import gde.GDE;
import gde.TestAnalyzer;
import gde.config.DeviceConfigurations;
import gde.config.ExportService;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.log.Level;
import gde.log.Logger;
import java.io.IOException;
import java.util.function.Supplier;

public abstract class Analyzer
implements Cloneable {
    private static final String $CLASS_NAME = Analyzer.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static Analyzer analyzer;
    protected static Supplier<Analyzer> analyzerBuilder;
    protected static Supplier<DataAccess> dataAccessBuilder;
    protected final Settings settings;
    protected final DataAccess dataAccess;
    protected final DeviceConfigurations deviceConfigurations;
    protected Thread deviceConfigurationsThread;
    protected IDevice activeDevice = null;
    protected Channels channels = null;

    public static void setBuilders(Supplier<Analyzer> analyzerBuilder, Supplier<DataAccess> dataAccessBuilder) {
        Analyzer.analyzerBuilder = analyzerBuilder;
        Analyzer.dataAccessBuilder = dataAccessBuilder;
    }

    public static boolean isWithBuilders() {
        return analyzerBuilder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Analyzer getInstance() {
        if (analyzer == null) {
            analyzer = analyzerBuilder != null ? analyzerBuilder.get() : (!GDE.isWithUi() ? new TestAnalyzer() : new Explorer());
            Analyzer analyzer = Analyzer.analyzer;
            synchronized (analyzer) {
                Analyzer.analyzer.startDeviceConfigurationsThread();
            }
        }
        return analyzer;
    }

    protected Analyzer() {
        this.settings = Settings.getInstance();
        this.dataAccess = dataAccessBuilder != null ? dataAccessBuilder.get() : (!GDE.isWithUi() ? DataAccess.getInstance() : DataAccess.getInstance());
        this.deviceConfigurations = new DeviceConfigurations();
    }

    public void startDeviceConfigurationsThread() {
        this.deviceConfigurationsThread = new Thread("loadDeviceConfigurations"){

            @Override
            public void run() {
                log.log(Level.FINE, "deviceConfigurationsThread    started");
                Analyzer.this.deviceConfigurations.initialize(Analyzer.this);
            }
        };
        this.deviceConfigurationsThread.start();
    }

    protected Analyzer(Analyzer that) {
        this.settings = new Settings(that.settings);
        this.dataAccess = that.dataAccess.clone();
        if (that.activeDevice == null) {
            this.activeDevice = null;
            this.channels = null;
        } else {
            this.activeDevice = that.activeDevice.getDeviceConfiguration().getAsDevice();
            this.channels = new Channels(that.channels);
            this.channels.setupChannels(that);
        }
        if (that.deviceConfigurations == null) {
            throw new UnsupportedOperationException("clone is requested before the configurations are loaded");
        }
        this.deviceConfigurations = that.deviceConfigurations;
        this.deviceConfigurationsThread = that.deviceConfigurationsThread;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public DeviceConfigurations getDeviceConfigurations() {
        if (this.deviceConfigurationsThread.isAlive()) {
            this.joinDeviceConfigurationsThread();
        }
        return this.deviceConfigurations;
    }

    @Nullable
    public Channels getChannels() {
        return this.channels;
    }

    @Nullable
    public Channel getActiveChannel() {
        return this.channels != null ? this.channels.getActiveChannel() : null;
    }

    @Nullable
    public IDevice getActiveDevice() {
        return this.activeDevice;
    }

    public void setActiveDevice(IDevice device) {
        this.activeDevice = device;
    }

    public void setActiveDevice(String deviceName) {
        this.setActiveDevice(this.deviceConfigurations.get(deviceName).getAsDevice());
    }

    public void setChannelNumber(int channelNumber) {
        this.channels.setActiveChannelNumber(channelNumber);
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Deprecated
    public Analyzer clone() {
        throw new UnsupportedOperationException();
    }

    public abstract Analyzer getReplica();

    public void joinDeviceConfigurationsThread() {
        try {
            while (this.deviceConfigurationsThread == null) {
                Thread.sleep(22L);
            }
            this.deviceConfigurationsThread.join();
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, "deviceConfigurationsThread.run()", e);
        }
    }

    public String toString() {
        String deviceName = this.activeDevice != null ? this.activeDevice.getName() : "null";
        int channelsSize = this.channels != null ? this.channels.size() : 0;
        int channelNumber = this.getActiveChannel() != null ? this.getActiveChannel().getNumber() : -1;
        return "Analyzer [activeDevice=" + deviceName + ", deviceConfigurationsSize=" + this.deviceConfigurations.getAllConfigurations().size() + ", channelNumber=" + channelNumber + ", objectKey=" + this.getSettings().getActiveObjectKey() + ", channelsSize=" + channelsSize + "]";
    }

    public void setArena(String fileDeviceName, int channelNumber, String objectKey) {
        try {
            DeviceConfiguration deviceConfig = this.getDeviceConfigurations().get(fileDeviceName);
            if (deviceConfig == null) {
                ExportService service = this.settings.getDeviceServices().get(fileDeviceName);
                this.getSettings().extractDevicePropertiesAndTemplates(service.getJarFile(), fileDeviceName);
                this.deviceConfigurations.add(this, fileDeviceName, fileDeviceName + ".xml", false);
                deviceConfig = this.deviceConfigurations.get(fileDeviceName);
            }
            log.log(Level.FINE, fileDeviceName, deviceConfig);
            IDevice asDevice = deviceConfig.getAsDevice();
            this.setArena(asDevice, channelNumber, objectKey);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setArena(IDevice device, int channelNumber, String objectKey) {
        this.settings.setActiveObjectKey(objectKey);
        log.fine(() -> String.valueOf(device) + "  " + String.valueOf(this.activeDevice));
        if (!device.equals(this.activeDevice)) {
            this.activeDevice = device;
            this.setActiveDevice(device);
            if (this.channels == null) {
                this.channels = Channels.createChannels();
                this.channels.setupChannels(this);
            } else {
                this.channels.setupChannels(this);
            }
        }
        this.channels.setActiveChannelNumber(channelNumber);
    }

    static {
        analyzerBuilder = null;
        dataAccessBuilder = null;
    }
}

