/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache.AndMatcher;
import freemarker.cache.ConditionalTemplateConfigurationFactory;
import freemarker.cache.FileExtensionMatcher;
import freemarker.cache.FileNameGlobMatcher;
import freemarker.cache.FirstMatchTemplateConfigurationFactory;
import freemarker.cache.MergingTemplateConfigurationFactory;
import freemarker.cache.NotMatcher;
import freemarker.cache.OrMatcher;
import freemarker.cache.PathGlobMatcher;
import freemarker.cache.PathRegexMatcher;
import freemarker.core.BugException;
import freemarker.core.DefaultTruncateBuiltinAlgorithm;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.ParseException;
import freemarker.core.PlainTextOutputFormat;
import freemarker.core.RTFOutputFormat;
import freemarker.core.TemplateConfiguration;
import freemarker.core.UndefinedOutputFormat;
import freemarker.core.XHTMLOutputFormat;
import freemarker.core.XMLOutputFormat;
import freemarker.core._ObjectBuilderSettingEvaluationException;
import freemarker.core._SettingEvaluationEnvironment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.SimpleObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.Version;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.WriteProtectable;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class _ObjectBuilderSettingEvaluator {
    private static final String INSTANCE_FIELD_NAME = "INSTANCE";
    private static final String BUILD_METHOD_NAME = "build";
    private static final String BUILDER_CLASS_POSTFIX = "Builder";
    private static Map<String, String> SHORTHANDS;
    private static final Object VOID;
    private final String src;
    private final Class expectedClass;
    private final boolean allowNull;
    private final _SettingEvaluationEnvironment env;
    private int pos;
    private boolean modernMode = false;

    private _ObjectBuilderSettingEvaluator(String src, int pos, Class expectedClass, boolean allowNull, _SettingEvaluationEnvironment env) {
        this.src = src;
        this.pos = pos;
        this.expectedClass = expectedClass;
        this.allowNull = allowNull;
        this.env = env;
    }

    public static Object eval(String src, Class expectedClass, boolean allowNull, _SettingEvaluationEnvironment env) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new _ObjectBuilderSettingEvaluator(src, 0, expectedClass, allowNull, env).eval();
    }

    public static int configureBean(String argumentListSrc, int posAfterOpenParen, Object bean, _SettingEvaluationEnvironment env) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new _ObjectBuilderSettingEvaluator(argumentListSrc, posAfterOpenParen, bean.getClass(), true, env).configureBean(bean);
    }

    private Object eval() throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object value;
        this.skipWS();
        try {
            value = this.ensureEvaled(this.fetchValue(false, true, false, true));
        }
        catch (LegacyExceptionWrapperSettingEvaluationExpression e2) {
            e2.rethrowLegacy();
            value = null;
        }
        this.skipWS();
        if (this.pos != this.src.length()) {
            throw new _ObjectBuilderSettingEvaluationException("end-of-expression", this.src, this.pos);
        }
        if (value == null && !this.allowNull) {
            throw new _ObjectBuilderSettingEvaluationException("Value can't be null.");
        }
        if (value != null && !this.expectedClass.isInstance(value)) {
            throw new _ObjectBuilderSettingEvaluationException("The resulting object (of class " + value.getClass() + ") is not a(n) " + this.expectedClass.getName() + ".");
        }
        return value;
    }

    private int configureBean(Object bean) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        PropertyAssignmentsExpression propAssignments = new PropertyAssignmentsExpression(bean);
        this.fetchParameterListInto(propAssignments);
        this.skipWS();
        propAssignments.eval();
        return this.pos;
    }

    private Object ensureEvaled(Object value) throws _ObjectBuilderSettingEvaluationException {
        return value instanceof SettingExpression ? ((SettingExpression)value).eval() : value;
    }

    private Object fetchBuilderCall(boolean optional, boolean topLevel) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        BuilderCallExpression exp = new BuilderCallExpression();
        exp.canBeStaticField = true;
        String fetchedClassName = this.fetchClassName(optional);
        if (fetchedClassName == null) {
            if (!optional) {
                throw new _ObjectBuilderSettingEvaluationException("class name", this.src, this.pos);
            }
            return VOID;
        }
        exp.className = _ObjectBuilderSettingEvaluator.shorthandToFullQualified(fetchedClassName);
        if (!fetchedClassName.equals(exp.className)) {
            this.modernMode = true;
            exp.canBeStaticField = false;
        }
        this.skipWS();
        char openParen = this.fetchOptionalChar("(");
        if (openParen == '\u0000' && !topLevel) {
            if (fetchedClassName.indexOf(46) != -1) {
                exp.mustBeStaticField = true;
            } else {
                this.pos = startPos;
                return VOID;
            }
        }
        if (openParen != '\u0000') {
            this.fetchParameterListInto(exp);
            exp.canBeStaticField = false;
        }
        return exp;
    }

    private void fetchParameterListInto(ExpressionWithParameters exp) throws _ObjectBuilderSettingEvaluationException {
        this.modernMode = true;
        this.skipWS();
        if (this.fetchOptionalChar(")") != ')') {
            do {
                this.skipWS();
                Object paramNameOrValue = this.fetchValue(false, false, true, false);
                if (paramNameOrValue == VOID) continue;
                this.skipWS();
                if (paramNameOrValue instanceof Name) {
                    exp.namedParamNames.add(((Name)paramNameOrValue).name);
                    this.skipWS();
                    this.fetchRequiredChar("=");
                    this.skipWS();
                    Object paramValue = this.fetchValue(false, false, true, true);
                    exp.namedParamValues.add(this.ensureEvaled(paramValue));
                } else {
                    if (!exp.namedParamNames.isEmpty()) {
                        throw new _ObjectBuilderSettingEvaluationException("Positional parameters must precede named parameters");
                    }
                    if (!exp.getAllowPositionalParameters()) {
                        throw new _ObjectBuilderSettingEvaluationException("Positional parameters not supported here");
                    }
                    exp.positionalParamValues.add(this.ensureEvaled(paramNameOrValue));
                }
                this.skipWS();
            } while (this.fetchRequiredChar(",)") == ',');
        }
    }

    private Object fetchValue(boolean optional, boolean topLevel, boolean resultCoerced, boolean resolveVariables) throws _ObjectBuilderSettingEvaluationException {
        if (this.pos < this.src.length()) {
            Object val = this.fetchNumberLike(true, resultCoerced);
            if (val != VOID) {
                return val;
            }
            val = this.fetchStringLiteral(true);
            if (val != VOID) {
                return val;
            }
            val = this.fetchListLiteral(true);
            if (val != VOID) {
                return val;
            }
            val = this.fetchMapLiteral(true);
            if (val != VOID) {
                return val;
            }
            val = this.fetchBuilderCall(true, topLevel);
            if (val != VOID) {
                return val;
            }
            String name = this.fetchSimpleName(true);
            if (name != null) {
                val = this.keywordToValueOrVoid(name);
                if (val != VOID) {
                    return val;
                }
                if (resolveVariables) {
                    throw new _ObjectBuilderSettingEvaluationException("Can't resolve variable reference: " + name);
                }
                return new Name(name);
            }
        }
        if (optional) {
            return VOID;
        }
        throw new _ObjectBuilderSettingEvaluationException("value or name", this.src, this.pos);
    }

    private boolean isKeyword(String name) {
        return this.keywordToValueOrVoid(name) != VOID;
    }

    private Object keywordToValueOrVoid(String name) {
        if (name.equals("true")) {
            return Boolean.TRUE;
        }
        if (name.equals("false")) {
            return Boolean.FALSE;
        }
        if (name.equals("null")) {
            return null;
        }
        return VOID;
    }

    private String fetchSimpleName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        char c2;
        char c3 = c2 = this.pos < this.src.length() ? this.src.charAt(this.pos) : (char)'\u0000';
        if (!this.isIdentifierStart(c2)) {
            if (optional) {
                return null;
            }
            throw new _ObjectBuilderSettingEvaluationException("class name", this.src, this.pos);
        }
        int startPos = this.pos++;
        while (this.pos != this.src.length() && this.isIdentifierMiddle(c2 = this.src.charAt(this.pos))) {
            ++this.pos;
        }
        return this.src.substring(startPos, this.pos);
    }

    private String fetchClassName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        StringBuilder sb = new StringBuilder();
        while (true) {
            String name;
            if ((name = this.fetchSimpleName(true)) == null) {
                if (!optional) {
                    throw new _ObjectBuilderSettingEvaluationException("name", this.src, this.pos);
                }
                this.pos = startPos;
                return null;
            }
            sb.append(name);
            this.skipWS();
            if (this.pos >= this.src.length() || this.src.charAt(this.pos) != '.') break;
            sb.append('.');
            ++this.pos;
            this.skipWS();
        }
        String className = sb.toString();
        if (this.isKeyword(className)) {
            this.pos = startPos;
            return null;
        }
        return className;
    }

    private Object fetchNumberLike(boolean optional, boolean resultCoerced) throws _ObjectBuilderSettingEvaluationException {
        char c2;
        int startPos = this.pos;
        boolean isVersion = false;
        boolean hasDot = false;
        while (this.pos != this.src.length()) {
            char c3 = this.src.charAt(this.pos);
            if (c3 == '.') {
                if (hasDot) {
                    isVersion = true;
                } else {
                    hasDot = true;
                }
            } else if (!this.isASCIIDigit(c3) && c3 != '-') break;
            ++this.pos;
        }
        if (startPos == this.pos) {
            if (optional) {
                return VOID;
            }
            throw new _ObjectBuilderSettingEvaluationException("number-like", this.src, this.pos);
        }
        String numStr = this.src.substring(startPos, this.pos);
        if (isVersion) {
            try {
                return new Version(numStr);
            }
            catch (IllegalArgumentException e2) {
                throw new _ObjectBuilderSettingEvaluationException("Malformed version number: " + numStr, e2);
            }
        }
        String typePostfix = null;
        while (this.pos != this.src.length() && Character.isLetter(c2 = this.src.charAt(this.pos))) {
            typePostfix = typePostfix == null ? String.valueOf(c2) : typePostfix + c2;
            ++this.pos;
        }
        try {
            if (numStr.endsWith(".")) {
                throw new NumberFormatException("A number can't end with a dot");
            }
            if (numStr.startsWith(".") || numStr.startsWith("-.") || numStr.startsWith("+.")) {
                throw new NumberFormatException("A number can't start with a dot");
            }
            if (typePostfix == null) {
                if (numStr.indexOf(46) == -1) {
                    BigInteger biNum = new BigInteger(numStr);
                    int bitLength = biNum.bitLength();
                    if (bitLength <= 31) {
                        return biNum.intValue();
                    }
                    if (bitLength <= 63) {
                        return biNum.longValue();
                    }
                    return biNum;
                }
                if (resultCoerced) {
                    return new BigDecimal(numStr);
                }
                return Double.valueOf(numStr);
            }
            if (typePostfix.equalsIgnoreCase("l")) {
                return Long.valueOf(numStr);
            }
            if (typePostfix.equalsIgnoreCase("bi")) {
                return new BigInteger(numStr);
            }
            if (typePostfix.equalsIgnoreCase("bd")) {
                return new BigDecimal(numStr);
            }
            if (typePostfix.equalsIgnoreCase("d")) {
                return Double.valueOf(numStr);
            }
            if (typePostfix.equalsIgnoreCase("f")) {
                return Float.valueOf(numStr);
            }
            throw new _ObjectBuilderSettingEvaluationException("Unrecognized number type postfix: " + typePostfix);
        }
        catch (NumberFormatException e3) {
            throw new _ObjectBuilderSettingEvaluationException("Malformed number: " + numStr, e3);
        }
    }

    private Object fetchStringLiteral(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        int q2 = 0;
        boolean afterEscape = false;
        boolean raw = false;
        while (true) {
            if (this.pos == this.src.length()) {
                if (q2 == 0) break;
                throw new _ObjectBuilderSettingEvaluationException(String.valueOf((char)q2), this.src, this.pos);
            }
            int c2 = this.src.charAt(this.pos);
            if (q2 == 0) {
                if (c2 == 114 && this.pos + 1 < this.src.length()) {
                    raw = true;
                    c2 = this.src.charAt(this.pos + 1);
                }
                if (c2 == 39) {
                    q2 = 39;
                } else {
                    if (c2 != 34) break;
                    q2 = 34;
                }
                if (raw) {
                    ++this.pos;
                }
            } else if (!afterEscape) {
                if (c2 == 92 && !raw) {
                    afterEscape = true;
                } else {
                    char prevC;
                    if (c2 == q2) break;
                    if (c2 == 123 && ((prevC = this.src.charAt(this.pos - 1)) == '$' || prevC == '#')) {
                        throw new _ObjectBuilderSettingEvaluationException("${...} and #{...} aren't allowed here.");
                    }
                }
            } else {
                afterEscape = false;
            }
            ++this.pos;
        }
        if (startPos == this.pos) {
            if (optional) {
                return VOID;
            }
            throw new _ObjectBuilderSettingEvaluationException("string literal", this.src, this.pos);
        }
        String sInside = this.src.substring(startPos + (raw ? 2 : 1), this.pos);
        try {
            ++this.pos;
            return raw ? sInside : StringUtil.FTLStringLiteralDec(sInside);
        }
        catch (ParseException e2) {
            throw new _ObjectBuilderSettingEvaluationException("Malformed string literal: " + sInside, e2);
        }
    }

    private Object fetchListLiteral(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        if (this.pos == this.src.length() || this.src.charAt(this.pos) != '[') {
            if (!optional) {
                throw new _ObjectBuilderSettingEvaluationException("[", this.src, this.pos);
            }
            return VOID;
        }
        ++this.pos;
        ListExpression listExp = new ListExpression();
        while (true) {
            this.skipWS();
            if (this.fetchOptionalChar("]") != '\u0000') {
                return listExp;
            }
            if (listExp.itemCount() != 0) {
                this.fetchRequiredChar(",");
                this.skipWS();
            }
            listExp.addItem(this.fetchValue(false, false, false, true));
            this.skipWS();
        }
    }

    private Object fetchMapLiteral(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        if (this.pos == this.src.length() || this.src.charAt(this.pos) != '{') {
            if (!optional) {
                throw new _ObjectBuilderSettingEvaluationException("{", this.src, this.pos);
            }
            return VOID;
        }
        ++this.pos;
        MapExpression mapExp = new MapExpression();
        while (true) {
            this.skipWS();
            if (this.fetchOptionalChar("}") != '\u0000') {
                return mapExp;
            }
            if (mapExp.itemCount() != 0) {
                this.fetchRequiredChar(",");
                this.skipWS();
            }
            Object key2 = this.fetchValue(false, false, false, true);
            this.skipWS();
            this.fetchRequiredChar(":");
            this.skipWS();
            Object value = this.fetchValue(false, false, false, true);
            mapExp.addItem(new KeyValuePair(key2, value));
            this.skipWS();
        }
    }

    private void skipWS() {
        while (this.pos != this.src.length()) {
            char c2 = this.src.charAt(this.pos);
            if (!Character.isWhitespace(c2)) {
                return;
            }
            ++this.pos;
        }
        return;
    }

    private char fetchOptionalChar(String expectedChars) throws _ObjectBuilderSettingEvaluationException {
        return this.fetchChar(expectedChars, true);
    }

    private char fetchRequiredChar(String expectedChars) throws _ObjectBuilderSettingEvaluationException {
        return this.fetchChar(expectedChars, false);
    }

    private char fetchChar(String expectedChars, boolean optional) throws _ObjectBuilderSettingEvaluationException {
        char c2;
        char c3 = c2 = this.pos < this.src.length() ? this.src.charAt(this.pos) : (char)'\u0000';
        if (expectedChars.indexOf(c2) != -1) {
            ++this.pos;
            return c2;
        }
        if (optional) {
            return '\u0000';
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < expectedChars.length(); ++i2) {
            if (i2 != 0) {
                sb.append(" or ");
            }
            sb.append(StringUtil.jQuote(expectedChars.substring(i2, i2 + 1)));
        }
        throw new _ObjectBuilderSettingEvaluationException(sb.toString(), this.src, this.pos);
    }

    private boolean isASCIIDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private boolean isIdentifierStart(char c2) {
        return Character.isLetter(c2) || c2 == '_' || c2 == '$';
    }

    private boolean isIdentifierMiddle(char c2) {
        return this.isIdentifierStart(c2) || this.isASCIIDigit(c2);
    }

    private static synchronized String shorthandToFullQualified(String className) {
        String fullClassName;
        if (SHORTHANDS == null) {
            SHORTHANDS = new HashMap<String, String>();
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, DefaultObjectWrapper.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, BeansWrapper.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, SimpleObjectWrapper.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, TemplateConfiguration.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, PathGlobMatcher.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, FileNameGlobMatcher.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, FileExtensionMatcher.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, PathRegexMatcher.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, AndMatcher.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, OrMatcher.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, NotMatcher.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, ConditionalTemplateConfigurationFactory.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, MergingTemplateConfigurationFactory.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, FirstMatchTemplateConfigurationFactory.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, HTMLOutputFormat.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, XHTMLOutputFormat.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, XMLOutputFormat.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, RTFOutputFormat.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, PlainTextOutputFormat.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, UndefinedOutputFormat.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, DefaultTruncateBuiltinAlgorithm.class);
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, Locale.class);
            SHORTHANDS.put("TimeZone", "freemarker.core._TimeZone");
            SHORTHANDS.put("markup", "freemarker.core._Markup");
            _ObjectBuilderSettingEvaluator.addWithSimpleName(SHORTHANDS, Configuration.class);
        }
        return (fullClassName = SHORTHANDS.get(className)) == null ? className : fullClassName;
    }

    private static void addWithSimpleName(Map map2, Class<?> pClass) {
        map2.put(pClass.getSimpleName(), pClass.getName());
    }

    private void setJavaBeanProperties(Object bean, List namedParamNames, List namedParamValues) throws _ObjectBuilderSettingEvaluationException {
        int i2;
        HashMap<String, Method> beanPropSetters;
        if (namedParamNames.isEmpty()) {
            return;
        }
        Class<?> cl = bean.getClass();
        try {
            PropertyDescriptor[] propDescs = Introspector.getBeanInfo(cl).getPropertyDescriptors();
            beanPropSetters = new HashMap<String, Method>(propDescs.length * 4 / 3, 1.0f);
            for (i2 = 0; i2 < propDescs.length; ++i2) {
                PropertyDescriptor propDesc = propDescs[i2];
                Method writeMethod = propDesc.getWriteMethod();
                if (writeMethod == null) continue;
                beanPropSetters.put(propDesc.getName(), writeMethod);
            }
        }
        catch (Exception e2) {
            throw new _ObjectBuilderSettingEvaluationException("Failed to inspect " + cl.getName() + " class", e2);
        }
        TemplateHashModel beanTM = null;
        for (i2 = 0; i2 < namedParamNames.size(); ++i2) {
            String name = (String)namedParamNames.get(i2);
            if (!beanPropSetters.containsKey(name)) {
                throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " class has no writeable JavaBeans property called " + StringUtil.jQuote(name) + ".");
            }
            Method beanPropSetter = beanPropSetters.put(name, null);
            if (beanPropSetter == null) {
                throw new _ObjectBuilderSettingEvaluationException("JavaBeans property " + StringUtil.jQuote(name) + " is set twice.");
            }
            try {
                TemplateModel m2;
                if (beanTM == null) {
                    TemplateModel wrappedObj = this.env.getObjectWrapper().wrap(bean);
                    if (!(wrappedObj instanceof TemplateHashModel)) {
                        throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " class is not a wrapped as TemplateHashModel.");
                    }
                    beanTM = (TemplateHashModel)wrappedObj;
                }
                if ((m2 = beanTM.get(beanPropSetter.getName())) == null) {
                    throw new _ObjectBuilderSettingEvaluationException("Can't find " + beanPropSetter + " as FreeMarker method.");
                }
                if (!(m2 instanceof TemplateMethodModelEx)) {
                    throw new _ObjectBuilderSettingEvaluationException(StringUtil.jQuote(beanPropSetter.getName()) + " wasn't a TemplateMethodModelEx.");
                }
                ArrayList<TemplateModel> args2 = new ArrayList<TemplateModel>();
                args2.add(this.env.getObjectWrapper().wrap(namedParamValues.get(i2)));
                ((TemplateMethodModelEx)m2).exec(args2);
                continue;
            }
            catch (Exception e3) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to set " + StringUtil.jQuote(name), e3);
            }
        }
    }

    static {
        VOID = new Object();
    }

    private static class LegacyExceptionWrapperSettingEvaluationExpression
    extends _ObjectBuilderSettingEvaluationException {
        public LegacyExceptionWrapperSettingEvaluationExpression(Throwable cause) {
            super("Legacy operation failed", cause);
            if (!(cause instanceof ClassNotFoundException || cause instanceof InstantiationException || cause instanceof IllegalAccessException)) {
                throw new IllegalArgumentException();
            }
        }

        public void rethrowLegacy() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            Throwable cause = this.getCause();
            if (cause instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw new BugException();
        }
    }

    private class PropertyAssignmentsExpression
    extends ExpressionWithParameters {
        private final Object bean;

        public PropertyAssignmentsExpression(Object bean) {
            this.bean = bean;
        }

        @Override
        Object eval() throws _ObjectBuilderSettingEvaluationException {
            _ObjectBuilderSettingEvaluator.this.setJavaBeanProperties(this.bean, this.namedParamNames, this.namedParamValues);
            return this.bean;
        }

        @Override
        protected boolean getAllowPositionalParameters() {
            return false;
        }
    }

    private class BuilderCallExpression
    extends ExpressionWithParameters {
        private String className;
        private boolean canBeStaticField;
        private boolean mustBeStaticField;

        private BuilderCallExpression() {
        }

        @Override
        Object eval() throws _ObjectBuilderSettingEvaluationException {
            Object result2;
            boolean clIsBuilderClass;
            Class cl;
            if (this.mustBeStaticField) {
                if (!this.canBeStaticField) {
                    throw new BugException();
                }
                return this.getStaticFieldValue(this.className);
            }
            if (!_ObjectBuilderSettingEvaluator.this.modernMode) {
                try {
                    try {
                        return ClassUtil.forName(this.className).newInstance();
                    }
                    catch (InstantiationException e2) {
                        throw new LegacyExceptionWrapperSettingEvaluationExpression(e2);
                    }
                    catch (IllegalAccessException e3) {
                        throw new LegacyExceptionWrapperSettingEvaluationExpression(e3);
                    }
                    catch (ClassNotFoundException e4) {
                        throw new LegacyExceptionWrapperSettingEvaluationExpression(e4);
                    }
                }
                catch (LegacyExceptionWrapperSettingEvaluationExpression e5) {
                    if (!this.canBeStaticField || this.className.indexOf(46) == -1) {
                        throw e5;
                    }
                    try {
                        return this.getStaticFieldValue(this.className);
                    }
                    catch (_ObjectBuilderSettingEvaluationException e2) {
                        throw e5;
                    }
                }
            }
            try {
                cl = ClassUtil.forName(this.className + _ObjectBuilderSettingEvaluator.BUILDER_CLASS_POSTFIX);
                clIsBuilderClass = true;
            }
            catch (ClassNotFoundException e6) {
                clIsBuilderClass = false;
                try {
                    cl = ClassUtil.forName(this.className);
                }
                catch (Exception e2) {
                    boolean failedToGetAsStaticField;
                    if (this.canBeStaticField) {
                        try {
                            return this.getStaticFieldValue(this.className);
                        }
                        catch (_ObjectBuilderSettingEvaluationException e3) {
                            failedToGetAsStaticField = true;
                        }
                    } else {
                        failedToGetAsStaticField = false;
                    }
                    throw new _ObjectBuilderSettingEvaluationException("Failed to get class " + StringUtil.jQuote(this.className) + (failedToGetAsStaticField ? " (also failed to resolve name as static field)" : "") + ".", e2);
                }
            }
            if (!clIsBuilderClass && this.hasNoParameters()) {
                try {
                    Field f2 = cl.getField(_ObjectBuilderSettingEvaluator.INSTANCE_FIELD_NAME);
                    if ((f2.getModifiers() & 9) == 9) {
                        return f2.get(null);
                    }
                }
                catch (NoSuchFieldException f2) {
                }
                catch (Exception e7) {
                    throw new _ObjectBuilderSettingEvaluationException("Error when trying to access " + StringUtil.jQuote(this.className) + "." + _ObjectBuilderSettingEvaluator.INSTANCE_FIELD_NAME, e7);
                }
            }
            Object constructorResult = this.callConstructor(cl);
            _ObjectBuilderSettingEvaluator.this.setJavaBeanProperties(constructorResult, this.namedParamNames, this.namedParamValues);
            if (clIsBuilderClass) {
                result2 = this.callBuild(constructorResult);
            } else {
                if (constructorResult instanceof WriteProtectable) {
                    ((WriteProtectable)constructorResult).writeProtect();
                }
                result2 = constructorResult;
            }
            return result2;
        }

        private Object getStaticFieldValue(String dottedName) throws _ObjectBuilderSettingEvaluationException {
            Field field2;
            Class cl;
            int lastDotIdx = dottedName.lastIndexOf(46);
            if (lastDotIdx == -1) {
                throw new IllegalArgumentException();
            }
            String className = _ObjectBuilderSettingEvaluator.shorthandToFullQualified(dottedName.substring(0, lastDotIdx));
            String fieldName = dottedName.substring(lastDotIdx + 1);
            try {
                cl = ClassUtil.forName(className);
            }
            catch (Exception e2) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get field's parent class, " + StringUtil.jQuote(className) + ".", e2);
            }
            try {
                field2 = cl.getField(fieldName);
            }
            catch (Exception e3) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get field " + StringUtil.jQuote(fieldName) + " from class " + StringUtil.jQuote(className) + ".", e3);
            }
            if ((field2.getModifiers() & 8) == 0) {
                throw new _ObjectBuilderSettingEvaluationException("Referred field isn't static: " + field2);
            }
            if ((field2.getModifiers() & 1) == 0) {
                throw new _ObjectBuilderSettingEvaluationException("Referred field isn't public: " + field2);
            }
            if (field2.getName().equals(_ObjectBuilderSettingEvaluator.INSTANCE_FIELD_NAME)) {
                throw new _ObjectBuilderSettingEvaluationException("The INSTANCE field is only accessible through pseudo-constructor call: " + className + "()");
            }
            try {
                return field2.get(null);
            }
            catch (Exception e4) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get field value: " + field2, e4);
            }
        }

        private Object callConstructor(Class cl) throws _ObjectBuilderSettingEvaluationException {
            if (this.hasNoParameters()) {
                try {
                    return cl.newInstance();
                }
                catch (Exception e2) {
                    throw new _ObjectBuilderSettingEvaluationException("Failed to call " + cl.getName() + " 0-argument constructor", e2);
                }
            }
            BeansWrapper ow = _ObjectBuilderSettingEvaluator.this.env.getObjectWrapper();
            ArrayList<TemplateModel> tmArgs = new ArrayList<TemplateModel>(this.positionalParamValues.size());
            for (int i2 = 0; i2 < this.positionalParamValues.size(); ++i2) {
                try {
                    tmArgs.add(ow.wrap(this.positionalParamValues.get(i2)));
                    continue;
                }
                catch (TemplateModelException e3) {
                    throw new _ObjectBuilderSettingEvaluationException("Failed to wrap arg #" + (i2 + 1), e3);
                }
            }
            try {
                return ow.newInstance(cl, tmArgs);
            }
            catch (Exception e4) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to call " + cl.getName() + " constructor", e4);
            }
        }

        private Object callBuild(Object constructorResult) throws _ObjectBuilderSettingEvaluationException {
            Method buildMethod;
            Class<?> cl = constructorResult.getClass();
            try {
                buildMethod = constructorResult.getClass().getMethod(_ObjectBuilderSettingEvaluator.BUILD_METHOD_NAME, null);
            }
            catch (NoSuchMethodException e2) {
                throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " builder class must have a public " + _ObjectBuilderSettingEvaluator.BUILD_METHOD_NAME + "() method", e2);
            }
            catch (Exception e3) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get the build() method of the " + cl.getName() + " builder class", e3);
            }
            try {
                return buildMethod.invoke(constructorResult, (Object[])null);
            }
            catch (Exception e4) {
                Throwable cause = e4 instanceof InvocationTargetException ? ((InvocationTargetException)e4).getTargetException() : e4;
                throw new _ObjectBuilderSettingEvaluationException("Failed to call build() method on " + cl.getName() + " instance", cause);
            }
        }

        private boolean hasNoParameters() {
            return this.positionalParamValues.isEmpty() && this.namedParamValues.isEmpty();
        }

        @Override
        protected boolean getAllowPositionalParameters() {
            return true;
        }
    }

    private static class KeyValuePair {
        private final Object key;
        private final Object value;

        public KeyValuePair(Object key2, Object value) {
            this.key = key2;
            this.value = value;
        }
    }

    private class MapExpression
    extends SettingExpression {
        private List<KeyValuePair> items;

        private MapExpression() {
            this.items = new ArrayList<KeyValuePair>();
        }

        void addItem(KeyValuePair item2) {
            this.items.add(item2);
        }

        public int itemCount() {
            return this.items.size();
        }

        @Override
        Object eval() throws _ObjectBuilderSettingEvaluationException {
            LinkedHashMap<Object, Object> res = new LinkedHashMap<Object, Object>(this.items.size() * 4 / 3, 1.0f);
            for (KeyValuePair item2 : this.items) {
                Object key2 = _ObjectBuilderSettingEvaluator.this.ensureEvaled(item2.key);
                if (key2 == null) {
                    throw new _ObjectBuilderSettingEvaluationException("Map can't use null as key.");
                }
                res.put(key2, _ObjectBuilderSettingEvaluator.this.ensureEvaled(item2.value));
            }
            return res;
        }
    }

    private class ListExpression
    extends SettingExpression {
        private List<Object> items;

        private ListExpression() {
            this.items = new ArrayList<Object>();
        }

        void addItem(Object item2) {
            this.items.add(item2);
        }

        public int itemCount() {
            return this.items.size();
        }

        @Override
        Object eval() throws _ObjectBuilderSettingEvaluationException {
            ArrayList<Object> res = new ArrayList<Object>(this.items.size());
            for (Object item2 : this.items) {
                res.add(_ObjectBuilderSettingEvaluator.this.ensureEvaled(item2));
            }
            return res;
        }
    }

    private abstract class ExpressionWithParameters
    extends SettingExpression {
        protected List positionalParamValues;
        protected List namedParamNames;
        protected List namedParamValues;

        private ExpressionWithParameters() {
            this.positionalParamValues = new ArrayList();
            this.namedParamNames = new ArrayList();
            this.namedParamValues = new ArrayList();
        }

        protected abstract boolean getAllowPositionalParameters();
    }

    private static abstract class SettingExpression {
        private SettingExpression() {
        }

        abstract Object eval() throws _ObjectBuilderSettingEvaluationException;
    }

    private static class Name {
        private final String name;

        public Name(String name) {
            this.name = name;
        }
    }
}

