/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class DigitalDisplay
extends Composite {
    static final Logger log = Logger.getLogger(DigitalDisplay.class.getName());
    CLabel textDigitalLabel;
    CLabel actualDigitalLabel;
    CLabel maxDigitalLabel;
    CLabel minDigitalLabel;
    Composite minMaxComposite;
    static int fontSize = 50;
    final DataExplorer application;
    final Channels channels;
    final String recordKey;
    final IDevice device;
    final Color backgroundColor;
    final Menu popupmenu;
    final TabAreaContextMenu contextMenu;

    public DigitalDisplay(DataExplorer currentApplication, Composite digitalWindow, String currentRecordKey, IDevice currentDevice) {
        super(digitalWindow, 2048);
        FillLayout digitalComposite1Layout = new FillLayout(512);
        this.setLayout((Layout)digitalComposite1Layout);
        this.recordKey = currentRecordKey;
        this.device = currentDevice;
        this.application = currentApplication;
        this.channels = Channels.getInstance();
        this.backgroundColor = Settings.getInstance().getDigitalInnerAreaBackground();
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
        this.contextMenu.createMenu(this.popupmenu, TabAreaContextMenu.TabMenuType.DIGITAL);
    }

    public void create() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                Record record;
                RecordSet activeRecordSet;
                Channel activeChannel;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "digitalLabel.paintControl, event=" + String.valueOf(evt));
                }
                if ((activeChannel = DigitalDisplay.this.channels.getActiveChannel()) != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && (record = activeRecordSet.get(DigitalDisplay.this.recordKey)) != null && record.size() > 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "update label for " + DigitalDisplay.this.recordKey);
                    }
                    DigitalDisplay.this.textDigitalLabel.setText(activeRecordSet.get(DigitalDisplay.this.recordKey).getName() + " [ " + activeRecordSet.get(DigitalDisplay.this.recordKey).getUnit() + " ]");
                    String actualValue = record.getFormattedStatisticsValue((double)((Integer)record.lastElement()).intValue() / 1000.0);
                    String maxValue = Messages.getString("GDE_MSGT0236") + record.getFormattedStatisticsValue((double)record.getMaxValue() / 1000.0);
                    String minValue = Messages.getString("GDE_MSGT0237") + record.getFormattedStatisticsValue((double)record.getMinValue() / 1000.0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, DigitalDisplay.this.recordKey + " actualValue=" + actualValue + " maxValue=" + maxValue + " minValue=" + minValue);
                    }
                    DigitalDisplay.this.actualDigitalLabel.setForeground(SWTResourceManager.getColor(record.getRGB()));
                    DigitalDisplay.this.actualDigitalLabel.setText(actualValue);
                    DigitalDisplay.this.maxDigitalLabel.setText(maxValue);
                    DigitalDisplay.this.minDigitalLabel.setText(minValue);
                }
            }
        });
        this.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "DigitalDisplay.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_7.html");
            }
        });
        this.textDigitalLabel = new CLabel((Composite)this, 0x1000000);
        this.textDigitalLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 4, 1));
        this.textDigitalLabel.setBackground(this.backgroundColor);
        this.textDigitalLabel.setMenu(this.popupmenu);
        this.textDigitalLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                Record record;
                RecordSet activeRecordSet;
                Channel activeChannel;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "digitalLabel.paintControl, event=" + String.valueOf(evt));
                }
                if ((activeChannel = DigitalDisplay.this.channels.getActiveChannel()) != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && (record = activeRecordSet.get(DigitalDisplay.this.recordKey)) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "update label for " + DigitalDisplay.this.recordKey);
                    }
                    DigitalDisplay.this.textDigitalLabel.setText(activeRecordSet.get(DigitalDisplay.this.recordKey).getName() + " [ " + activeRecordSet.get(DigitalDisplay.this.recordKey).getUnit() + " ]");
                }
            }
        });
        this.actualDigitalLabel = new CLabel((Composite)this, 0x1000000);
        this.actualDigitalLabel.setBackground(this.backgroundColor);
        this.actualDigitalLabel.setText("00,00");
        this.actualDigitalLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + fontSize, 0));
        this.actualDigitalLabel.setMenu(this.popupmenu);
        this.actualDigitalLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                Record record;
                RecordSet activeRecordSet;
                Channel activeChannel;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "digitalLabel.paintControl, event=" + String.valueOf(evt));
                }
                if ((activeChannel = DigitalDisplay.this.channels.getActiveChannel()) != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && (record = activeRecordSet.get(DigitalDisplay.this.recordKey)) != null && record.size() > 0) {
                    String actualValue = record.getFormattedStatisticsValue((double)((Integer)record.lastElement()).intValue() / 1000.0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, DigitalDisplay.this.recordKey + " actualValue=" + actualValue);
                    }
                    DigitalDisplay.this.actualDigitalLabel.setForeground(SWTResourceManager.getColor(record.getRGB()));
                    DigitalDisplay.this.actualDigitalLabel.setText(actualValue);
                }
            }
        });
        this.minMaxComposite = new Composite((Composite)this, 0);
        FillLayout digitalComposite1Layout = new FillLayout(256);
        this.minMaxComposite.setLayout((Layout)digitalComposite1Layout);
        this.minDigitalLabel = new CLabel(this.minMaxComposite, 0x1000000);
        this.minDigitalLabel.setText("MIN : 00,00");
        this.minDigitalLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 2, 1));
        this.minDigitalLabel.setBackground(this.backgroundColor);
        this.minDigitalLabel.setMenu(this.popupmenu);
        this.minDigitalLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                Record record;
                RecordSet activeRecordSet;
                Channel activeChannel;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "digitalLabel.paintControl, event=" + String.valueOf(evt));
                }
                if ((activeChannel = DigitalDisplay.this.channels.getActiveChannel()) != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && (record = activeRecordSet.get(DigitalDisplay.this.recordKey)) != null && record.size() > 0) {
                    String minValue = Messages.getString("GDE_MSGT0237") + record.getFormattedStatisticsValue((double)record.getMinValue() / 1000.0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, DigitalDisplay.this.recordKey + " minValue=" + minValue);
                    }
                    DigitalDisplay.this.minDigitalLabel.setText(minValue);
                }
            }
        });
        this.maxDigitalLabel = new CLabel(this.minMaxComposite, 0x1000000);
        this.maxDigitalLabel.setText("MAX : 00,00");
        this.maxDigitalLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 2, 1));
        this.maxDigitalLabel.setBackground(this.backgroundColor);
        this.maxDigitalLabel.setMenu(this.popupmenu);
        this.maxDigitalLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                Record record;
                RecordSet activeRecordSet;
                Channel activeChannel;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "digitalLabel.paintControl, event=" + String.valueOf(evt));
                }
                if ((activeChannel = DigitalDisplay.this.channels.getActiveChannel()) != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && (record = activeRecordSet.get(DigitalDisplay.this.recordKey)) != null && record.size() > 0) {
                    String maxValue = Messages.getString("GDE_MSGT0236") + record.getFormattedStatisticsValue((double)record.getMaxValue() / 1000.0);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, DigitalDisplay.this.recordKey + " maxValue=" + maxValue);
                    }
                    DigitalDisplay.this.maxDigitalLabel.setText(maxValue);
                }
            }
        });
    }

    public void redawDisplay() {
        this.actualDigitalLabel.redraw();
        this.minDigitalLabel.redraw();
        this.maxDigitalLabel.redraw();
    }

    public void setFontSize(int newFontSize) {
        fontSize = newFontSize;
    }
}

