/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.itextpdf.text.pdf.BaseFont;
import java.awt.Rectangle;
import org.xhtmlrenderer.extend.FSGlyphVector;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.ITextFSFontMetrics;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.JustificationInfo;

public class ITextTextRenderer
implements TextRenderer {
    private static float TEXT_MEASURING_DELTA = 0.01f;

    @Override
    public void setup(FontContext context) {
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string2, float x2, float y2) {
        ((ITextOutputDevice)outputDevice).drawString(string2, x2, y2, null);
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string2, float x2, float y2, JustificationInfo info) {
        ((ITextOutputDevice)outputDevice).drawString(string2, x2, y2, info);
    }

    @Override
    public FSFontMetrics getFSFontMetrics(FontContext context, FSFont font, String string2) {
        ITextFontResolver.FontDescription descr = ((ITextFSFont)font).getFontDescription();
        BaseFont bf = descr.getFont();
        float size = font.getSize2D();
        ITextFSFontMetrics result2 = new ITextFSFontMetrics();
        result2.setAscent(bf.getFontDescriptor(8, size));
        result2.setDescent(-bf.getFontDescriptor(6, size));
        result2.setStrikethroughOffset(-descr.getYStrikeoutPosition() / 1000.0f * size);
        if (descr.getYStrikeoutSize() != 0.0f) {
            result2.setStrikethroughThickness(descr.getYStrikeoutSize() / 1000.0f * size);
        } else {
            result2.setStrikethroughThickness(size / 12.0f);
        }
        result2.setUnderlineOffset(-descr.getUnderlinePosition() / 1000.0f * size);
        result2.setUnderlineThickness(descr.getUnderlineThickness() / 1000.0f * size);
        return result2;
    }

    @Override
    public int getWidth(FontContext context, FSFont font, String string2) {
        BaseFont bf = ((ITextFSFont)font).getFontDescription().getFont();
        float result2 = bf.getWidthPoint(string2, font.getSize2D());
        if ((double)result2 - Math.floor(result2) < (double)TEXT_MEASURING_DELTA) {
            return (int)result2;
        }
        return (int)Math.ceil(result2);
    }

    @Override
    public void setFontScale(float scale2) {
    }

    @Override
    public float getFontScale() {
        return 1.0f;
    }

    @Override
    public void setSmoothingThreshold(float fontsize) {
    }

    @Override
    public int getSmoothingLevel() {
        return 0;
    }

    @Override
    public void setSmoothingLevel(int level) {
    }

    @Override
    public Rectangle getGlyphBounds(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector, int index, float x2, float y2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[] getGlyphPositions(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FSGlyphVector getGlyphVector(OutputDevice outputDevice, FSFont font, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawGlyphVector(OutputDevice outputDevice, FSGlyphVector vector, float x2, float y2) {
        throw new UnsupportedOperationException();
    }
}

