/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitHistogram
implements MapDataVisualization {
    private final DistanceMeasure distance;
    private final boolean normalizeCount;

    public HitHistogram(boolean normalizeCount, DistanceMeasure distance) {
        this.normalizeCount = normalizeCount;
        this.distance = distance;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D map2, Iterable<double[]> data2) {
        int nR = map2.getNumberOfRows();
        int nC = map2.getNumberOfColumns();
        LocationFinder finder = new LocationFinder(map2);
        int numSamples = 0;
        double[][] hit = new double[nR][nC];
        for (double[] sample : data2) {
            Neuron best = MapUtils.findBest(sample, map2, this.distance);
            LocationFinder.Location loc = finder.getLocation(best);
            int row2 = loc.getRow();
            int col = loc.getColumn();
            double[] dArray = hit[row2];
            int n2 = col;
            dArray[n2] = dArray[n2] + 1.0;
            ++numSamples;
        }
        if (this.normalizeCount) {
            for (int r2 = 0; r2 < nR; ++r2) {
                int c2 = 0;
                while (c2 < nC) {
                    double[] dArray = hit[r2];
                    int n3 = c2++;
                    dArray[n3] = dArray[n3] / (double)numSamples;
                }
            }
        }
        return hit;
    }
}

