/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.GF256Poly;

public final class GF256 {
    public static final GF256 QR_CODE_FIELD = new GF256(285);
    public static final GF256 DATA_MATRIX_FIELD = new GF256(301);
    private final int[] expTable = new int[256];
    private final int[] logTable = new int[256];
    private final GF256Poly zero;
    private final GF256Poly one;

    private GF256(int primitive) {
        int i2;
        int x2 = 1;
        for (i2 = 0; i2 < 256; ++i2) {
            this.expTable[i2] = x2;
            if ((x2 <<= 1) < 256) continue;
            x2 ^= primitive;
        }
        for (i2 = 0; i2 < 255; ++i2) {
            this.logTable[this.expTable[i2]] = i2;
        }
        this.zero = new GF256Poly(this, new int[]{0});
        this.one = new GF256Poly(this, new int[]{1});
    }

    GF256Poly getZero() {
        return this.zero;
    }

    GF256Poly getOne() {
        return this.one;
    }

    GF256Poly buildMonomial(int degree, int coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.zero;
        }
        int[] coefficients = new int[degree + 1];
        coefficients[0] = coefficient;
        return new GF256Poly(this, coefficients);
    }

    static int addOrSubtract(int a2, int b2) {
        return a2 ^ b2;
    }

    int exp(int a2) {
        return this.expTable[a2];
    }

    int log(int a2) {
        if (a2 == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[a2];
    }

    int inverse(int a2) {
        if (a2 == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[255 - this.logTable[a2]];
    }

    int multiply(int a2, int b2) {
        if (a2 == 0 || b2 == 0) {
            return 0;
        }
        if (a2 == 1) {
            return b2;
        }
        if (b2 == 1) {
            return a2;
        }
        return this.expTable[(this.logTable[a2] + this.logTable[b2]) % 255];
    }
}

