/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.config.Settings;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.Ultramat16S;
import gde.exception.DataInconsitsentException;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.Locale;
import javax.xml.bind.JAXBException;

public class Ultramat12
extends Ultramat16S {
    public Ultramat12(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGI2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2222"), Messages.getString((String)"GDE_MSGT2222")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        this.dialog = null;
    }

    public Ultramat12(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGI2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2222"), Messages.getString((String)"GDE_MSGT2222")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
        this.dialog = null;
    }

    @Override
    public int getLovDataByteSize() {
        return 60;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int[] points = new int[this.getNumberOfMeasurements(recordSet.getChannelConfigNumber())];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        if (dataBuffer[offset] == 12) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                if (doUpdateProgressBar && i % 50 == 0) {
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1000.0);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }
}

