/*
 * Decompiled with CFR 0.152.
 */
package gde.device.tttronix;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.tttronix.QcCopter;
import gde.device.tttronix.QcCopterDialog;
import gde.device.tttronix.QcCopterSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.TimeLine;
import java.util.logging.Logger;

public class GathererThread
extends Thread {
    static final String $CLASS_NAME = GathererThread.class.getName();
    static final Logger log = Logger.getLogger(GathererThread.class.getName());
    final DataExplorer application;
    final QcCopterSerialPort serialPort;
    final QcCopter device;
    final QcCopterDialog dialog;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    boolean isPortOpenedByLiveGatherer = false;
    boolean isGatheredRecordSetVisible = true;
    boolean isCollectDataStopped = false;

    public GathererThread(DataExplorer currentApplication, QcCopter useDevice, QcCopterSerialPort useSerialPort, int channelConfigNumber, QcCopterDialog useDialog) throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.dialog = useDialog;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet = null;
        int[] points = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        long startCycleTime = 0L;
        long tmpCycleTime = 0L;
        long measurementCount = 0L;
        byte[] dataBuffer = null;
        this.isCollectDataStopped = false;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        }
        StringBuffer terminalText = new StringBuffer();
        while (!this.isCollectDataStopped && this.serialPort.isConnected()) {
            try {
                if (this.dialog != null && !this.dialog.isDisposed() && this.dialog.getTabFolderSelectionIndex() == 0) {
                    String text = this.serialPort.getTerminalData();
                    if (log.isLoggable(Level.FINER)) {
                        log.logp(Level.FINER, $CLASS_NAME, "run", text);
                    }
                    if (text.length() > 0 && !text.equals("")) {
                        if (this.serialPort.containsSTX(text.getBytes())) {
                            terminalText = new StringBuffer();
                            terminalText.append(Messages.getString((String)"GDE_MSGI1903")).append(text);
                            this.dialog.setTerminalText(terminalText.toString());
                        } else if (this.serialPort.containsFF(text.getBytes())) {
                            terminalText = new StringBuffer();
                            if (text.length() > 1) {
                                terminalText.append(text.substring(text.indexOf(12) + 1));
                            }
                        } else {
                            terminalText.append(text);
                        }
                        if (terminalText.length() > 60) {
                            this.dialog.setTerminalText(terminalText.toString());
                            continue;
                        }
                        log.logp(Level.WARNING, $CLASS_NAME, "run", text);
                        continue;
                    }
                    this.stopDataGatheringThread(true, null);
                    continue;
                }
                dataBuffer = this.serialPort.getData();
                if (this.channel.size() == 0 || recordSet == null || !this.recordSetKey.endsWith(this.device.getRecordSetStemNameReplacement())) {
                    this.application.setStatusMessage("");
                    this.recordSetKey = this.channel.getNextRecordSetNumber() + this.device.getRecordSetStemNameReplacement();
                    this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                    this.channel.applyTemplateBasics(this.recordSetKey);
                    log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", this.recordSetKey + " created for channel " + this.channel.getName());
                    if (this.channel.getActiveRecordSet() == null) {
                        this.channel.setActiveRecordSet(this.recordSetKey);
                    }
                    recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
                    recordSet.setAllDisplayable();
                    this.device.updateVisibilityStatus(recordSet, false);
                    this.channels.getActiveChannel().switchRecordSet(this.recordSetKey);
                    measurementCount = 0L;
                    startCycleTime = 0L;
                }
                this.isGatheredRecordSetVisible = this.recordSetKey.equals(this.channels.getActiveChannel().getActiveRecordSet().getName());
                tmpCycleTime = System.nanoTime() / 1000000L;
                if (measurementCount++ == 0L) {
                    startCycleTime = tmpCycleTime;
                } else if (measurementCount % 10L == 0L) {
                    this.device.updateVisibilityStatus(recordSet, true);
                }
                recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer), (double)(tmpCycleTime - startCycleTime));
                if (log.isLoggable(Level.TIME)) {
                    log.logp(Level.TIME, $CLASS_NAME, "run", "time = " + TimeLine.getFomatedTimeWithUnit((double)(tmpCycleTime - startCycleTime)));
                }
                if (!recordSet.isChildOfActiveChannel() || !recordSet.equals((Object)this.channels.getActiveChannel().getActiveRecordSet())) continue;
                this.application.updateAllTabs(false);
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                this.cleanup(message);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1900"));
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.logp(Level.FINE, $CLASS_NAME, "run", Messages.getString((String)"GDE_MSGI1900"));
                    continue;
                }
                log.log(Level.FINE, "data gathering end detected");
                this.stopDataGatheringThread(true, e);
            }
        }
        this.application.setStatusMessage("");
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
        }
        if (!this.isCollectDataStopped) {
            this.stopDataGatheringThread(true, null);
        }
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        RecordSet recordSet;
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null && this.serialPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
        }
        if (this.serialPort != null && this.serialPort.isConnected() && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.checkPortStatus();
        }
        if ((recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGT1903"));
            }
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}) + Messages.getString((String)"GDE_MSGT1902"));
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026") + Messages.getString((String)"GDE_MSGT1902"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, false);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().getId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialog(this.dialog.getDialogShell(), message);
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        GathererThread.this.application.updateStatisticsData();
                        GathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        GathererThread.this.application.openMessageDialog(GathererThread.this.dialog.getDialogShell(), message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(this.dialog.getDialogShell(), message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }
}

