/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.Analyzer;
import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTAdapterSerialPort;
import gde.device.graupner.Transmitter;
import gde.exception.TimeOutException;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MdlBackupRestoreApp {
    static final Logger log = Logger.getLogger("MdlBackupRestoreApp");
    private String selectedPort;
    HoTTAdapterSerialPort serialPort = null;
    final Settings settings = Settings.getInstance();
    private IDevice device;
    final HashMap<String, String> extensionFilterMap = new HashMap();
    protected Shell shlMdlBackuprestore;
    protected Display display = Display.getDefault();
    private CCombo portSelectCombo;
    private CLabel portDescription;
    private Thread listPortsThread;
    private boolean isUpdateSerialPorts = true;
    private Vector<String> availablePorts = new Vector();
    private final ArrayList<String> txMdlList = new ArrayList();
    private final ArrayList<String> pcMdlList = new ArrayList();
    private final ArrayList<String> selectedMdlList = new ArrayList();
    private Transmitter txType = Transmitter.UNSPECIFIED;
    private Button readMdlButton;
    private Table pcMdlsTable;
    private Table txMdlsTable;
    private TableColumn indexColumn;
    private TableColumn fileNameColum;
    private TableColumn filePathColum;
    private CLabel mdlStatusInfoLabel;
    private ProgressBar mdlStatusProgressBar;
    private Button saveMdlsButton;
    private StringBuilder selectedPcBaseFolder = new StringBuilder().append(this.settings.getDataFilePath());
    private String selectedPcFolder = this.selectedPcBaseFolder.toString();
    private HashMap<Integer, String> selectedMdlFile = new HashMap();
    private int pcMdlsTableSelectionIndex = 1;
    private Group pcMdlsGroup;
    private Group txMdlsGroup;
    private Button fileSelectButton;
    private Button deleteSelectionButton;
    private Button deleteAllButton;
    private Button upButton;
    private Button downButton;
    private Button saveToTxButton;

    public static void main(String[] args) {
        try {
            Handler[] handlers;
            LogFormatter lf = new LogFormatter();
            Logger rootLogger = Logger.getLogger("");
            for (Handler handler : handlers = rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
            }
            rootLogger.setLevel(Level.ALL);
            ConsoleHandler logHandler = new ConsoleHandler();
            logHandler.setFormatter((Formatter)lf);
            logHandler.setLevel(Level.INFO);
            rootLogger.addHandler(logHandler);
            log.setLevel(Level.INFO);
            MdlBackupRestoreApp window = new MdlBackupRestoreApp();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IDevice getInstanceOfDevice(DeviceConfiguration selectedActiveDeviceConfig) {
        IDevice newInst = null;
        try {
            newInst = selectedActiveDeviceConfig.defineInstanceOfDevice();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newInst;
    }

    public void open() {
        DeviceConfiguration deviceConfig = Analyzer.getInstance().getDeviceConfigurations().get("HoTTAdapter");
        if (deviceConfig == null) {
            try {
                JarFile jarFile = new JarFile(String.format("%s%s%s", FileUtils.getDevicePluginJarBasePath(), "/", "HoTTAdapter.jar"));
                this.settings.extractDeviceProperties(jarFile, "HoTTAdapter", Settings.getDevicesPath());
                Analyzer.getInstance().getDeviceConfigurations().add(Analyzer.getInstance(), "HoTTAdapter", "HoTTAdapter.xml", false);
                deviceConfig = Analyzer.getInstance().getDeviceConfigurations().get("HoTTAdapter");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.device = this.getInstanceOfDevice(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.hott.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)this.getClass().getClassLoader());
        this.serialPort = new HoTTAdapterSerialPort((HoTTAdapter)this.device, null);
        this.createContents();
        this.updateAvailablePorts();
        this.shlMdlBackuprestore.open();
        this.shlMdlBackuprestore.pack();
        while (!this.shlMdlBackuprestore.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void createContents() {
        this.shlMdlBackuprestore = new Shell();
        this.shlMdlBackuprestore.setSize(1032, 466);
        this.shlMdlBackuprestore.setText("MDL Backup/Restore");
        this.shlMdlBackuprestore.setLayout((Layout)new FillLayout(256));
        this.shlMdlBackuprestore.addListener(21, new Listener(){

            public void handleEvent(Event evt) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, MdlBackupRestoreApp.this.shlMdlBackuprestore.getLocation().toString() + "event = " + String.valueOf(evt));
                }
                Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir") + "/backup_" + MdlBackupRestoreApp.this.txType.getName().toLowerCase(), new String[0]);
                try {
                    Files.walk(tmpDir, new FileVisitOption[0]).forEach(source -> {
                        try {
                            if (!Files.isDirectory(source, new LinkOption[0])) {
                                System.out.format("deleting file %s\n", source);
                                Files.deleteIfExists(source);
                            }
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                    System.out.format("deleting dir %s\n", tmpDir);
                    Files.deleteIfExists(tmpDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        Composite innerComposite = new Composite((Composite)this.shlMdlBackuprestore, 0);
        innerComposite.setLayout((Layout)new RowLayout(512));
        Group serialPortSelectionGrp = new Group(innerComposite, 0);
        RowLayout portSelectionGroupLayout = new RowLayout(256);
        portSelectionGroupLayout.center = true;
        serialPortSelectionGrp.setLayout((Layout)portSelectionGroupLayout);
        serialPortSelectionGrp.setLayoutData((Object)new RowData(1024, 30));
        this.portDescription = new CLabel((Composite)serialPortSelectionGrp, 0);
        this.portDescription.setText("serieller Port");
        this.portDescription.setLayoutData((Object)new RowData(90, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18)));
        this.portDescription.setToolTipText(Messages.getString((String)"GDE_MSGT0165"));
        this.portSelectCombo = new CCombo((Composite)serialPortSelectionGrp, 0x800800);
        this.portSelectCombo.setLayoutData((Object)new RowData(440, GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18)));
        this.portSelectCombo.setEditable(false);
        this.portSelectCombo.setText(Messages.getString((String)"GDE_MSGT0199"));
        this.portSelectCombo.setToolTipText(Messages.getString((String)"GDE_MSGT0165"));
        this.portSelectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MdlBackupRestoreApp.this.selectedPort = MdlBackupRestoreApp.this.portSelectCombo.getItem(MdlBackupRestoreApp.this.portSelectCombo.getSelectionIndex()).trim().split(" ")[0];
                log.log(Level.OFF, "Selected serial port = " + MdlBackupRestoreApp.this.selectedPort);
                MdlBackupRestoreApp.this.device.setPort(MdlBackupRestoreApp.this.selectedPort);
                MdlBackupRestoreApp.this.readMdlButton.setEnabled(true);
            }
        });
        serialPortSelectionGrp.layout();
        Group listMdlsGroup = new Group(innerComposite, 0);
        listMdlsGroup.setLayout((Layout)new RowLayout(256));
        listMdlsGroup.setLayoutData((Object)new RowData(1024, 320));
        Composite filler = new Composite((Composite)listMdlsGroup, 0);
        filler.setLayoutData((Object)new RowData(5, 20));
        this.readMdlButton = new Button((Composite)listMdlsGroup, 0x1000008);
        this.readMdlButton.setLayoutData((Object)new RowData(155, 33));
        this.readMdlButton.setText("Lese MDLs");
        this.readMdlButton.setEnabled(false);
        this.readMdlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "readMdlButton.widgetSelected, event=" + String.valueOf(evt));
                MdlBackupRestoreApp.this.isUpdateSerialPorts = false;
                MdlBackupRestoreApp.this.portSelectCombo.setEnabled(false);
                MdlBackupRestoreApp.this.readMdlButton.setEnabled(false);
                new Thread("ReadModels"){

                    @Override
                    public void run() {
                        try {
                            MdlBackupRestoreApp.this.pcMdlList.clear();
                            MdlBackupRestoreApp.this.selectedMdlList.clear();
                            MdlBackupRestoreApp.this.selectedMdlFile.clear();
                            MdlBackupRestoreApp.this.txType = MdlBackupRestoreApp.this.serialPort.loadModelData(MdlBackupRestoreApp.this.txMdlList, MdlBackupRestoreApp.this.pcMdlList, System.getProperty("java.io.tmpdir"), MdlBackupRestoreApp.this.mdlStatusInfoLabel, MdlBackupRestoreApp.this.mdlStatusProgressBar);
                            MdlBackupRestoreApp.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MdlBackupRestoreApp.this.pcMdlsTable.removeAll();
                                    MdlBackupRestoreApp.this.txMdlsTable.removeAll();
                                    int index = 1;
                                    for (String mdlName : MdlBackupRestoreApp.this.txMdlList) {
                                        new TableItem(MdlBackupRestoreApp.this.pcMdlsTable, 0).setText(new String[]{String.format(" %-3d", index), mdlName});
                                        new TableItem(MdlBackupRestoreApp.this.txMdlsTable, 0).setText(new String[]{String.format(" %-3d", index++), mdlName});
                                        MdlBackupRestoreApp.this.selectedMdlList.add("");
                                    }
                                    WaitTimer.delay((long)500L);
                                    MdlBackupRestoreApp.this.portSelectCombo.setEnabled(true);
                                    MdlBackupRestoreApp.this.readMdlButton.setEnabled(true);
                                    MdlBackupRestoreApp.this.saveMdlsButton.setEnabled(true);
                                    MdlBackupRestoreApp.this.saveToTxButton.setEnabled(MdlBackupRestoreApp.this.txType.equals((Object)Transmitter.MZ_12pro));
                                    MdlBackupRestoreApp.this.fileSelectButton.setEnabled(true);
                                    MdlBackupRestoreApp.this.upButton.setEnabled(false);
                                    MdlBackupRestoreApp.this.downButton.setEnabled(false);
                                    MdlBackupRestoreApp.this.deleteSelectionButton.setEnabled(true);
                                    MdlBackupRestoreApp.this.deleteAllButton.setEnabled(true);
                                }
                            });
                        }
                        catch (TimeOutException | IOException e) {
                            MdlBackupRestoreApp.this.openMessageDialog(e.getMessage());
                            log.log(Level.WARNING, e.getMessage());
                        }
                    }
                }.start();
            }
        });
        filler = new Composite((Composite)listMdlsGroup, 0);
        filler.setLayoutData((Object)new RowData(700, 20));
        this.pcMdlsGroup = new Group((Composite)listMdlsGroup, 0);
        this.pcMdlsGroup.setText("PC");
        this.pcMdlsGroup.setLayoutData((Object)new RowData(780, 250));
        this.pcMdlsGroup.setLayout((Layout)new FillLayout(256));
        this.pcMdlsTable = new Table((Composite)this.pcMdlsGroup, 67586);
        this.pcMdlsTable.setLinesVisible(true);
        this.pcMdlsTable.setHeaderVisible(true);
        this.setPcTableHeader(this.pcMdlsTable);
        this.pcMdlsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MdlBackupRestoreApp.this.pcMdlsTableSelectionIndex = MdlBackupRestoreApp.this.pcMdlsTable.getSelectionIndex() + 1;
                log.log(Level.INFO, "pcMdlsTableSelectionIndex = " + MdlBackupRestoreApp.this.pcMdlsTableSelectionIndex);
                TableItem item = (TableItem)event.item;
                log.log(Level.INFO, "Selection={" + item.getText(0).trim() + "|" + item.getText(1) + "|" + item.getText(2) + "}");
                if (item.getText(1) != null && item.getText(1).length() > 0) {
                    int index = Integer.parseInt(item.getText(0).trim());
                    if (index == 1) {
                        MdlBackupRestoreApp.this.upButton.setEnabled(false);
                        MdlBackupRestoreApp.this.downButton.setEnabled(true);
                    } else if (index > 1 && index <= 248) {
                        MdlBackupRestoreApp.this.upButton.setEnabled(true);
                        MdlBackupRestoreApp.this.downButton.setEnabled(true);
                    } else if (index == 250) {
                        MdlBackupRestoreApp.this.upButton.setEnabled(true);
                        MdlBackupRestoreApp.this.downButton.setEnabled(false);
                    }
                } else {
                    MdlBackupRestoreApp.this.upButton.setEnabled(false);
                    MdlBackupRestoreApp.this.downButton.setEnabled(false);
                }
            }
        });
        this.pcMdlsGroup.layout();
        this.txMdlsGroup = new Group((Composite)listMdlsGroup, 0);
        this.txMdlsGroup.setLayoutData((Object)new RowData(GDE.IS_LINUX ? 230 : 200, 250));
        this.txMdlsGroup.setText("Tx");
        this.txMdlsGroup.setLayout((Layout)new FillLayout(256));
        this.txMdlsTable = new Table((Composite)this.txMdlsGroup, 67586);
        this.txMdlsTable.setLinesVisible(true);
        this.txMdlsTable.setHeaderVisible(true);
        this.setTxTableHeader(this.txMdlsTable);
        this.txMdlsGroup.layout();
        Composite actionButtonComposite = new Composite(innerComposite, 0);
        actionButtonComposite.setLayout((Layout)new RowLayout(256));
        actionButtonComposite.setLayoutData((Object)new RowData(1024, 100));
        actionButtonComposite.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)0));
        filler = new Composite(actionButtonComposite, 0);
        filler.setLayoutData((Object)new RowData(5, 30));
        this.saveMdlsButton = new Button(actionButtonComposite, 0x1000008);
        this.saveMdlsButton.setLayoutData((Object)new RowData(155, 33));
        this.saveMdlsButton.setEnabled(false);
        this.saveMdlsButton.setText("sichere MDLs");
        this.saveMdlsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "saveMdlsButton.widgetSelected, event=" + String.valueOf(evt));
                final String baseFolderName = MdlBackupRestoreApp.this.openDirFileDialog(Messages.getString((String)"GDE_MSGT2432"), MdlBackupRestoreApp.this.selectedPcBaseFolder.toString());
                new Thread("BackupModels"){

                    @Override
                    public void run() {
                        try {
                            if (baseFolderName != null && baseFolderName.length() < 3) {
                                MdlBackupRestoreApp.this.openMessageDialog(Messages.getString((String)"GDE_MSGE2400"));
                                return;
                            }
                            if (!MdlBackupRestoreApp.this.selectedMdlFile.isEmpty()) {
                                for (Integer index : MdlBackupRestoreApp.this.selectedMdlFile.keySet()) {
                                    MdlBackupRestoreApp.this.pcMdlList.set(index - 1, MdlBackupRestoreApp.this.selectedMdlFile.get(index));
                                }
                                MdlBackupRestoreApp.this.selectedMdlFile.clear();
                            }
                            if (baseFolderName != null && baseFolderName.length() > 0) {
                                MdlBackupRestoreApp.this.updateMdlTransferProgress(MdlBackupRestoreApp.this.mdlStatusInfoLabel, MdlBackupRestoreApp.this.mdlStatusProgressBar, 0L, 0L);
                                try {
                                    Path destDir = Paths.get(baseFolderName, new String[0]);
                                    Path srcDir = Paths.get(System.getProperty("java.io.tmpdir") + "/backup_" + MdlBackupRestoreApp.this.txType.getName().toLowerCase(), new String[0]);
                                    long size = Files.walk(srcDir, new FileVisitOption[0]).mapToLong(p -> p.toFile().length()).sum();
                                    size -= size % 8192L;
                                    long[] sizes = new long[]{size, size};
                                    MdlBackupRestoreApp.this.updateMdlTransferProgress(MdlBackupRestoreApp.this.mdlStatusInfoLabel, MdlBackupRestoreApp.this.mdlStatusProgressBar, sizes[0], sizes[1]);
                                    Path dest = destDir.resolve(srcDir.getFileName());
                                    log.log(Level.FINE, String.format("copying %s => %s%n", srcDir, dest));
                                    Files.walk(srcDir, new FileVisitOption[0]).forEach(source -> {
                                        Path destination = dest.resolve(srcDir.relativize((Path)source));
                                        try {
                                            if (!Files.isDirectory(destination, new LinkOption[0])) {
                                                log.log(Level.FINE, String.format("Files.copy(%s, %s)%n", source, destination));
                                                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                                                WaitTimer.delay((long)100L);
                                                sizes[1] = sizes[1] - source.toFile().length();
                                                MdlBackupRestoreApp.this.updateMdlTransferProgress(MdlBackupRestoreApp.this.mdlStatusInfoLabel, MdlBackupRestoreApp.this.mdlStatusProgressBar, sizes[0], sizes[1]);
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new UncheckedIOException(e);
                                        }
                                    });
                                }
                                catch (IOException e) {
                                    MdlBackupRestoreApp.this.openMessageDialog(e.getMessage());
                                }
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            MdlBackupRestoreApp.this.openMessageDialog(e.getMessage());
                        }
                    }
                }.start();
            }
        });
        this.fileSelectButton = new Button(actionButtonComposite, 0x1000008);
        this.fileSelectButton.setLayoutData((Object)new RowData(155, 33));
        this.fileSelectButton.setEnabled(false);
        this.fileSelectButton.setText("Datei");
        this.fileSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path;
                log.log(Level.FINEST, "fileSelectButton.widgetSelected, event=" + String.valueOf(evt));
                FileDialog fd = MdlBackupRestoreApp.this.openFileOpenDialog("MDL Selection", new String[]{"*.mdl"}, MdlBackupRestoreApp.this.selectedPcFolder.toString(), "", 4);
                MdlBackupRestoreApp.this.selectedPcFolder = path = fd.getFilterPath();
                String fileName = fd.getFileName();
                log.log(Level.INFO, path + " - " + fileName);
                if (!MdlBackupRestoreApp.this.txType.equals((Object)Transmitter.detectTransmitter(fileName, path))) {
                    MdlBackupRestoreApp.this.openMessageDialog("Transmitter radio type doesn't match " + MdlBackupRestoreApp.this.txType.getName() + "/" + Transmitter.detectTransmitter(fileName, path).getName());
                    return;
                }
                if (!MdlBackupRestoreApp.this.selectedMdlFile.isEmpty()) {
                    for (Integer index : MdlBackupRestoreApp.this.selectedMdlFile.keySet()) {
                        MdlBackupRestoreApp.this.pcMdlList.set(index - 1, MdlBackupRestoreApp.this.selectedMdlFile.get(index));
                    }
                    MdlBackupRestoreApp.this.selectedMdlFile.clear();
                }
                MdlBackupRestoreApp.this.selectedMdlFile.put(MdlBackupRestoreApp.this.pcMdlsTableSelectionIndex, fileName.substring(0, fileName.length() - 4) + ";" + path);
                MdlBackupRestoreApp.this.pcMdlsTable.removeAll();
                String tmpdir = System.getProperty("java.io.tmpdir");
                for (int i = 0; i < MdlBackupRestoreApp.this.pcMdlList.size(); ++i) {
                    if (i == MdlBackupRestoreApp.this.pcMdlsTableSelectionIndex - 1) {
                        new TableItem(MdlBackupRestoreApp.this.pcMdlsTable, 0).setText(new String[]{String.format(" %-3d", i + 1), fileName.substring(0, fileName.length() - 4), path});
                        continue;
                    }
                    new TableItem(MdlBackupRestoreApp.this.pcMdlsTable, 0).setText(new String[]{String.format(" %-3d", i + 1), MdlBackupRestoreApp.this.pcMdlList.get(i).split(";")[0], MdlBackupRestoreApp.this.pcMdlList.get(i).split(";").length > 1 && !MdlBackupRestoreApp.this.pcMdlList.get(i).split(";")[1].contains(tmpdir) ? MdlBackupRestoreApp.this.pcMdlList.get(i).split(";")[1] : ""});
                }
                MdlBackupRestoreApp.this.upButton.setEnabled(false);
                MdlBackupRestoreApp.this.downButton.setEnabled(false);
                MdlBackupRestoreApp.this.saveMdlsButton.setEnabled(false);
                MdlBackupRestoreApp.this.saveToTxButton.setEnabled(MdlBackupRestoreApp.this.txType.equals((Object)Transmitter.MZ_12pro));
            }
        });
        this.deleteSelectionButton = new Button(actionButtonComposite, 0x1000008);
        this.deleteSelectionButton.setLayoutData((Object)new RowData(155, 33));
        this.deleteSelectionButton.setEnabled(false);
        this.deleteSelectionButton.setText("L\u00f6schen");
        this.deleteSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "deleteSelectionButton.widgetSelected, event=" + String.valueOf(evt));
                int selectionIndex = MdlBackupRestoreApp.this.pcMdlsTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    TableItem item = MdlBackupRestoreApp.this.pcMdlsTable.getSelection()[0];
                    log.log(Level.INFO, "index" + selectionIndex + " Selection={" + item.getText(0).trim() + "|" + item.getText(1) + "|" + item.getText(2) + "}");
                    if (item.getText(0).trim().length() > 0) {
                        int index = Integer.parseInt(item.getText(0).trim());
                        MdlBackupRestoreApp.this.pcMdlsTable.clear(selectionIndex);
                        MdlBackupRestoreApp.this.pcMdlList.set(index - 1, "");
                    }
                    MdlBackupRestoreApp.this.upButton.setEnabled(false);
                    MdlBackupRestoreApp.this.downButton.setEnabled(false);
                }
            }
        });
        this.deleteAllButton = new Button(actionButtonComposite, 0x1000008);
        this.deleteAllButton.setLayoutData((Object)new RowData(155, 33));
        this.deleteAllButton.setEnabled(false);
        this.deleteAllButton.setText("Alles L\u00f6schen");
        this.deleteAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "deleteSelectionButton.widgetSelected, event=" + String.valueOf(evt));
                MdlBackupRestoreApp.this.pcMdlsTable.clearAll();
                for (int i = 0; i < MdlBackupRestoreApp.this.pcMdlList.size(); ++i) {
                    MdlBackupRestoreApp.this.pcMdlList.set(i, "");
                }
                MdlBackupRestoreApp.this.saveMdlsButton.setEnabled(false);
                MdlBackupRestoreApp.this.saveToTxButton.setEnabled(MdlBackupRestoreApp.this.txType.equals((Object)Transmitter.MZ_12pro));
                MdlBackupRestoreApp.this.fileSelectButton.setEnabled(true);
                MdlBackupRestoreApp.this.upButton.setEnabled(false);
                MdlBackupRestoreApp.this.downButton.setEnabled(false);
                MdlBackupRestoreApp.this.deleteSelectionButton.setEnabled(false);
                MdlBackupRestoreApp.this.deleteAllButton.setEnabled(false);
            }
        });
        this.upButton = new Button(actionButtonComposite, 0x1000008);
        this.upButton.setLayoutData((Object)new RowData(55, 33));
        this.upButton.setEnabled(false);
        this.upButton.setImage(SWTResourceManager.getImage((String)"resource/ArrowUp.gif"));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "upButton.widgetSelected, event=" + String.valueOf(evt));
                int selectionIndex = MdlBackupRestoreApp.this.pcMdlsTable.getSelectionIndex();
                TableItem item = MdlBackupRestoreApp.this.pcMdlsTable.getSelection()[0];
                log.log(Level.INFO, "index" + selectionIndex + " Selection={" + item.getText(0).trim() + "|" + item.getText(1) + "|" + item.getText(2) + "}");
                int index = Integer.parseInt(item.getText(0).trim());
                String selectedMdl = MdlBackupRestoreApp.this.selectedMdlFile.get(index);
                if (selectedMdl != null) {
                    MdlBackupRestoreApp.this.selectedMdlFile.put(index - 1, selectedMdl);
                    MdlBackupRestoreApp.this.selectedMdlFile.remove(index);
                } else {
                    for (int i = 0; i < MdlBackupRestoreApp.this.pcMdlList.size(); ++i) {
                        if (i != selectionIndex) continue;
                        String upShift = MdlBackupRestoreApp.this.pcMdlList.get(selectionIndex);
                        String downShift = MdlBackupRestoreApp.this.pcMdlList.get(selectionIndex - 1);
                        MdlBackupRestoreApp.this.pcMdlList.set(selectionIndex, downShift);
                        MdlBackupRestoreApp.this.pcMdlList.set(selectionIndex - 1, upShift);
                    }
                }
                MdlBackupRestoreApp.this.pcMdlsTable.removeAll();
                String tmpdir = System.getProperty("java.io.tmpdir");
                int i = 1;
                for (String mdlEntry : MdlBackupRestoreApp.this.pcMdlList) {
                    if (MdlBackupRestoreApp.this.selectedMdlFile.get(i) != null) {
                        String[] mdlPath = MdlBackupRestoreApp.this.selectedMdlFile.get(i).split(";");
                        new TableItem(MdlBackupRestoreApp.this.pcMdlsTable, 0).setText(new String[]{String.format(" %-3d", i), mdlPath[0], mdlPath[1]});
                    } else {
                        new TableItem(MdlBackupRestoreApp.this.pcMdlsTable, 0).setText(new String[]{String.format(" %-3d", i), mdlEntry.split(";")[0], mdlEntry.split(";").length > 1 && !mdlEntry.split(";")[1].contains(tmpdir) ? mdlEntry.split(";")[1] : ""});
                    }
                    ++i;
                }
                MdlBackupRestoreApp.this.pcMdlsTable.setSelection(--selectionIndex);
                if (selectionIndex == 0) {
                    MdlBackupRestoreApp.this.upButton.setEnabled(false);
                    MdlBackupRestoreApp.this.downButton.setEnabled(true);
                } else if (selectionIndex > 0 && selectionIndex <= 248) {
                    MdlBackupRestoreApp.this.upButton.setEnabled(true);
                    MdlBackupRestoreApp.this.downButton.setEnabled(true);
                } else if (selectionIndex == 249) {
                    MdlBackupRestoreApp.this.upButton.setEnabled(true);
                    MdlBackupRestoreApp.this.downButton.setEnabled(false);
                }
            }
        });
        this.downButton = new Button(actionButtonComposite, 0x1000008);
        this.downButton.setLayoutData((Object)new RowData(55, 33));
        this.downButton.setEnabled(false);
        this.downButton.setImage(SWTResourceManager.getImage((String)"resource/ArrowDown.gif"));
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "downButton.widgetSelected, event=" + String.valueOf(evt));
                int selectionIndex = MdlBackupRestoreApp.this.pcMdlsTable.getSelectionIndex();
                TableItem item = MdlBackupRestoreApp.this.pcMdlsTable.getSelection()[0];
                log.log(Level.INFO, "index " + selectionIndex + " Selection={" + item.getText(0).trim() + "|" + item.getText(1) + "|" + item.getText(2) + "}");
                int index = Integer.parseInt(item.getText(0).trim());
                String selectedMdl = MdlBackupRestoreApp.this.selectedMdlFile.get(index);
                if (selectedMdl != null) {
                    MdlBackupRestoreApp.this.selectedMdlFile.put(index + 1, selectedMdl);
                    MdlBackupRestoreApp.this.selectedMdlFile.remove(index);
                } else {
                    for (int i = 0; i < MdlBackupRestoreApp.this.pcMdlList.size(); ++i) {
                        if (i != selectionIndex) continue;
                        String upShift = MdlBackupRestoreApp.this.pcMdlList.get(selectionIndex + 1);
                        String downShift = MdlBackupRestoreApp.this.pcMdlList.get(selectionIndex);
                        MdlBackupRestoreApp.this.pcMdlList.set(selectionIndex + 1, downShift);
                        MdlBackupRestoreApp.this.pcMdlList.set(selectionIndex, upShift);
                        ++i;
                    }
                }
                MdlBackupRestoreApp.this.pcMdlsTable.removeAll();
                String tmpdir = System.getProperty("java.io.tmpdir");
                int i = 1;
                for (String mdlEntry : MdlBackupRestoreApp.this.pcMdlList) {
                    if (MdlBackupRestoreApp.this.selectedMdlFile.get(i) != null) {
                        String[] mdlPath = MdlBackupRestoreApp.this.selectedMdlFile.get(i).split(";");
                        new TableItem(MdlBackupRestoreApp.this.pcMdlsTable, 0).setText(new String[]{String.format(" %-3d", i), mdlPath[0], mdlPath[1]});
                    } else {
                        new TableItem(MdlBackupRestoreApp.this.pcMdlsTable, 0).setText(new String[]{String.format(" %-3d", i), mdlEntry.split(";")[0], mdlEntry.split(";").length > 1 && !mdlEntry.split(";")[1].contains(tmpdir) ? mdlEntry.split(";")[1] : ""});
                    }
                    ++i;
                }
                MdlBackupRestoreApp.this.pcMdlsTable.setSelection(++selectionIndex);
                log.log(Level.INFO, "new index " + selectionIndex);
                if (selectionIndex == 0) {
                    MdlBackupRestoreApp.this.upButton.setEnabled(false);
                    MdlBackupRestoreApp.this.downButton.setEnabled(true);
                } else if (selectionIndex > 0 && selectionIndex <= 248) {
                    MdlBackupRestoreApp.this.upButton.setEnabled(true);
                    MdlBackupRestoreApp.this.downButton.setEnabled(true);
                } else if (selectionIndex == 249) {
                    MdlBackupRestoreApp.this.upButton.setEnabled(true);
                    MdlBackupRestoreApp.this.downButton.setEnabled(false);
                }
            }
        });
        filler = new Composite(actionButtonComposite, 0);
        filler.setLayoutData((Object)new RowData(90, 33));
        this.saveToTxButton = new Button(actionButtonComposite, 0x1000008);
        this.saveToTxButton.setLayoutData((Object)new RowData(155, 33));
        this.saveToTxButton.setEnabled(false);
        this.saveToTxButton.setText("Schreibe MDLs");
        this.saveToTxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "saveToTxButton.widgetSelected, event=" + String.valueOf(evt));
                MdlBackupRestoreApp.this.readMdlButton.setEnabled(false);
                MdlBackupRestoreApp.this.saveMdlsButton.setEnabled(false);
                MdlBackupRestoreApp.this.saveToTxButton.setEnabled(false);
                MdlBackupRestoreApp.this.fileSelectButton.setEnabled(false);
                MdlBackupRestoreApp.this.upButton.setEnabled(false);
                MdlBackupRestoreApp.this.downButton.setEnabled(false);
                MdlBackupRestoreApp.this.deleteSelectionButton.setEnabled(false);
                MdlBackupRestoreApp.this.deleteAllButton.setEnabled(false);
                new Thread("WriteModels"){

                    @Override
                    public void run() {
                        try {
                            if (!MdlBackupRestoreApp.this.selectedMdlFile.isEmpty()) {
                                for (Integer index : MdlBackupRestoreApp.this.selectedMdlFile.keySet()) {
                                    MdlBackupRestoreApp.this.pcMdlList.set(index - 1, MdlBackupRestoreApp.this.selectedMdlFile.get(index));
                                }
                                MdlBackupRestoreApp.this.selectedMdlFile.clear();
                            }
                            for (int i = 0; i < MdlBackupRestoreApp.this.selectedMdlList.size() && i < MdlBackupRestoreApp.this.pcMdlList.size(); ++i) {
                                if (MdlBackupRestoreApp.this.selectedMdlList.get(i).length() > 0 && MdlBackupRestoreApp.this.selectedMdlList.get(i).contains(";") || MdlBackupRestoreApp.this.pcMdlList.get(i).length() <= 0) continue;
                                MdlBackupRestoreApp.this.selectedMdlList.set(i, MdlBackupRestoreApp.this.pcMdlList.get(i));
                            }
                            String errorMdlFiles = MdlBackupRestoreApp.this.serialPort.writeModelData(MdlBackupRestoreApp.this.selectedMdlList, MdlBackupRestoreApp.this.mdlStatusInfoLabel, MdlBackupRestoreApp.this.mdlStatusProgressBar);
                            if (errorMdlFiles.length() > 0) {
                                MdlBackupRestoreApp.this.openMessageDialog(errorMdlFiles);
                                return;
                            }
                            MdlBackupRestoreApp.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MdlBackupRestoreApp.this.pcMdlsTable.removeAll();
                                    MdlBackupRestoreApp.this.txMdlsTable.removeAll();
                                }
                            });
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage());
                            MdlBackupRestoreApp.this.openMessageDialog(e.getMessage());
                        }
                    }
                }.start();
            }
        });
        Composite mdlStatusComposite = new Composite(actionButtonComposite, 0);
        mdlStatusComposite.setLayoutData((Object)new RowData(1008, 36));
        mdlStatusComposite.setLayout((Layout)new RowLayout(256));
        this.mdlStatusInfoLabel = new CLabel(mdlStatusComposite, 0);
        this.mdlStatusInfoLabel.setLayoutData((Object)new RowData(800, 15));
        this.mdlStatusInfoLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{0, 0}));
        this.mdlStatusProgressBar = new ProgressBar(mdlStatusComposite, 0);
        this.mdlStatusProgressBar.setLayoutData((Object)new RowData(1001, 10));
        this.mdlStatusProgressBar.setMinimum(0);
        this.mdlStatusProgressBar.setMaximum(100);
    }

    private void setPcTableHeader(Table table) {
        TableColumn[] columns;
        table.removeAll();
        for (TableColumn tableColumn : columns = table.getColumns()) {
            tableColumn.dispose();
        }
        this.indexColumn = new TableColumn(table, 0);
        this.indexColumn.setWidth(50);
        this.indexColumn.setText(Messages.getString((String)"GDE_MSGT2445"));
        this.fileNameColum = new TableColumn(table, 0);
        this.fileNameColum.setWidth(150);
        this.fileNameColum.setText("Name");
        this.filePathColum = new TableColumn(table, 0);
        this.filePathColum.setWidth(500);
        this.filePathColum.setText("Path");
    }

    private void setTxTableHeader(Table table) {
        TableColumn[] columns;
        table.removeAll();
        for (TableColumn tableColumn : columns = table.getColumns()) {
            tableColumn.dispose();
        }
        this.indexColumn = new TableColumn(table, 0);
        this.indexColumn.setWidth(40);
        this.indexColumn.setText(Messages.getString((String)"GDE_MSGT2445"));
        this.fileNameColum = new TableColumn(table, 0);
        this.fileNameColum.setWidth(150);
        this.fileNameColum.setText("Name");
    }

    void updateAvailablePorts() {
        this.listPortsThread = new Thread("updateAvailablePorts"){

            @Override
            public void run() {
                try {
                    while (MdlBackupRestoreApp.this.shlMdlBackuprestore != null && !MdlBackupRestoreApp.this.shlMdlBackuprestore.isDisposed()) {
                        if (MdlBackupRestoreApp.this.isUpdateSerialPorts) {
                            MdlBackupRestoreApp.this.availablePorts.clear();
                            MdlBackupRestoreApp.this.availablePorts.addAll(DeviceCommPort.listConfiguredSerialPorts((boolean)false, (String)"", new Vector()).keySet());
                            if (MdlBackupRestoreApp.this.shlMdlBackuprestore != null && !MdlBackupRestoreApp.this.shlMdlBackuprestore.isDisposed()) {
                                MdlBackupRestoreApp.this.display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!MdlBackupRestoreApp.this.shlMdlBackuprestore.isDisposed()) {
                                            if (MdlBackupRestoreApp.this.availablePorts != null && MdlBackupRestoreApp.this.availablePorts.size() > 0) {
                                                MdlBackupRestoreApp.this.portSelectCombo.setItems(DeviceCommPort.prepareSerialPortList());
                                                int index = MdlBackupRestoreApp.this.availablePorts.indexOf(MdlBackupRestoreApp.this.selectedPort);
                                                if (index > -1) {
                                                    MdlBackupRestoreApp.this.portSelectCombo.select(index);
                                                } else if (MdlBackupRestoreApp.this.selectedPort == null) {
                                                    MdlBackupRestoreApp.this.portSelectCombo.setText(Messages.getString((String)"GDE_MSGT0197"));
                                                }
                                            } else {
                                                MdlBackupRestoreApp.this.portSelectCombo.setItems(new String[0]);
                                                MdlBackupRestoreApp.this.portSelectCombo.setText(Messages.getString((String)"GDE_MSGT0198"));
                                            }
                                        }
                                    }
                                });
                            }
                        } else {
                            return;
                        }
                        WaitTimer.delay((long)500L);
                    }
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, t.getMessage(), t);
                }
                log.log(Level.OFF, "updateAvailablePortsThread time =", StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - GDE.StartTime)));
            }
        };
        this.listPortsThread.start();
    }

    public String openDirFileDialog(String name, String path) {
        DirectoryDialog fileDirDialog = new DirectoryDialog(GDE.shell, 32768);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "dialogName = " + name + " path = " + path);
        }
        fileDirDialog.setText(name);
        if (path != null) {
            fileDirDialog.setFilterPath(path);
        }
        return fileDirDialog.open();
    }

    public FileDialog openFileOpenDialog(String name, String[] extensions, String path, String fileName, int addStyle) {
        FileDialog fileOpenDialog = new FileDialog(GDE.shell, 0x9000 | addStyle);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "dialogName = " + name + " path = " + path);
        }
        fileOpenDialog.setText(name);
        fileOpenDialog.setFileName(fileName == null ? "" : fileName);
        if (extensions != null) {
            this.adaptFilter(fileOpenDialog, extensions);
        }
        if (path != null) {
            fileOpenDialog.setFilterPath(path);
        }
        fileOpenDialog.open();
        return fileOpenDialog;
    }

    private void adaptFilter(FileDialog fileOpenDialog, String[] extensions) {
        if (!GDE.IS_WINDOWS) {
            Vector<String> tmpExt = new Vector<String>();
            for (String extension : extensions) {
                if (!extension.equals("*.*")) {
                    tmpExt.add(extension);
                    tmpExt.add(extension.toUpperCase());
                    continue;
                }
                tmpExt.add("*");
            }
            extensions = tmpExt.toArray(new String[1]);
        }
        fileOpenDialog.setFilterExtensions(extensions);
        fileOpenDialog.setFilterNames(this.getExtensionDescription(extensions));
    }

    public String[] getExtensionDescription(String[] extensions) {
        String[] filterNames = new String[extensions.length];
        for (int i = 0; i < filterNames.length; ++i) {
            int beginIndex = extensions[i].indexOf(46);
            String tmpExt = beginIndex != -1 ? extensions[i].substring(beginIndex + 1) : extensions[i];
            filterNames[i] = this.extensionFilterMap.get(tmpExt.toLowerCase());
            if (filterNames[i] == null) {
                filterNames[i] = extensions[i];
                continue;
            }
            beginIndex = filterNames[i].indexOf(46);
            if (beginIndex <= 0) continue;
            String tmpFilterExt = filterNames[i].substring(filterNames[i].indexOf(46) + 1, filterNames[i].length() - 1);
            filterNames[i] = tmpExt.equals(tmpFilterExt) ? filterNames[i] : filterNames[i].replace(tmpFilterExt, tmpExt);
        }
        return filterNames;
    }

    public void openMessageDialog(final String message) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox messageDialog = new MessageBox(GDE.shell, 40);
                messageDialog.setText("DataExplorer");
                messageDialog.setMessage(message);
                messageDialog.open();
            }
        });
    }

    public void updateMdlTransferProgress(final CLabel infoLabel, final ProgressBar progressBar, final long totalSize, final long remainingSize) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (totalSize == 0L) {
                    progressBar.setSelection(0);
                    infoLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{0, 0}));
                } else {
                    progressBar.setSelection((int)((totalSize - remainingSize) * 100L / totalSize));
                    infoLabel.setText(Messages.getString((String)"GDE_MSGT2443", (Object[])new Object[]{totalSize - remainingSize, totalSize}));
                }
            }
        });
    }
}

