/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.Analyzer;
import gde.histo.datasources.DirectoryScanner;
import gde.histo.exclusions.ExclusionData;
import gde.ui.DataExplorer;
import java.nio.file.Path;
import java.util.List;

public final class ExclusionActivity {
    public static void clearExcludeLists() {
        if (!DataExplorer.getInstance().getHistoExplorer().isPresent()) {
            throw new UnsupportedOperationException();
        }
        ExclusionData exclusionData = new ExclusionData(DirectoryScanner.getActiveFolder4Ui(), Analyzer.getInstance().getDataAccess());
        exclusionData.delete();
    }

    public static void setExcludeRecordSet(Path filePath, String recordsetBaseName) {
        ExclusionData exclusionData = new ExclusionData(DirectoryScanner.getActiveFolder4Ui(), Analyzer.getInstance().getDataAccess());
        if (recordsetBaseName.isEmpty()) {
            exclusionData.setProperty(filePath.getFileName().toString());
        } else {
            exclusionData.addToProperty(filePath.getFileName().toString(), recordsetBaseName);
        }
        exclusionData.store();
    }

    public static String[] getExcludedTrusses() {
        ExclusionData exclusionData = new ExclusionData(DirectoryScanner.getActiveFolder4Ui(), Analyzer.getInstance().getDataAccess());
        List<Path> excludedPaths = DataExplorer.getInstance().getPresentHistoExplorer().getHistoSet().getExcludedPaths();
        return exclusionData.getExcludedTrusses(excludedPaths);
    }
}

