/*
 * Decompiled with CFR 0.152.
 */
package gde.device.estner;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.device.DataTypes;
import gde.device.DeviceDialog;
import gde.device.estner.AMSettings;
import gde.device.estner.Akkumatik;
import gde.device.estner.AkkumatikSerialPort;
import gde.device.estner.GathererThread;
import gde.device.estner.ObjectFactory;
import gde.device.estner.Setting;
import gde.log.Level;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xml.sax.SAXException;

public class AkkumatikDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(AkkumatikDialog.class.getName());
    static final String AKKUMATIK_SETTINGS_XSD = "Akkumatik_Settings_V01.xsd";
    static final String AKKUMATIK_CONFIGURATION_SUFFIX = "/Akkumatik_Settings";
    static final String DEVICE_NAME = "Akkumatik";
    static final String[] STOP_MODE = new String[]{Messages.getString((String)"GDE_MSGT3464"), "Gradient", "\u2206-Peak-1", "\u2206-Peak-2", "\u2206-Peak-3"};
    static final String[] STOP_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3464"), "Gradient", "\u2206-Peak-1", "\u2206-Peak-2", "\u2206-Peak-3"};
    static final String[] STOP_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3464")};
    static final String[] STOP_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3464")};
    static final String[] CHARGE_CURRENT_TYPE = new String[]{"Auto", "Limit", "Fix"};
    static final String[] CHARGE_CURRENT_TYPE_NI = new String[]{"Auto", "Limit", "Fix"};
    static final String[] CHARGE_CURRENT_TYPE_PB = new String[]{"Fix"};
    static final String[] CHARGE_CURRENT_TYPE_LI = new String[]{"Fix"};
    static final byte[] OPEN_DIALOG = new byte[]{2, 51, 48, 65, 3};
    static final byte[] START_CH_1 = new byte[]{2, 52, 52, 66, 3};
    static final byte[] START_CH_2 = new byte[]{2, 52, 56, 78, 3};
    static final byte[] STOP_CH_1 = new byte[]{2, 52, 49, 71, 3};
    static final byte[] STOP_CH_2 = new byte[]{2, 52, 50, 68, 3};
    static Handler logHandler;
    static Logger rootLogger;
    final Akkumatik device;
    final AkkumatikSerialPort serialPort;
    final Channels channels;
    final Settings settings;
    AMSettings akkumatikSettings = null;
    List<Setting> akkuSettings = null;
    Setting actualAkkuSetting = null;
    CCombo programNameSelection;
    CCombo batteryTypeCombo;
    CCombo cellCountCombo;
    CCombo programCombo;
    CCombo cycleCountCombo;
    CCombo chargeModeCombo;
    CCombo chargeCurrentCombo;
    CCombo capacityCombo;
    CCombo chargeStopModeCombo;
    CCombo currentModeCombo;
    CCombo chargeAmountCombo;
    CCombo dischargeCurrentCombo;
    Button btnChannel1;
    Button btnChannel2;
    Button btnTransfer;
    Button btnStart;
    Button btnStop;
    Button removeEntry;
    Button editEntry;
    Label statusLabel;
    Label lblChargeMode;
    Label lblCurrentMode;
    Label lblCycleCount;
    Group grpCharge;
    Group grpDischarge;
    Composite currentTypeAmountGrp;
    int programSelectionIndex = 0;
    int comboHeight = GDE.IS_LINUX ? 22 : (GDE.IS_MAC ? 20 : 18);
    static boolean isDataAvailable;
    static byte[] data2Write;

    public AkkumatikDialog(Shell parent, Akkumatik useDevice) {
        super(parent);
        this.setText("Akkumatik Dialog");
        this.device = useDevice;
        this.serialPort = this.device.getCommunicationPort();
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        String basePath = Settings.getApplHomePath();
        this.akkumatikSettings = new ObjectFactory().createAMSettings();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(AkkumatikDialog.class.getClassLoader().getResourceAsStream("resource/Akkumatik_Settings_V01.xsd")));
            JAXBContext jc = JAXBContext.newInstance((String)"gde.device.estner");
            log.log(Level.TIME, "XSD init time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - GDE.StartTime)));
            long time = new Date().getTime();
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            this.akkumatikSettings = (AMSettings)unmarshaller.unmarshal(new File(basePath + "/Akkumatik_Settings.xml"));
            log.log(Level.TIME, "read setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - time)));
        }
        catch (JAXBException | SAXException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            this.akkumatikSettings = new ObjectFactory().createAMSettings();
            this.akkumatikSettings.setDialogSettings(new ObjectFactory().createDialogSettings());
            this.akkumatikSettings.getDialogSettings().setChannel1(new ObjectFactory().createActiveSetting());
            this.akkumatikSettings.getDialogSettings().getChannel1().setActiveSetting(0);
            this.akkumatikSettings.getDialogSettings().setChannel2(new ObjectFactory().createActiveSetting());
            this.akkumatikSettings.getDialogSettings().getChannel2().setActiveSetting(0);
            this.akkumatikSettings.getDialogSettings().setActiveChannel(1);
            this.akkumatikSettings.setAkkuSettings(new ObjectFactory().createAkkuSettings());
            this.akkumatikSettings.getAkkuSettings().getSetting().add(this.createAkkuSetting("Initial", 1, 0, 2, 0, 1000, 34, 2, 0, 0, 0, 100, 100));
            this.akkumatikSettings.setParameterSettings(new ObjectFactory().createParameterSettings());
        }
    }

    private Setting createAkkuSetting(String name, int channel, int accuType, int currentMode, int amount, int capacity, int cellCount, int program, int cycle, int chargeMode, int chargeStopMode, int chargeCurrent, int dischargeCurrent) {
        Setting akkuSetting = new ObjectFactory().createSetting();
        akkuSetting.setName(name);
        akkuSetting.setSettingType("Akku");
        akkuSetting.setChannel(channel);
        akkuSetting.setAccuTyp(accuType);
        akkuSetting.setCurrentMode(currentMode);
        akkuSetting.setAmount(amount);
        akkuSetting.setCapacity(capacity);
        akkuSetting.setCellCount((short)cellCount);
        akkuSetting.setProgram(program);
        akkuSetting.setCycle(cycle);
        akkuSetting.setChargeMode(chargeMode);
        akkuSetting.setChargeStopMode(chargeStopMode);
        akkuSetting.setChargeCurrent(chargeCurrent);
        akkuSetting.setDisChargeCurrent(dischargeCurrent);
        return akkuSetting;
    }

    public void open() {
        GathererThread dataGathererThread = this.device.getDataGathererThread();
        if (this.serialPort != null && dataGathererThread == null || dataGathererThread.isCollectDataStopped) {
            this.device.open_closeCommPort();
        }
        AkkumatikSerialPort.getChecksum(OPEN_DIALOG);
        if (this.serialPort != null && this.serialPort.isConnected()) {
            AkkumatikDialog.setData2Write(OPEN_DIALOG);
        }
        this.createContents();
        this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent evt) {
                log.log(Level.FINE, "boundsComposite.mouseEnter, event=" + String.valueOf(evt));
                AkkumatikDialog.this.fadeOutAplhaBlending(evt, AkkumatikDialog.this.dialogShell.getSize(), 10, 10, 10, 15);
            }

            public void mouseHover(MouseEvent evt) {
                log.log(Level.FINEST, "boundsComposite.mouseHover, event=" + String.valueOf(evt));
            }

            public void mouseExit(MouseEvent evt) {
                log.log(Level.FINE, "boundsComposite.mouseExit, event=" + String.valueOf(evt));
                AkkumatikDialog.this.fadeInAlpaBlending(evt, AkkumatikDialog.this.dialogShell.getSize(), 10, 10, -10, 15);
            }
        });
        this.dialogShell.open();
        this.dialogShell.layout();
        if (this.serialPort == null || dataGathererThread == null) {
            this.statusLabel.setText(Messages.getString((String)"GDE_MSGI3403"));
        }
        Display display = this.getParent().getDisplay();
        while (!this.dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        try {
            Long time = new Date().getTime();
            String basePath = Settings.getApplHomePath();
            JAXBContext jc = JAXBContext.newInstance((String)"gde.device.estner");
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)AKKUMATIK_SETTINGS_XSD);
            marshaller.marshal((Object)this.akkumatikSettings, (OutputStream)new FileOutputStream(basePath + "/Akkumatik_Settings.xml"));
            log.log(Level.TIME, "write setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - time)));
        }
        catch (FileNotFoundException | JAXBException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createContents() {
        this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
        this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
        log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
        if (this.dialogShell == null || this.dialogShell.isDisposed()) {
            this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            if (this.isAlphaEnabled) {
                this.dialogShell.setAlpha(254);
            }
            this.dialogShell.setLayout((Layout)new FormLayout());
            this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
            this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    if (!AkkumatikDialog.this.isDisposed()) {
                        AkkumatikDialog.this.getDialogShell().dispose();
                    }
                }
            });
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            AkkumatikDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.setSize(390, GDE.IS_LINUX ? 475 : 490);
            this.dialogShell.setLayout((Layout)new FormLayout());
            this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
            Composite composite = new Composite((Composite)this.dialogShell, 0);
            composite.setLayout((Layout)new RowLayout(256));
            FormData fd_composite = new FormData();
            fd_composite.bottom = new FormAttachment(0, GDE.IS_MAC ? 380 : 365);
            fd_composite.top = new FormAttachment(0, 10);
            fd_composite.right = new FormAttachment(0, 380);
            fd_composite.left = new FormAttachment(0, 10);
            composite.setLayoutData((Object)fd_composite);
            Composite composite_1 = new Composite(composite, 0);
            GridLayout shellLayout = new GridLayout(4, false);
            shellLayout.verticalSpacing = 0;
            shellLayout.horizontalSpacing = 0;
            shellLayout.marginWidth = 0;
            composite_1.setLayout((Layout)shellLayout);
            composite_1.setLayoutData((Object)new RowData(365, -1));
            this.programNameSelection = new CCombo(composite_1, 2048);
            this.programNameSelection.setEditable(false);
            this.programNameSelection.setBackground(this.application.COLOR_WHITE);
            this.programNameSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting = AkkumatikDialog.this.akkuSettings.get(AkkumatikDialog.this.programNameSelection.getSelectionIndex());
                    log.log(Level.FINE, "ProgramName = " + AkkumatikDialog.this.actualAkkuSetting.getName());
                    AkkumatikDialog.this.update(Akkumatik.ACCU_TYPES[AkkumatikDialog.this.akkuSettings.get(AkkumatikDialog.this.programNameSelection.getSelectionIndex()).getAccuTyp()], AkkumatikDialog.this.akkuSettings.get(AkkumatikDialog.this.programNameSelection.getSelectionIndex()).getChannel());
                    AkkumatikDialog.this.akkumatikSettings.getDialogSettings().setActiveChannel(AkkumatikDialog.this.btnChannel1.getSelection() ? 1 : 2);
                    switch (AkkumatikDialog.this.akkuSettings.get(AkkumatikDialog.this.programNameSelection.getSelectionIndex()).getChannel()) {
                        case 1: {
                            AkkumatikDialog.this.akkumatikSettings.getDialogSettings().getChannel1().setActiveSetting(AkkumatikDialog.this.programNameSelection.getSelectionIndex());
                            break;
                        }
                        case 2: {
                            AkkumatikDialog.this.akkumatikSettings.getDialogSettings().getChannel2().setActiveSetting(AkkumatikDialog.this.programNameSelection.getSelectionIndex());
                        }
                    }
                }
            });
            this.programNameSelection.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.character == '\r') {
                        AkkumatikDialog.this.programNameSelection.setEditable(false);
                        AkkumatikDialog.this.actualAkkuSetting.setName(AkkumatikDialog.this.programNameSelection.getText());
                        log.log(Level.FINE, "ProgramName = " + AkkumatikDialog.this.actualAkkuSetting.getName());
                        if (AkkumatikDialog.this.akkumatikSettings.getAkkuSettings() != null) {
                            AkkumatikDialog.this.akkuSettings = AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting;
                            String[] programNames = new String[AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size()];
                            for (int i = 0; i < AkkumatikDialog.this.akkuSettings.size(); ++i) {
                                programNames[i] = AkkumatikDialog.this.akkuSettings.get(i).getName();
                            }
                            AkkumatikDialog.this.programNameSelection.setItems(programNames);
                            AkkumatikDialog.this.programNameSelection.select(AkkumatikDialog.this.getActiveChannelProgram());
                        }
                    }
                }
            });
            GridData gd_programSelection = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_programSelection.widthHint = 210;
            gd_programSelection.heightHint = GDE.IS_WINDOWS ? -1 : this.comboHeight;
            this.programNameSelection.setLayoutData((Object)gd_programSelection);
            this.programNameSelection.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            log.log(Level.FINE, String.format("this.akkumatikSettings.getAkkuSettings() != null -> %b", this.akkumatikSettings.getAkkuSettings() != null));
            if (this.akkumatikSettings.getAkkuSettings() != null) {
                this.akkuSettings = this.akkumatikSettings.getAkkuSettings().setting;
                String[] programNames = new String[this.akkumatikSettings.getAkkuSettings().setting.size()];
                for (int i = 0; i < this.akkuSettings.size(); ++i) {
                    programNames[i] = this.akkuSettings.get(i).getName();
                    log.log(Level.INFO, String.format("add prrogram name -> %s", this.akkuSettings.get(i).getName()));
                }
                this.programNameSelection.setItems(programNames);
                this.programNameSelection.select(this.getActiveChannelProgram());
            }
            this.actualAkkuSetting = this.akkuSettings.get(this.programNameSelection.getSelectionIndex());
            Button addEntry = new Button(composite_1, 0);
            GridData gdButton = new GridData(16384, 0x1000000, false, false, 1, 1);
            gdButton.widthHint = 45;
            gdButton.heightHint = GDE.IS_WINDOWS ? -1 : this.comboHeight;
            addEntry.setLayoutData((Object)gdButton);
            addEntry.setText("+");
            addEntry.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            addEntry.setToolTipText(Messages.getString((String)"GDE_MSGT3467"));
            addEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int number = AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size();
                    AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().getSetting().add(AkkumatikDialog.this.createAkkuSetting("Initial_" + number, 1, 0, 2, 0, 1000, 34, 2, 0, 0, 0, 100, 100));
                    AkkumatikDialog.this.akkuSettings = AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting;
                    String[] programNames = new String[AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size()];
                    for (int i = 0; i < AkkumatikDialog.this.akkuSettings.size(); ++i) {
                        programNames[i] = AkkumatikDialog.this.akkuSettings.get(i).getName();
                    }
                    AkkumatikDialog.this.programNameSelection.setItems(programNames);
                    AkkumatikDialog.this.akkumatikSettings.getDialogSettings().getChannel1().setActiveSetting(programNames.length - 1);
                    AkkumatikDialog.this.programNameSelection.select(programNames.length - 1);
                    AkkumatikDialog.this.actualAkkuSetting = AkkumatikDialog.this.akkuSettings.get(programNames.length - 1);
                    AkkumatikDialog.this.removeEntry.setEnabled(AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size() > 0);
                    AkkumatikDialog.this.editEntry.setEnabled(AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size() > 0);
                }
            });
            this.removeEntry = new Button(composite_1, 0);
            this.removeEntry.setLayoutData((Object)gdButton);
            this.removeEntry.setText("-");
            this.removeEntry.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
            this.removeEntry.setToolTipText(Messages.getString((String)"GDE_MSGT3468"));
            this.removeEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.programSelectionIndex = AkkumatikDialog.this.programNameSelection.getSelectionIndex();
                    if (AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size() > 0) {
                        AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().getSetting().remove(AkkumatikDialog.this.programSelectionIndex);
                        String[] programNames = new String[AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size()];
                        for (int i = 0; i < AkkumatikDialog.this.akkuSettings.size(); ++i) {
                            programNames[i] = AkkumatikDialog.this.akkuSettings.get(i).getName();
                        }
                        AkkumatikDialog.this.programNameSelection.setItems(programNames);
                        AkkumatikDialog.this.akkumatikSettings.getDialogSettings().getChannel1().setActiveSetting(programNames.length - 1);
                        if (AkkumatikDialog.this.programSelectionIndex > 0) {
                            AkkumatikDialog.this.programNameSelection.select(AkkumatikDialog.this.programSelectionIndex - 1);
                        } else {
                            AkkumatikDialog.this.programNameSelection.select(0);
                        }
                    }
                    AkkumatikDialog.this.actualAkkuSetting = AkkumatikDialog.this.akkuSettings.get(AkkumatikDialog.this.programNameSelection.getSelectionIndex());
                    AkkumatikDialog.this.removeEntry.setEnabled(AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size() > 0);
                    AkkumatikDialog.this.editEntry.setEnabled(AkkumatikDialog.this.akkumatikSettings.getAkkuSettings().setting.size() > 0);
                }
            });
            this.removeEntry.setEnabled(this.akkumatikSettings.getAkkuSettings().setting.size() > 0);
            this.editEntry = new Button(composite_1, 0);
            this.editEntry.setLayoutData((Object)gdButton);
            this.editEntry.setText(Messages.getString((String)"GDE_MSGT3450"));
            this.editEntry.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.editEntry.setToolTipText(Messages.getString((String)"GDE_MSGT3469"));
            this.editEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.programSelectionIndex = AkkumatikDialog.this.programNameSelection.getSelectionIndex();
                    AkkumatikDialog.this.programNameSelection.setEditable(true);
                }
            });
            this.editEntry.setEnabled(this.akkumatikSettings.getAkkuSettings().setting.size() > 0);
            Group grpBattery = new Group(composite, 0);
            grpBattery.setLayout((Layout)new RowLayout(256));
            grpBattery.setLayoutData((Object)new RowData(170, GDE.IS_LINUX ? 135 : 120));
            grpBattery.setText(Messages.getString((String)"GDE_MSGT3451"));
            grpBattery.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            Composite filler = new Composite((Composite)grpBattery, 0);
            filler.setLayoutData((Object)new RowData(100, 1));
            Label lblBatteryType = new Label((Composite)grpBattery, 0);
            lblBatteryType.setLayoutData((Object)new RowData(90, this.comboHeight));
            lblBatteryType.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblBatteryType.setText(Messages.getString((String)"GDE_MSGT3452"));
            lblBatteryType.setToolTipText(Messages.getString((String)"GDE_MSGT3470"));
            this.batteryTypeCombo = new CCombo((Composite)grpBattery, 2048);
            this.batteryTypeCombo.setEditable(false);
            this.batteryTypeCombo.setBackground(this.application.COLOR_WHITE);
            this.batteryTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.batteryTypeCombo.setItems(Akkumatik.ACCU_TYPES);
            this.batteryTypeCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getAccuTyp().intValue());
            this.batteryTypeCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3470"));
            this.batteryTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.update(AkkumatikDialog.this.batteryTypeCombo.getText(), AkkumatikDialog.this.btnChannel1.getSelection() ? 1 : 2);
                    AkkumatikDialog.this.actualAkkuSetting.setAccuTyp(AkkumatikDialog.this.batteryTypeCombo.getSelectionIndex());
                    log.log(Level.FINE, "AccuTyp = " + AkkumatikDialog.this.actualAkkuSetting.getAccuTyp());
                    AkkumatikDialog.this.currentModeCombo.select(0);
                }
            });
            this.batteryTypeCombo.setLayoutData((Object)new RowData(70, this.comboHeight));
            filler = new Composite((Composite)grpBattery, 0);
            filler.setLayoutData((Object)new RowData(100, GDE.IS_MAC ? 6 : 4));
            Label lblCapacity = new Label((Composite)grpBattery, 0);
            lblCapacity.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblCapacity.setLayoutData((Object)new RowData(90, this.comboHeight));
            lblCapacity.setText(Messages.getString((String)"GDE_MSGT3453"));
            lblCapacity.setToolTipText(Messages.getString((String)"GDE_MSGT3471"));
            this.capacityCombo = new CCombo((Composite)grpBattery, 2048);
            this.capacityCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            ArrayList<CallSite> capa = new ArrayList<CallSite>();
            for (int i = 1; i < 101; ++i) {
                capa.add((CallSite)((Object)("" + 100 * i)));
            }
            this.capacityCombo.setItems(capa.toArray(new String[0]));
            this.capacityCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getCapacity() / 100 - 1);
            this.capacityCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3471"));
            this.capacityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setCapacity(Integer.parseInt(AkkumatikDialog.this.capacityCombo.getText()));
                    log.log(Level.FINE, "Capacity = " + AkkumatikDialog.this.actualAkkuSetting.getCapacity());
                }
            });
            this.capacityCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.character == '\r') {
                        int value = Integer.parseInt(AkkumatikDialog.this.capacityCombo.getText());
                        if (value > 65535) {
                            value = 65535;
                        } else if (value < 100) {
                            value = 100;
                        }
                        AkkumatikDialog.this.capacityCombo.setText("" + value);
                        AkkumatikDialog.this.actualAkkuSetting.setCapacity(value);
                        log.log(Level.FINE, "Capacity = " + AkkumatikDialog.this.actualAkkuSetting.getCapacity());
                    }
                }
            });
            this.capacityCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    evt.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)evt.text);
                }
            });
            this.capacityCombo.setLayoutData((Object)new RowData(70, this.comboHeight));
            filler = new Composite((Composite)grpBattery, 0);
            filler.setLayoutData((Object)new RowData(100, GDE.IS_MAC ? 6 : 4));
            Label lblNumberCells = new Label((Composite)grpBattery, 0);
            lblNumberCells.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblNumberCells.setLayoutData((Object)new RowData(90, this.comboHeight));
            lblNumberCells.setText(Messages.getString((String)"GDE_MSGT3454"));
            lblNumberCells.setToolTipText(Messages.getString((String)"GDE_MSGT3472"));
            this.cellCountCombo = new CCombo((Composite)grpBattery, 2048);
            this.cellCountCombo.setEditable(false);
            this.cellCountCombo.setBackground(this.application.COLOR_WHITE);
            this.cellCountCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            ArrayList<CallSite> cells = new ArrayList<CallSite>();
            for (int i = 1; i < 35; ++i) {
                cells.add((CallSite)((Object)("" + i)));
            }
            this.cellCountCombo.setItems(cells.toArray(new String[0]));
            this.cellCountCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getCellCount() - 1);
            this.cellCountCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3472"));
            this.cellCountCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setCellCount((short)(AkkumatikDialog.this.cellCountCombo.getSelectionIndex() + 1));
                    log.log(Level.FINE, "CellCount = " + AkkumatikDialog.this.actualAkkuSetting.getCellCount());
                }
            });
            this.cellCountCombo.setLayoutData((Object)new RowData(70, this.comboHeight));
            Composite composite_2 = new Composite(composite, 0);
            composite_2.setLayout((Layout)new RowLayout(256));
            composite_2.setLayoutData((Object)new RowData(178, GDE.IS_MAC ? 150 : 135));
            Group grpChannel = new Group(composite_2, 0);
            grpChannel.setLayoutData((Object)new RowData(165, GDE.IS_LINUX ? 30 : (GDE.IS_MAC ? 25 : 20)));
            grpChannel.setLayout((Layout)new RowLayout(256));
            grpChannel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            grpChannel.setText(Messages.getString((String)"GDE_MSGT3455"));
            this.btnChannel1 = new Button((Composite)grpChannel, 16);
            this.btnChannel1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.btnChannel1.setSelection(false);
            this.btnChannel1.setToolTipText(Messages.getString((String)"GDE_MSGT3473"));
            this.btnChannel1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.update(AkkumatikDialog.this.batteryTypeCombo.getText(), AkkumatikDialog.this.btnChannel1.getSelection() ? 1 : 2);
                    AkkumatikDialog.this.actualAkkuSetting.setChannel(AkkumatikDialog.this.btnChannel1.getSelection() ? 1 : 2);
                    log.log(Level.FINE, "Channel = " + AkkumatikDialog.this.actualAkkuSetting.getChannel());
                }
            });
            this.btnChannel1.setLayoutData((Object)new RowData(75, this.comboHeight));
            this.btnChannel1.setText(Messages.getString((String)"GDE_MSGT3455") + " 1");
            this.btnChannel2 = new Button((Composite)grpChannel, 16);
            this.btnChannel2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.btnChannel2.setSelection(false);
            this.btnChannel2.setToolTipText(Messages.getString((String)"GDE_MSGT3473"));
            this.btnChannel2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.update(AkkumatikDialog.this.batteryTypeCombo.getText(), AkkumatikDialog.this.btnChannel1.getSelection() ? 1 : 2);
                    AkkumatikDialog.this.actualAkkuSetting.setChannel(AkkumatikDialog.this.btnChannel1.getSelection() ? 1 : 2);
                    log.log(Level.FINE, "Channel = " + AkkumatikDialog.this.actualAkkuSetting.getChannel());
                }
            });
            this.btnChannel2.setLayoutData((Object)new RowData(75, this.comboHeight));
            this.btnChannel2.setText(Messages.getString((String)"GDE_MSGT3455") + " 2");
            Group grpProgramm = new Group(composite_2, 0);
            grpProgramm.setLayoutData((Object)new RowData(165, GDE.IS_LINUX ? 68 : 58));
            grpProgramm.setLayout((Layout)new RowLayout(256));
            grpProgramm.setText(Messages.getString((String)"GDE_MSGT3456"));
            grpProgramm.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            Label lblName = new Label((Composite)grpProgramm, 0);
            lblName.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblName.setLayoutData((Object)new RowData(60, this.comboHeight));
            lblName.setText("Name");
            lblName.setToolTipText(Messages.getString((String)"GDE_MSGT3474"));
            this.programCombo = new CCombo((Composite)grpProgramm, 2048);
            this.programCombo.setEditable(false);
            this.programCombo.setBackground(this.application.COLOR_WHITE);
            this.programCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.programCombo.setItems(Akkumatik.PROCESS_MODE);
            this.programCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getProgram().intValue());
            this.programCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3474"));
            this.programCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AkkumatikDialog.this.programCombo.getSelectionIndex() > 1 && AkkumatikDialog.this.programCombo.getSelectionIndex() < 6) {
                        AkkumatikDialog.this.cycleCountCombo.setEnabled(true);
                    } else {
                        AkkumatikDialog.this.cycleCountCombo.select(0);
                        AkkumatikDialog.this.cycleCountCombo.setEnabled(false);
                    }
                    AkkumatikDialog.this.actualAkkuSetting.setProgram(AkkumatikDialog.this.findIndexByName(Akkumatik.PROCESS_MODE, AkkumatikDialog.this.programCombo.getText()));
                    log.log(Level.FINE, "Program = " + AkkumatikDialog.this.actualAkkuSetting.getProgram());
                    AkkumatikDialog.this.updateChargeDischarge();
                }
            });
            this.programCombo.setLayoutData((Object)new RowData(90, this.comboHeight));
            filler = new Composite((Composite)grpProgramm, 0);
            filler.setLayoutData((Object)new RowData(120, 2));
            this.lblCycleCount = new Label((Composite)grpProgramm, 0);
            this.lblCycleCount.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.lblCycleCount.setLayoutData((Object)new RowData(60, this.comboHeight));
            this.lblCycleCount.setText(Messages.getString((String)"GDE_MSGT3457"));
            this.lblCycleCount.setToolTipText(Messages.getString((String)"GDE_MSGT3475"));
            this.cycleCountCombo = new CCombo((Composite)grpProgramm, 2048);
            this.cycleCountCombo.setEditable(false);
            this.cycleCountCombo.setBackground(this.application.COLOR_WHITE);
            ArrayList<CallSite> counts = new ArrayList<CallSite>();
            for (int i = 0; i < 10; ++i) {
                counts.add((CallSite)((Object)("" + i)));
            }
            this.cycleCountCombo.setItems(counts.toArray(new String[0]));
            this.cycleCountCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getCycle().intValue());
            this.cycleCountCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.cycleCountCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3475"));
            this.cycleCountCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setCycle(AkkumatikDialog.this.cycleCountCombo.getSelectionIndex());
                    log.log(Level.FINE, "Cycle = " + AkkumatikDialog.this.actualAkkuSetting.getCycle());
                }
            });
            this.cycleCountCombo.setLayoutData((Object)new RowData(90, this.comboHeight));
            this.grpCharge = new Group(composite, 0);
            this.grpCharge.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.grpCharge.setLayout((Layout)new RowLayout(256));
            this.grpCharge.setLayoutData((Object)new RowData(170, GDE.IS_LINUX ? 100 : 90));
            this.grpCharge.setText(Messages.getString((String)"GDE_MSGT3400"));
            this.lblChargeMode = new Label((Composite)this.grpCharge, 0);
            this.lblChargeMode.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.lblChargeMode.setLayoutData((Object)new RowData(80, this.comboHeight));
            this.lblChargeMode.setText(Messages.getString((String)"GDE_MSGT3458"));
            this.lblChargeMode.setToolTipText(Messages.getString((String)"GDE_MSGT3476"));
            this.chargeModeCombo = new CCombo((Composite)this.grpCharge, 2048);
            this.chargeModeCombo.setEditable(false);
            this.chargeModeCombo.setBackground(this.application.COLOR_WHITE);
            this.chargeModeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE);
            this.chargeModeCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getChargeMode().intValue());
            this.chargeModeCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3476"));
            this.chargeModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setChargeMode(AkkumatikDialog.this.findIndexByName(Akkumatik.CHARGE_MODE, AkkumatikDialog.this.chargeModeCombo.getText()));
                    log.log(Level.FINE, "ChargeMode = " + AkkumatikDialog.this.actualAkkuSetting.getChargeMode());
                }
            });
            this.chargeModeCombo.setLayoutData((Object)new RowData(80, this.comboHeight));
            filler = new Composite((Composite)this.grpCharge, 0);
            filler.setLayoutData((Object)new RowData(120, GDE.IS_MAC ? 4 : 2));
            Label lblChargeCurrent = new Label((Composite)this.grpCharge, 0);
            lblChargeCurrent.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblChargeCurrent.setLayoutData((Object)new RowData(80, this.comboHeight));
            lblChargeCurrent.setText(Messages.getString((String)"GDE_MSGT3459"));
            lblChargeCurrent.setToolTipText(Messages.getString((String)"GDE_MSGT3477"));
            this.chargeCurrentCombo = new CCombo((Composite)this.grpCharge, 2048);
            this.chargeCurrentCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            ArrayList<CallSite> chargeCurrentList = new ArrayList<CallSite>();
            for (int i = 1; i < 201; ++i) {
                chargeCurrentList.add((CallSite)((Object)("" + 50 * i)));
            }
            this.chargeCurrentCombo.setItems(chargeCurrentList.toArray(new String[0]));
            this.chargeCurrentCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getChargeCurrent() / 50 - 1);
            this.chargeCurrentCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3477"));
            this.chargeCurrentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setChargeCurrent(Integer.parseInt(AkkumatikDialog.this.chargeCurrentCombo.getText()));
                    log.log(Level.FINE, "ChargeCurrent = " + AkkumatikDialog.this.actualAkkuSetting.getChargeCurrent());
                }
            });
            this.chargeCurrentCombo.setLayoutData((Object)new RowData(80, this.comboHeight));
            this.chargeCurrentCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.character == '\r') {
                        int value = Integer.parseInt(AkkumatikDialog.this.chargeCurrentCombo.getText());
                        if (value > 9999) {
                            value = 9999;
                        } else if (value < 50) {
                            value = 50;
                        }
                        AkkumatikDialog.this.chargeCurrentCombo.setText("" + value);
                        AkkumatikDialog.this.actualAkkuSetting.setChargeCurrent(value);
                        log.log(Level.FINE, "ChargeCurrent = " + AkkumatikDialog.this.actualAkkuSetting.getChargeCurrent());
                    }
                }
            });
            this.chargeCurrentCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    evt.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)evt.text);
                }
            });
            filler = new Composite((Composite)this.grpCharge, 0);
            filler.setLayoutData((Object)new RowData(120, GDE.IS_MAC ? 4 : 2));
            Label lblStopMode = new Label((Composite)this.grpCharge, 0);
            lblStopMode.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblStopMode.setLayoutData((Object)new RowData(80, this.comboHeight));
            lblStopMode.setText("Stop Mode");
            lblStopMode.setToolTipText(Messages.getString((String)"GDE_MSGT3478"));
            this.chargeStopModeCombo = new CCombo((Composite)this.grpCharge, 2048);
            this.chargeStopModeCombo.setEditable(false);
            this.chargeStopModeCombo.setBackground(this.application.COLOR_WHITE);
            this.chargeStopModeCombo.setItems(STOP_MODE);
            this.chargeStopModeCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getChargeStopMode().intValue());
            this.chargeStopModeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.chargeStopModeCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3478"));
            this.chargeStopModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setChargeStopMode(AkkumatikDialog.this.findIndexByName(STOP_MODE, AkkumatikDialog.this.chargeStopModeCombo.getText()));
                    log.log(Level.FINE, "ChargeStopMode = " + AkkumatikDialog.this.actualAkkuSetting.getChargeStopMode());
                }
            });
            this.chargeStopModeCombo.setLayoutData((Object)new RowData(80, this.comboHeight));
            this.currentTypeAmountGrp = new Composite(composite, 0);
            this.currentTypeAmountGrp.setLayout((Layout)new RowLayout(256));
            this.currentTypeAmountGrp.setLayoutData((Object)new RowData(170, GDE.IS_LINUX ? 95 : (GDE.IS_WINDOWS ? 85 : 75)));
            Composite composite_4 = new Composite(this.currentTypeAmountGrp, 0);
            composite_4.setLayoutData((Object)new RowData(150, 20));
            this.lblCurrentMode = new Label(this.currentTypeAmountGrp, 0);
            this.lblCurrentMode.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.lblCurrentMode.setLayoutData((Object)new RowData(75, this.comboHeight));
            this.lblCurrentMode.setText(Messages.getString((String)"GDE_MSGT3460"));
            this.lblCurrentMode.setToolTipText(Messages.getString((String)"GDE_MSGT3479"));
            this.currentModeCombo = new CCombo(this.currentTypeAmountGrp, 2048);
            this.currentModeCombo.setEditable(false);
            this.currentModeCombo.setBackground(this.application.COLOR_WHITE);
            this.currentModeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE);
            this.currentModeCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getCurrentMode().intValue());
            this.currentModeCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3479"));
            this.currentModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setCurrentMode(AkkumatikDialog.this.findIndexByName(CHARGE_CURRENT_TYPE, AkkumatikDialog.this.currentModeCombo.getText()));
                    log.log(Level.FINE, "CurrentMode = " + AkkumatikDialog.this.actualAkkuSetting.getCurrentMode());
                }
            });
            this.currentModeCombo.setLayoutData((Object)new RowData(70, this.comboHeight));
            filler = new Composite(this.currentTypeAmountGrp, 0);
            filler.setLayoutData((Object)new RowData(120, GDE.IS_MAC ? 4 : 2));
            Label lblCapacityAmount = new Label(this.currentTypeAmountGrp, 0);
            lblCapacityAmount.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblCapacityAmount.setLayoutData((Object)new RowData(75, this.comboHeight));
            lblCapacityAmount.setText(Messages.getString((String)"GDE_MSGT3461"));
            lblCapacityAmount.setToolTipText(Messages.getString((String)"GDE_MSGT3480"));
            this.chargeAmountCombo = new CCombo(this.currentTypeAmountGrp, 2048);
            this.chargeAmountCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            ArrayList<Object> capaAmount = new ArrayList<Object>();
            for (int i = 1; i < 100; ++i) {
                capaAmount.add("" + 100 * i);
            }
            capaAmount.add(0, "0");
            this.chargeAmountCombo.setItems(capaAmount.toArray(new String[0]));
            this.chargeAmountCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getAmount() / 100);
            this.chargeAmountCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3480"));
            this.chargeAmountCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setAmount(Integer.parseInt(AkkumatikDialog.this.chargeAmountCombo.getText()));
                    log.log(Level.FINE, "Amount = " + AkkumatikDialog.this.actualAkkuSetting.getAmount());
                }
            });
            this.chargeAmountCombo.setLayoutData((Object)new RowData(70, this.comboHeight));
            this.chargeAmountCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.character == '\r') {
                        int value = Integer.parseInt(AkkumatikDialog.this.chargeAmountCombo.getText());
                        if (value > 65535) {
                            value = 65535;
                        }
                        AkkumatikDialog.this.chargeAmountCombo.setText("" + value);
                        AkkumatikDialog.this.actualAkkuSetting.setAmount(value);
                        log.log(Level.FINE, "Amount = " + AkkumatikDialog.this.actualAkkuSetting.getAmount());
                    }
                }
            });
            this.chargeAmountCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    evt.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)evt.text);
                }
            });
            this.grpDischarge = new Group(composite, 0);
            this.grpDischarge.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.grpDischarge.setLayout((Layout)new RowLayout(256));
            this.grpDischarge.setLayoutData((Object)new RowData(170, GDE.IS_LINUX ? 40 : (GDE.IS_WINDOWS ? 35 : 25)));
            this.grpDischarge.setText(Messages.getString((String)"GDE_MSGT3401"));
            Label lblDischargeCurrent = new Label((Composite)this.grpDischarge, 0);
            lblDischargeCurrent.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            lblDischargeCurrent.setLayoutData((Object)new RowData(80, this.comboHeight));
            lblDischargeCurrent.setText(Messages.getString((String)"GDE_MSGT3459"));
            lblDischargeCurrent.setToolTipText(Messages.getString((String)"GDE_MSGT3481"));
            this.dischargeCurrentCombo = new CCombo((Composite)this.grpDischarge, 2048);
            this.dischargeCurrentCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            ArrayList<CallSite> dischargeCurrentList = new ArrayList<CallSite>();
            for (int i = 1; i < 101; ++i) {
                dischargeCurrentList.add((CallSite)((Object)("" + 50 * i)));
            }
            this.dischargeCurrentCombo.setItems(dischargeCurrentList.toArray(new String[0]));
            this.dischargeCurrentCombo.select(this.akkuSettings.get(this.getActiveChannelProgram()).getDisChargeCurrent() / 50 - 1);
            this.dischargeCurrentCombo.setToolTipText(Messages.getString((String)"GDE_MSGT3481"));
            this.dischargeCurrentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.actualAkkuSetting.setDisChargeCurrent(Integer.parseInt(AkkumatikDialog.this.dischargeCurrentCombo.getText()));
                    log.log(Level.FINE, "DisChargeCurrent = " + AkkumatikDialog.this.actualAkkuSetting.getDisChargeCurrent());
                }
            });
            this.dischargeCurrentCombo.setLayoutData((Object)new RowData(80, this.comboHeight));
            this.dischargeCurrentCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    if (evt.character == '\r') {
                        int value = Integer.parseInt(AkkumatikDialog.this.dischargeCurrentCombo.getText());
                        if (value > 5000) {
                            value = 5000;
                        } else if (value < 50) {
                            value = 50;
                        }
                        AkkumatikDialog.this.dischargeCurrentCombo.setText("" + value);
                        AkkumatikDialog.this.actualAkkuSetting.setDisChargeCurrent(value);
                        log.log(Level.FINE, "DisChargeCurrent = " + AkkumatikDialog.this.actualAkkuSetting.getDisChargeCurrent());
                    }
                }
            });
            this.dischargeCurrentCombo.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    evt.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.INTEGER, (String)evt.text);
                }
            });
            this.statusLabel = new Label((Composite)this.dialogShell, 0);
            this.statusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            FormData fd_statusLabel = new FormData();
            fd_statusLabel.left = new FormAttachment((Control)composite, 10, 16384);
            fd_statusLabel.bottom = new FormAttachment((Control)composite, 20, 1024);
            fd_statusLabel.top = new FormAttachment((Control)composite, 2);
            fd_statusLabel.right = new FormAttachment((Control)composite, -10, 131072);
            this.statusLabel.setLayoutData((Object)fd_statusLabel);
            Composite composite_5 = new Composite((Composite)this.dialogShell, 0);
            composite_5.setLayout((Layout)new RowLayout(256));
            FormData fd_composite_5 = new FormData();
            fd_composite_5.top = new FormAttachment((Control)this.statusLabel, 2);
            fd_composite_5.bottom = new FormAttachment(0, 450);
            fd_composite_5.left = new FormAttachment(0, 10);
            fd_composite_5.right = new FormAttachment(0, 375);
            composite_5.setLayoutData((Object)fd_composite_5);
            this.btnTransfer = new Button(composite_5, 0);
            this.btnTransfer.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.btnTransfer.setEnabled(true);
            this.btnTransfer.setToolTipText(Messages.getString((String)"GDE_MSGT3482"));
            this.btnTransfer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    byte[] prg = AkkumatikSerialPort.getBytes2Write(AkkumatikDialog.this.actualAkkuSetting.toString());
                    AkkumatikDialog.this.statusLabel.setText("<STX> " + new String(prg) + " <CS> <ETX>");
                    log.log(Level.INFO, "Transfer: " + new String(prg));
                    if (AkkumatikDialog.this.serialPort != null && AkkumatikDialog.this.serialPort.isConnected()) {
                        AkkumatikDialog.setData2Write(prg);
                    }
                }
            });
            this.btnTransfer.setLayoutData((Object)new RowData(GDE.IS_MAC ? 118 : 115, GDE.IS_WINDOWS ? -1 : this.comboHeight));
            this.btnTransfer.setText(Messages.getString((String)"GDE_MSGT3462"));
            this.btnStart = new Button(composite_5, 0);
            this.btnStart.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.btnStart.setEnabled(true);
            this.btnStart.setToolTipText(Messages.getString((String)"GDE_MSGT3483"));
            this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.statusLabel.setText("<STX>44B<ETX>");
                    if (AkkumatikDialog.this.serialPort != null && AkkumatikDialog.this.serialPort.isConnected()) {
                        if (AkkumatikDialog.this.btnChannel1.getSelection()) {
                            AkkumatikDialog.setData2Write(START_CH_1);
                        } else if (AkkumatikDialog.this.btnChannel2.getSelection()) {
                            AkkumatikDialog.setData2Write(START_CH_2);
                        }
                    }
                }
            });
            this.btnStart.setLayoutData((Object)new RowData(GDE.IS_MAC ? 118 : 115, GDE.IS_WINDOWS ? -1 : this.comboHeight));
            this.btnStart.setText("Start");
            this.btnStop = new Button(composite_5, 0);
            this.btnStop.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            this.btnStop.setEnabled(true);
            this.btnStop.setToolTipText(Messages.getString((String)"GDE_MSGT3483"));
            this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.statusLabel.setText("<STX>41G<ETX>");
                    if (AkkumatikDialog.this.serialPort != null && AkkumatikDialog.this.serialPort.isConnected()) {
                        if (AkkumatikDialog.this.btnChannel1.getSelection()) {
                            AkkumatikDialog.setData2Write(STOP_CH_1);
                        } else if (AkkumatikDialog.this.btnChannel2.getSelection()) {
                            AkkumatikDialog.setData2Write(STOP_CH_2);
                        }
                    }
                }
            });
            this.btnStop.setLayoutData((Object)new RowData(GDE.IS_MAC ? 118 : 115, GDE.IS_WINDOWS ? -1 : this.comboHeight));
            this.btnStop.setText("Stop");
            Button btnClose = new Button(composite_5, 0);
            btnClose.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.dialogShell.dispose();
                }
            });
            btnClose.setLayoutData((Object)new RowData(GDE.IS_LINUX ? 352 : (GDE.IS_WINDOWS ? 350 : 360), GDE.IS_WINDOWS ? -1 : this.comboHeight));
            btnClose.setText(Messages.getString((String)"GDE_MSGT3463"));
            filler = new Composite(composite, 0);
            filler.setLayoutData((Object)new RowData(110, 10));
            Button btnHelp = new Button(composite, 0);
            btnHelp.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE - 1), (int)0));
            btnHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AkkumatikDialog.this.application.openHelpDialog(AkkumatikDialog.DEVICE_NAME, "HelpInfo.html");
                }
            });
            btnHelp.setLayoutData((Object)new RowData(GDE.IS_LINUX ? 40 : (GDE.IS_WINDOWS ? 38 : 43), GDE.IS_LINUX ? 40 : (GDE.IS_WINDOWS ? 38 : 43)));
            btnHelp.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
            this.update(Akkumatik.ACCU_TYPES[this.akkuSettings.get(this.programNameSelection.getSelectionIndex()).getAccuTyp()], this.akkuSettings.get(this.getActiveChannelProgram()).getChannel());
        }
    }

    private void update(String batteryType, int channelNumber) {
        this.capacityCombo.select(this.actualAkkuSetting.getCapacity() / 100 - 1);
        this.capacityCombo.setText("" + this.actualAkkuSetting.getCapacity());
        this.cycleCountCombo.select(this.actualAkkuSetting.getCycle().intValue());
        this.chargeCurrentCombo.select(this.actualAkkuSetting.getChargeCurrent() / 50 - 1);
        this.chargeCurrentCombo.setText("" + this.actualAkkuSetting.getChargeCurrent());
        this.chargeAmountCombo.select(this.actualAkkuSetting.getAmount() / 100);
        this.chargeAmountCombo.setText("" + this.actualAkkuSetting.getAmount());
        this.dischargeCurrentCombo.select(this.actualAkkuSetting.getDisChargeCurrent() / 50 - 1);
        this.dischargeCurrentCombo.setText("" + this.actualAkkuSetting.getDisChargeCurrent());
        switch (batteryType) {
            default: {
                this.batteryTypeCombo.select(0);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_NI);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_NI, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_NI);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_NI, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_NI);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_NI, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_NI);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_NI, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
                break;
            }
            case "NiMH": {
                this.batteryTypeCombo.select(1);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_NI);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_NI, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_NI);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_NI, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_NI);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_NI, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_NI);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_NI, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
                break;
            }
            case "Blei": 
            case "Pb": {
                this.batteryTypeCombo.select(2);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_PB);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_PB, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_PB);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_PB, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_PB);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_PB, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_PB);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_PB, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
                break;
            }
            case "BGel": 
            case "PbGel": {
                this.batteryTypeCombo.select(3);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_PB);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_PB, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_LI);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_PB, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_PB);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_PB, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_PB);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_PB, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
                break;
            }
            case "Li36": {
                this.batteryTypeCombo.select(4);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_LI);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_LI, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_LI);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_LI, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_LI);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_LI, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_PB);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_LI, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
                break;
            }
            case "Li37": {
                this.batteryTypeCombo.select(5);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_LI);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_LI, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_LI);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_LI, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_LI);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_LI, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_PB);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_LI, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
                break;
            }
            case "LiFe": {
                this.batteryTypeCombo.select(6);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_LI);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_LI, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_LI);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_LI, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_LI);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_LI, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_PB);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_LI, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
                break;
            }
            case "IUxx": {
                this.batteryTypeCombo.select(7);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_LI);
                this.programCombo.select(this.findIndexByName(Akkumatik.PROCESS_MODE_LI, Akkumatik.PROCESS_MODE[this.actualAkkuSetting.getProgram()]));
                this.chargeModeCombo.setItems(Akkumatik.CHARGE_MODE_LI);
                this.chargeModeCombo.select(this.findIndexByName(Akkumatik.CHARGE_MODE_LI, Akkumatik.CHARGE_MODE[this.actualAkkuSetting.getChargeMode()]));
                this.currentModeCombo.setItems(CHARGE_CURRENT_TYPE_LI);
                this.currentModeCombo.select(this.findIndexByName(CHARGE_CURRENT_TYPE_LI, CHARGE_CURRENT_TYPE[this.actualAkkuSetting.getCurrentMode()]));
                this.chargeStopModeCombo.setItems(STOP_MODE_PB);
                this.chargeStopModeCombo.select(this.findIndexByName(STOP_MODE_LI, STOP_MODE[this.actualAkkuSetting.getChargeStopMode()]));
            }
        }
        this.updateChargeDischarge();
        ArrayList<CallSite> cells = new ArrayList<CallSite>();
        block21 : switch (channelNumber) {
            default: {
                this.btnChannel1.setSelection(true);
                this.btnChannel2.setSelection(false);
                switch (batteryType) {
                    default: {
                        for (int i = 1; i < 35; ++i) {
                            cells.add((CallSite)((Object)("" + i)));
                        }
                        this.cellCountCombo.setItems(cells.toArray(new String[0]));
                        break block21;
                    }
                    case "Pb": 
                    case "PbGel": {
                        for (int i = 1; i < 21; ++i) {
                            cells.add((CallSite)((Object)("" + i)));
                        }
                        this.cellCountCombo.setItems(cells.toArray(new String[0]));
                        break block21;
                    }
                    case "Li36": 
                    case "Li37": {
                        for (int i = 1; i < 13; ++i) {
                            cells.add((CallSite)((Object)("" + i)));
                        }
                        this.cellCountCombo.setItems(cells.toArray(new String[0]));
                        break block21;
                    }
                    case "LiFe": {
                        this.batteryTypeCombo.select(6);
                        for (int i = 1; i < 15; ++i) {
                            cells.add((CallSite)((Object)("" + i)));
                        }
                        this.cellCountCombo.setItems(cells.toArray(new String[0]));
                        break block21;
                    }
                    case "IUxx": 
                }
                for (int i = 1; i < 13; ++i) {
                    cells.add((CallSite)((Object)("" + i)));
                }
                this.cellCountCombo.setItems(cells.toArray(new String[0]));
                break;
            }
            case 2: {
                this.btnChannel1.setSelection(false);
                this.btnChannel2.setSelection(true);
                this.programCombo.setItems(Akkumatik.PROCESS_MODE_CH2);
                this.programCombo.select(0);
                this.actualAkkuSetting.setProgram(0);
                this.lblChargeMode.setForeground(this.application.COLOR_GREY);
                this.chargeModeCombo.select(0);
                this.chargeModeCombo.setEnabled(false);
                this.actualAkkuSetting.setChargeMode(0);
                this.lblCurrentMode.setForeground(this.application.COLOR_GREY);
                this.currentModeCombo.select(2);
                this.currentModeCombo.setEnabled(false);
                this.actualAkkuSetting.setCurrentMode(2);
                switch (batteryType) {
                    default: {
                        for (int i = 1; i < 9; ++i) {
                            cells.add((CallSite)((Object)("" + i)));
                        }
                        this.cellCountCombo.setItems(cells.toArray(new String[0]));
                        break block21;
                    }
                    case "Pb": 
                    case "PbGel": {
                        for (int i = 1; i < 5; ++i) {
                            cells.add((CallSite)((Object)("" + i)));
                        }
                        this.cellCountCombo.setItems(cells.toArray(new String[0]));
                        break block21;
                    }
                    case "Li36": 
                    case "Li37": 
                    case "LiFe": 
                    case "IUxx": 
                }
                for (int i = 1; i < 4; ++i) {
                    cells.add((CallSite)((Object)("" + i)));
                }
                this.cellCountCombo.setItems(cells.toArray(new String[0]));
            }
        }
        int cellsSelection = this.actualAkkuSetting.getCellCount() - 1;
        if (cellsSelection > this.cellCountCombo.getItemCount() - 1) {
            this.cellCountCombo.select(this.cellCountCombo.getItemCount() - 1);
        } else {
            this.cellCountCombo.select(cellsSelection);
        }
    }

    private int findIndexByName(String[] nameArray, String searchString) {
        int index;
        boolean isMatchFound = false;
        for (index = 0; index < nameArray.length; ++index) {
            if (!nameArray[index].equals(searchString)) continue;
            isMatchFound = true;
            break;
        }
        log.log(Level.FINE, String.format("%s - isMatchFound %b return %d", searchString, isMatchFound, isMatchFound ? index : -1));
        return isMatchFound ? index : -1;
    }

    private int getActiveChannelProgram() {
        if (this.akkumatikSettings != null && this.akkumatikSettings.getDialogSettings() != null && this.akkumatikSettings.getDialogSettings().getActiveChannel() != null) {
            int activeSettingChannel = this.akkumatikSettings.getDialogSettings().getActiveChannel();
            int activeChannelProgram = activeSettingChannel == 1 ? this.akkumatikSettings.getDialogSettings().getChannel1().getActiveSetting() : this.akkumatikSettings.getDialogSettings().getChannel2().getActiveSetting();
            return activeChannelProgram;
        }
        return 0;
    }

    private void updateChargeDischarge() {
        switch (this.programCombo.getSelectionIndex()) {
            case 0: {
                this.grpCharge.setEnabled(true);
                for (Control child : this.grpCharge.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.currentTypeAmountGrp.setEnabled(true);
                for (Control child : this.currentTypeAmountGrp.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.grpDischarge.setEnabled(false);
                this.dischargeCurrentCombo.setText("0");
                this.actualAkkuSetting.setDisChargeCurrent(0);
                for (Control child : this.grpDischarge.getChildren()) {
                    child.setEnabled(false);
                    child.setForeground(this.application.COLOR_GREY);
                }
                this.cycleCountCombo.select(1);
                this.cycleCountCombo.setEnabled(false);
                this.actualAkkuSetting.setCycle(1);
                break;
            }
            case 1: {
                this.grpCharge.setEnabled(false);
                this.chargeCurrentCombo.setText("0");
                this.actualAkkuSetting.setChargeCurrent(0);
                for (Control child : this.grpCharge.getChildren()) {
                    child.setEnabled(false);
                    child.setForeground(this.application.COLOR_GREY);
                }
                this.currentTypeAmountGrp.setEnabled(false);
                for (Control child : this.currentTypeAmountGrp.getChildren()) {
                    child.setEnabled(false);
                    child.setForeground(this.application.COLOR_GREY);
                }
                this.grpDischarge.setEnabled(true);
                for (Control child : this.grpDischarge.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.cycleCountCombo.select(1);
                this.cycleCountCombo.setEnabled(false);
                this.actualAkkuSetting.setCycle(1);
                break;
            }
            case 6: {
                this.grpCharge.setEnabled(true);
                for (Control child : this.grpCharge.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.lblChargeMode.setForeground(this.application.COLOR_GREY);
                this.chargeModeCombo.setEnabled(false);
                this.chargeModeCombo.setForeground(this.application.COLOR_GREY);
                this.chargeModeCombo.select(0);
                this.actualAkkuSetting.setChargeMode(0);
                this.currentTypeAmountGrp.setEnabled(true);
                for (Control child : this.currentTypeAmountGrp.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.lblCurrentMode.setForeground(this.application.COLOR_GREY);
                this.currentModeCombo.select(2);
                this.currentModeCombo.setEnabled(false);
                this.currentModeCombo.setForeground(this.application.COLOR_GREY);
                this.actualAkkuSetting.setCurrentMode(2);
                this.grpDischarge.setEnabled(false);
                for (Control child : this.grpDischarge.getChildren()) {
                    child.setEnabled(false);
                    child.setForeground(this.application.COLOR_GREY);
                }
                this.lblCycleCount.setForeground(this.application.COLOR_GREY);
                this.cycleCountCombo.select(1);
                this.cycleCountCombo.setEnabled(false);
                this.actualAkkuSetting.setCycle(1);
                break;
            }
            case 7: {
                this.grpCharge.setEnabled(true);
                for (Control child : this.grpCharge.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.currentTypeAmountGrp.setEnabled(false);
                for (Control child : this.currentTypeAmountGrp.getChildren()) {
                    child.setEnabled(false);
                    child.setForeground(this.application.COLOR_GREY);
                }
                this.grpDischarge.setEnabled(true);
                for (Control child : this.grpDischarge.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.lblCycleCount.setForeground(this.application.COLOR_GREY);
                this.cycleCountCombo.select(1);
                this.cycleCountCombo.setEnabled(false);
                this.actualAkkuSetting.setCycle(1);
                break;
            }
            default: {
                this.grpCharge.setEnabled(true);
                for (Control child : this.grpCharge.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.currentTypeAmountGrp.setEnabled(true);
                for (Control child : this.currentTypeAmountGrp.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.grpDischarge.setEnabled(true);
                for (Control child : this.grpDischarge.getChildren()) {
                    child.setEnabled(true);
                    child.setForeground(this.application.COLOR_BLACK);
                }
                this.cycleCountCombo.select(1);
                this.cycleCountCombo.setEnabled(true);
                this.actualAkkuSetting.setCycle(1);
            }
        }
    }

    public static void main(String[] args) {
        AkkumatikDialog.initLogger();
        Logger.getLogger("").setLevel(Level.TIME);
        Settings.getInstance();
        String basePath = Settings.getApplHomePath();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(AkkumatikDialog.class.getClassLoader().getResourceAsStream("resource/Akkumatik_Settings_V01.xsd")));
            JAXBContext jc = JAXBContext.newInstance((String)"gde.device.estner");
            AMSettings akkumatikSettings = new ObjectFactory().createAMSettings();
            log.log(Level.TIME, "XSD init time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - GDE.StartTime)));
            try {
                long time = new Date().getTime();
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                unmarshaller.setSchema(schema);
                akkumatikSettings = (AMSettings)unmarshaller.unmarshal(new File(basePath + "/Akkumatik_Settings.xml"));
                log.log(Level.TIME, "read setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - time)));
                if (akkumatikSettings.getDialogSettings() != null) {
                    log.log(Level.OFF, "active channel = " + akkumatikSettings.getDialogSettings().getActiveChannel());
                    log.log(Level.OFF, "active setting channel 1, aktive entry = " + akkumatikSettings.getDialogSettings().getChannel1().getActiveSetting());
                    log.log(Level.OFF, "active setting channel 2, aktive entry = " + akkumatikSettings.getDialogSettings().getChannel2().getActiveSetting());
                }
                if (akkumatikSettings.getAkkuSettings() != null) {
                    List<Setting> akkuSettings = akkumatikSettings.getAkkuSettings().setting;
                    for (Setting setting : akkuSettings) {
                        log.log(Level.OFF, "Akku Setting Name = " + setting.getName());
                        AkkumatikSerialPort.getBytes2Write(setting.toString());
                    }
                }
                time = new Date().getTime();
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)AKKUMATIK_SETTINGS_XSD);
                marshaller.marshal((Object)akkumatikSettings, (OutputStream)new FileOutputStream(basePath + "/Akkumatik_Settings_1.xml"));
                log.log(Level.TIME, "write setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - GDE.StartTime)));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
    }

    public static void initLogger() {
        Handler[] handlers;
        logHandler = new ConsoleHandler();
        logHandler.setFormatter((Formatter)new LogFormatter());
        logHandler.setLevel(Level.INFO);
        rootLogger = Logger.getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.setLevel(Level.ALL);
        rootLogger.addHandler(logHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setData2Write(byte[] newData2Write) {
        byte[] byArray = data2Write;
        synchronized (data2Write) {
            data2Write = new byte[newData2Write.length];
            System.arraycopy(newData2Write, 0, data2Write, 0, data2Write.length);
            isDataAvailable = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData2Write() {
        byte[] byArray = data2Write;
        synchronized (data2Write) {
            byte[] retData2Write = null;
            if (isDataAvailable) {
                retData2Write = new byte[data2Write.length];
                System.arraycopy(data2Write, 0, retData2Write, 0, retData2Write.length);
                isDataAvailable = false;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return retData2Write;
        }
    }

    static {
        isDataAvailable = false;
        data2Write = new byte[0];
    }
}

