/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class CLabel
extends Canvas {
    private static final int GAP = 5;
    private static final int DEFAULT_MARGIN = 3;
    private static final String ELLIPSIS = "...";
    private int align = 16384;
    private int leftMargin = 3;
    private int topMargin = 3;
    private int rightMargin = 3;
    private int bottomMargin = 3;
    private String text;
    private Image image;
    private String appToolTipText;
    private boolean ignoreDispose;
    private Image backgroundImage;
    private Color[] gradientColors;
    private int[] gradientPercents;
    private boolean gradientVertical;
    private Color background;
    private static int DRAW_FLAGS = 15;

    public CLabel(Composite parent, int style) {
        super(parent, CLabel.checkStyle(style));
        if ((style & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(event -> this.onPaint(event));
        this.addTraverseListener(event -> {
            if (event.detail == 128) {
                this.onMnemonic(event);
            }
        });
        this.addListener(12, event -> this.onDispose(event));
        this.initAccessible();
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style |= 4;
        }
        int mask = 100663340;
        style &= mask;
        return style |= 0x20080000;
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        Point e2 = this.getTotalSize(this.image, this.text);
        e2.x = wHint == -1 ? (e2.x += this.leftMargin + this.rightMargin) : wHint;
        e2.y = hHint == -1 ? (e2.y += this.topMargin + this.bottomMargin) : hHint;
        return e2;
    }

    private void drawBevelRect(GC gc, int x2, int y2, int w2, int h2, Color topleft, Color bottomright) {
        gc.setForeground(bottomright);
        gc.drawLine(x2 + w2, y2, x2 + w2, y2 + h2);
        gc.drawLine(x2, y2 + h2, x2 + w2, y2 + h2);
        gc.setForeground(topleft);
        gc.drawLine(x2, y2, x2 + w2 - 1, y2);
        gc.drawLine(x2, y2, x2, y2 + h2 - 1);
    }

    char _findMnemonic(String string2) {
        if (string2 == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string2.length();
        while (true) {
            if (index < length && string2.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string2.charAt(index) != '&') {
                return Character.toLowerCase(string2.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public int getAlignment() {
        return this.align;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public Image getImage() {
        return this.image;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    private Point getTotalSize(Image image, String text2) {
        Point size = new Point(0, 0);
        if (image != null) {
            Rectangle r2 = image.getBounds();
            size.x += r2.width;
            size.y += r2.height;
        }
        GC gc = new GC(this);
        if (text2 != null && text2.length() > 0) {
            Point e2 = gc.textExtent(text2, DRAW_FLAGS);
            size.x += e2.x;
            size.y = Math.max(size.y, e2.y);
            if (image != null) {
                size.x += 5;
            }
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        gc.dispose();
        return size;
    }

    @Override
    public int getStyle() {
        int style = super.getStyle();
        switch (this.align) {
            case 131072: {
                style |= 0x20000;
                break;
            }
            case 0x1000000: {
                style |= 0x1000000;
                break;
            }
            case 16384: {
                style |= 0x4000;
            }
        }
        return style;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            @Override
            public void getName(AccessibleEvent e2) {
                e2.result = CLabel.this.getText();
            }

            @Override
            public void getHelp(AccessibleEvent e2) {
                e2.result = CLabel.this.getToolTipText();
            }

            @Override
            public void getKeyboardShortcut(AccessibleEvent e2) {
                char mnemonic = CLabel.this._findMnemonic(CLabel.this.text);
                if (mnemonic != '\u0000') {
                    e2.result = "Alt+" + mnemonic;
                }
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildAtPoint(AccessibleControlEvent e2) {
                e2.childID = -1;
            }

            @Override
            public void getLocation(AccessibleControlEvent e2) {
                Rectangle rect = CLabel.this.getDisplay().map((Control)CLabel.this.getParent(), null, CLabel.this.getBounds());
                e2.x = rect.x;
                e2.y = rect.y;
                e2.width = rect.width;
                e2.height = rect.height;
            }

            @Override
            public void getChildCount(AccessibleControlEvent e2) {
                e2.detail = 0;
            }

            @Override
            public void getRole(AccessibleControlEvent e2) {
                e2.detail = 41;
            }

            @Override
            public void getState(AccessibleControlEvent e2) {
                e2.detail = 64;
            }
        });
    }

    void onDispose(Event event) {
        if (this.ignoreDispose) {
            this.ignoreDispose = false;
            return;
        }
        this.ignoreDispose = true;
        this.notifyListeners(event.type, event);
        event.type = 0;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.backgroundImage = null;
        this.text = null;
        this.image = null;
        this.appToolTipText = null;
    }

    void onMnemonic(TraverseEvent event) {
        char mnemonic = this._findMnemonic(this.text);
        if (mnemonic == '\u0000') {
            return;
        }
        if (Character.toLowerCase(event.character) != mnemonic) {
            return;
        }
        Composite control = this.getParent();
        while (control != null) {
            Control[] children = control.getChildren();
            int index = 0;
            while (index < children.length) {
                if (children[index] == this) break;
                ++index;
            }
            if (++index < children.length && children[index].setFocus()) {
                event.doit = true;
                event.detail = 0;
            }
            control = control.getParent();
        }
    }

    void onPaint(PaintEvent event) {
        int x2;
        String[] lines;
        GC gc;
        Point extent;
        Image img;
        Rectangle rect;
        block41: {
            rect = this.getClientArea();
            if (rect.width == 0 || rect.height == 0) {
                return;
            }
            boolean shortenText = false;
            String t2 = this.text;
            img = this.image;
            int availableWidth = Math.max(0, rect.width - (this.leftMargin + this.rightMargin));
            extent = this.getTotalSize(img, t2);
            if (extent.x > availableWidth) {
                img = null;
                extent = this.getTotalSize(img, t2);
                if (extent.x > availableWidth) {
                    shortenText = true;
                }
            }
            gc = event.gc;
            String[] stringArray = lines = this.text == null ? null : this.splitString(this.text);
            if (shortenText) {
                extent.x = 0;
                int i2 = 0;
                while (i2 < lines.length) {
                    Point e2 = gc.textExtent(lines[i2], DRAW_FLAGS);
                    if (e2.x > availableWidth) {
                        lines[i2] = this.shortenText(gc, lines[i2], availableWidth);
                        extent.x = Math.max(extent.x, this.getTotalSize(null, (String)lines[i2]).x);
                    } else {
                        extent.x = Math.max(extent.x, e2.x);
                    }
                    ++i2;
                }
                if (this.appToolTipText == null) {
                    super.setToolTipText(this.text);
                }
            } else {
                super.setToolTipText(this.appToolTipText);
            }
            x2 = rect.x + this.leftMargin;
            if (this.align == 0x1000000) {
                x2 = (rect.width - extent.x) / 2;
            }
            if (this.align == 131072) {
                x2 = rect.width - this.rightMargin - extent.x;
            }
            try {
                if (this.backgroundImage != null) {
                    Rectangle imageRect = this.backgroundImage.getBounds();
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(rect);
                    int xPos = 0;
                    while (xPos < rect.width) {
                        int yPos = 0;
                        while (yPos < rect.height) {
                            gc.drawImage(this.backgroundImage, xPos, yPos);
                            yPos += imageRect.height;
                        }
                        xPos += imageRect.width;
                    }
                } else if (this.gradientColors != null) {
                    Color oldBackground = gc.getBackground();
                    if (this.gradientColors.length == 1) {
                        if (this.gradientColors[0] != null) {
                            gc.setBackground(this.gradientColors[0]);
                        }
                        gc.fillRectangle(0, 0, rect.width, rect.height);
                    } else {
                        Color oldForeground = gc.getForeground();
                        Color lastColor = this.gradientColors[0];
                        if (lastColor == null) {
                            lastColor = oldBackground;
                        }
                        int pos = 0;
                        int i3 = 0;
                        while (i3 < this.gradientPercents.length) {
                            gc.setForeground(lastColor);
                            lastColor = this.gradientColors[i3 + 1];
                            if (lastColor == null) {
                                lastColor = oldBackground;
                            }
                            gc.setBackground(lastColor);
                            if (this.gradientVertical) {
                                int gradientHeight = this.gradientPercents[i3] * rect.height / 100 - pos;
                                gc.fillGradientRectangle(0, pos, rect.width, gradientHeight, true);
                                pos += gradientHeight;
                            } else {
                                int gradientWidth = this.gradientPercents[i3] * rect.width / 100 - pos;
                                gc.fillGradientRectangle(pos, 0, gradientWidth, rect.height, false);
                                pos += gradientWidth;
                            }
                            ++i3;
                        }
                        if (this.gradientVertical && pos < rect.height) {
                            gc.setBackground(this.getBackground());
                            gc.fillRectangle(0, pos, rect.width, rect.height - pos);
                        }
                        if (!this.gradientVertical && pos < rect.width) {
                            gc.setBackground(this.getBackground());
                            gc.fillRectangle(pos, 0, rect.width - pos, rect.height);
                        }
                        gc.setForeground(oldForeground);
                    }
                    gc.setBackground(oldBackground);
                } else if ((this.background != null || (this.getStyle() & 0x20000000) == 0) && this.background.getAlpha() > 0) {
                    gc.setBackground(this.getBackground());
                    gc.fillRectangle(rect);
                }
            }
            catch (SWTException sWTException) {
                if ((this.getStyle() & 0x20000000) != 0) break block41;
                gc.setBackground(this.getBackground());
                gc.fillRectangle(rect);
            }
        }
        int style = this.getStyle();
        if ((style & 4) != 0 || (style & 8) != 0) {
            this.paintBorder(gc, rect);
        }
        Rectangle imageRect = null;
        int lineHeight = 0;
        int textHeight = 0;
        int imageHeight = 0;
        if (img != null) {
            imageRect = img.getBounds();
            imageHeight = imageRect.height;
        }
        if (lines != null) {
            lineHeight = gc.getFontMetrics().getHeight();
            textHeight = lines.length * lineHeight;
        }
        int imageY = 0;
        int midPoint = 0;
        int lineY = 0;
        if (imageHeight > textHeight) {
            imageY = this.topMargin == 3 && this.bottomMargin == 3 ? rect.y + (rect.height - imageHeight) / 2 : this.topMargin;
            midPoint = imageY + imageHeight / 2;
            lineY = midPoint - textHeight / 2;
        } else {
            lineY = this.topMargin == 3 && this.bottomMargin == 3 ? rect.y + (rect.height - textHeight) / 2 : this.topMargin;
            midPoint = lineY + textHeight / 2;
            imageY = midPoint - imageHeight / 2;
        }
        if (img != null) {
            gc.drawImage(img, 0, 0, imageRect.width, imageHeight, x2, imageY, imageRect.width, imageHeight);
            x2 += imageRect.width + 5;
            extent.x -= imageRect.width + 5;
        }
        if (lines != null) {
            gc.setForeground(this.getForeground());
            int i4 = 0;
            while (i4 < lines.length) {
                int lineX = x2;
                if (lines.length > 1) {
                    int lineWidth;
                    if (this.align == 0x1000000) {
                        lineWidth = gc.textExtent((String)lines[i4], (int)CLabel.DRAW_FLAGS).x;
                        lineX = x2 + Math.max(0, (extent.x - lineWidth) / 2);
                    }
                    if (this.align == 131072) {
                        lineWidth = gc.textExtent((String)lines[i4], (int)CLabel.DRAW_FLAGS).x;
                        lineX = Math.max(x2, rect.x + rect.width - this.rightMargin - lineWidth);
                    }
                }
                gc.drawText(lines[i4], lineX, lineY, DRAW_FLAGS);
                lineY += lineHeight;
                ++i4;
            }
        }
    }

    private void paintBorder(GC gc, Rectangle r2) {
        Display disp = this.getDisplay();
        Color c1 = null;
        Color c2 = null;
        int style = this.getStyle();
        if ((style & 4) != 0) {
            c1 = disp.getSystemColor(18);
            c2 = disp.getSystemColor(20);
        }
        if ((style & 8) != 0) {
            c1 = disp.getSystemColor(19);
            c2 = disp.getSystemColor(18);
        }
        if (c1 != null && c2 != null) {
            gc.setLineWidth(1);
            this.drawBevelRect(gc, r2.x, r2.y, r2.width - 1, r2.height - 1, c1, c2);
        }
    }

    public void setAlignment(int align) {
        this.checkWidget();
        if (align != 16384 && align != 131072 && align != 0x1000000) {
            SWT.error(5);
        }
        if (this.align != align) {
            this.align = align;
            this.redraw();
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.backgroundImage == null && this.gradientColors == null && this.gradientPercents == null && (color == null ? this.background == null : color.equals(this.background))) {
            return;
        }
        this.background = color;
        this.backgroundImage = null;
        this.gradientColors = null;
        this.gradientPercents = null;
        this.redraw();
    }

    public void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        this.checkWidget();
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                SWT.error(5);
            }
            if (this.getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
            int i2 = 0;
            while (i2 < percents.length) {
                if (percents[i2] < 0 || percents[i2] > 100) {
                    SWT.error(5);
                }
                if (i2 > 0 && percents[i2] < percents[i2 - 1]) {
                    SWT.error(5);
                }
                ++i2;
            }
        }
        Color background = this.getBackground();
        if (this.backgroundImage == null) {
            if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
                boolean same = false;
                int i3 = 0;
                while (i3 < this.gradientColors.length) {
                    boolean bl = same = this.gradientColors[i3] == colors[i3] || this.gradientColors[i3] == null && colors[i3] == background || this.gradientColors[i3] == background && colors[i3] == null;
                    if (!same) break;
                    ++i3;
                }
                if (same) {
                    i3 = 0;
                    while (i3 < this.gradientPercents.length) {
                        boolean bl = same = this.gradientPercents[i3] == percents[i3];
                        if (!same) break;
                        ++i3;
                    }
                }
                if (same && this.gradientVertical == vertical) {
                    return;
                }
            }
        } else {
            this.backgroundImage = null;
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colors.length];
            int i4 = 0;
            while (i4 < colors.length) {
                this.gradientColors[i4] = colors[i4] != null ? colors[i4] : background;
                ++i4;
            }
            this.gradientPercents = new int[percents.length];
            i4 = 0;
            while (i4 < percents.length) {
                this.gradientPercents[i4] = percents[i4];
                ++i4;
            }
            this.gradientVertical = vertical;
        }
        this.redraw();
    }

    public void setBackground(Image image) {
        this.checkWidget();
        if (image == this.backgroundImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.backgroundImage = image;
        this.redraw();
    }

    public void setBottomMargin(int bottomMargin) {
        this.checkWidget();
        if (this.bottomMargin == bottomMargin || bottomMargin < 0) {
            return;
        }
        this.bottomMargin = bottomMargin;
        this.redraw();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }

    public void setLeftMargin(int leftMargin) {
        this.checkWidget();
        if (this.leftMargin == leftMargin || leftMargin < 0) {
            return;
        }
        this.leftMargin = leftMargin;
        this.redraw();
    }

    public void setMargins(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        this.checkWidget();
        this.leftMargin = Math.max(0, leftMargin);
        this.topMargin = Math.max(0, topMargin);
        this.rightMargin = Math.max(0, rightMargin);
        this.bottomMargin = Math.max(0, bottomMargin);
        this.redraw();
    }

    public void setRightMargin(int rightMargin) {
        this.checkWidget();
        if (this.rightMargin == rightMargin || rightMargin < 0) {
            return;
        }
        this.rightMargin = rightMargin;
        this.redraw();
    }

    public void setText(String text2) {
        this.checkWidget();
        if (text2 == null) {
            text2 = "";
        }
        if (!text2.equals(this.text)) {
            this.text = text2;
            this.redraw();
        }
    }

    @Override
    public void setToolTipText(String string2) {
        super.setToolTipText(string2);
        this.appToolTipText = super.getToolTipText();
    }

    public void setTopMargin(int topMargin) {
        this.checkWidget();
        if (this.topMargin == topMargin || topMargin < 0) {
            return;
        }
        this.topMargin = topMargin;
        this.redraw();
    }

    protected String shortenText(GC gc, String t2, int width) {
        int min;
        if (t2 == null) {
            return null;
        }
        int w2 = gc.textExtent((String)ELLIPSIS, (int)CLabel.DRAW_FLAGS).x;
        if (width <= w2) {
            return t2;
        }
        int l2 = t2.length();
        int max = l2 / 2;
        int mid = (max + (min = 0)) / 2 - 1;
        if (mid <= 0) {
            return t2;
        }
        TextLayout layout = new TextLayout(this.getDisplay());
        layout.setText(t2);
        mid = this.validateOffset(layout, mid);
        while (min < mid && mid < max) {
            String s1 = t2.substring(0, mid);
            String s2 = t2.substring(this.validateOffset(layout, l2 - mid), l2);
            int l1 = gc.textExtent((String)s1, (int)CLabel.DRAW_FLAGS).x;
            int l22 = gc.textExtent((String)s2, (int)CLabel.DRAW_FLAGS).x;
            if (l1 + w2 + l22 > width) {
                max = mid;
                mid = this.validateOffset(layout, (max + min) / 2);
                continue;
            }
            if (l1 + w2 + l22 < width) {
                min = mid;
                mid = this.validateOffset(layout, (max + min) / 2);
                continue;
            }
            min = max;
        }
        String result2 = mid == 0 ? t2 : String.valueOf(t2.substring(0, mid)) + ELLIPSIS + t2.substring(this.validateOffset(layout, l2 - mid), l2);
        layout.dispose();
        return result2;
    }

    int validateOffset(TextLayout layout, int offset) {
        int nextOffset = layout.getNextOffset(offset, 2);
        if (nextOffset != offset) {
            return layout.getPreviousOffset(nextOffset, 2);
        }
        return offset;
    }

    private String[] splitString(String text2) {
        int pos;
        String[] lines = new String[1];
        int start = 0;
        do {
            if ((pos = text2.indexOf(10, start)) == -1) {
                lines[lines.length - 1] = text2.substring(start);
                continue;
            }
            boolean crlf = pos > 0 && text2.charAt(pos - 1) == '\r';
            lines[lines.length - 1] = text2.substring(start, pos - (crlf ? 1 : 0));
            start = pos + 1;
            String[] newLines = new String[lines.length + 1];
            System.arraycopy(lines, 0, newLines, 0, lines.length);
            lines = newLines;
        } while (pos != -1);
        return lines;
    }
}

