/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging.jfr;

import com.sun.javafx.logging.Logger;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.logging.jfr.JFRInputEvent;
import com.sun.javafx.logging.jfr.JFRPulsePhaseEvent;
import jdk.jfr.FlightRecorder;

public final class JFRPulseLogger
extends Logger {
    private final ThreadLocal<JFRPulsePhaseEvent> currentPulsePhaseEvent;
    private final ThreadLocal<JFRInputEvent> currentInputEvent;
    private int pulseNumber;
    private int fxPulseNumber;
    private int renderPulseNumber;
    private Thread fxThread;

    public static Logger createInstance() {
        if (FlightRecorder.isInitialized() || PulseLogger.isPulseLoggingRequested()) {
            return new JFRPulseLogger();
        }
        return null;
    }

    private JFRPulseLogger() {
        FlightRecorder.register(JFRInputEvent.class);
        FlightRecorder.register(JFRPulsePhaseEvent.class);
        this.currentPulsePhaseEvent = new ThreadLocal<JFRPulsePhaseEvent>(){

            @Override
            public JFRPulsePhaseEvent initialValue() {
                return new JFRPulsePhaseEvent();
            }
        };
        this.currentInputEvent = new ThreadLocal<JFRInputEvent>(){

            @Override
            public JFRInputEvent initialValue() {
                return new JFRInputEvent();
            }
        };
    }

    @Override
    public void pulseStart() {
        ++this.pulseNumber;
        this.fxPulseNumber = this.pulseNumber;
        if (this.fxThread == null) {
            this.fxThread = Thread.currentThread();
        }
        this.newPhase("Pulse start");
    }

    @Override
    public void pulseEnd() {
        this.newPhase(null);
        this.fxPulseNumber = 0;
    }

    @Override
    public void renderStart() {
        this.renderPulseNumber = this.fxPulseNumber;
    }

    @Override
    public void renderEnd() {
        this.newPhase(null);
        this.renderPulseNumber = 0;
    }

    @Override
    public void newPhase(String string2) {
        JFRPulsePhaseEvent jFRPulsePhaseEvent = this.currentPulsePhaseEvent.get();
        if (!jFRPulsePhaseEvent.isEnabled()) {
            jFRPulsePhaseEvent.setPhaseName(null);
            return;
        }
        if (jFRPulsePhaseEvent.getPhaseName() != null) {
            jFRPulsePhaseEvent.commit();
        }
        if (string2 == null) {
            jFRPulsePhaseEvent.setPhaseName(null);
            return;
        }
        jFRPulsePhaseEvent = new JFRPulsePhaseEvent();
        jFRPulsePhaseEvent.begin();
        jFRPulsePhaseEvent.setPhaseName(string2);
        jFRPulsePhaseEvent.setPulseId(Thread.currentThread() == this.fxThread ? this.fxPulseNumber : this.renderPulseNumber);
        this.currentPulsePhaseEvent.set(jFRPulsePhaseEvent);
    }

    @Override
    public void newInput(String string2) {
        JFRInputEvent jFRInputEvent = this.currentInputEvent.get();
        if (!jFRInputEvent.isEnabled()) {
            jFRInputEvent.setInput(null);
            return;
        }
        if (jFRInputEvent.getInput() != null) {
            jFRInputEvent.commit();
        }
        if (string2 == null) {
            jFRInputEvent.setInput(null);
            return;
        }
        jFRInputEvent = new JFRInputEvent();
        jFRInputEvent.begin();
        jFRInputEvent.setInput(string2);
        this.currentInputEvent.set(jFRInputEvent);
    }
}

