/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.languages;

import com.itextpdf.text.pdf.Glyph;
import com.itextpdf.text.pdf.languages.IndicGlyphRepositioner;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BanglaGlyphRepositioner
extends IndicGlyphRepositioner {
    private static final String[] CHARCTERS_TO_BE_SHIFTED_LEFT_BY_1 = new String[]{"\u09bf", "\u09c7", "\u09c8"};
    private final Map<Integer, int[]> cmap31;
    private final Map<String, Glyph> glyphSubstitutionMap;

    public BanglaGlyphRepositioner(Map<Integer, int[]> cmap31, Map<String, Glyph> glyphSubstitutionMap) {
        this.cmap31 = cmap31;
        this.glyphSubstitutionMap = glyphSubstitutionMap;
    }

    @Override
    public void repositionGlyphs(List<Glyph> glyphList) {
        for (int i2 = 0; i2 < glyphList.size(); ++i2) {
            Glyph glyph = glyphList.get(i2);
            if (glyph.chars.equals("\u09cb")) {
                this.handleOKaarAndOUKaar(i2, glyphList, '\u09c7', '\u09be');
                continue;
            }
            if (!glyph.chars.equals("\u09cc")) continue;
            this.handleOKaarAndOUKaar(i2, glyphList, '\u09c7', '\u09d7');
        }
        super.repositionGlyphs(glyphList);
    }

    @Override
    public List<String> getCharactersToBeShiftedLeftByOnePosition() {
        return Arrays.asList(CHARCTERS_TO_BE_SHIFTED_LEFT_BY_1);
    }

    private void handleOKaarAndOUKaar(int currentIndex, List<Glyph> glyphList, char first, char second) {
        Glyph g1 = this.getGlyph(first);
        Glyph g2 = this.getGlyph(second);
        glyphList.set(currentIndex, g1);
        glyphList.add(currentIndex + 1, g2);
    }

    private Glyph getGlyph(char c2) {
        Glyph glyph = this.glyphSubstitutionMap.get(String.valueOf(c2));
        if (glyph != null) {
            return glyph;
        }
        int[] metrics = this.cmap31.get(c2);
        int glyphCode = metrics[0];
        int glyphWidth = metrics[1];
        return new Glyph(glyphCode, glyphWidth, String.valueOf(c2));
    }
}

