/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import gde.ui.tab.AnalogDisplay;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class AnalogWindow
extends CTabItem {
    static final Logger log = Logger.getLogger(AnalogWindow.class.getName());
    Composite analogMainComposite;
    HashMap<String, AnalogDisplay> displays;
    GridLayout analogMainCompositeLayout;
    String info = Messages.getString("GDE_MSGT0230");
    Color surroundingBackground;
    final DataExplorer application;
    final Channels channels;
    final CTabFolder displayTab;
    final Menu popupmenu;
    final TabAreaContextMenu contextMenu;
    RecordSet oldRecordSet;
    Channel oldChannel;
    String[] oldRecordsToDisplay;

    public AnalogWindow(CTabFolder currentDisplayTab, int style, int position) {
        super(currentDisplayTab, style, position);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.displayTab = currentDisplayTab;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0231"));
        this.surroundingBackground = Settings.getInstance().getAnalogSurroundingAreaBackground();
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.contextMenu = new TabAreaContextMenu();
        this.displays = new HashMap(3);
    }

    public void create() {
        this.analogMainComposite = new Composite((Composite)this.displayTab, 0);
        this.analogMainCompositeLayout = new GridLayout();
        this.analogMainCompositeLayout.makeColumnsEqualWidth = true;
        this.analogMainCompositeLayout.numColumns = 2;
        this.setControl((Control)this.analogMainComposite);
        this.analogMainComposite.setLayout((Layout)this.analogMainCompositeLayout);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "digitalMainComposite " + this.analogMainComposite.getBounds().toString());
        }
        this.analogMainComposite.setBackground(this.surroundingBackground);
        this.analogMainComposite.setMenu(this.popupmenu);
        this.analogMainComposite.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "analogMainComposite.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_8.html");
            }
        });
        this.analogMainComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "analogMainComposite.paintControl, event=" + String.valueOf(evt));
                }
                AnalogWindow.this.contextMenu.createMenu(AnalogWindow.this.popupmenu, TabAreaContextMenu.TabMenuType.SIMPLE);
                AnalogWindow.this.update(false);
            }
        });
        this.analogMainComposite.layout();
    }

    public synchronized void updateChilds() {
        RecordSet recordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (recordSet != null) {
            String[] activeRecordKeys = recordSet.getDisplayableAndVisibleRecordNames();
            if (activeRecordKeys.length != this.displays.size()) {
                this.update(true);
            } else {
                for (String recordKey : activeRecordKeys) {
                    AnalogDisplay display = this.displays.get(recordKey);
                    if (display == null) continue;
                    display.checkTachoNeedlePosition();
                }
            }
        }
    }

    public synchronized void update(boolean forceUpdate) {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            RecordSet recordSet;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, " ");
            }
            if ((recordSet = activeChannel.getActiveRecordSet()) != null && recordSet.getDevice().isAnalogTabRequested()) {
                boolean isUpdateRequired;
                recordSet.updateSyncRecordScale();
                String[] recordsToDisplay = recordSet.getDisplayableAndVisibleRecordNames();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, activeChannel.getName());
                }
                boolean bl = isUpdateRequired = forceUpdate || this.oldRecordSet == null || !recordSet.getName().equals(this.oldRecordSet.getName()) || this.oldChannel == null || !this.oldChannel.getName().equals(activeChannel.getName()) || recordsToDisplay.length != this.oldRecordsToDisplay.length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "isUpdateRequired = " + isUpdateRequired);
                }
                if (isUpdateRequired) {
                    AnalogDisplay display;
                    this.analogMainComposite.setLayout((Layout)this.analogMainCompositeLayout);
                    for (String recordKey : this.displays.keySet().toArray(new String[0])) {
                        display = this.displays.get(recordKey);
                        if (display == null) continue;
                        if (!display.isDisposed()) {
                            display.dispose();
                        }
                        this.displays.remove(recordKey);
                    }
                    for (String recordKey : recordSet.getDisplayableAndVisibleRecordNames()) {
                        display = new AnalogDisplay(this.analogMainComposite, recordKey, DataExplorer.getInstance().getActiveDevice());
                        display.create();
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "created analog display for " + recordKey);
                        }
                        this.displays.put(recordKey, display);
                    }
                    this.oldRecordSet = recordSet;
                    this.oldRecordsToDisplay = recordsToDisplay;
                }
            } else {
                for (String recordKey : this.displays.keySet().toArray(new String[0])) {
                    AnalogDisplay display = this.displays.get(recordKey);
                    if (display == null) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "clean child " + recordKey);
                    }
                    if (!display.isDisposed()) {
                        display.dispose();
                    }
                    this.displays.remove(recordKey);
                }
            }
            this.oldChannel = activeChannel;
            this.analogMainComposite.layout();
        }
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.analogMainComposite.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.analogMainComposite.print(imageGC);
        if (GDE.IS_MAC) {
            this.analogMainComposite.print(imageGC);
        }
        imageGC.dispose();
        return tabContentImage;
    }

    public void setInnerAreaBackground(Color newInnerAreaBackground) {
        this.update(true);
    }

    public void setSurroundingAreaBackground(Color newSurroundingBackground) {
        this.analogMainComposite.setBackground(newSurroundingBackground);
        this.surroundingBackground = newSurroundingBackground;
        this.analogMainComposite.redraw();
    }
}

