/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.device.ChannelType;
import gde.device.ChannelTypes;
import gde.device.DeviceConfiguration;
import gde.device.MeasurementType;
import gde.device.ObjectFactory;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.ui.dialog.edit.MeasurementTypeTabItem;
import gde.ui.dialog.edit.PropertyTypeTabItem;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ChannelTypeTabItem
extends CTabItem
implements Cloneable {
    static final Logger log = Logger.getLogger(ChannelTypeTabItem.class.getName());
    Composite channelConfigComposite;
    Button channelConfigAddButton;
    Label channelConfigLabel;
    CCombo channelConfigTypeCombo;
    Text channelConfigText;
    CTabFolder measurementsTabFolder;
    ChannelTypes channelConfigType = ChannelTypes.TYPE_OUTLET;
    String channelConfigName = Messages.getString("GDE_MSGT0527");
    final CTabFolder channelConfigInnerTabFolder;
    final DevicePropertiesEditor propsEditor;
    final String tabName;
    DeviceConfiguration deviceConfig;
    int channelConfigNumber;
    ChannelType channelType;

    public ChannelTypeTabItem(CTabFolder parent, int style, int index) {
        super(parent, style);
        this.channelConfigInnerTabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        this.tabName = " " + (index + 1) + " ";
        log.log(java.util.logging.Level.FINE, "ChannelTypeTabItem " + this.tabName);
        this.initGUI();
    }

    public void setChannelType(DeviceConfiguration useDeviceConfig, ChannelType useChannelType, int useChannelConfigNumber) {
        log.log(java.util.logging.Level.FINE, "ChannelTypeTabItem.setChannelType");
        this.deviceConfig = useDeviceConfig;
        this.channelType = useChannelType;
        this.channelConfigNumber = useChannelConfigNumber;
        this.channelConfigComposite.redraw();
        this.setText(" " + this.channelConfigNumber + " " + this.channelType.getName());
        if (this.channelConfigNumber == 1) {
            this.setupMeasurementItems();
        }
        this.initialize();
        this.channelConfigInnerTabFolder.setSelection(0);
    }

    public void setupMeasurementItems() {
        int i;
        int actualTabItemCount;
        int measurementTypeCount = this.channelType.getMeasurement().size();
        if (measurementTypeCount < (actualTabItemCount = this.measurementsTabFolder.getItemCount())) {
            for (i = measurementTypeCount; i < actualTabItemCount; ++i) {
                MeasurementTypeTabItem tmpMeasurementTypeTabItem = (MeasurementTypeTabItem)this.measurementsTabFolder.getItem(measurementTypeCount);
                if (tmpMeasurementTypeTabItem.measurementPropertiesTabFolder != null) {
                    for (CTabItem tmpPropertyTypeTabItem : tmpMeasurementTypeTabItem.measurementPropertiesTabFolder.getItems()) {
                        ((PropertyTypeTabItem)tmpPropertyTypeTabItem).dispose();
                    }
                    tmpMeasurementTypeTabItem.measurementPropertiesTabItem.dispose();
                }
                if (tmpMeasurementTypeTabItem.statisticsTypeTabItem != null) {
                    tmpMeasurementTypeTabItem.statisticsTypeTabItem.dispose();
                }
                tmpMeasurementTypeTabItem.dispose();
            }
        } else if (measurementTypeCount > actualTabItemCount) {
            for (i = actualTabItemCount; i < measurementTypeCount; ++i) {
                new MeasurementTypeTabItem(this.measurementsTabFolder, 0, i);
            }
        }
        this.measurementsTabFolder.getItem(measurementTypeCount - 1).setShowClose(true);
        ((MeasurementTypeTabItem)this.measurementsTabFolder.getItem(0)).setMeasurementType(this.deviceConfig, this.channelType.getMeasurement().get(0), this.channelConfigNumber);
        for (i = 1; i < measurementTypeCount; ++i) {
            MeasurementTypeTabItem measurementTabItem = (MeasurementTypeTabItem)this.measurementsTabFolder.getItem(i);
            measurementTabItem.setMeasurementTypeName(this.deviceConfig, this.channelType.getMeasurement().get(i), this.channelConfigNumber);
        }
        ((MeasurementTypeTabItem)this.measurementsTabFolder.getSelection()).enableContextMenu(true);
    }

    public void cleanMeasurementitems() {
        int measurementTypeCount;
        for (int i = measurementTypeCount = this.measurementsTabFolder.getItemCount(); i > 1; --i) {
            MeasurementTypeTabItem tmpMeasurementTypeTabItem = (MeasurementTypeTabItem)this.measurementsTabFolder.getItem(i - 1);
            if (tmpMeasurementTypeTabItem.measurementPropertiesTabFolder != null) {
                for (CTabItem tmpPropertyTypeTabItem : tmpMeasurementTypeTabItem.measurementPropertiesTabFolder.getItems()) {
                    ((PropertyTypeTabItem)tmpPropertyTypeTabItem).dispose();
                }
                tmpMeasurementTypeTabItem.measurementPropertiesTabItem.dispose();
            }
            if (tmpMeasurementTypeTabItem.statisticsTypeTabItem != null) {
                tmpMeasurementTypeTabItem.statisticsTypeTabItem.dispose();
            }
            tmpMeasurementTypeTabItem.dispose();
        }
    }

    public synchronized ChannelTypeTabItem clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return new ChannelTypeTabItem(this);
    }

    private ChannelTypeTabItem(ChannelTypeTabItem copyFrom) {
        super(copyFrom.channelConfigInnerTabFolder, 64);
        MeasurementTypeTabItem measurementTabItem;
        int i;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        this.channelConfigInnerTabFolder = copyFrom.channelConfigInnerTabFolder;
        this.deviceConfig = copyFrom.deviceConfig;
        this.channelConfigNumber = this.channelConfigInnerTabFolder.getItemCount();
        this.channelType = new ObjectFactory().createChannelType();
        this.channelConfigType = copyFrom.channelConfigType;
        this.channelConfigName = copyFrom.channelConfigName;
        this.channelType.setName(this.channelConfigType == ChannelTypes.TYPE_OUTLET ? this.channelConfigName : Messages.getString("GDE_MSGT0507"));
        this.channelType.setType(this.channelConfigType);
        this.tabName = " " + this.channelConfigNumber + " " + (this.deviceConfig != null ? this.channelType.getName() : "");
        this.initGUI();
        int measurementTypeCount = copyFrom.channelType.getMeasurement().size();
        int actualTabItemCount = this.measurementsTabFolder.getItemCount();
        if (measurementTypeCount < actualTabItemCount) {
            for (i = measurementTypeCount; i < actualTabItemCount; ++i) {
                measurementTabItem = (MeasurementTypeTabItem)this.measurementsTabFolder.getItem(measurementTypeCount);
                measurementTabItem.dispose();
            }
        } else if (measurementTypeCount > actualTabItemCount) {
            for (i = actualTabItemCount; i < measurementTypeCount; ++i) {
                new MeasurementTypeTabItem(this.measurementsTabFolder, 0, i);
            }
        }
        this.measurementsTabFolder.getItem(measurementTypeCount - 1).setShowClose(true);
        if (this.deviceConfig != null) {
            this.deviceConfig.addChannelType(this.channelType);
            for (i = 0; i < copyFrom.channelType.getMeasurement().size(); ++i) {
                measurementTabItem = (MeasurementTypeTabItem)this.measurementsTabFolder.getItem(i);
                MeasurementType tmpMeasurementType = copyFrom.channelType.getMeasurement().get(i).clone();
                measurementTabItem.setMeasurementType(this.deviceConfig, tmpMeasurementType, this.channelConfigNumber);
                this.channelType.getMeasurement().add(tmpMeasurementType);
            }
        }
    }

    private void initGUI() {
        try {
            SWTResourceManager.registerResourceUser((Widget)this);
            this.setText(this.tabName);
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.channelConfigComposite = new Composite((Composite)this.channelConfigInnerTabFolder, 0);
            this.setControl((Control)this.channelConfigComposite);
            this.channelConfigComposite.setLayout((Layout)new FormLayout());
            this.channelConfigComposite.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "channelConfigComposite.helpRequested " + String.valueOf(evt));
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A1.html#device_properties_channelConfig");
                }
            });
            this.channelConfigTypeCombo = new CCombo(this.channelConfigComposite, 2048);
            this.channelConfigTypeCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 1000, 9);
            fd.top = new FormAttachment(0, 1000, 7);
            fd.width = 120;
            fd.height = 18;
            this.channelConfigTypeCombo.setLayoutData((Object)fd);
            this.channelConfigTypeCombo.setItems(StringHelper.enumValues2StringArray((Object[])ChannelTypes.values()));
            this.channelConfigTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "channelConfigTypeCombo.widgetSelected, event=" + String.valueOf(evt));
                    ChannelTypeTabItem.this.channelConfigType = ChannelTypes.valueOf(ChannelTypeTabItem.this.channelConfigTypeCombo.getText());
                    if (ChannelTypeTabItem.this.channelType != null) {
                        ChannelTypeTabItem.this.channelType.setType(ChannelTypeTabItem.this.channelConfigType);
                        ChannelTypeTabItem.this.deviceConfig.setChangePropery(true);
                        ChannelTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.channelConfigText = new Text(this.channelConfigComposite, 18432);
            this.channelConfigText.setText(Messages.getString("GDE_MSGT0527"));
            this.channelConfigText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            fd = new FormData();
            fd.left = new FormAttachment(0, 1000, 150);
            fd.top = new FormAttachment(0, 1000, 7);
            fd.width = 130;
            fd.height = 16;
            this.channelConfigText.setLayoutData((Object)fd);
            this.channelConfigText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "channelConfigText.keyReleased, event=" + String.valueOf(evt));
                    ChannelTypeTabItem.this.channelConfigName = ChannelTypeTabItem.this.channelConfigText.getText().trim();
                    if (ChannelTypeTabItem.this.channelType != null) {
                        ChannelTypeTabItem.this.channelType.setName(ChannelTypeTabItem.this.channelConfigName);
                        ChannelTypeTabItem.this.deviceConfig.setChangePropery(true);
                        ChannelTypeTabItem.this.propsEditor.enableSaveButton(true);
                        ChannelTypeTabItem.this.setText(" " + ChannelTypeTabItem.this.channelConfigNumber + " " + ChannelTypeTabItem.this.channelConfigName);
                    }
                }
            });
            this.channelConfigLabel = new Label(this.channelConfigComposite, 0x1000000);
            this.channelConfigLabel.setText(Messages.getString("GDE_MSGT0528"));
            this.channelConfigLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            fd = new FormData();
            fd.top = new FormAttachment(0, 1000, 9);
            fd.right = new FormAttachment(1000, 1000, -60);
            fd.width = 280;
            fd.height = 18;
            this.channelConfigLabel.setLayoutData((Object)fd);
            this.measurementsTabFolder = new CTabFolder(this.channelConfigComposite, 2048);
            fd = new FormData();
            fd.top = new FormAttachment(0, 1000, 35);
            fd.left = new FormAttachment(0, 1000, 0);
            fd.right = new FormAttachment(1000, 1000, 0);
            fd.bottom = new FormAttachment(1000, 1000, 0);
            this.measurementsTabFolder.setLayoutData((Object)fd);
            new MeasurementTypeTabItem(this.measurementsTabFolder, 0, 0);
            this.measurementsTabFolder.setSelection(0);
            this.measurementsTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void restore(CTabFolderEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementsTabFolder.restore, event=" + String.valueOf(evt));
                    ((CTabItem)evt.item).getControl();
                }

                public void close(CTabFolderEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementsTabFolder.close, event=" + String.valueOf(evt));
                    MeasurementTypeTabItem tabItem = (MeasurementTypeTabItem)evt.item;
                    if (ChannelTypeTabItem.this.deviceConfig != null) {
                        ChannelTypeTabItem.this.deviceConfig.removeMeasurementFromChannel(ChannelTypeTabItem.this.channelConfigNumber, tabItem.measurementType);
                    }
                    ChannelTypeTabItem.this.measurementsTabFolder.setSelection(ChannelTypeTabItem.this.measurementsTabFolder.getSelectionIndex() - 1);
                    tabItem.dispose();
                    int itemCount = ChannelTypeTabItem.this.measurementsTabFolder.getItemCount();
                    if (itemCount > 1) {
                        ChannelTypeTabItem.this.measurementsTabFolder.getItem(itemCount - 1).setShowClose(true);
                    }
                }
            });
            this.measurementsTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "measurementsTabFolder.close, event=" + String.valueOf(evt));
                    GDE.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MeasurementTypeTabItem tmpMeasurementTypeTabItem = (MeasurementTypeTabItem)ChannelTypeTabItem.this.measurementsTabFolder.getSelection();
                            tmpMeasurementTypeTabItem.setMeasurementType(tmpMeasurementTypeTabItem.deviceConfig, tmpMeasurementTypeTabItem.measurementType, tmpMeasurementTypeTabItem.channelConfigNumber);
                            tmpMeasurementTypeTabItem.enableContextMenu(true);
                        }
                    });
                }
            });
            this.channelConfigAddButton = new Button(this.channelConfigComposite, 0x1000008);
            this.channelConfigAddButton.setText("+");
            this.channelConfigAddButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.channelConfigAddButton.setBounds(574, 9, 42, 19);
            fd = new FormData();
            fd.top = new FormAttachment(0, 1000, 7);
            fd.width = 42;
            fd.height = 20;
            fd.right = new FormAttachment(1000, 1000, -10);
            this.channelConfigAddButton.setLayoutData((Object)fd);
            this.channelConfigAddButton.setToolTipText(Messages.getString("GDE_MSGT0526"));
            this.channelConfigAddButton.setSize(40, 20);
            this.channelConfigAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "channelConfigAddButton.widgetSelected, event=" + String.valueOf(evt));
                    ChannelTypeTabItem.this.channelConfigInnerTabFolder.getItem(ChannelTypeTabItem.this.channelConfigInnerTabFolder.getItemCount() - 1).setShowClose(false);
                    ChannelTypeTabItem.this.clone();
                }
            });
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        if (this.channelType != null) {
            this.channelConfigType = this.channelType.getType();
            this.channelConfigTypeCombo.select(this.channelConfigType.ordinal());
            this.channelConfigName = this.channelType.getName();
            this.channelConfigText.setText(this.channelConfigName);
        }
    }

    public CTabFolder getMeasurementsTabFolder() {
        return this.measurementsTabFolder;
    }
}

