/* 
    Copyright (C) 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptwasp";
declare description "wasp";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.10";
declare license "GPL 3.0 or later";


//link the libraries
ba = library("basics.lib");
ma = library("maths.lib");
si = library("signals.lib");
fi = library("effect.lib");
os = library("oscillators.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
	     phase = 0.00005; // base time for resetpulse in sec.
	     peak_bandwidth = 200;// the bandwidth for applying the peak
	   };

//wasp filter
//a slider for the frequency of the wasp effect
waspfreq = hslider("[1][lv2:integer]frequency", 0, 0, 20000, 1) : si.smoo;

wasp = _<:(saw)*_ with {

  //a positive sawtooth with reset (resetable with resetpulse == 1)
  saw = os.lf_sawpos_reset(waspfreq,resetpulse);

  //resets the sawtooth peridically
  //if resetslider == 0 it will send 0
  resetpulse = select2(resetslider,0,_ * ba.pulsen((constant.phase * ma.SR),resetslider+1 * constant.phase * ma.SR)) with {

    //a slider that controls the reset
    resetslider = hslider ("[2][lv2:integer]overlap mode",0,0,100,1) : si.smoo;
    
  };

};

//higphass filter
highpass = fi.highpass(1,1+(waspfreq*(highpassfactor/100))) with {

  //a slider for the highpass factor
  highpassfactor = hslider("[3][lv2:integer]highpass factor", 0, 0, 100, 1) : si.smoo;
};

//lowpass filter
lowpass = fi.lowpass(1, 1+20000-(waspfreq*(lowpassfactor/100))) with {

  //a slider for the lowpass factor
  lowpassfactor = hslider("[4][lv2:integer]lowpass factor", 0, 0, 100, 1) : si.smoo;
};

//peak filter
peak =  fi.peak_eq(peaklevel/3, 1+waspfreq, constant.peak_bandwidth) with {

  //a slider for the peak factor
  peaklevel = hslider("[5][lv2:integer]peak factor", 0, 0, 100, 1) : si.smoo;
};

// the process, that is going to be executed
process = par( i, constant.nchannels,cptbasics.bargraphinput(i) :
				     cptbasics.stereodrywetmonofx(i, wasp : lowpass : highpass : peak ) :
				     cptbasics.bargraphoutput(i));
