/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptstereo1176r4limiter";
declare description "1176_R4 limiter  filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.12";
declare license "GPL 3.0 or later";

//link the libraries
co = library("compressors.lib");
cptbasics = library("lib/basics.lib");

// constanta used in this program
constant = environment {
	     nchannels = 2;// number of channels; do not change this - this is a stereo filter
	   };

// the process, that is going to be executed
// constant.nchannels in parallel
process = par(i, constant.nchannels, cptbasics.bargraphinput(i)) :
	  
	  cptbasics.stereodrywetstereofx(co.limiter_1176_R4_stereo) :
	  par(i, constant.nchannels, cptbasics.bargraphoutput(i));
